/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleXcodeTasksKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.DirAccessibility;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.EmbedAndSignTask;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.FrameworkCopy;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeEnvironment;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.SwiftExportKt;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u001e\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u000b*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"namePrefix", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "getNamePrefix", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)Ljava/lang/String;", "builtProductsDirAccessibility", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/DirAccessibility;", "fireEnvException", "", "frameworkTaskName", "fireSandboxException", "", "appleFrameworkDir", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "Lorg/gradle/api/Project;", "embedAndSignTaskName", "registerAssembleAppleFrameworkTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "framework", "registerEmbedAndSignAppleFrameworkTask", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAppleXcodeTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleXcodeTasks.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/AppleXcodeTasksKt\n+ 2 TasksProvider.kt\norg/jetbrains/kotlin/gradle/tasks/TasksProviderKt\n*L\n1#1,378:1\n81#2:379\n68#2,7:380\n81#2:387\n68#2,7:388\n37#2,6:395\n81#2:401\n68#2,7:402\n81#2:409\n68#2,7:410\n81#2:417\n68#2,7:418\n*S KotlinDebug\n*F\n+ 1 AppleXcodeTasks.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/AppleXcodeTasksKt\n*L\n134#1:379\n134#1:380,7\n138#1:387\n138#1:388,7\n146#1:395,6\n231#1:401\n231#1:402,7\n241#1:409\n241#1:410,7\n257#1:417\n257#1:418,7\n*E\n"})
public final class AppleXcodeTasksKt {
    /*
     * WARNING - void declaration
     */
    private static final TaskProvider<? extends Task> registerAssembleAppleFrameworkTask(Project $this$registerAssembleAppleFrameworkTask, Framework framework2) {
        TaskProvider taskProvider2;
        if (!framework2.getKonanTarget$kotlin_gradle_plugin_common().getFamily().isAppleFamily() || !KotlinNativeTargetPresetKt.getEnabledOnCurrentHost(framework2.getKonanTarget$kotlin_gradle_plugin_common())) {
            return null;
        }
        List<KonanTarget> envTargets = XcodeEnvironment.INSTANCE.getTargets();
        boolean needFatFramework = envTargets.size() > 1;
        NativeBuildType frameworkBuildType = framework2.getBuildType();
        KotlinNativeTarget frameworkTarget = framework2.getTarget();
        boolean isRequestedFramework = envTargets.contains(frameworkTarget.getKonanTarget());
        String[] stringArray = new String[]{"assemble", AppleXcodeTasksKt.getNamePrefix(framework2), frameworkBuildType.getName(), "AppleFrameworkForXcode", isRequestedFramework && needFatFramework ? null : frameworkTarget.getName()};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        if (envBuildType == null || envTargets.isEmpty() || XcodeEnvironment.INSTANCE.getBuiltProductsDir() == null) {
            String envConfiguration = System.getenv("CONFIGURATION");
            if (!((Collection)envTargets).isEmpty() && envConfiguration != null) {
                Project project = $this$registerAssembleAppleFrameworkTask.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                KotlinToolingDiagnosticsCollectorKt.reportDiagnostic(project, KotlinToolingDiagnostics.UnknownAppleFrameworkBuildType.INSTANCE.invoke(envConfiguration));
            } else {
                $this$registerAssembleAppleFrameworkTask.getLogger().debug("Not registering " + frameworkTaskName + ", since not called from Xcode");
            }
            return null;
        }
        if (!isRequestedFramework) {
            void $this$locateOrRegisterTask$iv;
            Project envConfiguration = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<DefaultTask, Unit>(frameworkBuildType, frameworkTarget){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ KotlinNativeTarget $frameworkTarget;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$frameworkTarget = $frameworkTarget;
                    super(1);
                }

                public final void invoke(DefaultTask task2) {
                    Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                    task2.setDescription("Packs " + this.$frameworkBuildType + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                    task2.setEnabled(false);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
            TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
            boolean $i$f$locateTask2 = false;
            TaskProvider taskProvider3 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, DefaultTask.class) : null;
            taskProvider2 = taskProvider3;
            if (taskProvider3 == null) {
                Project project2 = $this$locateOrRegisterTask$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                taskProvider2 = TasksProviderKt.registerTask$default(project2, frameworkTaskName, DefaultTask.class, null, body$iv, 4, null);
            }
        } else if (needFatFramework) {
            Project $this$locateOrRegisterTask$iv = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<FatFrameworkTask, Unit>(frameworkBuildType, framework2, $this$registerAssembleAppleFrameworkTask, frameworkTaskName, envBuildType){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ Framework $framework;
                final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
                final /* synthetic */ String $frameworkTaskName;
                final /* synthetic */ NativeBuildType $envBuildType;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$framework = $framework;
                    this.$this_registerAssembleAppleFrameworkTask = $receiver;
                    this.$frameworkTaskName = $frameworkTaskName;
                    this.$envBuildType = $envBuildType;
                    super(1);
                }

                public final void invoke(FatFrameworkTask task2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                    task2.setDescription("Packs " + this.$frameworkBuildType + " fat framework for Xcode");
                    task2.setBaseName(this.$framework.getBaseName());
                    task2.getDestinationDirProperty().fileProvider(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$frameworkTaskName));
                    Project project = this.$this_registerAssembleAppleFrameworkTask.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    task2.setEnabled(!PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getSwiftExportEnabled() && this.$frameworkBuildType == this.$envBuildType);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
            TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
            boolean $i$f$locateTask3 = false;
            TaskProvider taskProvider4 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, FatFrameworkTask.class) : null;
            TaskProvider taskProvider5 = taskProvider4;
            if (taskProvider4 == null) {
                Project project3 = $this$locateOrRegisterTask$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                taskProvider5 = TasksProviderKt.registerTask$default(project3, frameworkTaskName, FatFrameworkTask.class, null, body$iv, 4, null);
            }
            Project it = $this$locateOrRegisterTask$iv = taskProvider5;
            boolean bl = false;
            it.configure(new Action(framework2){
                final /* synthetic */ Framework $framework;
                {
                    this.$framework = $framework;
                }

                public final void execute(FatFrameworkTask task2) {
                    Framework[] frameworkArray = new Framework[]{this.$framework};
                    task2.from(frameworkArray);
                }
            });
            taskProvider2 = $this$locateOrRegisterTask$iv;
        } else {
            void $this$registerTask_u24default$iv;
            Project $this$locateOrRegisterTask$iv = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<FrameworkCopy, Unit>(frameworkBuildType, frameworkTarget, $this$registerAssembleAppleFrameworkTask, envBuildType, framework2, frameworkTaskName){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ KotlinNativeTarget $frameworkTarget;
                final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
                final /* synthetic */ NativeBuildType $envBuildType;
                final /* synthetic */ Framework $framework;
                final /* synthetic */ String $frameworkTaskName;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$frameworkTarget = $frameworkTarget;
                    this.$this_registerAssembleAppleFrameworkTask = $receiver;
                    this.$envBuildType = $envBuildType;
                    this.$framework = $framework;
                    this.$frameworkTaskName = $frameworkTaskName;
                    super(1);
                }

                public final void invoke(FrameworkCopy task2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                    task2.setDescription("Packs " + this.$frameworkBuildType + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                    Project project = this.$this_registerAssembleAppleFrameworkTask.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    task2.setEnabled(!PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getSwiftExportEnabled() && this.$frameworkBuildType == this.$envBuildType);
                    task2.getSourceFramework().fileProvider(this.$framework.getLinkTaskProvider().flatMap((Transformer)registerAssembleAppleFrameworkTask.1.INSTANCE));
                    task2.getSourceDsym().fileProvider(FrameworkCopy.Companion.dsymFile(FileUtilsKt.mapDirectoryToFile((Provider<Directory>)((Provider)task2.getSourceFramework()))));
                    Object[] objectArray = new Object[]{this.$framework.getLinkTaskProvider()};
                    task2.dependsOn(objectArray);
                    task2.getDestinationDirectory().fileProvider(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$frameworkTaskName));
                }
            };
            List args$iv = CollectionsKt.emptyList();
            boolean $i$f$registerTask = false;
            taskProvider2 = TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, frameworkTaskName, FrameworkCopy.class, args$iv, body$iv);
        }
        return taskProvider2;
    }

    private static final Void fireEnvException(String frameworkTaskName) {
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        String envConfiguration = System.getenv("CONFIGURATION");
        if (envConfiguration != null && envBuildType == null) {
            throw new IllegalStateException("Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically. Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'\n" + XcodeEnvironment.INSTANCE);
        }
        throw new IllegalStateException("Please run the " + frameworkTaskName + " task from Xcode ('SDK_NAME', 'CONFIGURATION', 'TARGET_BUILD_DIR', 'ARCHS' and 'FRAMEWORKS_FOLDER_PATH' not provided)\n" + XcodeEnvironment.INSTANCE);
    }

    private static final void fireSandboxException(String frameworkTaskName) {
        boolean userScriptSandboxingEnabled = XcodeEnvironment.INSTANCE.getUserScriptSandboxingEnabled();
        String message2 = userScriptSandboxingEnabled ? "You " : "BUILT_PRODUCTS_DIR is not accessible, probably you ";
        throw new IllegalStateException(message2 + "have sandboxing for user scripts enabled.\nTo make the " + frameworkTaskName + " task pass, disable this feature. \nIn your Xcode project, navigate to \"Build Setting\", and under \"Build Options\" set \"User script sandboxing\" (ENABLE_USER_SCRIPT_SANDBOXING) to \"NO\". \nThen, run \"./gradlew --stop\" to stop the Gradle daemon\nFor more information, see documentation: https://jb.gg/ltd9e6");
    }

    private static final DirAccessibility builtProductsDirAccessibility() {
        DirAccessibility dirAccessibility;
        File builtProductsDir = XcodeEnvironment.INSTANCE.getBuiltProductsDir();
        if (builtProductsDir != null) {
            DirAccessibility dirAccessibility2;
            try {
                Files.createDirectories(builtProductsDir.toPath(), new FileAttribute[0]);
                File tempFile = File.createTempFile("sandbox", ".tmp", builtProductsDir);
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                dirAccessibility2 = DirAccessibility.ACCESSIBLE;
            }
            catch (IOException e) {
                dirAccessibility2 = DirAccessibility.NOT_ACCESSIBLE;
            }
            dirAccessibility = dirAccessibility2;
        } else {
            dirAccessibility = DirAccessibility.DOES_NOT_EXIST;
        }
        return dirAccessibility;
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerEmbedAndSignAppleFrameworkTask(@NotNull Project $this$registerEmbedAndSignAppleFrameworkTask, @NotNull Framework framework2) {
        void $this$locateOrRegisterTask$iv;
        Project name$iv;
        void $this$locateOrRegisterTask$iv2;
        TaskProvider<?> swiftExportTask;
        Intrinsics.checkNotNullParameter((Object)$this$registerEmbedAndSignAppleFrameworkTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)framework2, (String)"framework");
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        List<KonanTarget> envTargets = XcodeEnvironment.INSTANCE.getTargets();
        File envEmbeddedFrameworksDir = XcodeEnvironment.INSTANCE.getEmbeddedFrameworksDir();
        String envSign = XcodeEnvironment.INSTANCE.getSign();
        boolean userScriptSandboxingEnabled = XcodeEnvironment.INSTANCE.getUserScriptSandboxingEnabled();
        String frameworkTaskName = AppleXcodeTasksKt.embedAndSignTaskName(framework2);
        Project project = $this$registerEmbedAndSignAppleFrameworkTask.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        TaskProvider<?> taskProvider2 = swiftExportTask = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getSwiftExportEnabled() && XcodeEnvironment.INSTANCE.getTargets().contains(framework2.getTarget().getKonanTarget()) ? SwiftExportKt.registerSwiftExportTask($this$registerEmbedAndSignAppleFrameworkTask, framework2) : null;
        if (envBuildType == null || envTargets.isEmpty() || envEmbeddedFrameworksDir == null) {
            void $this$locateOrRegisterTask$iv3;
            Project project2 = $this$registerEmbedAndSignAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<DefaultTask, Unit>(framework2, frameworkTaskName){
                final /* synthetic */ Framework $framework;
                final /* synthetic */ String $frameworkTaskName;
                {
                    this.$framework = $framework;
                    this.$frameworkTaskName = $frameworkTaskName;
                    super(1);
                }

                public final void invoke(DefaultTask task2) {
                    Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                    task2.setGroup("build");
                    task2.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                    task2.doFirst(new Action(this.$frameworkTaskName){
                        final /* synthetic */ String $frameworkTaskName;
                        {
                            this.$frameworkTaskName = $frameworkTaskName;
                        }

                        public final void execute(Task it) {
                            AppleXcodeTasksKt.access$fireEnvException(this.$frameworkTaskName);
                            throw null;
                        }
                    });
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project3 = $this$locateOrRegisterTask$iv3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            Project $this$locateTask$iv$iv = project3;
            boolean $i$f$locateTask = false;
            TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
            TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
            boolean $i$f$locateTask2 = false;
            TaskProvider taskProvider3 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, DefaultTask.class) : null;
            TaskProvider taskProvider4 = taskProvider3;
            if (taskProvider3 == null) {
                Project project4 = $this$locateOrRegisterTask$iv3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                taskProvider4 = TasksProviderKt.registerTask$default(project4, frameworkTaskName, DefaultTask.class, null, body$iv, 4, null);
            }
            return;
        }
        Project body$iv = $this$registerEmbedAndSignAppleFrameworkTask;
        String $i$f$locateOrRegisterTask = "checkSandboxAndWriteProtection";
        Function1 body$iv2 = (Function1)new Function1<DefaultTask, Unit>(frameworkTaskName, userScriptSandboxingEnabled){
            final /* synthetic */ String $frameworkTaskName;
            final /* synthetic */ boolean $userScriptSandboxingEnabled;
            {
                this.$frameworkTaskName = $frameworkTaskName;
                this.$userScriptSandboxingEnabled = $userScriptSandboxingEnabled;
                super(1);
            }

            public final void invoke(DefaultTask task2) {
                Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                task2.setGroup("build");
                task2.setDescription("Check BUILT_PRODUCTS_DIR accessible and ENABLE_USER_SCRIPT_SANDBOXING not enabled");
                task2.doFirst(new Action(this.$frameworkTaskName, this.$userScriptSandboxingEnabled){
                    final /* synthetic */ String $frameworkTaskName;
                    final /* synthetic */ boolean $userScriptSandboxingEnabled;
                    {
                        this.$frameworkTaskName = $frameworkTaskName;
                        this.$userScriptSandboxingEnabled = $userScriptSandboxingEnabled;
                    }

                    public final void execute(Task it) {
                        DirAccessibility dirAccessible = AppleXcodeTasksKt.access$builtProductsDirAccessibility();
                        switch (registerEmbedAndSignAppleFrameworkTask.checkSandboxAndWriteProtectionTask.WhenMappings.$EnumSwitchMapping$0[dirAccessible.ordinal()]) {
                            case 1: {
                                AppleXcodeTasksKt.access$fireSandboxException(this.$frameworkTaskName);
                                break;
                            }
                            case 2: 
                            case 3: {
                                if (!this.$userScriptSandboxingEnabled) break;
                                AppleXcodeTasksKt.access$fireSandboxException(this.$frameworkTaskName);
                            }
                        }
                    }
                });
            }
        };
        boolean $i$f$locateOrRegisterTask2 = false;
        Project project5 = $this$locateOrRegisterTask$iv2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        Project $this$locateTask$iv$iv = project5;
        boolean $i$f$locateTask = false;
        TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
        TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
        boolean $i$f$locateTask3 = false;
        TaskProvider taskProvider5 = $this$locateTask$iv$iv$iv.getNames().contains(name$iv) ? $this$locateTask$iv$iv$iv.named((String)name$iv, DefaultTask.class) : null;
        TaskProvider taskProvider6 = taskProvider5;
        if (taskProvider5 == null) {
            Project project6 = $this$locateOrRegisterTask$iv2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
            taskProvider6 = TasksProviderKt.registerTask$default(project6, (String)name$iv, DefaultTask.class, null, body$iv2, 4, null);
        }
        TaskProvider checkSandboxAndWriteProtectionTask2 = taskProvider6;
        name$iv = $this$registerEmbedAndSignAppleFrameworkTask;
        body$iv2 = (Function1)new Function1<EmbedAndSignTask, Unit>(framework2, $this$registerEmbedAndSignAppleFrameworkTask, envBuildType, envTargets, envEmbeddedFrameworksDir, userScriptSandboxingEnabled, envSign){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
            final /* synthetic */ NativeBuildType $envBuildType;
            final /* synthetic */ List<KonanTarget> $envTargets;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ boolean $userScriptSandboxingEnabled;
            final /* synthetic */ String $envSign;
            {
                this.$framework = $framework;
                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                this.$envBuildType = $envBuildType;
                this.$envTargets = $envTargets;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$userScriptSandboxingEnabled = $userScriptSandboxingEnabled;
                this.$envSign = $envSign;
                super(1);
            }

            public final void invoke(EmbedAndSignTask task2) {
                Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                task2.setGroup("build");
                task2.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                Project project = this.$this_registerEmbedAndSignAppleFrameworkTask.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                task2.setEnabled(!PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getSwiftExportEnabled() && !this.$framework.isStatic());
                TaskInputsInternal taskInputsInternal = task2.getInputs();
                NativeBuildType nativeBuildType = this.$envBuildType;
                List<KonanTarget> list = this.$envTargets;
                File file = this.$envEmbeddedFrameworksDir;
                boolean bl = this.$userScriptSandboxingEnabled;
                String string = this.$envSign;
                TaskInputsInternal $this$invoke_u24lambda_u240 = taskInputsInternal;
                boolean bl2 = false;
                $this$invoke_u24lambda_u240.property("type", (Object)nativeBuildType);
                $this$invoke_u24lambda_u240.property("targets", list);
                $this$invoke_u24lambda_u240.property("embeddedFrameworksDir", (Object)file);
                $this$invoke_u24lambda_u240.property("userScriptSandboxingEnabled", (Object)bl);
                if (string != null) {
                    $this$invoke_u24lambda_u240.property("sign", (Object)string);
                }
            }
        };
        $i$f$locateOrRegisterTask2 = false;
        Project project7 = $this$locateOrRegisterTask$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
        $this$locateTask$iv$iv = project7;
        $i$f$locateTask = false;
        TaskContainer taskContainer2 = $this$locateTask$iv$iv.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"tasks");
        $this$locateTask$iv$iv$iv = taskContainer2;
        $i$f$locateTask3 = false;
        TaskProvider taskProvider7 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, EmbedAndSignTask.class) : null;
        TaskProvider taskProvider8 = taskProvider7;
        if (taskProvider7 == null) {
            Project project8 = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
            taskProvider8 = TasksProviderKt.registerTask$default(project8, frameworkTaskName, EmbedAndSignTask.class, null, body$iv2, 4, null);
        }
        TaskProvider embedAndSignTask2 = taskProvider8;
        TaskProvider<? extends Task> taskProvider9 = AppleXcodeTasksKt.registerAssembleAppleFrameworkTask($this$registerEmbedAndSignAppleFrameworkTask, framework2);
        if (taskProvider9 == null) {
            return;
        }
        TaskProvider<? extends Task> assembleTask = taskProvider9;
        TasksProviderKt.dependsOn(assembleTask, checkSandboxAndWriteProtectionTask2);
        if (framework2.getBuildType() != envBuildType || !envTargets.contains(framework2.getKonanTarget$kotlin_gradle_plugin_common())) {
            return;
        }
        embedAndSignTask2.configure(new Action(framework2, assembleTask, swiftExportTask, $this$registerEmbedAndSignAppleFrameworkTask, frameworkTaskName, envEmbeddedFrameworksDir, envSign){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ TaskProvider<? extends Task> $assembleTask;
            final /* synthetic */ TaskProvider<?> $swiftExportTask;
            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
            final /* synthetic */ String $frameworkTaskName;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            {
                this.$framework = $framework;
                this.$assembleTask = $assembleTask;
                this.$swiftExportTask = $swiftExportTask;
                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                this.$frameworkTaskName = $frameworkTaskName;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
            }

            public final void execute(EmbedAndSignTask task2) {
                File frameworkFile = this.$framework.getOutputFile();
                Object[] objectArray = new Object[]{this.$assembleTask};
                task2.dependsOn(objectArray);
                if (this.$swiftExportTask != null) {
                    objectArray = new Object[]{this.$swiftExportTask};
                    task2.dependsOn(objectArray);
                }
                task2.getSourceFramework().fileProvider(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerEmbedAndSignAppleFrameworkTask, this.$frameworkTaskName).map(new Transformer(frameworkFile){
                    final /* synthetic */ File $frameworkFile;
                    {
                        this.$frameworkFile = $frameworkFile;
                    }

                    public final File transform(File it) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        String string = this.$frameworkFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frameworkFile.name");
                        return FilesKt.resolve((File)it, (String)string);
                    }
                }));
                task2.getDestinationDirectory().set(this.$envEmbeddedFrameworksDir);
                if (this.$envSign != null) {
                    task2.doLast(new Action(this.$envEmbeddedFrameworksDir, frameworkFile, task2, this.$envSign){
                        final /* synthetic */ File $envEmbeddedFrameworksDir;
                        final /* synthetic */ File $frameworkFile;
                        final /* synthetic */ EmbedAndSignTask $task;
                        final /* synthetic */ String $envSign;
                        {
                            this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                            this.$frameworkFile = $frameworkFile;
                            this.$task = $task;
                            this.$envSign = $envSign;
                        }

                        public final void execute(Task it) {
                            String string = this.$frameworkFile.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frameworkFile.name");
                            File binary = FilesKt.resolve((File)FilesKt.resolve((File)this.$envEmbeddedFrameworksDir, (String)string), (String)FilesKt.getNameWithoutExtension((File)this.$frameworkFile));
                            this.$task.getExecOperations().exec(new Action(this.$envSign, binary){
                                final /* synthetic */ String $envSign;
                                final /* synthetic */ File $binary;
                                {
                                    this.$envSign = $envSign;
                                    this.$binary = $binary;
                                }

                                public final void execute(ExecSpec it) {
                                    Object[] objectArray = new Object[]{"codesign", "--force", "--sign", this.$envSign, "--", this.$binary};
                                    it.commandLine(objectArray);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private static final String embedAndSignTaskName(Framework $this$embedAndSignTaskName) {
        String[] stringArray = new String[]{"embedAndSign", AppleXcodeTasksKt.getNamePrefix($this$embedAndSignTaskName), "AppleFrameworkForXcode"};
        return StringUtilsKt.lowerCamelCaseName(stringArray);
    }

    private static final String getNamePrefix(Framework $this$namePrefix) {
        return KotlinNativeBinaryContainer.Companion.extractPrefixFromBinaryName$kotlin_gradle_plugin_common($this$namePrefix.getName(), $this$namePrefix.getBuildType(), $this$namePrefix.getOutputKind().getTaskNameClassifier());
    }

    private static final Provider<File> appleFrameworkDir(Project $this$appleFrameworkDir, String frameworkTaskName) {
        Provider provider;
        Project project = $this$appleFrameworkDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getAppleCopyFrameworkToBuiltProductsDir()) {
            Provider provider2 = $this$appleFrameworkDir.getProject().provider(new Callable(frameworkTaskName){
                final /* synthetic */ String $frameworkTaskName;
                {
                    this.$frameworkTaskName = $frameworkTaskName;
                }

                public final File call() {
                    File file = XcodeEnvironment.INSTANCE.getBuiltProductsDir();
                    if (file == null) {
                        AppleXcodeTasksKt.access$fireEnvException(this.$frameworkTaskName);
                        throw null;
                    }
                    return file;
                }
            });
            provider = provider2;
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"frameworkTaskName: Strin\u2026rameworkTaskName) }\n    }");
        } else {
            Provider provider3 = $this$appleFrameworkDir.getLayout().getBuildDirectory().dir("xcode-frameworks").map(new Transformer(frameworkTaskName){
                final /* synthetic */ String $frameworkTaskName;
                {
                    this.$frameworkTaskName = $frameworkTaskName;
                }

                public final File transform(Directory it) {
                    File file = it.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                    File file2 = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
                    if (file2 == null) {
                        AppleXcodeTasksKt.access$fireEnvException(this.$frameworkTaskName);
                        throw null;
                    }
                    return FilesKt.resolve((File)file, (File)file2);
                }
            });
            provider = provider3;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"frameworkTaskName: Strin\u2026askName))\n        }\n    }");
        }
        return provider;
    }

    public static final /* synthetic */ Provider access$appleFrameworkDir(Project $receiver, String frameworkTaskName) {
        return AppleXcodeTasksKt.appleFrameworkDir($receiver, frameworkTaskName);
    }

    public static final /* synthetic */ String access$getNamePrefix(Framework $receiver) {
        return AppleXcodeTasksKt.getNamePrefix($receiver);
    }

    public static final /* synthetic */ Void access$fireEnvException(String frameworkTaskName) {
        return AppleXcodeTasksKt.fireEnvException(frameworkTaskName);
    }

    public static final /* synthetic */ DirAccessibility access$builtProductsDirAccessibility() {
        return AppleXcodeTasksKt.builtProductsDirAccessibility();
    }

    public static final /* synthetic */ void access$fireSandboxException(String frameworkTaskName) {
        AppleXcodeTasksKt.fireSandboxException(frameworkTaskName);
    }
}

