/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson;

import java.io.IOException;
import java.math.BigDecimal;
import org.jetbrains.kotlin.com.google.gson.JsonParseException;
import org.jetbrains.kotlin.com.google.gson.ToNumberStrategy;
import org.jetbrains.kotlin.com.google.gson.internal.LazilyParsedNumber;
import org.jetbrains.kotlin.com.google.gson.stream.JsonReader;
import org.jetbrains.kotlin.com.google.gson.stream.MalformedJsonException;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader in) throws IOException {
            return in.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader in) throws IOException {
            return new LazilyParsedNumber(in.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader in) throws IOException, JsonParseException {
            String value2 = in.nextString();
            try {
                return Long.parseLong(value2);
            }
            catch (NumberFormatException longE) {
                try {
                    Double d = Double.valueOf(value2);
                    if ((d.isInfinite() || d.isNaN()) && !in.isLenient()) {
                        throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + "; at path " + in.getPath());
                    }
                    return d;
                }
                catch (NumberFormatException doubleE) {
                    throw new JsonParseException("Cannot parse " + value2 + "; at path " + in.getPath(), doubleE);
                }
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader in) throws IOException {
            String value2 = in.nextString();
            try {
                return new BigDecimal(value2);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Cannot parse " + value2 + "; at path " + in.getPath(), e);
            }
        }
    };

}

