/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker;", "()V", "checkCreatedSourceSet", "", "diagnosticsCollector", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "Lorg/jetbrains/kotlin/gradle/utils/DeprecatedAndroidSourceSet;", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker
implements KotlinAndroidSourceSetLayoutChecker {
    @NotNull
    public static final MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker INSTANCE = new MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker();

    private MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker() {
    }

    @Override
    public void checkCreatedSourceSet(@NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        if (PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(target2.getProject()).getIgnoreMppAndroidSourceSetLayoutV2AndroidStyleDirs()) {
            return;
        }
        File projectRoot = target2.getProject().getRootDir();
        File androidStyleSourceDir = target2.getProject().file((Object)("src/" + androidSourceSet.getName() + "/kotlin"));
        if (kotlinSourceSet.getKotlin().getSrcDirs().contains(androidStyleSourceDir) && androidStyleSourceDir.exists()) {
            File kotlinStyleSourceDirToUse = target2.getProject().file((Object)("src/" + kotlinSourceSet.getName() + "/kotlin"));
            Project project = target2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)androidStyleSourceDir, (String)"androidStyleSourceDir");
            Intrinsics.checkNotNullExpressionValue((Object)projectRoot, (String)"projectRoot");
            String string = FilesKt.relativeTo((File)androidStyleSourceDir, (File)projectRoot).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidStyleSourceDir.re\u2026o(projectRoot).toString()");
            Intrinsics.checkNotNullExpressionValue((Object)kotlinStyleSourceDirToUse, (String)"kotlinStyleSourceDirToUse");
            String string2 = FilesKt.relativeTo((File)kotlinStyleSourceDirToUse, (File)projectRoot).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinStyleSourceDirToUs\u2026o(projectRoot).toString()");
            diagnosticsCollector.report(project, KotlinToolingDiagnostics.AndroidStyleSourceDirUsageWarning.INSTANCE.invoke(string, string2));
        }
    }

    @Override
    public void checkBeforeLayoutApplied(@NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        KotlinAndroidSourceSetLayoutChecker.DefaultImpls.checkBeforeLayoutApplied(this, diagnosticsCollector, target2, layout);
    }
}

