/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001a\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/logging/SL4JKotlinLogger;", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "log", "Lorg/slf4j/Logger;", "prefix", "", "(Lorg/slf4j/Logger;Ljava/lang/String;)V", "isDebugEnabled", "", "()Z", "debug", "", "msg", "error", "throwable", "", "info", "lifecycle", "transformMessage", "warn", "kotlin-gradle-plugin_common"})
public final class SL4JKotlinLogger
implements KotlinLogger {
    @NotNull
    private final Logger log;
    @Nullable
    private final String prefix;

    public SL4JKotlinLogger(@NotNull Logger log, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.prefix = prefix;
    }

    public /* synthetic */ SL4JKotlinLogger(Logger logger, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(logger, string);
    }

    private final String transformMessage(String msg) {
        CharSequence charSequence = this.prefix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return msg;
        }
        return this.prefix + msg;
    }

    public void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log.debug(this.transformMessage(msg));
    }

    public void lifecycle(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log.info(this.transformMessage(msg));
    }

    public void error(@NotNull String msg, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log.error(this.transformMessage(msg), throwable);
    }

    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log.info(this.transformMessage(msg));
    }

    public void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log.warn(this.transformMessage(msg));
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }
}

