/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.InternalKotlinGradlePluginApi;
import org.jetbrains.kotlin.gradle.dsl.KotlinSourceSetConvention;
import org.jetbrains.kotlin.gradle.dsl.NativeTargetShortcutTrace;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticFactory;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayoutKt;
import org.jetbrains.kotlin.gradle.utils.KotlinPlatformTypeUtilsKt;

@InternalKotlinGradlePluginApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\bG\b\u00c7\u0002\u0018\u00002\u00020\u0001:D\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics;", "", "()V", "presetsDeprecationSeverity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "resourcesBugReportRequest", "", "getResourcesBugReportRequest", "()Ljava/lang/String;", "AgpRequirementNotMetForAndroidSourceSetLayoutV2", "AndroidGradlePluginIsMissing", "AndroidMainSourceSetConventionUsedWithoutAndroidTarget", "AndroidSourceSetLayoutV1Deprecation", "AndroidSourceSetLayoutV1SourceSetsNotFoundError", "AndroidStyleSourceDirUsageWarning", "AndroidTargetIsMissing", "AssetsPublishedMoreThanOncePerTarget", "BrokenKotlinNativeBundleError", "BuildToolsApiVersionInconsistency", "CInteropRequiredParametersNotSpecifiedError", "CircularDependsOnEdges", "CommonMainOrTestWithDependsOnDiagnostic", "CreateTarget", "DependencyDoesNotPhysicallyExist", "DeprecatedGradleProperties", "DeprecatedJvmWithJavaPresetDiagnostic", "DeprecatedKotlinNativeTargetsDiagnostic", "DeprecatedPropertyWithReplacement", "DisabledCinteropsCommonizationInHmppProject", "DisabledKotlinNativeTargets", "DuplicateSourceSetsError", "ExperimentalArtifactsDslUsed", "ExperimentalTryNextWarning", "FailedToGetAgpVersionWarning", "FromPreset", "IncompatibleAgpVersionTooHighWarning", "IncompatibleAgpVersionTooLowWarning", "InconsistentTargetCompatibilityForKotlinAndJavaTasks", "IncorrectCompileOnlyDependencyWarning", "InternalKotlinGradlePluginPropertiesUsed", "IosSourceSetConventionUsedWithoutIosTarget", "JsEnvironmentNotChosenExplicitly", "JvmWithJavaIsIncompatibleWithAndroid", "Kotlin12XMppDeprecation", "KotlinCompilationSourceDeprecation", "KotlinDefaultHierarchyFallbackDependsOnUsageDetected", "KotlinDefaultHierarchyFallbackIllegalTargetNames", "KotlinDefaultHierarchyFallbackNativeTargetShortcutUsageDetected", "KotlinJvmMainRunTaskConflict", "KotlinSourceSetDependsOnDefaultCompilationSourceSet", "KotlinSourceSetTreeDependsOnMismatch", "KotlinTargetAlreadyDeclared", "MissingResourcesConfigurationForTarget", "MissingRuntimeDependencyConfigurationForWasmTarget", "MultipleSourceSetRootsInCompilation", "NativeStdlibIsMissingDiagnostic", "NoComposeCompilerPluginAppliedWarning", "NoKotlinTargetsDeclared", "PlatformSourceSetConventionUsedWithCustomTargetName", "PlatformSourceSetConventionUsedWithoutCorrespondingTarget", "PreHMPPFlagsError", "PreHmppDependenciesUsedInBuild", "RedundantDependsOnEdgesFound", "ResourceMayNotBePublishedForTarget", "ResourceMayNotBeResolvedForTarget", "ResourceMayNotBeResolvedWithGradleVersion", "ResourcePublishedMoreThanOncePerTarget", "SourceSetLayoutV1StyleDirUsageWarning", "TargetFromPreset", "UnknownAppleFrameworkBuildType", "UnknownValueProvidedForResourcesStrategy", "UnrecognizedKotlinNativeDistributionType", "UnusedSourceSetsWarning", "WasmSourceSetsNotFoundError", "WasmStabilityWarning", "XCFrameworkDifferentInnerFrameworksName", "XcodeVersionTooHighWarning", "kotlin-gradle-plugin_common"})
public final class KotlinToolingDiagnostics {
    @NotNull
    public static final KotlinToolingDiagnostics INSTANCE = new KotlinToolingDiagnostics();
    @NotNull
    private static final ToolingDiagnostic.Severity presetsDeprecationSeverity = ToolingDiagnostic.Severity.WARNING;

    private KotlinToolingDiagnostics() {
    }

    private final String getResourcesBugReportRequest() {
        return "This is likely a bug in Kotlin Gradle Plugin configuration. Please report this issue to https://kotl.in/issue.";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AgpRequirementNotMetForAndroidSourceSetLayoutV2;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "minimumRequiredAgpVersion", "", "currentAgpVersion", "kotlin-gradle-plugin_common"})
    public static final class AgpRequirementNotMetForAndroidSourceSetLayoutV2
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AgpRequirementNotMetForAndroidSourceSetLayoutV2 INSTANCE = new AgpRequirementNotMetForAndroidSourceSetLayoutV2();

        private AgpRequirementNotMetForAndroidSourceSetLayoutV2() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String minimumRequiredAgpVersion, @NotNull String currentAgpVersion) {
            Intrinsics.checkNotNullParameter((Object)minimumRequiredAgpVersion, (String)"minimumRequiredAgpVersion");
            Intrinsics.checkNotNullParameter((Object)currentAgpVersion, (String)"currentAgpVersion");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                    " + KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV2().getName() + " requires Android Gradle Plugin Version >= " + minimumRequiredAgpVersion + ".\n                    Found " + currentAgpVersion + "\n                ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidGradlePluginIsMissing;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class AndroidGradlePluginIsMissing
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidGradlePluginIsMissing INSTANCE = new AndroidGradlePluginIsMissing();

        private AndroidGradlePluginIsMissing() {
            super(ToolingDiagnostic.Severity.FATAL);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable Throwable trace) {
            return ToolingDiagnosticFactory.build$default(this, "The Android target requires a 'Android Gradle Plugin' to be applied to the project. \n\nplugins {\n    kotlin(\"multiplatform\")\n    \n    /* Android Gradle Plugin missing */\n    id(\"com.android.library\") /* <- Android Gradle Plugin for libraries */\n    id(\"com.android.application\") <* <- Android Gradle Plugin for applications */\n}\n\nkotlin {\n    androidTarget() /* <- requires Android Gradle Plugin to be applied */\n}", null, trace, 2, null);
        }

        public static /* synthetic */ ToolingDiagnostic invoke$default(AndroidGradlePluginIsMissing androidGradlePluginIsMissing, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = null;
            }
            return androidGradlePluginIsMissing.invoke(throwable);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidMainSourceSetConventionUsedWithoutAndroidTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
    public static final class AndroidMainSourceSetConventionUsedWithoutAndroidTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidMainSourceSetConventionUsedWithoutAndroidTarget INSTANCE = new AndroidMainSourceSetConventionUsedWithoutAndroidTarget();

        private AndroidMainSourceSetConventionUsedWithoutAndroidTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |Accessed '" + sourceSet + "' without registering the Android target\n                |Please apply a given Android Gradle plugin (e.g. com.android.library) and register an Android target\n                |\n                |Example using the 'com.android.library' plugin:\n                |\n                |    plugins {\n                |        id(\"com.android.library\")\n                |    }\n                |\n                |    android {\n                |        namespace = \"org.sample.library\"\n                |        compileSdk = 33\n                |    }\n                |\n                |    kotlin {\n                |        androidTarget() /* <- register the androidTarget */\n                |    }\n            "), null, (int)1, null), null, KotlinSourceSetConvention.INSTANCE.isRegisteredByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidSourceSetLayoutV1Deprecation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class AndroidSourceSetLayoutV1Deprecation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidSourceSetLayoutV1Deprecation INSTANCE = new AndroidSourceSetLayoutV1Deprecation();

        private AndroidSourceSetLayoutV1Deprecation() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "The version 1 of Android source set layout is deprecated. Please remove kotlin.mpp.androidSourceSetLayoutVersion=1 from the gradle.properties file.\n\nLearn how to migrate to the version 2 source set layout at: https://kotl.in/android-source-set-layout-v2", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidSourceSetLayoutV1SourceSetsNotFoundError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "nameOfRequestedSourceSet", "", "kotlin-gradle-plugin_common"})
    public static final class AndroidSourceSetLayoutV1SourceSetsNotFoundError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidSourceSetLayoutV1SourceSetsNotFoundError INSTANCE = new AndroidSourceSetLayoutV1SourceSetsNotFoundError();

        private AndroidSourceSetLayoutV1SourceSetsNotFoundError() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String nameOfRequestedSourceSet) {
            Intrinsics.checkNotNullParameter((Object)nameOfRequestedSourceSet, (String)"nameOfRequestedSourceSet");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                KotlinSourceSet with name '" + nameOfRequestedSourceSet + "' not found:\n                The SourceSet requested ('" + nameOfRequestedSourceSet + "') was renamed in Kotlin 1.9.0\n                \n                In order to migrate you might want to replace:\n                sourceSets.getByName(\"androidTest\") -> sourceSets.getByName(\"androidUnitTest\")\n                sourceSets.getByName(\"androidAndroidTest\") -> sourceSets.getByName(\"androidInstrumentedTest\")\n                \n                Learn more about the new Kotlin/Android SourceSet Layout:\n                https://kotl.in/android-source-set-layout-v2\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidStyleSourceDirUsageWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidStyleSourceDirInUse", "", "kotlinStyleSourceDirToUse", "kotlin-gradle-plugin_common"})
    public static final class AndroidStyleSourceDirUsageWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidStyleSourceDirUsageWarning INSTANCE = new AndroidStyleSourceDirUsageWarning();

        private AndroidStyleSourceDirUsageWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidStyleSourceDirInUse, @NotNull String kotlinStyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)androidStyleSourceDirInUse, (String)"androidStyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)kotlinStyleSourceDirToUse, (String)"kotlinStyleSourceDirToUse");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Usage of 'Android Style' source directory " + androidStyleSourceDirInUse + " is deprecated.\n                Use " + kotlinStyleSourceDirToUse + " instead.\n                \n                To suppress this warning: put the following in your gradle.properties:\n                " + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_ANDROID_SOURCE_SET_LAYOUT_ANDROID_STYLE_NO_WARN() + "=true\n                \n                Learn more: https://kotl.in/android-source-set-layout-v2\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidTargetIsMissing;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "projectName", "", "projectPath", "androidPluginId", "kotlin-gradle-plugin_common"})
    public static final class AndroidTargetIsMissing
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidTargetIsMissing INSTANCE = new AndroidTargetIsMissing();

        private AndroidTargetIsMissing() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String projectName, @NotNull String projectPath2, @NotNull String androidPluginId) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)androidPluginId, (String)"androidPluginId");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Missing 'androidTarget()' Kotlin target in multiplatform project '" + projectName + " (" + projectPath2 + ")'.\n            The Android Gradle plugin was applied without creating a corresponding 'android()' Kotlin Target:\n            \n            ```\n            plugins {\n                id(\"" + androidPluginId + "\")\n                kotlin(\"multiplatform\")\n            }\n            \n            kotlin {\n                androidTarget() // <-- please register this Android target\n            }\n            ```\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AssetsPublishedMoreThanOncePerTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class AssetsPublishedMoreThanOncePerTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AssetsPublishedMoreThanOncePerTarget INSTANCE = new AssetsPublishedMoreThanOncePerTarget();

        private AssetsPublishedMoreThanOncePerTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Only one assets publication per android target is allowed.\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$BrokenKotlinNativeBundleError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlinNativeHomePropertyValue", "", "kotlinNativeHomeProperty", "kotlin-gradle-plugin_common"})
    public static final class BrokenKotlinNativeBundleError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final BrokenKotlinNativeBundleError INSTANCE = new BrokenKotlinNativeBundleError();

        private BrokenKotlinNativeBundleError() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable String kotlinNativeHomePropertyValue, @NotNull String kotlinNativeHomeProperty) {
            Intrinsics.checkNotNullParameter((Object)kotlinNativeHomeProperty, (String)"kotlinNativeHomeProperty");
            return ToolingDiagnosticFactory.build$default(this, "The Kotlin/Native distribution (" + kotlinNativeHomePropertyValue + ") used in this build does not provide required subdirectories. Make sure that the '" + kotlinNativeHomeProperty + "' property points to a valid Kotlin/Native distribution.", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$BuildToolsApiVersionInconsistency;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "expectedVersion", "", "actualVersion", "kotlin-gradle-plugin_common"})
    public static final class BuildToolsApiVersionInconsistency
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final BuildToolsApiVersionInconsistency INSTANCE = new BuildToolsApiVersionInconsistency();

        private BuildToolsApiVersionInconsistency() {
            super(ToolingDiagnostic.Severity.FATAL);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String expectedVersion, @Nullable String actualVersion) {
            Intrinsics.checkNotNullParameter((Object)expectedVersion, (String)"expectedVersion");
            ToolingDiagnosticFactory toolingDiagnosticFactory = this;
            StringBuilder stringBuilder = new StringBuilder().append("\n                Artifact org.jetbrains.kotlin:kotlin-build-tools-impl must have version aligned with the version of KGP when compilation via the Build Tools API is disabled.\n\n                Expected version: ").append(expectedVersion).append("\n                Actual resolved version: ");
            String string = actualVersion;
            if (string == null) {
                string = "not found";
            }
            return ToolingDiagnosticFactory.build$default(toolingDiagnosticFactory, StringsKt.trimIndent((String)stringBuilder.append(string).append("\n            ").toString()), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CInteropRequiredParametersNotSpecifiedError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class CInteropRequiredParametersNotSpecifiedError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CInteropRequiredParametersNotSpecifiedError INSTANCE = new CInteropRequiredParametersNotSpecifiedError();

        private CInteropRequiredParametersNotSpecifiedError() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "For the Cinterop task, either the `definitionFile` or `packageName` parameter must be specified, however, neither has been provided.\n\nMore info here: https://kotlinlang.org/docs/multiplatform-dsl-reference.html#cinterops ", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CircularDependsOnEdges;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSetsOnCycle", "", "", "kotlin-gradle-plugin_common"})
    public static final class CircularDependsOnEdges
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CircularDependsOnEdges INSTANCE = new CircularDependsOnEdges();

        private CircularDependsOnEdges() {
            super(ToolingDiagnostic.Severity.FATAL);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> sourceSetsOnCycle) {
            Intrinsics.checkNotNullParameter(sourceSetsOnCycle, (String)"sourceSetsOnCycle");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Circular dependsOn hierarchy found in the Kotlin source sets: " + CollectionsKt.joinToString$default((Iterable)sourceSetsOnCycle, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null) + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CommonMainOrTestWithDependsOnDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "suffix", "", "kotlin-gradle-plugin_common"})
    public static final class CommonMainOrTestWithDependsOnDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CommonMainOrTestWithDependsOnDiagnostic INSTANCE = new CommonMainOrTestWithDependsOnDiagnostic();

        private CommonMainOrTestWithDependsOnDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            return ToolingDiagnosticFactory.build$default(this, "common" + suffix + " can't declare dependsOn on other source sets", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CreateTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "DEPRECATION_MESSAGE", "", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class CreateTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CreateTarget INSTANCE = new CreateTarget();
        @NotNull
        public static final String DEPRECATION_MESSAGE = "The KotlinTargetPreset.createTarget() API is deprecated and will be removed in future releases. Learn how to configure targets at: https://kotl.in/target-configuration";

        private CreateTarget() {
            super(presetsDeprecationSeverity);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, DEPRECATION_MESSAGE, null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DependencyDoesNotPhysicallyExist;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependency", "Ljava/io/File;", "kotlin-gradle-plugin_common"})
    public static final class DependencyDoesNotPhysicallyExist
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DependencyDoesNotPhysicallyExist INSTANCE = new DependencyDoesNotPhysicallyExist();

        private DependencyDoesNotPhysicallyExist() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull File dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n               Unable to find the dependency at the location '" + dependency.getAbsolutePath() + "'.\n               Please make sure that the dependency exists at the specified location or ensure that dependency declarations are correct in your project.\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedGradleProperties;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "usedDeprecatedProperty", "", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedGradleProperties
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedGradleProperties INSTANCE = new DeprecatedGradleProperties();

        private DeprecatedGradleProperties() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String usedDeprecatedProperty) {
            Intrinsics.checkNotNullParameter((Object)usedDeprecatedProperty, (String)"usedDeprecatedProperty");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |The `" + usedDeprecatedProperty + "` deprecated property is used in your build.\n                |Please, stop using it as it is unsupported and may apply no effect to your build.\n                "), null, (int)1, null), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedJvmWithJavaPresetDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedJvmWithJavaPresetDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedJvmWithJavaPresetDiagnostic INSTANCE = new DeprecatedJvmWithJavaPresetDiagnostic();

        private DeprecatedJvmWithJavaPresetDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "The 'jvmWithJava' preset is deprecated and will be removed soon. Please use an ordinary JVM target with Java support:\n\n    kotlin {\n        jvm {\n            withJava()\n        }\n    }\n\nAfter this change, please move the Java sources to the Kotlin source set directories. \nFor example, if the JVM target is given the default name 'jvm':\n * instead of 'src/main/java', use 'src/jvmMain/java'\n * instead of 'src/test/java', use 'src/jvmTest/java'", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedKotlinNativeTargetsDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "usedTargetIds", "", "", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedKotlinNativeTargetsDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedKotlinNativeTargetsDiagnostic INSTANCE = new DeprecatedKotlinNativeTargetsDiagnostic();

        private DeprecatedKotlinNativeTargetsDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> usedTargetIds) {
            Intrinsics.checkNotNullParameter(usedTargetIds, (String)"usedTargetIds");
            return ToolingDiagnosticFactory.build$default(this, "The following removed Kotlin/Native targets were used in the project: " + CollectionsKt.joinToString$default((Iterable)usedTargetIds, null, null, null, (int)0, null, null, (int)63, null), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedPropertyWithReplacement;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "deprecatedPropertyName", "", "replacement", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedPropertyWithReplacement
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedPropertyWithReplacement INSTANCE = new DeprecatedPropertyWithReplacement();

        private DeprecatedPropertyWithReplacement() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String deprecatedPropertyName, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)deprecatedPropertyName, (String)"deprecatedPropertyName");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            return ToolingDiagnosticFactory.build$default(this, "Project property '" + deprecatedPropertyName + "' is deprecated. Please use '" + replacement + "' instead.", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DisabledCinteropsCommonizationInHmppProject;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "affectedSourceSetsString", "", "affectedCinteropsString", "kotlin-gradle-plugin_common"})
    public static final class DisabledCinteropsCommonizationInHmppProject
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DisabledCinteropsCommonizationInHmppProject INSTANCE = new DisabledCinteropsCommonizationInHmppProject();

        private DisabledCinteropsCommonizationInHmppProject() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String affectedSourceSetsString, @NotNull String affectedCinteropsString) {
            Intrinsics.checkNotNullParameter((Object)affectedSourceSetsString, (String)"affectedSourceSetsString");
            Intrinsics.checkNotNullParameter((Object)affectedCinteropsString, (String)"affectedCinteropsString");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                The project is using Kotlin Multiplatform with hierarchical structure and disabled 'cinterop commonization'\n                See: https://kotlinlang.org/docs/mpp-share-on-platforms.html#use-native-libraries-in-the-hierarchical-structure\n           \n                'cinterop commonization' can be enabled in your 'gradle.properties'\n                kotlin.mpp.enableCInteropCommonization=true\n                \n                To hide this message, add to your 'gradle.properties'\n                " + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_ENABLE_CINTEROP_COMMONIZATION() + ".nowarn=true \n            \n                The following source sets are affected: \n                " + affectedSourceSetsString + "\n                \n                The following cinterops are affected: \n                " + affectedCinteropsString + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DisabledKotlinNativeTargets;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "disabledTargetNames", "", "", "kotlin-gradle-plugin_common"})
    public static final class DisabledKotlinNativeTargets
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DisabledKotlinNativeTargets INSTANCE = new DisabledKotlinNativeTargets();

        private DisabledKotlinNativeTargets() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> disabledTargetNames) {
            Intrinsics.checkNotNullParameter(disabledTargetNames, (String)"disabledTargetNames");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                The following Kotlin/Native targets cannot be built on this machine and are disabled:\n                " + CollectionsKt.joinToString$default((Iterable)disabledTargetNames, null, null, null, (int)0, null, null, (int)63, null) + "\n                To hide this message, add '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_NATIVE_IGNORE_DISABLED_TARGETS() + "=true' to the Gradle properties.\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DuplicateSourceSetsError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "duplicatedSourceSets", "", "", "", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DuplicateSourceSetsError\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,984:1\n126#2:985\n153#2,3:986\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DuplicateSourceSetsError\n*L\n738#1:985\n738#1:986,3\n*E\n"})
    public static final class DuplicateSourceSetsError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DuplicateSourceSetsError INSTANCE = new DuplicateSourceSetsError();

        private DuplicateSourceSetsError() {
            super(ToolingDiagnostic.Severity.FATAL);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Map<String, ? extends List<String>> duplicatedSourceSets) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(duplicatedSourceSets, (String)"duplicatedSourceSets");
            Map<String, ? extends List<String>> $this$map$iv = duplicatedSourceSets;
            boolean $i$f$map = false;
            Map<String, ? extends List<String>> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void entry2;
                Map.Entry item$iv$iv;
                Map.Entry entry3 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CollectionsKt.joinToString$default((Iterable)((Iterable)entry2.getValue()), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            String duplicatesGroupsString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"], [", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
            return ToolingDiagnosticFactory.build$default(this, "Duplicate Kotlin source sets have been detected: " + duplicatesGroupsString + ". Keep in mind that source set names are case-insensitive, which means that `srcMain` and `sRcMain` are considered the same source set.", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ExperimentalArtifactsDslUsed;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class ExperimentalArtifactsDslUsed
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ExperimentalArtifactsDslUsed INSTANCE = new ExperimentalArtifactsDslUsed();

        private ExperimentalArtifactsDslUsed() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                'kotlinArtifacts' DSL is experimental and may be changed in the future.\n                To suppress this warning add '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_NATIVE_SUPPRESS_EXPERIMENTAL_ARTIFACTS_DSL_WARNING() + "=true' to your gradle.properties\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ExperimentalTryNextWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class ExperimentalTryNextWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ExperimentalTryNextWarning INSTANCE = new ExperimentalTryNextWarning();

        private ExperimentalTryNextWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "ATTENTION: 'kotlin.experimental.tryNext' is an experimental option enabled in the project for trying out the next Kotlin compiler language version only.\nPlease refrain from using it in production code and provide feedback to the Kotlin team for any issues encountered via https://kotl.in/issue", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$FailedToGetAgpVersionWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class FailedToGetAgpVersionWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final FailedToGetAgpVersionWarning INSTANCE = new FailedToGetAgpVersionWarning();

        private FailedToGetAgpVersionWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "Failed to get AndroidGradlePluginVersion", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$FromPreset;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "DEPRECATION_MESSAGE", "", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class FromPreset
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final FromPreset INSTANCE = new FromPreset();
        @NotNull
        public static final String DEPRECATION_MESSAGE = "The fromPreset() API is deprecated and will be removed in future releases. Learn how to configure targets at: https://kotl.in/target-configuration";

        private FromPreset() {
            super(presetsDeprecationSeverity);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, DEPRECATION_MESSAGE, null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncompatibleAgpVersionTooHighWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidGradlePluginVersionString", "", "minSupported", "maxTested", "kotlin-gradle-plugin_common"})
    public static final class IncompatibleAgpVersionTooHighWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncompatibleAgpVersionTooHighWarning INSTANCE = new IncompatibleAgpVersionTooHighWarning();

        private IncompatibleAgpVersionTooHighWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidGradlePluginVersionString, @NotNull String minSupported, @NotNull String maxTested) {
            Intrinsics.checkNotNullParameter((Object)androidGradlePluginVersionString, (String)"androidGradlePluginVersionString");
            Intrinsics.checkNotNullParameter((Object)minSupported, (String)"minSupported");
            Intrinsics.checkNotNullParameter((Object)maxTested, (String)"maxTested");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Kotlin Multiplatform <-> Android Gradle Plugin compatibility issue:\n                The applied Android Gradle Plugin version (" + androidGradlePluginVersionString + ") is higher \n                than the maximum known to the Kotlin Gradle Plugin.\n                Tooling stability in such configuration isn't tested, please report encountered issues to https://kotl.in/issue\n                \n                Minimum supported Android Gradle Plugin version: " + minSupported + "\n                Maximum tested Android Gradle Plugin version: " + maxTested + "\n                \n                To suppress this message add '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_ANDROID_GRADLE_PLUGIN_COMPATIBILITY_NO_WARN() + "=true' to your gradle.properties\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncompatibleAgpVersionTooLowWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidGradlePluginVersionString", "", "minSupported", "maxTested", "kotlin-gradle-plugin_common"})
    public static final class IncompatibleAgpVersionTooLowWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncompatibleAgpVersionTooLowWarning INSTANCE = new IncompatibleAgpVersionTooLowWarning();

        private IncompatibleAgpVersionTooLowWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidGradlePluginVersionString, @NotNull String minSupported, @NotNull String maxTested) {
            Intrinsics.checkNotNullParameter((Object)androidGradlePluginVersionString, (String)"androidGradlePluginVersionString");
            Intrinsics.checkNotNullParameter((Object)minSupported, (String)"minSupported");
            Intrinsics.checkNotNullParameter((Object)maxTested, (String)"maxTested");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Kotlin Multiplatform <-> Android Gradle Plugin compatibility issue:\n                The applied Android Gradle Plugin version (" + androidGradlePluginVersionString + ") is lower than the minimum supported\n                \n                Minimum supported Android Gradle Plugin version: " + minSupported + "\n                Maximum tested Android Gradle Plugin version: " + maxTested + "\n                \n                To suppress this message add '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_ANDROID_GRADLE_PLUGIN_COMPATIBILITY_NO_WARN() + "=true' to your gradle.properties\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$InconsistentTargetCompatibilityForKotlinAndJavaTasks;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "javaTaskName", "", "targetCompatibility", "kotlinTaskName", "jvmTarget", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "kotlin-gradle-plugin_common"})
    public static final class InconsistentTargetCompatibilityForKotlinAndJavaTasks
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final InconsistentTargetCompatibilityForKotlinAndJavaTasks INSTANCE = new InconsistentTargetCompatibilityForKotlinAndJavaTasks();

        private InconsistentTargetCompatibilityForKotlinAndJavaTasks() {
            super((ToolingDiagnostic.Severity)null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String javaTaskName, @NotNull String targetCompatibility, @NotNull String kotlinTaskName, @NotNull String jvmTarget, @NotNull ToolingDiagnostic.Severity severity) {
            Intrinsics.checkNotNullParameter((Object)javaTaskName, (String)"javaTaskName");
            Intrinsics.checkNotNullParameter((Object)targetCompatibility, (String)"targetCompatibility");
            Intrinsics.checkNotNullParameter((Object)kotlinTaskName, (String)"kotlinTaskName");
            Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Inconsistent JVM-target compatibility detected for tasks '" + javaTaskName + "' (" + targetCompatibility + ") and '" + kotlinTaskName + "' (" + jvmTarget + ").\n                " + (severity == ToolingDiagnostic.Severity.WARNING ? "This will become an error in Gradle 8.0." : "") + "\n                Consider using JVM Toolchain: https://kotl.in/gradle/jvm/toolchain\n                Learn more about JVM-target validation: https://kotl.in/gradle/jvm/target-validation \n            ")), severity, null, 4, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "compilationsWithCompileOnlyDependencies", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning$CompilationDependenciesPair;", "CompilationDependenciesPair", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,984:1\n1557#2:985\n1628#2,3:986\n289#3,16:989\n126#4:1005\n153#4,3:1006\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning\n*L\n772#1:985\n772#1:986,3\n778#1:989,16\n783#1:1005\n783#1:1006,3\n*E\n"})
    public static final class IncorrectCompileOnlyDependencyWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncorrectCompileOnlyDependencyWarning INSTANCE = new IncorrectCompileOnlyDependencyWarning();

        private IncorrectCompileOnlyDependencyWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<CompilationDependenciesPair> compilationsWithCompileOnlyDependencies) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map $this$flatGroupBy$iv;
            CompilationDependenciesPair it;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(compilationsWithCompileOnlyDependencies, (String)"compilationsWithCompileOnlyDependencies");
            Iterable $this$map$iv2 = compilationsWithCompileOnlyDependencies;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                CompilationDependenciesPair compilationDependenciesPair = (CompilationDependenciesPair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinPlatformTypeUtilsKt.getPrettyName(it.getCompilation().getPlatformType()));
            }
            String formattedPlatformNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))), null, null, null, (int)0, null, null, (int)63, null);
            List<CompilationDependenciesPair> $i$f$map22 = compilationsWithCompileOnlyDependencies;
            boolean $i$f$flatGroupBy = false;
            Map result$iv = new LinkedHashMap();
            Iterator $i$f$mapTo22 = $this$flatGroupBy$iv.iterator();
            while ($i$f$mapTo22.hasNext()) {
                Object element$iv = $i$f$mapTo22.next();
                CompilationDependenciesPair it2 = (CompilationDependenciesPair)element$iv;
                boolean bl = false;
                Collection keys$iv = it2.getDependencyCoords();
                it = (CompilationDependenciesPair)element$iv;
                boolean bl2 = false;
                String value$iv = it.getCompilation().getDefaultSourceSet().getName();
                for (Object key$iv : keys$iv) {
                    String it3 = (String)key$iv;
                    boolean bl3 = false;
                    String transformedKey$iv = it3;
                    List list$iv = (List)result$iv.get(transformedKey$iv);
                    if (list$iv == null) {
                        list$iv = new ArrayList();
                        result$iv.put(transformedKey$iv, list$iv);
                    }
                    ((Collection)list$iv).add(value$iv);
                }
            }
            $this$flatGroupBy$iv = result$iv;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                collection = destination$iv$iv2;
                boolean bl = false;
                String dependency = (String)entry2.getKey();
                List sourceSetNames = (List)entry2.getValue();
                collection.add(dependency + " (source sets: " + CollectionsKt.joinToString$default((Iterable)sourceSetNames, null, null, null, (int)0, null, null, (int)63, null) + ')');
            }
            String formattedCompileOnlyDeps2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2))), (CharSequence)"\n", null, null, (int)0, null, (Function1)invoke.formattedCompileOnlyDeps.5.INSTANCE, (int)30, null);
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |A compileOnly dependency is used in targets: " + formattedPlatformNames + ".\n                |Dependencies:\n                |" + formattedCompileOnlyDeps2 + "\n                |\n                |Using compileOnly dependencies in these targets is not currently supported, because compileOnly dependencies must be present during the compilation of projects that depend on this project.\n                |\n                |To ensure consistent compilation behaviour, compileOnly dependencies should be exposed as api dependencies.\n                |\n                |Example:\n                |\n                |    kotlin {\n                |        sourceSets {\n                |            nativeMain {\n                |                dependencies {\n                |                    compileOnly(\"org.example:lib:1.2.3\")\n                |                    // additionally add the compileOnly dependency as an api dependency:\n                |                    api(\"org.example:lib:1.2.3\")\n                |                }\n                |            }\n                |        }\n                |    }\n                |\n                |This warning can be suppressed in gradle.properties:\n                |\n                |    kotlin.suppressGradlePluginWarnings=" + this.getId() + "\n                |\n                "), null, (int)1, null), null, null, 6, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning$CompilationDependenciesPair;", "", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "dependencyCoords", "", "", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;Ljava/util/List;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getDependencyCoords", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
        public static final class CompilationDependenciesPair {
            @NotNull
            private final KotlinCompilation<?> compilation;
            @NotNull
            private final List<String> dependencyCoords;

            public CompilationDependenciesPair(@NotNull KotlinCompilation<?> compilation2, @NotNull List<String> dependencyCoords) {
                Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
                Intrinsics.checkNotNullParameter(dependencyCoords, (String)"dependencyCoords");
                this.compilation = compilation2;
                this.dependencyCoords = dependencyCoords;
            }

            @NotNull
            public final KotlinCompilation<?> getCompilation() {
                return this.compilation;
            }

            @NotNull
            public final List<String> getDependencyCoords() {
                return this.dependencyCoords;
            }

            @NotNull
            public final KotlinCompilation<?> component1() {
                return this.compilation;
            }

            @NotNull
            public final List<String> component2() {
                return this.dependencyCoords;
            }

            @NotNull
            public final CompilationDependenciesPair copy(@NotNull KotlinCompilation<?> compilation2, @NotNull List<String> dependencyCoords) {
                Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
                Intrinsics.checkNotNullParameter(dependencyCoords, (String)"dependencyCoords");
                return new CompilationDependenciesPair(compilation2, dependencyCoords);
            }

            public static /* synthetic */ CompilationDependenciesPair copy$default(CompilationDependenciesPair compilationDependenciesPair, KotlinCompilation kotlinCompilation, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    kotlinCompilation = compilationDependenciesPair.compilation;
                }
                if ((n & 2) != 0) {
                    list = compilationDependenciesPair.dependencyCoords;
                }
                return compilationDependenciesPair.copy(kotlinCompilation, list);
            }

            @NotNull
            public String toString() {
                return "CompilationDependenciesPair(compilation=" + this.compilation + ", dependencyCoords=" + this.dependencyCoords + ')';
            }

            public int hashCode() {
                int result2 = this.compilation.hashCode();
                result2 = result2 * 31 + ((Object)this.dependencyCoords).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CompilationDependenciesPair)) {
                    return false;
                }
                CompilationDependenciesPair compilationDependenciesPair = (CompilationDependenciesPair)other;
                if (!Intrinsics.areEqual(this.compilation, compilationDependenciesPair.compilation)) {
                    return false;
                }
                return Intrinsics.areEqual(this.dependencyCoords, compilationDependenciesPair.dependencyCoords);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$InternalKotlinGradlePluginPropertiesUsed;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "propertiesUsed", "", "", "kotlin-gradle-plugin_common"})
    public static final class InternalKotlinGradlePluginPropertiesUsed
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final InternalKotlinGradlePluginPropertiesUsed INSTANCE = new InternalKotlinGradlePluginPropertiesUsed();

        private InternalKotlinGradlePluginPropertiesUsed() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> propertiesUsed) {
            Intrinsics.checkNotNullParameter(propertiesUsed, (String)"propertiesUsed");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |ATTENTION! This build uses the following Kotlin Gradle Plugin properties:\n                |\n                |" + CollectionsKt.joinToString$default((Iterable)propertiesUsed, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n                |\n                |Internal properties are not recommended for production use. \n                |Stability and future compatibility of the build is not guaranteed.\n            "), null, (int)1, null), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IosSourceSetConventionUsedWithoutIosTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
    public static final class IosSourceSetConventionUsedWithoutIosTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IosSourceSetConventionUsedWithoutIosTarget INSTANCE = new IosSourceSetConventionUsedWithoutIosTarget();

        private IosSourceSetConventionUsedWithoutIosTarget() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |Accessed '" + sourceSet + "' without registering any ios target:\n                |  kotlin {\n                |     /* Register at least one of the following targets */\n                |     iosX64()\n                |     iosArm64()\n                |     iosSimulatorArm64()\n                |\n                |     /* Use convention */\n                |     sourceSets." + sourceSet.getName() + ".dependencies {\n                |\n                |     }\n                |  }\n            "), null, (int)1, null), null, KotlinSourceSetConvention.INSTANCE.isRegisteredByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JsEnvironmentNotChosenExplicitly;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "availableEnvironments", "", "", "kotlin-gradle-plugin_common"})
    public static final class JsEnvironmentNotChosenExplicitly
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final JsEnvironmentNotChosenExplicitly INSTANCE = new JsEnvironmentNotChosenExplicitly();

        private JsEnvironmentNotChosenExplicitly() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> availableEnvironments) {
            Intrinsics.checkNotNullParameter(availableEnvironments, (String)"availableEnvironments");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |Please choose a JavaScript environment to build distributions and run tests.\n                |Not choosing any of them will be an error in the future releases.\n                |kotlin {\n                |    js {\n                |        // To build distributions for and run tests on browser or Node.js use one or both of:\n                |        " + CollectionsKt.joinToString$default((Iterable)availableEnvironments, (CharSequence)"\n        ", null, null, (int)0, null, null, (int)62, null) + "\n                |    }\n                |}\n            "), null, (int)1, null), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JvmWithJavaIsIncompatibleWithAndroid;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidPluginId", "", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class JvmWithJavaIsIncompatibleWithAndroid
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final JvmWithJavaIsIncompatibleWithAndroid INSTANCE = new JvmWithJavaIsIncompatibleWithAndroid();

        private JvmWithJavaIsIncompatibleWithAndroid() {
            super(ToolingDiagnostic.Severity.FATAL);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidPluginId, @Nullable Throwable trace) {
            Intrinsics.checkNotNullParameter((Object)androidPluginId, (String)"androidPluginId");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                'withJava()' is not compatible with Android Plugins\n                Incompatible Android Plugin applied: '" + androidPluginId + "'\n                \n                  kotlin {\n                      jvm {\n                          withJava() /* <- cannot be used when the Android Plugin is present */\n                      }\n                  }\n            ")), null, trace, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$Kotlin12XMppDeprecation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class Kotlin12XMppDeprecation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final Kotlin12XMppDeprecation INSTANCE = new Kotlin12XMppDeprecation();

        private Kotlin12XMppDeprecation() {
            super(ToolingDiagnostic.Severity.FATAL);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "The 'org.jetbrains.kotlin.platform.*' plugins are no longer available.\nPlease migrate the project to the 'org.jetbrains.kotlin.multiplatform' plugin.\nSee: https://kotl.in/legacy-multiplatform-plugins", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinCompilationSourceDeprecation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class KotlinCompilationSourceDeprecation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinCompilationSourceDeprecation INSTANCE = new KotlinCompilationSourceDeprecation();

        private KotlinCompilationSourceDeprecation() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable Throwable trace) {
            return ToolingDiagnosticFactory.build$default(this, "`KotlinCompilation.source(KotlinSourceSet)` method is deprecated\nand will be removed in upcoming Kotlin releases.\n\nSee https://kotl.in/compilation-source-deprecation for details.", null, trace, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackDependsOnUsageDetected;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "project", "Lorg/gradle/api/Project;", "sourceSetsWithDependsOnEdges", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackDependsOnUsageDetected\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,984:1\n1557#2:985\n1628#2,3:986\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackDependsOnUsageDetected\n*L\n542#1:985\n542#1:986,3\n*E\n"})
    public static final class KotlinDefaultHierarchyFallbackDependsOnUsageDetected
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinDefaultHierarchyFallbackDependsOnUsageDetected INSTANCE = new KotlinDefaultHierarchyFallbackDependsOnUsageDetected();

        private KotlinDefaultHierarchyFallbackDependsOnUsageDetected() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Project project, @NotNull Iterable<? extends KotlinSourceSet> sourceSetsWithDependsOnEdges) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(sourceSetsWithDependsOnEdges, (String)"sourceSetsWithDependsOnEdges");
            Iterable iterable = CollectionsKt.toSet(sourceSetsWithDependsOnEdges);
            StringBuilder stringBuilder = new StringBuilder().append("\n                The Default Kotlin Hierarchy Template was not applied to '").append(project.getDisplayName()).append("':\n                Explicit .dependsOn() edges were configured for the following source sets:\n                ");
            ToolingDiagnosticFactory toolingDiagnosticFactory = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            return ToolingDiagnosticFactory.build$default(toolingDiagnosticFactory, StringsKt.trimIndent((String)stringBuilder.append(collection).append("\n                \n                Consider removing dependsOn-calls or disabling the default template by adding\n                    '").append(PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_APPLY_DEFAULT_HIERARCHY_TEMPLATE()).append("=false'\n                to your gradle.properties\n                \n                Learn more about hierarchy templates: https://kotl.in/hierarchy-template\n            ").toString()), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackIllegalTargetNames;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "project", "Lorg/gradle/api/Project;", "illegalTargetNamesUsed", "", "", "kotlin-gradle-plugin_common"})
    public static final class KotlinDefaultHierarchyFallbackIllegalTargetNames
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinDefaultHierarchyFallbackIllegalTargetNames INSTANCE = new KotlinDefaultHierarchyFallbackIllegalTargetNames();

        private KotlinDefaultHierarchyFallbackIllegalTargetNames() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Project project, @NotNull Iterable<String> illegalTargetNamesUsed2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(illegalTargetNamesUsed2, (String)"illegalTargetNamesUsed");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                The Default Kotlin Hierarchy Template was not applied to '" + project.getDisplayName() + "':\n                Source sets created by the following targets will clash with source sets created by the template:\n                " + CollectionsKt.toSet(illegalTargetNamesUsed2) + "\n                \n                Consider renaming the targets or disabling the default template by adding \n                    '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_APPLY_DEFAULT_HIERARCHY_TEMPLATE() + "=false'\n                to your gradle.properties\n                \n                Learn more about hierarchy templates: https://kotl.in/hierarchy-template\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0080\u0002\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackNativeTargetShortcutUsageDetected;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "project", "Lorg/gradle/api/Project;", "trace", "Lorg/jetbrains/kotlin/gradle/dsl/NativeTargetShortcutTrace;", "invoke$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static final class KotlinDefaultHierarchyFallbackNativeTargetShortcutUsageDetected
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinDefaultHierarchyFallbackNativeTargetShortcutUsageDetected INSTANCE = new KotlinDefaultHierarchyFallbackNativeTargetShortcutUsageDetected();

        private KotlinDefaultHierarchyFallbackNativeTargetShortcutUsageDetected() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke$kotlin_gradle_plugin_common(@NotNull Project project, @NotNull NativeTargetShortcutTrace trace) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                The Default Kotlin Hierarchy Template was not applied to '" + project.getDisplayName() + "':\n                Deprecated '" + trace.getShortcut() + "()' shortcut was used:\n                \n                  kotlin {\n                      " + trace.getShortcut() + "()\n                  }\n                \n                Please declare the required targets explicitly:\n                \n                  kotlin {\n                      " + trace.getShortcut() + "X64()\n                      " + trace.getShortcut() + "Arm64()\n                      " + trace.getShortcut() + "SimulatorArm64() /* <- Note: Was not previously applied */\n                      /* ... */\n                  }\n                \n                After that, replace `by getting` with static accessors:\n                \n                  sourceSets {\n                      commonMain { ... }\n                      \n                      " + trace.getShortcut() + "Main {\n                          dependencies { ... }\n                      }\n                  }\n                \n                To suppress the 'Default Hierarchy Template' add\n                    '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_APPLY_DEFAULT_HIERARCHY_TEMPLATE() + "=false'\n                to your gradle.properties\n                \n                Learn more about hierarchy templates: https://kotl.in/hierarchy-template\n            ")), null, trace, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinJvmMainRunTaskConflict;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "taskName", "kotlin-gradle-plugin_common"})
    public static final class KotlinJvmMainRunTaskConflict
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinJvmMainRunTaskConflict INSTANCE = new KotlinJvmMainRunTaskConflict();

        private KotlinJvmMainRunTaskConflict() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2, @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Target '" + targetName2 + "': Unable to create run task '" + taskName + "' as there is already such a task registered\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinSourceSetDependsOnDefaultCompilationSourceSet;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependeeName", "", "dependencyName", "kotlin-gradle-plugin_common"})
    public static final class KotlinSourceSetDependsOnDefaultCompilationSourceSet
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinSourceSetDependsOnDefaultCompilationSourceSet INSTANCE = new KotlinSourceSetDependsOnDefaultCompilationSourceSet();

        private KotlinSourceSetDependsOnDefaultCompilationSourceSet() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String dependeeName, @NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter((Object)dependeeName, (String)"dependeeName");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Kotlin Source Set '" + dependeeName + "' can't depend on '" + dependencyName + "' which is a default source set for compilation.\n                None of source sets can depend on the compilation default source sets.\n                Please remove this dependency edge.\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002J+\u0010\u0003\u001a\u00020\u00042\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002J\"\u0010\u000b\u001a\u00020\u00062\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinSourceSetTreeDependsOnMismatch;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependeeName", "", "dependencyName", "dependents", "", "", "renderSourceSetGroups", "sourceSetGroups", "kotlin-gradle-plugin_common"})
    public static final class KotlinSourceSetTreeDependsOnMismatch
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinSourceSetTreeDependsOnMismatch INSTANCE = new KotlinSourceSetTreeDependsOnMismatch();

        private KotlinSourceSetTreeDependsOnMismatch() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String dependeeName, @NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter((Object)dependeeName, (String)"dependeeName");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Kotlin Source Set '" + dependeeName + "' can't depend on '" + dependencyName + "' as they are from different Source Set Trees.\n                Please remove this dependency edge.\n            ")), null, null, 6, null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Map<String, ? extends List<String>> dependents, @NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter(dependents, (String)"dependents");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Following Kotlin Source Set groups can't depend on '" + dependencyName + "' together as they belong to different Kotlin Source Set Trees.\n                " + KotlinToolingDiagnosticsKt.indentLines$default(this.renderSourceSetGroups(dependents), 16, false, 2, null) + "\n                Please keep dependsOn edges only from one group and remove the others.                \n            ")), null, null, 6, null);
        }

        private final String renderSourceSetGroups(Map<String, ? extends List<String>> sourceSetGroups) {
            StringBuilder stringBuilder;
            StringBuilder $this$renderSourceSetGroups_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (Map.Entry<String, ? extends List<String>> entry2 : sourceSetGroups.entrySet()) {
                String sourceSetTreeName = entry2.getKey();
                List<String> sourceSets = entry2.getValue();
                StringBuilder stringBuilder2 = $this$renderSourceSetGroups_u24lambda_u240.append("Source Sets from '" + sourceSetTreeName + "' Tree:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder3 = $this$renderSourceSetGroups_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)sourceSets, (CharSequence)"\n", null, null, (int)0, null, (Function1)renderSourceSetGroups.1.1.INSTANCE, (int)30, null));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTargetAlreadyDeclared;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetDslFunctionName", "", "kotlin-gradle-plugin_common"})
    public static final class KotlinTargetAlreadyDeclared
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinTargetAlreadyDeclared INSTANCE = new KotlinTargetAlreadyDeclared();

        private KotlinTargetAlreadyDeclared() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetDslFunctionName) {
            Intrinsics.checkNotNullParameter((Object)targetDslFunctionName, (String)"targetDslFunctionName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Kotlin Target '" + targetDslFunctionName + "()' is already declared.\n\n                Declaring multiple Kotlin Targets of the same type is not recommended\n                and will become an error in the upcoming Kotlin releases.\n                \n                Read https://kotl.in/declaring-multiple-targets for details.\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$MissingResourcesConfigurationForTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class MissingResourcesConfigurationForTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final MissingResourcesConfigurationForTarget INSTANCE = new MissingResourcesConfigurationForTarget();

        private MissingResourcesConfigurationForTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Resources will not be resolved for " + targetName2 + " as it is missing resourcesConfiguration.\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$MissingRuntimeDependencyConfigurationForWasmTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class MissingRuntimeDependencyConfigurationForWasmTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final MissingRuntimeDependencyConfigurationForWasmTarget INSTANCE = new MissingRuntimeDependencyConfigurationForWasmTarget();

        private MissingRuntimeDependencyConfigurationForWasmTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Resources will not be resolved for " + targetName2 + " as it is missing runtimeDependencyConfiguration.\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0086\u0002J#\u0010\u0003\u001a\u00020\u00042\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$MultipleSourceSetRootsInCompilation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetNames", "", "", "unexpectedSourceSetRoot", "expectedRoot", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "sourceSetRoots", "kotlin-gradle-plugin_common"})
    public static final class MultipleSourceSetRootsInCompilation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final MultipleSourceSetRootsInCompilation INSTANCE = new MultipleSourceSetRootsInCompilation();

        private MultipleSourceSetRootsInCompilation() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinCompilation<?> kotlinCompilation, @NotNull String unexpectedSourceSetRoot, @NotNull String expectedRoot) {
            Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
            Intrinsics.checkNotNullParameter((Object)unexpectedSourceSetRoot, (String)"unexpectedSourceSetRoot");
            Intrinsics.checkNotNullParameter((Object)expectedRoot, (String)"expectedRoot");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Kotlin Source Set '" + unexpectedSourceSetRoot + "' is included to '" + kotlinCompilation.getName() + "' compilation of '" + kotlinCompilation.getTarget().getName() + "' target,\n            but it doesn't depend on '" + expectedRoot + "'.\n            \n            Please remove '" + unexpectedSourceSetRoot + "' and include its sources to the compilation's default source set:\n            \n                kotlin.sourceSets[\"" + kotlinCompilation.getDefaultSourceSet().getName() + "\"].kotlin.srcDir() // <-- pass sources directory of '" + unexpectedSourceSetRoot + "'                     \n\n            Or provide explicit dependency if the solution above is not applicable\n            \n                kotlin.sourceSets[\"" + unexpectedSourceSetRoot + "\"].dependsOn(" + expectedRoot + ")    \n\n            See https://kotl.in/connecting-source-sets for more details.\n            ")), null, null, 6, null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> targetNames, @NotNull String unexpectedSourceSetRoot, @NotNull String expectedRoot) {
            Intrinsics.checkNotNullParameter(targetNames, (String)"targetNames");
            Intrinsics.checkNotNullParameter((Object)unexpectedSourceSetRoot, (String)"unexpectedSourceSetRoot");
            Intrinsics.checkNotNullParameter((Object)expectedRoot, (String)"expectedRoot");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Kotlin Source Set '" + unexpectedSourceSetRoot + "' is included in compilations of Kotlin Targets: " + CollectionsKt.joinToString$default((Iterable)targetNames, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.1.INSTANCE, (int)30, null) + "  \n            but it doesn't depend on '" + expectedRoot + "'\n            \n            Please remove '" + unexpectedSourceSetRoot + "' and include its sources to one of the default source set: https://kotl.in/hierarchy-template\n            For example:\n\n                kotlin.sourceSets.commonMain.kotlin.srcDir() // <-- pass here sources directory\n            \n            Or add explicit dependency if the solution above is not applicable:\n            \n                kotlin.sourceSets[\"" + unexpectedSourceSetRoot + "\"].dependsOn(" + expectedRoot + ")\n            \n            See https://kotl.in/connecting-source-sets for more details.\n            ")), null, null, 6, null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinCompilation<?> kotlinCompilation, @NotNull Collection<String> sourceSetRoots) {
            Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
            Intrinsics.checkNotNullParameter(sourceSetRoots, (String)"sourceSetRoots");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Kotlin Source Sets: " + CollectionsKt.joinToString$default((Iterable)sourceSetRoots, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.2.INSTANCE, (int)30, null) + " \n            are included to '" + kotlinCompilation.getName() + "' compilation of '" + kotlinCompilation.getTarget().getName() + "' target.\n            However, they have no common source set root between them.\n            \n            Please remove these kotlin source sets and include their source directories to the compilation's default source set.\n            \n                kotlin.sourceSets[\"" + kotlinCompilation.getDefaultSourceSet().getName() + "\"].kotlin.srcDir() // <-- pass sources directories here \n            \n            Or, if the solution above is not applicable, specify `dependsOn` edges between these source sets so that there are no multiple roots.\n            See https://kotl.in/connecting-source-sets for more details.\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NativeStdlibIsMissingDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "changedKotlinNativeHomeProperty", "", "kotlin-gradle-plugin_common"})
    public static final class NativeStdlibIsMissingDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NativeStdlibIsMissingDiagnostic INSTANCE = new NativeStdlibIsMissingDiagnostic();

        private NativeStdlibIsMissingDiagnostic() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable String changedKotlinNativeHomeProperty) {
            return ToolingDiagnosticFactory.build$default(this, "The Kotlin/Native distribution used in this build does not provide the standard library." + this.onlyIf(" Make sure that the '" + changedKotlinNativeHomeProperty + "' property points to a valid Kotlin/Native distribution.", changedKotlinNativeHomeProperty != null), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NoComposeCompilerPluginAppliedWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class NoComposeCompilerPluginAppliedWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NoComposeCompilerPluginAppliedWarning INSTANCE = new NoComposeCompilerPluginAppliedWarning();

        private NoComposeCompilerPluginAppliedWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "The Compose compiler plugin is now a part of Kotlin, please apply the 'org.jetbrains.kotlin.plugin.compose' Gradle plugin to enable it. Learn more about this at https://kotl.in/compose-plugin", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NoKotlinTargetsDeclared;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "projectName", "", "projectPath", "kotlin-gradle-plugin_common"})
    public static final class NoKotlinTargetsDeclared
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NoKotlinTargetsDeclared INSTANCE = new NoKotlinTargetsDeclared();

        private NoKotlinTargetsDeclared() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String projectName, @NotNull String projectPath2) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Please initialize at least one Kotlin target in '" + projectName + " (" + projectPath2 + ")'.\n                Read more https://kotl.in/set-up-targets\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PlatformSourceSetConventionUsedWithCustomTargetName;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "expectedTargetName", "", "kotlin-gradle-plugin_common"})
    public static final class PlatformSourceSetConventionUsedWithCustomTargetName
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PlatformSourceSetConventionUsedWithCustomTargetName INSTANCE = new PlatformSourceSetConventionUsedWithCustomTargetName();

        private PlatformSourceSetConventionUsedWithCustomTargetName() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet, @NotNull KotlinTarget target2, @NotNull String expectedTargetName) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)expectedTargetName, (String)"expectedTargetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                |Accessed '" + sourceSet + "', but " + expectedTargetName + " target used a custom name '" + target2.getName() + "' (expected '" + expectedTargetName + "'):\n                |\n                |Replace:\n                |    kotlin {\n                |        " + expectedTargetName + "(\"" + target2.getName() + "\") /* <- custom name used */\n                |    }\n                |\n                |With:\n                |   kotlin {\n                |       " + expectedTargetName + "()\n                |   }\n            "), null, (int)1, null), null, KotlinSourceSetConvention.INSTANCE.isRegisteredByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PlatformSourceSetConventionUsedWithoutCorrespondingTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "expectedTargetName", "", "kotlin-gradle-plugin_common"})
    public static final class PlatformSourceSetConventionUsedWithoutCorrespondingTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PlatformSourceSetConventionUsedWithoutCorrespondingTarget INSTANCE = new PlatformSourceSetConventionUsedWithoutCorrespondingTarget();

        private PlatformSourceSetConventionUsedWithoutCorrespondingTarget() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet, @NotNull String expectedTargetName) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            Intrinsics.checkNotNullParameter((Object)expectedTargetName, (String)"expectedTargetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimMargin$default((String)("\n                 |Accessed '" + sourceSet + "' without the registering the " + expectedTargetName + " target:\n                 |  kotlin {\n                 |      " + expectedTargetName + "() /* <- register the '" + expectedTargetName + "' target */\n                 |\n                 |      sourceSets." + sourceSet.getName() + ".dependencies {\n                 |\n                 |      }\n                 |  }\n                "), null, (int)1, null), null, KotlinSourceSetConvention.INSTANCE.isRegisteredByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PreHMPPFlagsError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "usedDeprecatedFlags", "", "", "kotlin-gradle-plugin_common"})
    public static final class PreHMPPFlagsError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PreHMPPFlagsError INSTANCE = new PreHMPPFlagsError();

        private PreHMPPFlagsError() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> usedDeprecatedFlags) {
            Intrinsics.checkNotNullParameter(usedDeprecatedFlags, (String)"usedDeprecatedFlags");
            return ToolingDiagnosticFactory.build$default(this, "The following properties are obsolete and no longer supported:\n" + CollectionsKt.joinToString$default((Iterable)usedDeprecatedFlags, null, null, null, (int)0, null, null, (int)63, null) + "\nRead the details here: https://kotlinlang.org/docs/multiplatform-compatibility-guide.html#deprecate-hmpp-properties", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PreHmppDependenciesUsedInBuild;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependencyName", "", "kotlin-gradle-plugin_common"})
    public static final class PreHmppDependenciesUsedInBuild
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PreHmppDependenciesUsedInBuild INSTANCE = new PreHmppDependenciesUsedInBuild();

        private PreHmppDependenciesUsedInBuild() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                The dependency '" + dependencyName + "' was published in the legacy mode. Support for such dependencies will be removed in the future.\n                See https://kotl.in/0b5kn8 for details.\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$RedundantDependsOnEdgesFound;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "redundantEdges", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$RedundantDependsOnEdgesFound$RedundantEdge;", "RedundantEdge", "kotlin-gradle-plugin_common"})
    public static final class RedundantDependsOnEdgesFound
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final RedundantDependsOnEdgesFound INSTANCE = new RedundantDependsOnEdgesFound();

        private RedundantDependsOnEdgesFound() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<RedundantEdge> redundantEdges) {
            Intrinsics.checkNotNullParameter(redundantEdges, (String)"redundantEdges");
            return ToolingDiagnosticFactory.build$kotlin_gradle_plugin_common$default(this, null, null, (Function1)new Function1<StringBuilder, Unit>(redundantEdges){
                final /* synthetic */ List<RedundantEdge> $redundantEdges;
                {
                    this.$redundantEdges = $redundantEdges;
                    super(1);
                }

                public final void invoke(StringBuilder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    StringBuilder stringBuilder = $this$build.append("Redundant dependsOn edges between Kotlin Source Sets found.");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder2 = $this$build.append("Please remove the following dependsOn invocations from your build scripts:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                    Iterable $this$forEach$iv = this.$redundantEdges;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        RedundantEdge edge = (RedundantEdge)element$iv;
                        boolean bl = false;
                        StringBuilder stringBuilder3 = $this$build.append(" * " + edge.getFrom() + ".dependsOn(" + edge.getTo() + ')');
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                    }
                    StringBuilder stringBuilder4 = $this$build.append("They are already added from Kotlin Target Hierarchy template https://kotl.in/hierarchy-template");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                }
            }, 3, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$RedundantDependsOnEdgesFound$RedundantEdge;", "", "from", "", "to", "(Ljava/lang/String;Ljava/lang/String;)V", "getFrom", "()Ljava/lang/String;", "getTo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
        public static final class RedundantEdge {
            @NotNull
            private final String from;
            @NotNull
            private final String to;

            public RedundantEdge(@NotNull String from2, @NotNull String to) {
                Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                this.from = from2;
                this.to = to;
            }

            @NotNull
            public final String getFrom() {
                return this.from;
            }

            @NotNull
            public final String getTo() {
                return this.to;
            }

            @NotNull
            public final String component1() {
                return this.from;
            }

            @NotNull
            public final String component2() {
                return this.to;
            }

            @NotNull
            public final RedundantEdge copy(@NotNull String from2, @NotNull String to) {
                Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                return new RedundantEdge(from2, to);
            }

            public static /* synthetic */ RedundantEdge copy$default(RedundantEdge redundantEdge, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = redundantEdge.from;
                }
                if ((n & 2) != 0) {
                    string2 = redundantEdge.to;
                }
                return redundantEdge.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "RedundantEdge(from=" + this.from + ", to=" + this.to + ')';
            }

            public int hashCode() {
                int result2 = this.from.hashCode();
                result2 = result2 * 31 + this.to.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RedundantEdge)) {
                    return false;
                }
                RedundantEdge redundantEdge = (RedundantEdge)other;
                if (!Intrinsics.areEqual((Object)this.from, (Object)redundantEdge.from)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.to, (Object)redundantEdge.to);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourceMayNotBePublishedForTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class ResourceMayNotBePublishedForTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourceMayNotBePublishedForTarget INSTANCE = new ResourceMayNotBePublishedForTarget();

        private ResourceMayNotBePublishedForTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Resources publication for target " + targetName2 + " is not supported yet.\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourceMayNotBeResolvedForTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class ResourceMayNotBeResolvedForTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourceMayNotBeResolvedForTarget INSTANCE = new ResourceMayNotBeResolvedForTarget();

        private ResourceMayNotBeResolvedForTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Resources resolution for target " + targetName2 + " is not supported.\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourceMayNotBeResolvedWithGradleVersion;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "currentGradleVersion", "minimumRequiredVersion", "kotlin-gradle-plugin_common"})
    public static final class ResourceMayNotBeResolvedWithGradleVersion
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourceMayNotBeResolvedWithGradleVersion INSTANCE = new ResourceMayNotBeResolvedWithGradleVersion();

        private ResourceMayNotBeResolvedWithGradleVersion() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2, @NotNull String currentGradleVersion, @NotNull String minimumRequiredVersion) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)currentGradleVersion, (String)"currentGradleVersion");
            Intrinsics.checkNotNullParameter((Object)minimumRequiredVersion, (String)"minimumRequiredVersion");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Resources for target " + targetName2 + " may not be resolved. Minimum required Gradle version is " + minimumRequiredVersion + " but current is " + currentGradleVersion + ".\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourcePublishedMoreThanOncePerTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class ResourcePublishedMoreThanOncePerTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourcePublishedMoreThanOncePerTarget INSTANCE = new ResourcePublishedMoreThanOncePerTarget();

        private ResourcePublishedMoreThanOncePerTarget() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName2) {
            Intrinsics.checkNotNullParameter((Object)targetName2, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Only one resources publication per target " + targetName2 + " is allowed.\n            \n            " + INSTANCE.getResourcesBugReportRequest() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SourceSetLayoutV1StyleDirUsageWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "v1StyleSourceDirInUse", "", "currentLayoutName", "v2StyleSourceDirToUse", "kotlin-gradle-plugin_common"})
    public static final class SourceSetLayoutV1StyleDirUsageWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SourceSetLayoutV1StyleDirUsageWarning INSTANCE = new SourceSetLayoutV1StyleDirUsageWarning();

        private SourceSetLayoutV1StyleDirUsageWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String v1StyleSourceDirInUse, @NotNull String currentLayoutName, @NotNull String v2StyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)v1StyleSourceDirInUse, (String)"v1StyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)currentLayoutName, (String)"currentLayoutName");
            Intrinsics.checkNotNullParameter((Object)v2StyleSourceDirToUse, (String)"v2StyleSourceDirToUse");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Found used source directory " + v1StyleSourceDirInUse + "\n                This source directory was supported by: " + KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV1().getName() + "\n                Current KotlinAndroidSourceSetLayout: " + currentLayoutName + "\n                New source directory is: " + v2StyleSourceDirToUse + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0005\u001a\u00020\u0006H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$TargetFromPreset;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "DEPRECATION_MESSAGE", "", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class TargetFromPreset
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final TargetFromPreset INSTANCE = new TargetFromPreset();
        @NotNull
        public static final String DEPRECATION_MESSAGE = "The targetFromPreset() API is deprecated and will be removed in future releases. Learn how to configure targets at: https://kotl.in/target-configuration";

        private TargetFromPreset() {
            super(presetsDeprecationSeverity);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, DEPRECATION_MESSAGE, null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnknownAppleFrameworkBuildType;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "envConfiguration", "", "kotlin-gradle-plugin_common"})
    public static final class UnknownAppleFrameworkBuildType
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnknownAppleFrameworkBuildType INSTANCE = new UnknownAppleFrameworkBuildType();

        private UnknownAppleFrameworkBuildType() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String envConfiguration) {
            Intrinsics.checkNotNullParameter((Object)envConfiguration, (String)"envConfiguration");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically.\n                Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnknownValueProvidedForResourcesStrategy;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "value", "", "kotlin-gradle-plugin_common"})
    public static final class UnknownValueProvidedForResourcesStrategy
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnknownValueProvidedForResourcesStrategy INSTANCE = new UnknownValueProvidedForResourcesStrategy();

        private UnknownValueProvidedForResourcesStrategy() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n            Unknown value " + value2 + " provided for " + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_RESOURCES_RESOLUTION_STRATEGY() + "\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnrecognizedKotlinNativeDistributionType;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "actualValue", "", "kotlin-gradle-plugin_common"})
    public static final class UnrecognizedKotlinNativeDistributionType
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnrecognizedKotlinNativeDistributionType INSTANCE = new UnrecognizedKotlinNativeDistributionType();

        private UnrecognizedKotlinNativeDistributionType() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String actualValue) {
            Intrinsics.checkNotNullParameter((Object)actualValue, (String)"actualValue");
            return ToolingDiagnosticFactory.build$default(this, "Gradle Property 'kotlin.native.distribution.type' sets unknown Kotlin/Native distribution type: " + actualValue + "\nAvailable values: prebuilt, light", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnusedSourceSetsWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSetNames", "", "", "kotlin-gradle-plugin_common"})
    public static final class UnusedSourceSetsWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnusedSourceSetsWarning INSTANCE = new UnusedSourceSetsWarning();

        private UnusedSourceSetsWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> sourceSetNames) {
            String string;
            Intrinsics.checkNotNullParameter(sourceSetNames, (String)"sourceSetNames");
            if (sourceSetNames.size() == 1) {
                string = "The Kotlin source set " + (String)CollectionsKt.single((Iterable)sourceSetNames) + " was configured but not added to any Kotlin compilation.\n";
            } else {
                String sourceSetNamesString2 = CollectionsKt.joinToString$default((Iterable)sourceSetNames, (CharSequence)"\n", null, null, (int)0, null, (Function1)invoke.cause.sourceSetNamesString.1.INSTANCE, (int)30, null);
                string = "The following Kotlin source sets were configured but not added to any Kotlin compilation:\n" + sourceSetNamesString2;
            }
            String cause2 = string;
            String details = "You can add a source set to a target's compilation by connecting it with the compilation's default source set using 'dependsOn'.\nSee https://kotl.in/connecting-source-sets";
            return ToolingDiagnosticFactory.build$default(this, cause2 + '\n' + details, null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$WasmSourceSetsNotFoundError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "nameOfRequestedSourceSet", "", "kotlin-gradle-plugin_common"})
    public static final class WasmSourceSetsNotFoundError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final WasmSourceSetsNotFoundError INSTANCE = new WasmSourceSetsNotFoundError();

        private WasmSourceSetsNotFoundError() {
            super(ToolingDiagnostic.Severity.ERROR);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String nameOfRequestedSourceSet) {
            Intrinsics.checkNotNullParameter((Object)nameOfRequestedSourceSet, (String)"nameOfRequestedSourceSet");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                KotlinSourceSet with name '" + nameOfRequestedSourceSet + "' not found:\n                The SourceSet requested ('" + nameOfRequestedSourceSet + "') was renamed in Kotlin 1.9.20\n    \n                In order to migrate you might want to replace: \n                val wasmMain by getting -> val wasmJsMain by getting\n                val wasmTest by getting -> val wasmJsTest by getting\n            ")), null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$WasmStabilityWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class WasmStabilityWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final WasmStabilityWarning INSTANCE = new WasmStabilityWarning();

        private WasmStabilityWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, "New 'wasm' target is Work-in-Progress and is subject to change without notice. Please report encountered issues to https://kotl.in/issue", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$XCFrameworkDifferentInnerFrameworksName;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "xcFramework", "", "innerFrameworks", "kotlin-gradle-plugin_common"})
    public static final class XCFrameworkDifferentInnerFrameworksName
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final XCFrameworkDifferentInnerFrameworksName INSTANCE = new XCFrameworkDifferentInnerFrameworksName();

        private XCFrameworkDifferentInnerFrameworksName() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String xcFramework, @NotNull String innerFrameworks) {
            Intrinsics.checkNotNullParameter((Object)xcFramework, (String)"xcFramework");
            Intrinsics.checkNotNullParameter((Object)innerFrameworks, (String)"innerFrameworks");
            return ToolingDiagnosticFactory.build$default(this, "Name of XCFramework '" + xcFramework + "' differs from inner frameworks name '" + innerFrameworks + "'! Framework renaming is not supported yet", null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$XcodeVersionTooHighWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "xcodeVersionString", "", "maxTested", "kotlin-gradle-plugin_common"})
    public static final class XcodeVersionTooHighWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final XcodeVersionTooHighWarning INSTANCE = new XcodeVersionTooHighWarning();

        private XcodeVersionTooHighWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String xcodeVersionString, @NotNull String maxTested) {
            Intrinsics.checkNotNullParameter((Object)xcodeVersionString, (String)"xcodeVersionString");
            Intrinsics.checkNotNullParameter((Object)maxTested, (String)"maxTested");
            return ToolingDiagnosticFactory.build$default(this, StringsKt.trimIndent((String)("\n                Kotlin <-> Xcode compatibility issue:\n                The selected Xcode version (" + xcodeVersionString + ") is higher than the maximum known to the Kotlin Gradle Plugin.\n                Stability in such configuration hasn't been tested, please report encountered issues to https://kotl.in/issue\n                \n                Maximum tested Xcode version: " + maxTested + "\n                \n                To suppress this message add '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_APPLE_XCODE_COMPATIBILITY_NOWARN() + "=true' to your gradle.properties\n            ")), null, null, 6, null);
        }
    }
}

