/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.LibraryTools;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks.CopySwiftExportIntermediatesForConsumer;

@DisableCachingByDefault(because="This task only copies files")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b!\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0014\u0010-\u001a\u00020)2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020,0+J\b\u0010/\u001a\u00020)H\u0007J\b\u00100\u001a\u00020)H\u0002J\b\u00101\u001a\u00020)H\u0002J\b\u00102\u001a\u00020)H\u0002R\u0013\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0013\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u00020\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0013\u0010\u0019\u001a\u00020\u00148G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#R\u0013\u0010&\u001a\u00020\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000e\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/CopySwiftExportIntermediatesForConsumer;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "fileSystem", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ProjectLayout;Lorg/gradle/api/provider/ProviderFactory;Lorg/gradle/api/file/FileSystemOperations;)V", "builtProductsDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getBuiltProductsDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "includeBridgeDirectory", "getIncludeBridgeDirectory", "includeKotlinRuntimeDirectory", "getIncludeKotlinRuntimeDirectory", "interfaces", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInterfaces", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinRuntimeDestinationPath", "getKotlinRuntimeDestinationPath", "libraries", "getLibraries", "libraryName", "Lorg/gradle/api/provider/Property;", "", "getLibraryName", "()Lorg/gradle/api/provider/Property;", "libraryTools", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/LibraryTools;", "getLibraryTools", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/LibraryTools;", "libraryTools$delegate", "Lkotlin/Lazy;", "syntheticInterfacesDestinationPath", "getSyntheticInterfacesDestinationPath", "addInterface", "", "swiftInterface", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "addLibrary", "library", "copy", "copyInterfaces", "copyOtherIncludes", "mergeAndCopyLibrary", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nCopySwiftExportIntermediatesForConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopySwiftExportIntermediatesForConsumer.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/CopySwiftExportIntermediatesForConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1863#2,2:125\n*S KotlinDebug\n*F\n+ 1 CopySwiftExportIntermediatesForConsumer.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/CopySwiftExportIntermediatesForConsumer\n*L\n104#1:125,2\n*E\n"})
public abstract class CopySwiftExportIntermediatesForConsumer
extends DefaultTask {
    @NotNull
    private final FileSystemOperations fileSystem;
    @NotNull
    private final DirectoryProperty builtProductsDirectory;
    @NotNull
    private final ConfigurableFileCollection libraries;
    @NotNull
    private final ConfigurableFileCollection interfaces;
    @NotNull
    private final DirectoryProperty syntheticInterfacesDestinationPath;
    @NotNull
    private final DirectoryProperty kotlinRuntimeDestinationPath;
    @NotNull
    private final Lazy libraryTools$delegate;

    @Inject
    public CopySwiftExportIntermediatesForConsumer(@NotNull ObjectFactory objectFactory, @NotNull ProjectLayout projectLayout, @NotNull ProviderFactory providerFactory, @NotNull FileSystemOperations fileSystem) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        DirectoryProperty directoryProperty = objectFactory.directoryProperty().convention(projectLayout.dir(providerFactory.environmentVariable("BUILT_PRODUCTS_DIR").map((Transformer)builtProductsDirectory.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryP\u2026File(it)\n        })\n    )");
        this.builtProductsDirectory = directoryProperty;
        ConfigurableFileCollection configurableFileCollection = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objectFactory.fileCollection()");
        this.libraries = configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"objectFactory.fileCollection()");
        this.interfaces = configurableFileCollection2;
        DirectoryProperty directoryProperty2 = objectFactory.directoryProperty().convention(this.builtProductsDirectory.dir("KotlinBridge"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objectFactory.directoryP\u2026ants.KOTLIN_BRIDGE)\n    )");
        this.syntheticInterfacesDestinationPath = directoryProperty2;
        DirectoryProperty directoryProperty3 = objectFactory.directoryProperty().convention(this.builtProductsDirectory.dir("KotlinRuntime"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty3, (String)"objectFactory.directoryP\u2026nts.KOTLIN_RUNTIME)\n    )");
        this.kotlinRuntimeDestinationPath = directoryProperty3;
        this.libraryTools$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LibraryTools>(this){
            final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LibraryTools invoke() {
                return new LibraryTools(this.this$0.getLogger());
            }
        }));
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getIncludeBridgeDirectory();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getIncludeKotlinRuntimeDirectory();

    @Input
    @NotNull
    public abstract Property<String> getLibraryName();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final DirectoryProperty getBuiltProductsDirectory() {
        return this.builtProductsDirectory;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getLibraries() {
        return this.libraries;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getInterfaces() {
        return this.interfaces;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getSyntheticInterfacesDestinationPath() {
        return this.syntheticInterfacesDestinationPath;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getKotlinRuntimeDestinationPath() {
        return this.kotlinRuntimeDestinationPath;
    }

    public final void addLibrary(@NotNull Provider<File> library2) {
        Intrinsics.checkNotNullParameter(library2, (String)"library");
        Object[] objectArray = new Object[]{library2};
        this.libraries.from(objectArray);
    }

    public final void addInterface(@NotNull Provider<File> swiftInterface) {
        Intrinsics.checkNotNullParameter(swiftInterface, (String)"swiftInterface");
        Object[] objectArray = new Object[]{swiftInterface};
        this.interfaces.from(objectArray);
    }

    private final LibraryTools getLibraryTools() {
        Lazy lazy = this.libraryTools$delegate;
        return (LibraryTools)lazy.getValue();
    }

    @TaskAction
    public final void copy() {
        this.mergeAndCopyLibrary();
        this.copyInterfaces();
        this.copyOtherIncludes();
    }

    private final void mergeAndCopyLibrary() {
        Set set2 = this.libraries.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"libraries.files");
        List libsInput = CollectionsKt.toList((Iterable)set2);
        if (((Collection)libsInput).size() > 1) {
            File output2 = (File)this.builtProductsDirectory.map(new Transformer(this){
                final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
                {
                    this.this$0 = $receiver;
                }

                public final File transform(Directory it) {
                    File file = it.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                    Object object = this.this$0.getLibraryName().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"libraryName.get()");
                    return FilesKt.resolve((File)file, (String)((String)object));
                }
            }).get();
            LibraryTools libraryTools2 = this.getLibraryTools();
            Intrinsics.checkNotNullExpressionValue((Object)output2, (String)"output");
            libraryTools2.createFatLibrary(libsInput, output2);
        } else {
            this.fileSystem.copy(new Action(libsInput, this){
                final /* synthetic */ List<File> $libsInput;
                final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
                {
                    this.$libsInput = $libsInput;
                    this.this$0 = $receiver;
                }

                public final void execute(CopySpec it) {
                    Object[] objectArray = new Object[]{CollectionsKt.single(this.$libsInput)};
                    it.from(objectArray);
                    it.into((Object)this.this$0.getBuiltProductsDirectory());
                    it.rename(new Transformer(this.this$0){
                        final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final String transform(String it) {
                            return (String)this.this$0.getLibraryName().get();
                        }
                    });
                }
            });
        }
    }

    private final void copyInterfaces() {
        Set set2 = this.interfaces.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"interfaces.files");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File swiftInterface = (File)element$iv;
            boolean bl = false;
            this.fileSystem.copy(new Action(swiftInterface, this){
                final /* synthetic */ File $swiftInterface;
                final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
                {
                    this.$swiftInterface = $swiftInterface;
                    this.this$0 = $receiver;
                }

                public final void execute(CopySpec it) {
                    Object[] objectArray = new Object[]{this.$swiftInterface};
                    it.from(objectArray);
                    it.into((Object)this.this$0.getBuiltProductsDirectory());
                    it.setIncludeEmptyDirs(false);
                }
            });
        }
    }

    private final void copyOtherIncludes() {
        this.fileSystem.copy(new Action(this){
            final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.this$0.getIncludeBridgeDirectory()};
                it.from(objectArray);
                it.into((Object)this.this$0.getSyntheticInterfacesDestinationPath());
            }
        });
        this.fileSystem.copy(new Action(this){
            final /* synthetic */ CopySwiftExportIntermediatesForConsumer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.this$0.getIncludeKotlinRuntimeDirectory()};
                it.from(objectArray);
                it.into((Object)this.this$0.getKotlinRuntimeDestinationPath());
            }
        });
    }
}

