/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.binaryen;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.ConfigurationPhaseAware;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.AbstractSettings;
import org.jetbrains.kotlin.gradle.targets.js.binaryen.BinaryenEnv;
import org.jetbrains.kotlin.gradle.targets.js.binaryen.BinaryenPlatform;
import org.jetbrains.kotlin.gradle.targets.js.binaryen.BinaryenSetupTask;
import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010.\u001a\u00020\u0002H\u0014R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R/\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\fR\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u001b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u000e\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R+\u0010*\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\u000e\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010\f\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenRootExtension;", "Lorg/jetbrains/kotlin/gradle/targets/js/AbstractSettings;", "Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenEnv;", "rootProject", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "<set-?>", "", "command", "getCommand", "()Ljava/lang/String;", "setCommand", "(Ljava/lang/String;)V", "command$delegate", "Lorg/jetbrains/kotlin/gradle/internal/ConfigurationPhaseAware$Property;", "", "download", "getDownload", "()Z", "setDownload", "(Z)V", "download$delegate", "downloadBaseUrl", "getDownloadBaseUrl", "setDownloadBaseUrl", "downloadBaseUrl$delegate", "gradleHome", "Ljava/io/File;", "kotlin.jvm.PlatformType", "installationDir", "getInstallationDir", "()Ljava/io/File;", "setInstallationDir", "(Ljava/io/File;)V", "installationDir$delegate", "getRootProject", "()Lorg/gradle/api/Project;", "setupTaskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenSetupTask;", "getSetupTaskProvider", "()Lorg/gradle/api/tasks/TaskProvider;", "version", "getVersion", "setVersion", "version$delegate", "finalizeConfiguration", "Companion", "kotlin-gradle-plugin_common"})
public class BinaryenRootExtension
extends AbstractSettings<BinaryenEnv> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final transient Project rootProject;
    private final File gradleHome;
    @NotNull
    private final ConfigurationPhaseAware.Property installationDir$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property downloadBaseUrl$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property version$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property download$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property command$delegate;
    @NotNull
    public static final String EXTENSION_NAME = "kotlinBinaryen";

    /*
     * WARNING - void declaration
     */
    public BinaryenRootExtension(@NotNull Project rootProject) {
        void it;
        File file;
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        this.rootProject = rootProject;
        if (!Intrinsics.areEqual((Object)this.rootProject.getRootProject(), (Object)this.rootProject)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        File file2 = file = this.rootProject.getGradle().getGradleUserHomeDir();
        BinaryenRootExtension binaryenRootExtension = this;
        boolean bl = false;
        Logger logger = this.rootProject.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"rootProject.logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Storing cached files in " + it);
        binaryenRootExtension.gradleHome = file;
        ConfigurationPhaseAware configurationPhaseAware = this;
        File file3 = this.gradleHome;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"gradleHome");
        this.installationDir$delegate = configurationPhaseAware.new ConfigurationPhaseAware.Property<File>(FilesKt.resolve((File)file3, (String)"binaryen"));
        this.downloadBaseUrl$delegate = new ConfigurationPhaseAware.Property<String>("https://github.com/WebAssembly/binaryen/releases/download");
        this.version$delegate = new ConfigurationPhaseAware.Property<String>("117");
        this.download$delegate = new ConfigurationPhaseAware.Property<Boolean>(true);
        this.command$delegate = new ConfigurationPhaseAware.Property<String>("wasm-opt");
    }

    @NotNull
    public final Project getRootProject() {
        return this.rootProject;
    }

    @Override
    @NotNull
    public File getInstallationDir() {
        return (File)this.installationDir$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Override
    public void setInstallationDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.installationDir$delegate.setValue(this, $$delegatedProperties[0], file);
    }

    @Override
    @Nullable
    public String getDownloadBaseUrl() {
        return (String)this.downloadBaseUrl$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Override
    public void setDownloadBaseUrl(@Nullable String string) {
        this.downloadBaseUrl$delegate.setValue(this, $$delegatedProperties[1], string);
    }

    @Override
    @NotNull
    public String getVersion() {
        return (String)this.version$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Override
    public void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version$delegate.setValue(this, $$delegatedProperties[2], string);
    }

    @Override
    public boolean getDownload() {
        return (Boolean)this.download$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Override
    public void setDownload(boolean bl) {
        this.download$delegate.setValue(this, $$delegatedProperties[3], bl);
    }

    @Override
    @NotNull
    public String getCommand() {
        return (String)this.command$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Override
    public void setCommand(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.command$delegate.setValue(this, $$delegatedProperties[4], string);
    }

    @NotNull
    public final TaskProvider<BinaryenSetupTask> getSetupTaskProvider() {
        TaskProvider taskProvider2 = this.rootProject.getTasks().withType(BinaryenSetupTask.class).named("kotlinBinaryenSetup");
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"rootProject.tasks.withTy\u2026d(BinaryenSetupTask.NAME)");
        return taskProvider2;
    }

    @Override
    @NotNull
    protected BinaryenEnv finalizeConfiguration() {
        String platform2 = BinaryenPlatform.INSTANCE.getPlatform();
        String requiredVersionName = "binaryen-version_" + this.getVersion();
        String string = this.getInstallationDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"installationDir.absolutePath");
        CleanableStore cleanableStore = CleanableStore.Companion.get(string);
        File targetPath = cleanableStore.get(requiredVersionName).use();
        boolean isWindows = Intrinsics.areEqual((Object)BinaryenPlatform.INSTANCE.getName(), (Object)"windows");
        return new BinaryenEnv(this.getDownload(), this.getDownloadBaseUrl(), "com.github.webassembly:binaryen:" + this.getVersion() + ':' + platform2 + "@tar.gz", BinaryenRootExtension.finalizeConfiguration$getExecutable(isWindows, this, targetPath, "wasm-opt", this.getCommand(), "exe"), targetPath, cleanableStore, isWindows);
    }

    private static final String finalizeConfiguration$getExecutable(boolean isWindows, BinaryenRootExtension this$0, File targetPath, String command, String customCommand, String windowsExtension) {
        String string;
        String finalCommand;
        String string2 = finalCommand = isWindows && Intrinsics.areEqual((Object)customCommand, (Object)command) ? command + '.' + windowsExtension : customCommand;
        if (this$0.getDownload()) {
            String string3 = FilesKt.resolve((File)FilesKt.resolve((File)targetPath, (String)"bin"), (String)finalCommand).getAbsolutePath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetPath\n             \u2026            .absolutePath");
        } else {
            string = finalCommand;
        }
        return string;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BinaryenRootExtension.class), "installationDir", "getInstallationDir()Ljava/io/File;"))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BinaryenRootExtension.class), "downloadBaseUrl", "getDownloadBaseUrl()Ljava/lang/String;"))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BinaryenRootExtension.class), "version", "getVersion()Ljava/lang/String;"))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BinaryenRootExtension.class), "download", "getDownload()Z"))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BinaryenRootExtension.class), "command", "getCommand()Ljava/lang/String;")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenRootExtension$Companion;", "", "()V", "EXTENSION_NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

