/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.cache;

import java.util.AbstractMap;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.cache.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.cache.RemovalCause;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class RemovalNotification<K, V>
extends AbstractMap.SimpleImmutableEntry<K, V> {
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    public static <K, V> RemovalNotification<K, V> create(@CheckForNull K key, @CheckForNull V value2, RemovalCause cause2) {
        return new RemovalNotification<K, V>(key, value2, cause2);
    }

    private RemovalNotification(@CheckForNull K key, @CheckForNull V value2, RemovalCause cause2) {
        super(key, value2);
        this.cause = Preconditions.checkNotNull(cause2);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }
}

