/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.primitives.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Chars {
    public static final int BYTES = 2;

    private Chars() {
    }

    public static int hashCode(char value2) {
        return value2;
    }

    public static char checkedCast(long value2) {
        char result2 = (char)value2;
        Preconditions.checkArgument((long)result2 == value2, "Out of range: %s", value2);
        return result2;
    }

    public static char saturatedCast(long value2) {
        if (value2 > 65535L) {
            return '\uffff';
        }
        if (value2 < 0L) {
            return '\u0000';
        }
        return (char)value2;
    }

    public static int compare(char a, char b) {
        return a - b;
    }

    public static boolean contains(char[] array2, char target2) {
        for (char value2 : array2) {
            if (value2 != target2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(char[] array2, char target2) {
        return Chars.indexOf(array2, target2, 0, array2.length);
    }

    private static int indexOf(char[] array2, char target2, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(char[] array2, char[] target2) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target2, "target");
        if (target2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target2.length + 1; ++i2) {
            for (int j = 0; j < target2.length; ++j) {
                if (array2[i2 + j] != target2[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array2, char target2) {
        return Chars.lastIndexOf(array2, target2, 0, array2.length);
    }

    private static int lastIndexOf(char[] array2, char target2, int start2, int end) {
        for (int i2 = end - 1; i2 >= start2; --i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static char min(char ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        char min = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min) continue;
            min = array2[i2];
        }
        return min;
    }

    public static char max(char ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        char max = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] <= max) continue;
            max = array2[i2];
        }
        return max;
    }

    public static char constrainToRange(char value2, char min, char max) {
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        return value2 < min ? min : (value2 < max ? value2 : max);
    }

    public static char[] concat(char[] ... arrays) {
        int length = 0;
        for (char[] array2 : arrays) {
            length += array2.length;
        }
        char[] result2 = new char[length];
        int pos = 0;
        for (char[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    @GwtIncompatible
    public static byte[] toByteArray(char value2) {
        return new byte[]{(byte)(value2 >> 8), (byte)value2};
    }

    @GwtIncompatible
    public static char fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Chars.fromBytes(bytes[0], bytes[1]);
    }

    @GwtIncompatible
    public static char fromBytes(byte b1, byte b2) {
        return (char)(b1 << 8 | b2 & 0xFF);
    }

    public static char[] ensureCapacity(char[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, char ... array2) {
        Preconditions.checkNotNull(separator);
        int len = array2.length;
        if (len == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(len + separator.length() * (len - 1));
        builder.append(array2[0]);
        for (int i2 = 1; i2 < len; ++i2) {
            builder.append(separator).append(array2[i2]);
        }
        return builder.toString();
    }

    public static Comparator<char[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static char[] toArray(Collection<Character> collection) {
        if (collection instanceof CharArrayAsList) {
            return ((CharArrayAsList)collection).toCharArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        char[] array2 = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = ((Character)Preconditions.checkNotNull(boxedArray[i2])).charValue();
        }
        return array2;
    }

    public static void sortDescending(char[] array2) {
        Preconditions.checkNotNull(array2);
        Chars.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(char[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Chars.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(char[] array2) {
        Preconditions.checkNotNull(array2);
        Chars.reverse(array2, 0, array2.length);
    }

    public static void reverse(char[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j = toIndex - 1; i2 < j; ++i2, --j) {
            char tmp = array2[i2];
            array2[i2] = array2[j];
            array2[j] = tmp;
        }
    }

    public static void rotate(char[] array2, int distance) {
        Chars.rotate(array2, distance, 0, array2.length);
    }

    public static void rotate(char[] array2, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m = -distance % length;
        m = m < 0 ? m + length : m;
        int newFirstIndex = m + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Chars.reverse(array2, fromIndex, newFirstIndex);
        Chars.reverse(array2, newFirstIndex, toIndex);
        Chars.reverse(array2, fromIndex, toIndex);
    }

    public static List<Character> asList(char ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new CharArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class CharArrayAsList
    extends AbstractList<Character>
    implements RandomAccess,
    Serializable {
        final char[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        CharArrayAsList(char[] array2) {
            this(array2, 0, array2.length);
        }

        CharArrayAsList(char[] array2, int start2, int end) {
            this.array = array2;
            this.start = start2;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Character get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return Character.valueOf(this.array[this.start + index]);
        }

        @Override
        public boolean contains(@CheckForNull Object target2) {
            return target2 instanceof Character && Chars.indexOf(this.array, ((Character)target2).charValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Character && (i2 = Chars.indexOf(this.array, ((Character)target2).charValue(), this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Character && (i2 = Chars.lastIndexOf(this.array, ((Character)target2).charValue(), this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Character set(int index, Character element) {
            Preconditions.checkElementIndex(index, this.size());
            char oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).charValue();
            return Character.valueOf(oldValue);
        }

        @Override
        public List<Character> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new CharArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CharArrayAsList) {
                CharArrayAsList that = (CharArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Chars.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 3);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        char[] toCharArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<char[]>
    {
        INSTANCE;


        @Override
        public int compare(char[] left, char[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Chars.compare(left[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Chars.lexicographicalComparator()";
        }
    }
}

