/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.compilerRunner.CompilerExecutionSettings;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.tasks.BackupRestoreWrapper;
import org.jetbrains.kotlin.gradle.tasks.FailedCompilationException;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.TaskOutputsBackup;
import org.jetbrains.kotlin.gradle.tasks.TasksOutputsBackupKt;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0017\u0018BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers;", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "jdkToolsJar", "Ljava/io/File;", "compilerExecutionSettings", "Lorg/jetbrains/kotlin/compilerRunner/CompilerExecutionSettings;", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "fusMetricsConsumer", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;Ljava/io/File;Lorg/jetbrains/kotlin/compilerRunner/CompilerExecutionSettings;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;Lorg/gradle/workers/WorkerExecutor;Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;)V", "runCompilerAsync", "Lorg/gradle/workers/WorkQueue;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "taskOutputsBackup", "Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "GradleKotlinCompilerWorkAction", "GradleKotlinCompilerWorkParameters", "kotlin-gradle-plugin_common"})
public final class GradleCompilerRunnerWithWorkers
extends GradleCompilerRunner {
    @NotNull
    private final WorkerExecutor workerExecutor;

    public GradleCompilerRunnerWithWorkers(@NotNull GradleCompileTaskProvider taskProvider2, @Nullable File jdkToolsJar, @NotNull CompilerExecutionSettings compilerExecutionSettings, @NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetrics, @NotNull WorkerExecutor workerExecutor, @Nullable StatisticsValuesConsumer fusMetricsConsumer) {
        Intrinsics.checkNotNullParameter((Object)taskProvider2, (String)"taskProvider");
        Intrinsics.checkNotNullParameter((Object)compilerExecutionSettings, (String)"compilerExecutionSettings");
        Intrinsics.checkNotNullParameter(buildMetrics, (String)"buildMetrics");
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        super(taskProvider2, jdkToolsJar, compilerExecutionSettings, buildMetrics, fusMetricsConsumer);
        this.workerExecutor = workerExecutor;
    }

    @Override
    @NotNull
    protected WorkQueue runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs, @Nullable TaskOutputsBackup taskOutputsBackup) {
        Intrinsics.checkNotNullParameter((Object)workArgs, (String)"workArgs");
        this.getBuildMetrics().addTimeMetric((BuildPerformanceMetric)GradleBuildPerformanceMetric.CALL_WORKER);
        WorkQueue workQueue2 = this.workerExecutor.noIsolation();
        workQueue2.submit(GradleKotlinCompilerWorkAction.class, new Action(workArgs, taskOutputsBackup, this){
            final /* synthetic */ GradleKotlinCompilerWorkArguments $workArgs;
            final /* synthetic */ TaskOutputsBackup $taskOutputsBackup;
            final /* synthetic */ GradleCompilerRunnerWithWorkers this$0;
            {
                this.$workArgs = $workArgs;
                this.$taskOutputsBackup = $taskOutputsBackup;
                this.this$0 = $receiver;
            }

            public final void execute(GradleKotlinCompilerWorkParameters params) {
                params.getCompilerWorkArguments().set((Object)this.$workArgs);
                if (this.$taskOutputsBackup != null) {
                    params.getTaskOutputsToRestore().set((Iterable)this.$taskOutputsBackup.getOutputsToRestore());
                    params.getBuildDir().set((Provider)this.$taskOutputsBackup.getBuildDirectory());
                    params.getSnapshotsDir().set(this.$taskOutputsBackup.getSnapshotsDir());
                    params.getMetricsReporter().set(this.this$0.getBuildMetrics());
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"workQueue");
        return workQueue2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkParameters;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/FileSystemOperations;)V", "logger", "Lorg/jetbrains/kotlin/gradle/logging/GradleKotlinLogger;", "execute", "", "kotlin-gradle-plugin_common"})
    public static abstract class GradleKotlinCompilerWorkAction
    implements WorkAction<GradleKotlinCompilerWorkParameters> {
        @NotNull
        private final FileSystemOperations fileSystemOperations;
        @NotNull
        private final GradleKotlinLogger logger;

        @Inject
        public GradleKotlinCompilerWorkAction(@NotNull FileSystemOperations fileSystemOperations) {
            Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
            this.fileSystemOperations = fileSystemOperations;
            Logger logger = Logging.getLogger((String)"kotlin-compile-worker");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"kotlin-compile-worker\")");
            this.logger = new GradleKotlinLogger(logger, null, 2, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            TaskOutputsBackup taskOutputsBackup;
            if (((GradleKotlinCompilerWorkParameters)this.getParameters()).getSnapshotsDir().isPresent()) {
                DirectoryProperty directoryProperty = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getBuildDir();
                Provider provider = (Provider)((GradleKotlinCompilerWorkParameters)this.getParameters()).getSnapshotsDir();
                Object object = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getTaskOutputsToRestore().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.taskOutputsToRestore.get()");
                taskOutputsBackup = new TaskOutputsBackup(this.fileSystemOperations, directoryProperty, (Provider<Directory>)provider, (List)object, this.logger);
            } else {
                taskOutputsBackup = null;
            }
            TaskOutputsBackup taskOutputsBackup2 = taskOutputsBackup;
            try {
                Object object = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getCompilerWorkArguments().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.compilerWorkArguments.get()");
                new GradleKotlinCompilerWork((GradleKotlinCompilerWorkArguments)object).run();
            }
            catch (FailedCompilationException e) {
                TaskOutputsBackup taskOutputsBackup3 = taskOutputsBackup2;
                if (taskOutputsBackup3 != null) {
                    TasksOutputsBackupKt.tryRestoringOnRecoverableException(taskOutputsBackup3, e, new BackupRestoreWrapper(this){
                        final /* synthetic */ GradleKotlinCompilerWorkAction this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void wrap(Function0<Unit> restoreAction) {
                            void time$iv;
                            void $this$measure$iv;
                            Intrinsics.checkNotNullParameter(restoreAction, (String)"restoreAction");
                            Object object = ((GradleKotlinCompilerWorkParameters)this.this$0.getParameters()).getMetricsReporter().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.metricsReporter.get()");
                            BuildMetricsReporter buildMetricsReporter = (BuildMetricsReporter)object;
                            BuildTime buildTime = (BuildTime)GradleBuildTime.RESTORE_OUTPUT_FROM_BACKUP;
                            GradleKotlinCompilerWorkAction gradleKotlinCompilerWorkAction = this.this$0;
                            boolean $i$f$measure = false;
                            $this$measure$iv.startMeasure((BuildTime)time$iv);
                            try {
                                boolean bl = false;
                                GradleKotlinCompilerWorkAction.access$getLogger$p(gradleKotlinCompilerWorkAction).info("Restoring task outputs to pre-compilation state");
                                restoreAction.invoke();
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                $this$measure$iv.endMeasure((BuildTime)time$iv);
                            }
                        }
                    });
                }
                throw e;
            }
            finally {
                TaskOutputsBackup taskOutputsBackup4 = taskOutputsBackup2;
                if (taskOutputsBackup4 != null) {
                    taskOutputsBackup4.deleteSnapshot();
                }
            }
        }

        public static final /* synthetic */ GradleKotlinLogger access$getLogger$p(GradleKotlinCompilerWorkAction $this) {
            return $this.logger;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "buildDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDir", "()Lorg/gradle/api/file/DirectoryProperty;", "compilerWorkArguments", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "getCompilerWorkArguments", "()Lorg/gradle/api/provider/Property;", "metricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "getMetricsReporter", "snapshotsDir", "getSnapshotsDir", "taskOutputsToRestore", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getTaskOutputsToRestore", "()Lorg/gradle/api/provider/ListProperty;", "kotlin-gradle-plugin_common"})
    public static interface GradleKotlinCompilerWorkParameters
    extends WorkParameters {
        @NotNull
        public Property<GradleKotlinCompilerWorkArguments> getCompilerWorkArguments();

        @NotNull
        public ListProperty<File> getTaskOutputsToRestore();

        @NotNull
        public DirectoryProperty getSnapshotsDir();

        @NotNull
        public DirectoryProperty getBuildDir();

        @NotNull
        public Property<BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>> getMetricsReporter();
    }
}

