/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.storage.lf;

import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorageWithRWLockedPageContent;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.PagedStorage;
import org.jetbrains.kotlin.com.intellij.util.io.storage.IDataTable;

public final class DataTableLF
implements IDataTable {
    private static final Logger LOG = Logger.getInstance(DataTableLF.class);
    private static final int HEADER_SIZE = 32;
    private static final int DIRTY_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private final PagedStorage file;
    private volatile int wasteSize;
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_WASTE_SIZE_OFFSET = 4;
    private volatile boolean isDirty;

    public DataTableLF(@NotNull Path filePath, @NotNull StorageLockContext context) throws IOException {
        if (filePath == null) {
            DataTableLF.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DataTableLF.$$$reportNull$$$0(1);
        }
        this.file = PagedFileStorageWithRWLockedPageContent.createWithDefaults(filePath, context, 8192, false, context.lockingStrategyWithGlobalLock());
        if (this.file.length() == 0L) {
            this.markDirty();
        } else {
            this.readInHeader(filePath);
        }
    }

    @Override
    public boolean isCompactNecessary() {
        return (double)this.wasteSize / (double)this.file.length() > 0.25 && this.wasteSize > 0x300000;
    }

    private void readInHeader(@NotNull Path filePath) throws IOException {
        int magic;
        if (filePath == null) {
            DataTableLF.$$$reportNull$$$0(2);
        }
        if ((magic = this.file.getInt(0L)) != 523190095) {
            IOException ioError = new IOException("Records table for '" + filePath + "' haven't been closed correctly. Rebuild required.");
            try {
                this.file.close();
            }
            catch (IOException ioe) {
                ioError.addSuppressed(ioe);
            }
            throw ioError;
        }
        this.wasteSize = this.file.getInt(4L);
    }

    @Override
    public void readBytes(long address, byte[] bytes) throws IOException {
        this.file.get(address, bytes, 0, bytes.length);
    }

    @Override
    public void writeBytes(long address, byte[] bytes) throws IOException {
        this.writeBytes(address, bytes, 0, bytes.length);
    }

    @Override
    public void writeBytes(long address, byte[] bytes, int off, int len) throws IOException {
        this.markDirty();
        this.file.put(address, bytes, off, len);
    }

    @Override
    public long allocateSpace(int len) throws IOException {
        long result2 = Math.max(this.file.length(), 32L);
        long newLength = result2 + (long)len;
        this.writeBytes(newLength - 1L, new byte[]{0});
        long actualLength = this.file.length();
        if (actualLength != newLength) {
            LOG.error("Failed to resize the storage at: " + this.file + ". Required: " + newLength + ", actual: " + actualLength);
        }
        return result2;
    }

    @Override
    public void reclaimSpace(int len) throws IOException {
        if (len > 0) {
            this.markDirty();
            this.wasteSize += len;
        }
    }

    @Override
    public void close() throws IOException {
        this.markClean();
        this.file.close();
    }

    @Override
    public void force() throws IOException {
        this.markClean();
        this.file.force();
    }

    @Override
    public boolean isDirty() {
        return this.isDirty || this.file.isDirty();
    }

    private void markClean() throws IOException {
        if (this.isDirty) {
            this.isDirty = false;
            this.fillInHeader(523190095, this.wasteSize);
        }
    }

    private void markDirty() throws IOException {
        if (!this.isDirty) {
            this.isDirty = true;
            this.fillInHeader(313341156, 0);
        }
    }

    private void fillInHeader(int magic, int wasteSize) throws IOException {
        this.file.putInt(0L, magic);
        this.file.putInt(4L, wasteSize);
    }

    @Override
    public int getWaste() {
        return this.wasteSize;
    }

    @Override
    public long getFileSize() {
        return this.file.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/storage/lf/DataTableLF";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readInHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

