/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.CompositeMetadataArtifact;
import org.jetbrains.kotlin.gradle.plugin.mpp.CompositeMetadataArtifactContent;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.ModuleDependencyIdentifier;
import org.jetbrains.kotlin.gradle.plugin.mpp.SourceSetMetadataLayout;
import org.jetbrains.kotlin.gradle.utils.ChecksumUtilsKt;
import org.jetbrains.kotlin.gradle.utils.ZipUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0005\u0015\u0016\u0017\u0018\u0019B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifact;", "moduleDependencyIdentifier", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;", "moduleDependencyVersion", "", "kotlinProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "primaryArtifactFile", "Ljava/io/File;", "hostSpecificArtifactFilesBySourceSetName", "", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;Ljava/io/File;Ljava/util/Map;)V", "getModuleDependencyIdentifier", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;", "getModuleDependencyVersion", "()Ljava/lang/String;", "exists", "", "open", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent;", "ArtifactFile", "CInteropMetadataBinaryImpl", "CompositeMetadataArtifactContentImpl", "MetadataBinaryImpl", "SourceSetContentImpl", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nCompositeMetadataArtifactImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeMetadataArtifactImpl.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1726#2,3:239\n*S KotlinDebug\n*F\n+ 1 CompositeMetadataArtifactImpl.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl\n*L\n28#1:239,3\n*E\n"})
public final class CompositeMetadataArtifactImpl
implements CompositeMetadataArtifact {
    @NotNull
    private final ModuleDependencyIdentifier moduleDependencyIdentifier;
    @NotNull
    private final String moduleDependencyVersion;
    @NotNull
    private final KotlinProjectStructureMetadata kotlinProjectStructureMetadata;
    @NotNull
    private final File primaryArtifactFile;
    @NotNull
    private final Map<String, File> hostSpecificArtifactFilesBySourceSetName;

    public CompositeMetadataArtifactImpl(@NotNull ModuleDependencyIdentifier moduleDependencyIdentifier, @NotNull String moduleDependencyVersion, @NotNull KotlinProjectStructureMetadata kotlinProjectStructureMetadata2, @NotNull File primaryArtifactFile, @NotNull Map<String, ? extends File> hostSpecificArtifactFilesBySourceSetName) {
        Intrinsics.checkNotNullParameter((Object)moduleDependencyIdentifier, (String)"moduleDependencyIdentifier");
        Intrinsics.checkNotNullParameter((Object)moduleDependencyVersion, (String)"moduleDependencyVersion");
        Intrinsics.checkNotNullParameter((Object)kotlinProjectStructureMetadata2, (String)"kotlinProjectStructureMetadata");
        Intrinsics.checkNotNullParameter((Object)primaryArtifactFile, (String)"primaryArtifactFile");
        Intrinsics.checkNotNullParameter(hostSpecificArtifactFilesBySourceSetName, (String)"hostSpecificArtifactFilesBySourceSetName");
        this.moduleDependencyIdentifier = moduleDependencyIdentifier;
        this.moduleDependencyVersion = moduleDependencyVersion;
        this.kotlinProjectStructureMetadata = kotlinProjectStructureMetadata2;
        this.primaryArtifactFile = primaryArtifactFile;
        this.hostSpecificArtifactFilesBySourceSetName = hostSpecificArtifactFilesBySourceSetName;
    }

    @Override
    @NotNull
    public ModuleDependencyIdentifier getModuleDependencyIdentifier() {
        return this.moduleDependencyIdentifier;
    }

    @Override
    @NotNull
    public String getModuleDependencyVersion() {
        return this.moduleDependencyVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exists() {
        File it;
        if (!this.primaryArtifactFile.exists()) return false;
        Iterable $this$all$iv = this.hostSpecificArtifactFilesBySourceSetName.values();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (File)element$iv;
            boolean bl = false;
        } while (it.exists());
        return false;
    }

    @Override
    @NotNull
    public CompositeMetadataArtifactContent open() {
        return new CompositeMetadataArtifactContentImpl();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0006J\b\u0010\u001d\u001a\u00020\u001aH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "checksum", "", "getChecksum", "()Ljava/lang/String;", "checksum$delegate", "Lkotlin/Lazy;", "entries", "", "Ljava/util/zip/ZipEntry;", "getEntries", "()Ljava/util/List;", "entries$delegate", "isClosed", "", "lazyZip", "Lkotlin/Lazy;", "Ljava/util/zip/ZipFile;", "zip", "getZip", "()Ljava/util/zip/ZipFile;", "close", "", "containsKlibDirectory", "path", "ensureNotClosed", "kotlin-gradle-plugin_common"})
    private static final class ArtifactFile
    implements Closeable {
        @NotNull
        private final File file;
        private boolean isClosed;
        @NotNull
        private final Lazy<ZipFile> lazyZip;
        @NotNull
        private final Lazy entries$delegate;
        @NotNull
        private final Lazy checksum$delegate;

        public ArtifactFile(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.file = file2;
            this.lazyZip = LazyKt.lazy((Function0)((Function0)new Function0<ZipFile>(this){
                final /* synthetic */ ArtifactFile this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final ZipFile invoke() {
                    ArtifactFile.access$ensureNotClosed(this.this$0);
                    return new ZipFile(ArtifactFile.access$getFile$p(this.this$0));
                }
            }));
            this.entries$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends ZipEntry>>(this){
                final /* synthetic */ ArtifactFile this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final List<ZipEntry> invoke() {
                    Enumeration<? extends ZipEntry> enumeration = this.this$0.getZip().entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zip.entries()");
                    ArrayList<? extends ZipEntry> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    return arrayList;
                }
            }));
            this.checksum$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ArtifactFile this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String invoke() {
                    CRC32 crc32 = new CRC32();
                    Iterable $this$forEach$iv = this.this$0.getEntries();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ZipEntry entry2 = (ZipEntry)element$iv;
                        boolean bl = false;
                        crc32.update((int)entry2.getCrc());
                    }
                    return ChecksumUtilsKt.checksumString((int)crc32.getValue());
                }
            }));
        }

        @NotNull
        public final ZipFile getZip() {
            return (ZipFile)this.lazyZip.getValue();
        }

        @NotNull
        public final List<ZipEntry> getEntries() {
            Lazy lazy = this.entries$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final String getChecksum() {
            Lazy lazy = this.checksum$delegate;
            return (String)lazy.getValue();
        }

        public final boolean containsKlibDirectory(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String pathToTheManifestFile = ZipUtilsKt.ensureValidZipDirectoryPath(path) + "default/manifest";
            return this.getZip().getEntry(pathToTheManifestFile) != null;
        }

        private final void ensureNotClosed() {
            if (this.isClosed) {
                throw new IOException("LazyZipFile is already closed!");
            }
        }

        @Override
        public void close() {
            this.isClosed = true;
            if (this.lazyZip.isInitialized()) {
                ((ZipFile)this.lazyZip.getValue()).close();
            }
        }

        public static final /* synthetic */ void access$ensureNotClosed(ArtifactFile $this) {
            $this.ensureNotClosed();
        }

        public static final /* synthetic */ File access$getFile$p(ArtifactFile $this) {
            return $this.file;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$CInteropMetadataBinaryImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$CInteropMetadataBinary;", "containingSourceSetContent", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;", "cinteropLibraryName", "", "artifactFile", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl;Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;)V", "archiveExtension", "getArchiveExtension", "()Ljava/lang/String;", "checksum", "getChecksum", "getCinteropLibraryName", "getContainingSourceSetContent", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;", "relativeFile", "Ljava/io/File;", "getRelativeFile", "()Ljava/io/File;", "copyTo", "", "file", "kotlin-gradle-plugin_common"})
    private final class CInteropMetadataBinaryImpl
    implements CompositeMetadataArtifactContent.CInteropMetadataBinary {
        @NotNull
        private final CompositeMetadataArtifactContent.SourceSetContent containingSourceSetContent;
        @NotNull
        private final String cinteropLibraryName;
        @NotNull
        private final ArtifactFile artifactFile;
        @NotNull
        private final File relativeFile;

        /*
         * WARNING - void declaration
         */
        public CInteropMetadataBinaryImpl(@NotNull CompositeMetadataArtifactContent.SourceSetContent containingSourceSetContent, @NotNull String cinteropLibraryName, ArtifactFile artifactFile) {
            void $this$relativeFile_u24lambda_u240;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)containingSourceSetContent, (String)"containingSourceSetContent");
            Intrinsics.checkNotNullParameter((Object)cinteropLibraryName, (String)"cinteropLibraryName");
            Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
            this.containingSourceSetContent = containingSourceSetContent;
            this.cinteropLibraryName = cinteropLibraryName;
            this.artifactFile = artifactFile;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            CInteropMetadataBinaryImpl cInteropMetadataBinaryImpl = this;
            boolean bl = false;
            $this$relativeFile_u24lambda_u240.append(this.getContainingSourceSetContent().getContainingArtifactContent().getContainingArtifact().getModuleDependencyIdentifier());
            $this$relativeFile_u24lambda_u240.append("-");
            $this$relativeFile_u24lambda_u240.append(this.getContainingSourceSetContent().getContainingArtifactContent().getContainingArtifact().getModuleDependencyVersion());
            $this$relativeFile_u24lambda_u240.append("-");
            $this$relativeFile_u24lambda_u240.append(this.getContainingSourceSetContent().getSourceSetName());
            $this$relativeFile_u24lambda_u240.append("-cinterop");
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2;
            cInteropMetadataBinaryImpl.relativeFile = FilesKt.resolve((File)new File(string3), (String)(this.getCinteropLibraryName() + '-' + this.getChecksum() + '.' + this.getArchiveExtension()));
        }

        @Override
        @NotNull
        public CompositeMetadataArtifactContent.SourceSetContent getContainingSourceSetContent() {
            return this.containingSourceSetContent;
        }

        @Override
        @NotNull
        public String getCinteropLibraryName() {
            return this.cinteropLibraryName;
        }

        @Override
        @NotNull
        public String getArchiveExtension() {
            return SourceSetMetadataLayout.KLIB.INSTANCE.getArchiveExtension();
        }

        @Override
        @NotNull
        public String getChecksum() {
            return this.artifactFile.getChecksum();
        }

        @Override
        @NotNull
        public File getRelativeFile() {
            return this.relativeFile;
        }

        @Override
        public boolean copyTo(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)this.getArchiveExtension())) {
                boolean $i$a$-require-CompositeMetadataArtifactImpl$CInteropMetadataBinaryImpl$copyTo$22 = false;
                String $i$a$-require-CompositeMetadataArtifactImpl$CInteropMetadataBinaryImpl$copyTo$22 = "Expected 'file.extension == '" + SourceSetMetadataLayout.KLIB.INSTANCE.getArchiveExtension() + "'. Found " + FilesKt.getExtension((File)file2);
                throw new IllegalArgumentException($i$a$-require-CompositeMetadataArtifactImpl$CInteropMetadataBinaryImpl$copyTo$22.toString());
            }
            String sourceSetName = this.getContainingSourceSetContent().getSourceSetName();
            String string2 = CompositeMetadataArtifactImpl.this.kotlinProjectStructureMetadata.getSourceSetCInteropMetadataDirectory().get(sourceSetName);
            if (string2 == null) {
                throw new IllegalStateException(("Missing CInteropMetadataDirectory for SourceSet " + sourceSetName).toString());
            }
            String cinteropMetadataDirectory = string2;
            String cinteropMetadataDirectoryPath = ZipUtilsKt.ensureValidZipDirectoryPath(cinteropMetadataDirectory);
            String libraryPath = cinteropMetadataDirectoryPath + this.getCinteropLibraryName() + '/';
            if (!this.artifactFile.containsKlibDirectory(libraryPath)) {
                return false;
            }
            file2.getParentFile().mkdirs();
            ZipUtilsKt.copyPartially(this.artifactFile.getZip(), file2, cinteropMetadataDirectoryPath + this.getCinteropLibraryName() + '/');
            return true;
        }

        @Override
        public boolean copyIntoDirectory(@NotNull File directory) {
            return CompositeMetadataArtifactContent.CInteropMetadataBinary.DefaultImpls.copyIntoDirectory(this, directory);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$CompositeMetadataArtifactContentImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl;)V", "containingArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifact;", "getContainingArtifact", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifact;", "sourceSets", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;", "getSourceSets", "()Ljava/util/List;", "sourceSetsImpl", "", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$SourceSetContentImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl;", "close", "", "findSourceSet", "name", "getSourceSet", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nCompositeMetadataArtifactImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeMetadataArtifactImpl.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$CompositeMetadataArtifactContentImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1271#2,2:239\n1285#2,4:241\n1855#2,2:245\n*S KotlinDebug\n*F\n+ 1 CompositeMetadataArtifactImpl.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$CompositeMetadataArtifactContentImpl\n*L\n41#1:239,2\n41#1:241,4\n58#1:245,2\n*E\n"})
    public final class CompositeMetadataArtifactContentImpl
    implements CompositeMetadataArtifactContent {
        @NotNull
        private final Map<String, SourceSetContentImpl> sourceSetsImpl;
        @NotNull
        private final List<CompositeMetadataArtifactContent.SourceSetContent> sourceSets;

        /*
         * WARNING - void declaration
         */
        public CompositeMetadataArtifactContentImpl() {
            void $this$associateWith$iv;
            Iterable iterable = CompositeMetadataArtifactImpl.this.kotlinProjectStructureMetadata.getSourceSetNames();
            CompositeMetadataArtifactImpl compositeMetadataArtifactImpl = CompositeMetadataArtifactImpl.this;
            CompositeMetadataArtifactContentImpl compositeMetadataArtifactContentImpl = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void sourceSetName;
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                CompositeMetadataArtifactContent compositeMetadataArtifactContent = this;
                File file2 = (File)compositeMetadataArtifactImpl.hostSpecificArtifactFilesBySourceSetName.get(sourceSetName);
                if (file2 == null) {
                    file2 = compositeMetadataArtifactImpl.primaryArtifactFile;
                }
                SourceSetContentImpl sourceSetContentImpl = compositeMetadataArtifactImpl.new SourceSetContentImpl(compositeMetadataArtifactContent, (String)sourceSetName, new ArtifactFile(file2));
                map2.put(t, sourceSetContentImpl);
            }
            compositeMetadataArtifactContentImpl.sourceSetsImpl = result$iv;
            this.sourceSets = CollectionsKt.toList((Iterable)this.sourceSetsImpl.values());
        }

        @Override
        @NotNull
        public CompositeMetadataArtifact getContainingArtifact() {
            return CompositeMetadataArtifactImpl.this;
        }

        @Override
        @NotNull
        public List<CompositeMetadataArtifactContent.SourceSetContent> getSourceSets() {
            return this.sourceSets;
        }

        @Override
        @NotNull
        public CompositeMetadataArtifactContent.SourceSetContent getSourceSet(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            CompositeMetadataArtifactContent.SourceSetContent sourceSetContent = this.findSourceSet(name2);
            if (sourceSetContent == null) {
                throw new IllegalArgumentException("No SourceSet with name " + name2 + " found. Known SourceSets: " + this.sourceSetsImpl.keySet());
            }
            return sourceSetContent;
        }

        @Override
        @Nullable
        public CompositeMetadataArtifactContent.SourceSetContent findSourceSet(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return this.sourceSetsImpl.get(name2);
        }

        @Override
        public void close() {
            Iterable $this$forEach$iv = this.sourceSetsImpl.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SourceSetContentImpl it = (SourceSetContentImpl)element$iv;
                boolean bl = false;
                it.close();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$MetadataBinaryImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$MetadataBinary;", "containingSourceSetContent", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;", "artifactFile", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl;Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;)V", "archiveExtension", "", "getArchiveExtension", "()Ljava/lang/String;", "checksum", "getChecksum", "getContainingSourceSetContent", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;", "relativeFile", "Ljava/io/File;", "getRelativeFile", "()Ljava/io/File;", "copyTo", "", "file", "kotlin-gradle-plugin_common"})
    private final class MetadataBinaryImpl
    implements CompositeMetadataArtifactContent.MetadataBinary {
        @NotNull
        private final CompositeMetadataArtifactContent.SourceSetContent containingSourceSetContent;
        @NotNull
        private final ArtifactFile artifactFile;
        @NotNull
        private final File relativeFile;

        /*
         * WARNING - void declaration
         */
        public MetadataBinaryImpl(@NotNull CompositeMetadataArtifactContent.SourceSetContent containingSourceSetContent, ArtifactFile artifactFile) {
            void $this$relativeFile_u24lambda_u240;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)containingSourceSetContent, (String)"containingSourceSetContent");
            Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
            this.containingSourceSetContent = containingSourceSetContent;
            this.artifactFile = artifactFile;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            MetadataBinaryImpl metadataBinaryImpl = this;
            boolean bl = false;
            $this$relativeFile_u24lambda_u240.append(this.getContainingSourceSetContent().getContainingArtifactContent().getContainingArtifact().getModuleDependencyIdentifier());
            $this$relativeFile_u24lambda_u240.append("-");
            $this$relativeFile_u24lambda_u240.append(this.getContainingSourceSetContent().getContainingArtifactContent().getContainingArtifact().getModuleDependencyVersion());
            $this$relativeFile_u24lambda_u240.append("-");
            $this$relativeFile_u24lambda_u240.append(this.getContainingSourceSetContent().getSourceSetName());
            $this$relativeFile_u24lambda_u240.append("-");
            $this$relativeFile_u24lambda_u240.append(this.getChecksum());
            $this$relativeFile_u24lambda_u240.append(".");
            $this$relativeFile_u24lambda_u240.append(this.getArchiveExtension());
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2;
            metadataBinaryImpl.relativeFile = new File(string3);
        }

        @Override
        @NotNull
        public CompositeMetadataArtifactContent.SourceSetContent getContainingSourceSetContent() {
            return this.containingSourceSetContent;
        }

        @Override
        @NotNull
        public String getArchiveExtension() {
            Object object = CompositeMetadataArtifactImpl.this.kotlinProjectStructureMetadata.getSourceSetBinaryLayout().get(this.getContainingSourceSetContent().getSourceSetName());
            if (object == null || (object = ((SourceSetMetadataLayout)object).getArchiveExtension()) == null) {
                object = SourceSetMetadataLayout.METADATA.INSTANCE.getArchiveExtension();
            }
            return object;
        }

        @Override
        @NotNull
        public String getChecksum() {
            return this.artifactFile.getChecksum();
        }

        @Override
        @NotNull
        public File getRelativeFile() {
            return this.relativeFile;
        }

        @Override
        public boolean copyTo(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)this.getArchiveExtension())) {
                boolean bl = false;
                String string2 = "Expected file.extension == '" + this.getArchiveExtension() + "'. Found " + FilesKt.getExtension((File)file2);
                throw new IllegalArgumentException(string2.toString());
            }
            String libraryPath = this.getContainingSourceSetContent().getSourceSetName() + '/';
            if (!this.artifactFile.containsKlibDirectory(libraryPath)) {
                return false;
            }
            file2.getParentFile().mkdirs();
            ZipUtilsKt.copyPartially(this.artifactFile.getZip(), file2, libraryPath);
            return true;
        }

        @Override
        public boolean copyIntoDirectory(@NotNull File directory) {
            return CompositeMetadataArtifactContent.MetadataBinary.DefaultImpls.copyIntoDirectory(this, directory);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$SourceSetContentImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$SourceSetContent;", "Ljava/io/Closeable;", "containingArtifactContent", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent;", "sourceSetName", "", "artifactFile", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl;Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactImpl$ArtifactFile;)V", "cinteropMetadataBinaries", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$CInteropMetadataBinary;", "getCinteropMetadataBinaries", "()Ljava/util/List;", "cinteropMetadataBinaries$delegate", "Lkotlin/Lazy;", "getContainingArtifactContent", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent;", "metadataBinary", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$MetadataBinary;", "getMetadataBinary", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataArtifactContent$MetadataBinary;", "metadataBinary$delegate", "getSourceSetName", "()Ljava/lang/String;", "close", "", "kotlin-gradle-plugin_common"})
    private final class SourceSetContentImpl
    implements CompositeMetadataArtifactContent.SourceSetContent,
    Closeable {
        @NotNull
        private final CompositeMetadataArtifactContent containingArtifactContent;
        @NotNull
        private final String sourceSetName;
        @NotNull
        private final ArtifactFile artifactFile;
        @NotNull
        private final Lazy metadataBinary$delegate;
        @NotNull
        private final Lazy cinteropMetadataBinaries$delegate;

        public SourceSetContentImpl(@NotNull CompositeMetadataArtifactContent containingArtifactContent, @NotNull String sourceSetName, ArtifactFile artifactFile) {
            Intrinsics.checkNotNullParameter((Object)containingArtifactContent, (String)"containingArtifactContent");
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
            this.containingArtifactContent = containingArtifactContent;
            this.sourceSetName = sourceSetName;
            this.artifactFile = artifactFile;
            this.metadataBinary$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MetadataBinaryImpl>(this, CompositeMetadataArtifactImpl.this){
                final /* synthetic */ SourceSetContentImpl this$0;
                final /* synthetic */ CompositeMetadataArtifactImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                public final MetadataBinaryImpl invoke() {
                    return SourceSetContentImpl.access$getArtifactFile$p(this.this$0).containsKlibDirectory(this.this$0.getSourceSetName()) ? this.this$1.new MetadataBinaryImpl(this.this$0, SourceSetContentImpl.access$getArtifactFile$p(this.this$0)) : null;
                }
            }));
            this.cinteropMetadataBinaries$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends CompositeMetadataArtifactContent.CInteropMetadataBinary>>(CompositeMetadataArtifactImpl.this, this){
                final /* synthetic */ CompositeMetadataArtifactImpl this$0;
                final /* synthetic */ SourceSetContentImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final List<CompositeMetadataArtifactContent.CInteropMetadataBinary> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    String string2 = CompositeMetadataArtifactImpl.access$getKotlinProjectStructureMetadata$p(this.this$0).getSourceSetCInteropMetadataDirectory().get(this.this$1.getSourceSetName());
                    if (string2 == null) {
                        return CollectionsKt.emptyList();
                    }
                    String cinteropMetadataDirectory = string2;
                    String cinteropMetadataDirectoryPath = ZipUtilsKt.ensureValidZipDirectoryPath(cinteropMetadataDirectory);
                    Sequence<ZipEntry> cinteropEntries = ZipUtilsKt.listDescendants(SourceSetContentImpl.access$getArtifactFile$p(this.this$1).getZip(), cinteropMetadataDirectoryPath);
                    Set cinteropLibraryNames2 = SequencesKt.toSet((Sequence)SequencesKt.map(cinteropEntries, (Function1)((Function1)new Function1<ZipEntry, String>(cinteropMetadataDirectoryPath){
                        final /* synthetic */ String $cinteropMetadataDirectoryPath;
                        {
                            this.$cinteropMetadataDirectoryPath = $cinteropMetadataDirectoryPath;
                            super(1);
                        }

                        public final String invoke(ZipEntry entry2) {
                            Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
                            String string2 = entry2.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                            String[] stringArray = new String[]{"/"};
                            return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)string2, (CharSequence)this.$cinteropMetadataDirectoryPath), (String[])stringArray, (boolean)false, (int)2, (int)2, null));
                        }
                    })));
                    Iterable iterable = cinteropLibraryNames2;
                    CompositeMetadataArtifactImpl compositeMetadataArtifactImpl = this.this$0;
                    SourceSetContentImpl sourceSetContentImpl = this.this$1;
                    boolean $i$f$map = false;
                    void var9_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void cinteropLibraryName;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(compositeMetadataArtifactImpl.new CInteropMetadataBinaryImpl(sourceSetContentImpl, (String)cinteropLibraryName, SourceSetContentImpl.access$getArtifactFile$p(sourceSetContentImpl)));
                    }
                    return (List)destination$iv$iv;
                }
            }));
        }

        @Override
        @NotNull
        public CompositeMetadataArtifactContent getContainingArtifactContent() {
            return this.containingArtifactContent;
        }

        @Override
        @NotNull
        public String getSourceSetName() {
            return this.sourceSetName;
        }

        @Override
        @Nullable
        public CompositeMetadataArtifactContent.MetadataBinary getMetadataBinary() {
            Lazy lazy = this.metadataBinary$delegate;
            return (CompositeMetadataArtifactContent.MetadataBinary)lazy.getValue();
        }

        @Override
        @NotNull
        public List<CompositeMetadataArtifactContent.CInteropMetadataBinary> getCinteropMetadataBinaries() {
            Lazy lazy = this.cinteropMetadataBinaries$delegate;
            return (List)lazy.getValue();
        }

        @Override
        public void close() {
            this.artifactFile.close();
        }

        public static final /* synthetic */ ArtifactFile access$getArtifactFile$p(SourceSetContentImpl $this) {
            return $this.artifactFile;
        }
    }
}

