/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.resources.AssembleHierarchicalResourcesTask;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b!\u0018\u00002\u00020\u0001:\u0003 !\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "fileSystem", "Lorg/gradle/api/file/FileSystemOperations;", "getFileSystem", "()Lorg/gradle/api/file/FileSystemOperations;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "getProjectLayout", "()Lorg/gradle/api/file/ProjectLayout;", "relativeResourcePlacement", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getRelativeResourcePlacement", "()Lorg/gradle/api/provider/Property;", "resourceDirectoriesByLevel", "Lorg/gradle/api/provider/ListProperty;", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$Resource;", "getResourceDirectoriesByLevel", "()Lorg/gradle/api/provider/ListProperty;", "resourcesSourceSetWalk", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk;", "Lorg/gradle/api/file/FileTree;", "kotlin.jvm.PlatformType", "action", "", "FileSystem", "Resource", "SourceSetWalk", "kotlin-gradle-plugin_common"})
public abstract class AssembleHierarchicalResourcesTask
extends DefaultTask {
    @NotNull
    private final SourceSetWalk<Resource, FileTree> resourcesSourceSetWalk = new SourceSetWalk((FileSystem)new FileSystem<Resource>(){

        public Sequence<File> walk(Resource root2) {
            Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
            Object object = root2.getResourcesFileTree().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"root.resourcesFileTree.get()");
            return CollectionsKt.asSequence((Iterable)((Iterable)object));
        }

        public boolean exists(File file2) {
            return FileSystem.DefaultImpls.exists(this, file2);
        }

        public boolean isDirectory(File file2) {
            return FileSystem.DefaultImpls.isDirectory(this, file2);
        }
    }, resourcesSourceSetWalk.2.INSTANCE, resourcesSourceSetWalk.3.INSTANCE);

    @Inject
    @NotNull
    public abstract FileSystemOperations getFileSystem();

    @Inject
    @NotNull
    public abstract ProjectLayout getProjectLayout();

    @Nested
    @NotNull
    public abstract ListProperty<List<Resource>> getResourceDirectoriesByLevel();

    @Input
    @NotNull
    public abstract Property<File> getRelativeResourcePlacement();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public final void action() {
        Object object = this.getResourceDirectoriesByLevel().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resourceDirectoriesByLevel.get()");
        List<FileTree> directoriesToCopy = this.resourcesSourceSetWalk.directoriesToCopy((List)object).unwrapOrThrow();
        File outputDirectoryFile = ((Directory)this.getOutputDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)outputDirectoryFile, (String)"outputDirectoryFile");
        FileUtilsKt.deleteDirectoryContents(outputDirectoryFile);
        this.getFileSystem().copy(new Action(directoriesToCopy, outputDirectoryFile, this){
            final /* synthetic */ List<FileTree> $directoriesToCopy;
            final /* synthetic */ File $outputDirectoryFile;
            final /* synthetic */ AssembleHierarchicalResourcesTask this$0;
            {
                this.$directoriesToCopy = $directoriesToCopy;
                this.$outputDirectoryFile = $outputDirectoryFile;
                this.this$0 = $receiver;
            }

            public final void execute(CopySpec copy2) {
                Iterable $this$forEach$iv = this.$directoriesToCopy;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FileTree dir2 = (FileTree)element$iv;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{dir2};
                    copy2.from(objectArray);
                }
                File file2 = this.$outputDirectoryFile;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"outputDirectoryFile");
                Object object = this.this$0.getRelativeResourcePlacement().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"relativeResourcePlacement.get()");
                copy2.into((Object)FilesKt.resolve((File)file2, (File)((File)object)));
                copy2.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
            }
        });
        File[] fileArray = outputDirectoryFile.listFiles();
        if (!(fileArray != null ? !(fileArray.length == 0) : false)) {
            Object object2 = this.getRelativeResourcePlacement().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"relativeResourcePlacement.get()");
            FilesKt.resolve((File)outputDirectoryFile, (File)((File)object2)).mkdirs();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$FileSystem;", "RootEntity", "", "exists", "", "file", "Ljava/io/File;", "isDirectory", "walk", "Lkotlin/sequences/Sequence;", "root", "(Ljava/lang/Object;)Lkotlin/sequences/Sequence;", "kotlin-gradle-plugin_common"})
    public static interface FileSystem<RootEntity> {
        @NotNull
        public Sequence<File> walk(RootEntity var1);

        public boolean exists(@NotNull File var1);

        public boolean isDirectory(@NotNull File var1);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static <RootEntity> boolean exists(@NotNull FileSystem<RootEntity> $this, @NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return file2.exists();
            }

            public static <RootEntity> boolean isDirectory(@NotNull FileSystem<RootEntity> $this, @NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return file2.isDirectory();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\u0010\rR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$Resource;", "", "resourcesBaseDirectory", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "includes", "", "", "excludes", "layout", "Lorg/gradle/api/file/ProjectLayout;", "resourcesFileTree", "Lorg/gradle/api/file/FileTree;", "(Lorg/gradle/api/provider/Provider;Ljava/util/List;Ljava/util/List;Lorg/gradle/api/file/ProjectLayout;Lorg/gradle/api/provider/Provider;)V", "getResourcesBaseDirectory", "()Lorg/gradle/api/provider/Provider;", "getResourcesFileTree", "kotlin-gradle-plugin_common"})
    public static final class Resource {
        @NotNull
        private final Provider<File> resourcesBaseDirectory;
        @NotNull
        private final Provider<FileTree> resourcesFileTree;

        public Resource(@NotNull Provider<File> resourcesBaseDirectory, @NotNull List<String> includes, @NotNull List<String> excludes, @NotNull ProjectLayout layout, @NotNull Provider<FileTree> resourcesFileTree) {
            Intrinsics.checkNotNullParameter(resourcesBaseDirectory, (String)"resourcesBaseDirectory");
            Intrinsics.checkNotNullParameter(includes, (String)"includes");
            Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Intrinsics.checkNotNullParameter(resourcesFileTree, (String)"resourcesFileTree");
            this.resourcesBaseDirectory = resourcesBaseDirectory;
            this.resourcesFileTree = resourcesFileTree;
        }

        public /* synthetic */ Resource(Provider provider, final List list, final List list2, ProjectLayout projectLayout, Provider provider2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                Provider provider3 = projectLayout.dir(provider).map(new Transformer(){

                    public final FileTree transform(Directory baseDirectory) {
                        return baseDirectory.getAsFileTree().matching(new Action(){

                            public final void execute(PatternFilterable patternFilter) {
                                String[] stringArray;
                                String it;
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    boolean bl = false;
                                    stringArray = new String[]{it};
                                    patternFilter.include(stringArray);
                                }
                                $this$forEach$iv = list2;
                                $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    boolean bl = false;
                                    stringArray = new String[]{it};
                                    patternFilter.exclude(stringArray);
                                }
                            }
                        });
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"includes: List<String>,\n\u2026}\n            }\n        }");
                provider2 = provider3;
            }
            this((Provider<File>)provider, list, list2, projectLayout, (Provider<FileTree>)provider2);
        }

        @Internal
        @NotNull
        public final Provider<File> getResourcesBaseDirectory() {
            return this.resourcesBaseDirectory;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<FileTree> getResourcesFileTree() {
            return this.resourcesFileTree;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u001aB;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\nJ&\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0012J1\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00028\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk;", "Resource", "FileTreeToCopy", "", "fileSystem", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$FileSystem;", "basePathFromResource", "Lkotlin/Function1;", "Ljava/io/File;", "fileTreeToCopyFromResource", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$FileSystem;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getBasePathFromResource", "()Lkotlin/jvm/functions/Function1;", "getFileSystem", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$FileSystem;", "getFileTreeToCopyFromResource", "directoriesToCopy", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result;", "", "leveledResources", "discoverAndAppendResourceDirectory", "resource", "relativePathsSeenAtThisLevel", "", "", "(Ljava/lang/Object;Ljava/util/Map;)Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result;", "Result", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nAssembleHierarchicalResourcesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssembleHierarchicalResourcesTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n2634#2:177\n2634#2:179\n1#3:178\n1#3:180\n*S KotlinDebug\n*F\n+ 1 AssembleHierarchicalResourcesTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk\n*L\n124#1:177\n126#1:179\n124#1:178\n126#1:180\n*E\n"})
    public static final class SourceSetWalk<Resource, FileTreeToCopy> {
        @NotNull
        private final FileSystem<Resource> fileSystem;
        @NotNull
        private final Function1<Resource, File> basePathFromResource;
        @NotNull
        private final Function1<Resource, FileTreeToCopy> fileTreeToCopyFromResource;

        public SourceSetWalk(@NotNull FileSystem<Resource> fileSystem, @NotNull Function1<? super Resource, ? extends File> basePathFromResource, @NotNull Function1<? super Resource, ? extends FileTreeToCopy> fileTreeToCopyFromResource) {
            Intrinsics.checkNotNullParameter(fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter(basePathFromResource, (String)"basePathFromResource");
            Intrinsics.checkNotNullParameter(fileTreeToCopyFromResource, (String)"fileTreeToCopyFromResource");
            this.fileSystem = fileSystem;
            this.basePathFromResource = basePathFromResource;
            this.fileTreeToCopyFromResource = fileTreeToCopyFromResource;
        }

        @NotNull
        public final FileSystem<Resource> getFileSystem() {
            return this.fileSystem;
        }

        @NotNull
        public final Function1<Resource, File> getBasePathFromResource() {
            return this.basePathFromResource;
        }

        @NotNull
        public final Function1<Resource, FileTreeToCopy> getFileTreeToCopyFromResource() {
            return this.fileTreeToCopyFromResource;
        }

        @NotNull
        public final Result<List<FileTreeToCopy>> directoriesToCopy(@NotNull List<? extends List<? extends Resource>> leveledResources) {
            Iterable iterable;
            Intrinsics.checkNotNullParameter(leveledResources, (String)"leveledResources");
            List directoriesToCopy = new ArrayList();
            Iterable $this$onEach$iv = leveledResources;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                Iterable iterable2;
                List level = (List)element$iv;
                boolean bl2 = false;
                Map relativePathsSeenAtThisLevel = new LinkedHashMap();
                Iterable $this$onEach$iv2 = level;
                boolean $i$f$onEach2 = false;
                Iterable $this$onEach_u24lambda_u2416$iv2 = iterable2 = $this$onEach$iv2;
                $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                Iterator iterator2 = $this$onEach_u24lambda_u2416$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2;
                    Object resource = element$iv2 = iterator2.next();
                    boolean bl3 = false;
                    Result<FileTreeToCopy> result2 = this.discoverAndAppendResourceDirectory(resource, relativePathsSeenAtThisLevel);
                    if (result2 instanceof Result.Collision) {
                        return new Result.Collision(((Result.Collision)result2).getLeft(), ((Result.Collision)result2).getRight());
                    }
                    if (result2 instanceof Result.NotDirectory) {
                        return new Result.NotDirectory(((Result.NotDirectory)result2).getPath());
                    }
                    if (!(result2 instanceof Result.ToCopy)) continue;
                    directoriesToCopy.add(((Result.ToCopy)result2).getValue());
                }
            }
            return new Result.ToCopy<List>(directoriesToCopy);
        }

        private final Result<FileTreeToCopy> discoverAndAppendResourceDirectory(Resource resource, Map<String, File> relativePathsSeenAtThisLevel) {
            File resourcesDirectory = (File)this.basePathFromResource.invoke(resource);
            if (!this.fileSystem.exists(resourcesDirectory)) {
                return null;
            }
            if (!this.fileSystem.isDirectory(resourcesDirectory)) {
                return new Result.NotDirectory(resourcesDirectory);
            }
            List collisions2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map(this.fileSystem.walk(resource), (Function1)new Function1<File, Result.Collision<FileTreeToCopy>>(this, resourcesDirectory, relativePathsSeenAtThisLevel){
                final /* synthetic */ SourceSetWalk<Resource, FileTreeToCopy> this$0;
                final /* synthetic */ File $resourcesDirectory;
                final /* synthetic */ Map<String, File> $relativePathsSeenAtThisLevel;
                {
                    this.this$0 = $receiver;
                    this.$resourcesDirectory = $resourcesDirectory;
                    this.$relativePathsSeenAtThisLevel = $relativePathsSeenAtThisLevel;
                    super(1);
                }

                public final Result.Collision<FileTreeToCopy> invoke(File child) {
                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                    if (this.this$0.getFileSystem().isDirectory(child)) {
                        return null;
                    }
                    String relativePath = FilesKt.toRelativeString((File)child, (File)this.$resourcesDirectory);
                    File file2 = this.$relativePathsSeenAtThisLevel.get(relativePath);
                    if (file2 != null) {
                        File alreadySeenFile = file2;
                        boolean bl = false;
                        return new Result.Collision<T>(child, alreadySeenFile);
                    }
                    this.$relativePathsSeenAtThisLevel.put(relativePath, child);
                    return null;
                }
            }), (Function1)discoverAndAppendResourceDirectory.collisions.2.INSTANCE));
            if (!((Collection)collisions2).isEmpty()) {
                return (Result)CollectionsKt.first((List)collisions2);
            }
            return new Result.ToCopy<Object>(this.fileTreeToCopyFromResource.invoke(resource));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002:\u0003\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result;", "T", "", "()V", "unwrapOrThrow", "()Ljava/lang/Object;", "Collision", "NotDirectory", "ToCopy", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$Collision;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$NotDirectory;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$ToCopy;", "kotlin-gradle-plugin_common"})
        public static abstract class Result<T> {
            private Result() {
            }

            public final T unwrapOrThrow() {
                Result result2 = this;
                if (result2 instanceof Collision) {
                    throw new IllegalStateException(("There is a duplicate resource in a source set level:\n" + ((Collision)this).getLeft().getCanonicalPath() + '\n' + ((Collision)this).getRight().getCanonicalPath()).toString());
                }
                if (result2 instanceof NotDirectory) {
                    throw new IllegalStateException(("Path " + ((NotDirectory)this).getPath() + " is not a directory").toString());
                }
                if (result2 instanceof ToCopy) {
                    return ((ToCopy)this).getValue();
                }
                throw new NoWhenBranchMatchedException();
            }

            public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J#\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$Collision;", "T", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result;", "left", "Ljava/io/File;", "right", "(Ljava/io/File;Ljava/io/File;)V", "getLeft", "()Ljava/io/File;", "getRight", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
            public static final class Collision<T>
            extends Result<T> {
                @NotNull
                private final File left;
                @NotNull
                private final File right;

                public Collision(@NotNull File left, @NotNull File right) {
                    Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                    Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                    super(null);
                    this.left = left;
                    this.right = right;
                }

                @NotNull
                public final File getLeft() {
                    return this.left;
                }

                @NotNull
                public final File getRight() {
                    return this.right;
                }

                @NotNull
                public final File component1() {
                    return this.left;
                }

                @NotNull
                public final File component2() {
                    return this.right;
                }

                @NotNull
                public final Collision<T> copy(@NotNull File left, @NotNull File right) {
                    Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                    Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                    return new Collision<T>(left, right);
                }

                public static /* synthetic */ Collision copy$default(Collision collision, File file2, File file3, int n, Object object) {
                    if ((n & 1) != 0) {
                        file2 = collision.left;
                    }
                    if ((n & 2) != 0) {
                        file3 = collision.right;
                    }
                    return collision.copy(file2, file3);
                }

                @NotNull
                public String toString() {
                    return "Collision(left=" + this.left + ", right=" + this.right + ')';
                }

                public int hashCode() {
                    int result2 = this.left.hashCode();
                    result2 = result2 * 31 + this.right.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Collision)) {
                        return false;
                    }
                    Collision collision = (Collision)other;
                    if (!Intrinsics.areEqual((Object)this.left, (Object)collision.left)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.right, (Object)collision.right);
                }
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$NotDirectory;", "T", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result;", "path", "Ljava/io/File;", "(Ljava/io/File;)V", "getPath", "()Ljava/io/File;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
            public static final class NotDirectory<T>
            extends Result<T> {
                @NotNull
                private final File path;

                public NotDirectory(@NotNull File path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    super(null);
                    this.path = path;
                }

                @NotNull
                public final File getPath() {
                    return this.path;
                }

                @NotNull
                public final File component1() {
                    return this.path;
                }

                @NotNull
                public final NotDirectory<T> copy(@NotNull File path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    return new NotDirectory<T>(path);
                }

                public static /* synthetic */ NotDirectory copy$default(NotDirectory notDirectory, File file2, int n, Object object) {
                    if ((n & 1) != 0) {
                        file2 = notDirectory.path;
                    }
                    return notDirectory.copy(file2);
                }

                @NotNull
                public String toString() {
                    return "NotDirectory(path=" + this.path + ')';
                }

                public int hashCode() {
                    return this.path.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof NotDirectory)) {
                        return false;
                    }
                    NotDirectory notDirectory = (NotDirectory)other;
                    return Intrinsics.areEqual((Object)this.path, (Object)notDirectory.path);
                }
            }

            @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$ToCopy;", "T", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result;", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/gradle/plugin/mpp/resources/AssembleHierarchicalResourcesTask$SourceSetWalk$Result$ToCopy;", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
            public static final class ToCopy<T>
            extends Result<T> {
                private final T value;

                public ToCopy(T value2) {
                    super(null);
                    this.value = value2;
                }

                public final T getValue() {
                    return this.value;
                }

                public final T component1() {
                    return this.value;
                }

                @NotNull
                public final ToCopy<T> copy(T value2) {
                    return new ToCopy<T>(value2);
                }

                public static /* synthetic */ ToCopy copy$default(ToCopy toCopy, Object object, int n, Object object2) {
                    if ((n & 1) != 0) {
                        object = toCopy.value;
                    }
                    return toCopy.copy(object);
                }

                @NotNull
                public String toString() {
                    return "ToCopy(value=" + this.value + ')';
                }

                public int hashCode() {
                    return this.value == null ? 0 : this.value.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ToCopy)) {
                        return false;
                    }
                    ToCopy toCopy = (ToCopy)other;
                    return Intrinsics.areEqual(this.value, toCopy.value);
                }
            }
        }
    }
}

