/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.KonanDistribution;
import org.jetbrains.kotlin.commonizer.KonanDistributionKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizerLock;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0002J=\u0010\u001d\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102'\u0010\u001e\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00140\u0010\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00160\u001fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache;", "Ljava/io/Serializable;", "outputDirectory", "Ljava/io/File;", "konanHome", "logger", "Lorg/gradle/api/logging/Logger;", "isCachingEnabled", "", "(Ljava/io/File;Ljava/io/File;Lorg/gradle/api/logging/Logger;Z)V", "lock", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerLock;", "isCached", "directory", "isMissingPlatformLibraries", "missingOutputTargets", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "isUpToDate", "outputTargets", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "logInfo", "", "message", "", "readObject", "input", "Ljava/io/ObjectInputStream;", "todoTargets", "writeCacheForUncachedTargets", "writeCacheAction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nNativeDistributionCommonizerCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeDistributionCommonizerCache.kt\norg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n766#2:110\n857#2,2:111\n2634#2:113\n1549#2:115\n1620#2,3:116\n1549#2:119\n1620#2,3:120\n2624#2,3:123\n1#3:114\n*S KotlinDebug\n*F\n+ 1 NativeDistributionCommonizerCache.kt\norg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache\n*L\n60#1:110\n60#1:111,2\n61#1:113\n84#1:115\n84#1:116,3\n85#1:119\n85#1:120,3\n86#1:123,3\n61#1:114\n*E\n"})
public final class NativeDistributionCommonizerCache
implements Serializable {
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final File konanHome;
    @NotNull
    private final Logger logger;
    private final boolean isCachingEnabled;
    @NotNull
    private transient NativeDistributionCommonizerLock lock;

    public NativeDistributionCommonizerCache(@NotNull File outputDirectory2, @NotNull File konanHome2, @NotNull Logger logger, boolean isCachingEnabled) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.outputDirectory = outputDirectory2;
        this.konanHome = konanHome2;
        this.logger = logger;
        this.isCachingEnabled = isCachingEnabled;
        this.lock = new NativeDistributionCommonizerLock(this.outputDirectory, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NativeDistributionCommonizerCache.access$logInfo((NativeDistributionCommonizerCache)this.receiver, p0);
            }
        }));
    }

    public final boolean isUpToDate(@NotNull Set<SharedCommonizerTarget> outputTargets) {
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        return ((Set)this.lock.withLock((Function1)new Function1<File, Set<? extends SharedCommonizerTarget>>(this, outputTargets){
            final /* synthetic */ NativeDistributionCommonizerCache this$0;
            final /* synthetic */ Set<SharedCommonizerTarget> $outputTargets;
            {
                this.this$0 = $receiver;
                this.$outputTargets = $outputTargets;
                super(1);
            }

            public final Set<SharedCommonizerTarget> invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NativeDistributionCommonizerCache.access$todoTargets(this.this$0, this.$outputTargets);
            }
        })).isEmpty();
    }

    public final void writeCacheForUncachedTargets(@NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull Function1<? super Set<SharedCommonizerTarget>, Unit> writeCacheAction) {
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter(writeCacheAction, (String)"writeCacheAction");
        this.lock.withLock((Function1)new Function1<File, Unit>(this, outputTargets, writeCacheAction){
            final /* synthetic */ NativeDistributionCommonizerCache this$0;
            final /* synthetic */ Set<SharedCommonizerTarget> $outputTargets;
            final /* synthetic */ Function1<Set<SharedCommonizerTarget>, Unit> $writeCacheAction;
            {
                this.this$0 = $receiver;
                this.$outputTargets = $outputTargets;
                this.$writeCacheAction = $writeCacheAction;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(File it) {
                void $this$filterTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Set todoOutputTargets = NativeDistributionCommonizerCache.access$todoTargets(this.this$0, this.$outputTargets);
                if (todoOutputTargets.isEmpty()) {
                    return;
                }
                this.$writeCacheAction.invoke((Object)todoOutputTargets);
                Iterable iterable = todoOutputTargets;
                NativeDistributionCommonizerCache nativeDistributionCommonizerCache = this.this$0;
                boolean $i$f$map22 = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void outputTarget;
                    SharedCommonizerTarget sharedCommonizerTarget2 = (SharedCommonizerTarget)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(NativeDistributionCommonizerCache.access$getOutputDirectory$p(nativeDistributionCommonizerCache), (CommonizerTarget)outputTarget));
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                Iterable $i$f$map22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    File commonizedDirectory = (File)element$iv$iv;
                    boolean bl = false;
                    if (!commonizedDirectory.isDirectory()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    File commonizedDirectory = (File)element$iv;
                    boolean bl = false;
                    FilesKt.resolve((File)commonizedDirectory, (String)".success").createNewFile();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Set<SharedCommonizerTarget> todoTargets(Set<SharedCommonizerTarget> outputTargets) {
        SharedCommonizerTarget outputTarget;
        void $this$filterTo$iv$iv;
        this.lock.checkLocked(this.outputDirectory);
        this.logInfo("Calculating cache state for " + outputTargets);
        if (!this.isCachingEnabled) {
            this.logInfo("Cache disabled");
            if (this.isMissingPlatformLibraries(outputTargets)) {
                return SetsKt.emptySet();
            }
            return outputTargets;
        }
        Iterable $this$filter$iv = outputTargets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            outputTarget = (SharedCommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!this.isCached(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(this.outputDirectory, (CommonizerTarget)outputTarget))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl2 = false;
            this.logInfo("Cache hit: " + outputTarget + " already commonized");
        }
        Set cachedOutputTargets = CollectionsKt.toSet((Iterable)iterable);
        Set todoOutputTargets = SetsKt.minus(outputTargets, (Iterable)cachedOutputTargets);
        if (todoOutputTargets.isEmpty() || this.isMissingPlatformLibraries(todoOutputTargets)) {
            this.logInfo("All available targets are commonized already - Nothing to do");
            if (!((Collection)todoOutputTargets).isEmpty()) {
                this.logInfo("Platforms cannot be commonized, because of missing platform libraries: " + todoOutputTargets);
            }
            return SetsKt.emptySet();
        }
        return todoOutputTargets;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMissingPlatformLibraries(Set<? extends CommonizerTarget> missingOutputTargets) {
        boolean bl;
        block5: {
            KonanTarget target2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = CommonizerTargetKt.allLeaves((Iterable)missingOutputTargets);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(target2.getKonanTarget());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void konanTarget2;
                target2 = (KonanTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(FilesKt.resolve((File)KonanDistributionKt.getPlatformLibsDir((KonanDistribution)new KonanDistribution(this.konanHome)), (String)konanTarget2.getName()));
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File platformLibsDir = (File)element$iv;
                    boolean bl4 = false;
                    if (!platformLibsDir.exists()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isCached(File directory) {
        File successMarkerFile = FilesKt.resolve((File)directory, (String)".success");
        return successMarkerFile.isFile();
    }

    private final void logInfo(String message2) {
        this.logger.info("Native Distribution Commonization: " + message2);
    }

    private final void readObject(ObjectInputStream input) {
        input.defaultReadObject();
        this.lock = new NativeDistributionCommonizerLock(this.outputDirectory, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NativeDistributionCommonizerCache.access$logInfo((NativeDistributionCommonizerCache)this.receiver, p0);
            }
        }));
    }

    public static final /* synthetic */ Set access$todoTargets(NativeDistributionCommonizerCache $this, Set outputTargets) {
        return $this.todoTargets(outputTargets);
    }

    public static final /* synthetic */ File access$getOutputDirectory$p(NativeDistributionCommonizerCache $this) {
        return $this.outputDirectory;
    }

    public static final /* synthetic */ void access$logInfo(NativeDistributionCommonizerCache $this, String message2) {
        $this.logInfo(message2);
    }
}

