/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.diagnostics;

import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersion;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.utils.AndroidPluginIdsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck;", "", "()V", "minimalSupportedAgpVersion", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "getMinimalSupportedAgpVersion", "()Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "checkAgpVersion", "", "Lorg/gradle/api/Project;", "agpVersionProvider", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck$AndroidGradlePluginVersionProvider;", "agpPluginId", "", "runAgpCompatibilityCheckIfAgpIsApplied", "AndroidGradlePluginVersionProvider", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAgpCompatibilityCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgpCompatibilityCheck.kt\norg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1855#2,2:62\n*S KotlinDebug\n*F\n+ 1 AgpCompatibilityCheck.kt\norg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck\n*L\n22#1:62,2\n*E\n"})
public final class AgpCompatibilityCheck {
    @NotNull
    public static final AgpCompatibilityCheck INSTANCE = new AgpCompatibilityCheck();
    @NotNull
    private static final AndroidGradlePluginVersion minimalSupportedAgpVersion = new AndroidGradlePluginVersion(7, 3, 1, null, 8, null);

    private AgpCompatibilityCheck() {
    }

    @NotNull
    public final AndroidGradlePluginVersion getMinimalSupportedAgpVersion() {
        return minimalSupportedAgpVersion;
    }

    public final void runAgpCompatibilityCheckIfAgpIsApplied(@NotNull Project $this$runAgpCompatibilityCheckIfAgpIsApplied, @NotNull AndroidGradlePluginVersionProvider agpVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$runAgpCompatibilityCheckIfAgpIsApplied, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)agpVersionProvider, (String)"agpVersionProvider");
        AtomicBoolean wasChecked = new AtomicBoolean(false);
        Iterable $this$forEach$iv = AndroidPluginIdsKt.getAndroidPluginIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String agpPluginId = (String)element$iv;
            boolean bl = false;
            $this$runAgpCompatibilityCheckIfAgpIsApplied.getPlugins().withId(agpPluginId, new Action(wasChecked, $this$runAgpCompatibilityCheckIfAgpIsApplied, agpVersionProvider, agpPluginId){
                final /* synthetic */ AtomicBoolean $wasChecked;
                final /* synthetic */ Project $this_runAgpCompatibilityCheckIfAgpIsApplied;
                final /* synthetic */ AndroidGradlePluginVersionProvider $agpVersionProvider;
                final /* synthetic */ String $agpPluginId;
                {
                    this.$wasChecked = $wasChecked;
                    this.$this_runAgpCompatibilityCheckIfAgpIsApplied = $receiver;
                    this.$agpVersionProvider = $agpVersionProvider;
                    this.$agpPluginId = $agpPluginId;
                }

                public final void execute(Plugin<?> it) {
                    if (!this.$wasChecked.getAndSet(true)) {
                        AgpCompatibilityCheck.access$checkAgpVersion(AgpCompatibilityCheck.INSTANCE, this.$this_runAgpCompatibilityCheckIfAgpIsApplied, this.$agpVersionProvider, this.$agpPluginId);
                    }
                }
            });
        }
    }

    public static /* synthetic */ void runAgpCompatibilityCheckIfAgpIsApplied$default(AgpCompatibilityCheck agpCompatibilityCheck, Project project, AndroidGradlePluginVersionProvider androidGradlePluginVersionProvider, int n, Object object) {
        if ((n & 1) != 0) {
            androidGradlePluginVersionProvider = AndroidGradlePluginVersionProvider.Default.INSTANCE;
        }
        agpCompatibilityCheck.runAgpCompatibilityCheckIfAgpIsApplied(project, androidGradlePluginVersionProvider);
    }

    private final void checkAgpVersion(Project $this$checkAgpVersion, AndroidGradlePluginVersionProvider agpVersionProvider, String agpPluginId) {
        AndroidGradlePluginVersion androidGradlePluginVersion = agpVersionProvider.get();
        if (androidGradlePluginVersion == null) {
            KotlinToolingDiagnosticsCollectorKt.reportDiagnosticOncePerProject$default($this$checkAgpVersion, KotlinToolingDiagnostics.FailedToGetAgpVersionWarning.INSTANCE.invoke(agpPluginId), null, 2, null);
            return;
        }
        if (androidGradlePluginVersion.compareTo(minimalSupportedAgpVersion) < 0) {
            KotlinToolingDiagnosticsCollectorKt.reportDiagnosticOncePerProject$default($this$checkAgpVersion, KotlinToolingDiagnostics.IncompatibleAgpVersionTooLowFatalError.INSTANCE.invoke(androidGradlePluginVersion.toString(), minimalSupportedAgpVersion.toString()), null, 2, null);
        }
    }

    public static final /* synthetic */ void access$checkAgpVersion(AgpCompatibilityCheck $this, Project $receiver, AndroidGradlePluginVersionProvider agpVersionProvider, String agpPluginId) {
        $this.checkAgpVersion($receiver, agpVersionProvider, agpPluginId);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0004J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck$AndroidGradlePluginVersionProvider;", "", "get", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "Default", "kotlin-gradle-plugin_common"})
    public static interface AndroidGradlePluginVersionProvider {
        @Nullable
        public AndroidGradlePluginVersion get();

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck$AndroidGradlePluginVersionProvider$Default;", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpCompatibilityCheck$AndroidGradlePluginVersionProvider;", "()V", "get", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "kotlin-gradle-plugin_common"})
        public static final class Default
        implements AndroidGradlePluginVersionProvider {
            @NotNull
            public static final Default INSTANCE = new Default();

            private Default() {
            }

            @Override
            @Nullable
            public AndroidGradlePluginVersion get() {
                return AndroidGradlePluginVersion.Companion.getCurrentOrNull();
            }
        }
    }
}

