/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.ir.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrClass;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrField;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrProperty;
import org.jetbrains.kotlin.gradle.internal.ir.types.IrSimpleType;
import org.jetbrains.kotlin.gradle.internal.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.gradle.internal.ir.util.RenderIrElementKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"getInlineClassUnderlyingType", "Lorg/jetbrains/kotlin/gradle/internal/ir/types/IrSimpleType;", "irClass", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrClass;", "getInlineClassBackingField", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrField;", "ir.tree"})
public final class InlineClassesKt {
    @NotNull
    public static final IrSimpleType getInlineClassUnderlyingType(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(irClass);
        if (inlineClassRepresentation == null) {
            throw new IllegalStateException(("Not an inline class: " + RenderIrElementKt.render$default(irClass, null, 1, null)).toString());
        }
        InlineClassRepresentation<IrSimpleType> representation = inlineClassRepresentation;
        return representation.getUnderlyingType();
    }

    @NotNull
    public static final IrField getInlineClassBackingField(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        for (IrDeclaration declaration : irClass.getDeclarations()) {
            IrField backingField;
            if (declaration instanceof IrField && !((IrField)declaration).isStatic()) {
                return (IrField)declaration;
            }
            if (!(declaration instanceof IrProperty) || (backingField = ((IrProperty)declaration).getBackingField()) == null || backingField.isStatic()) continue;
            return backingField;
        }
        throw new IllegalStateException(("Inline class has no field: " + IrUtilsKt.getFqNameWhenAvailable(irClass)).toString());
    }
}

