/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.PreparedKotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.mpp.IMppDependenciesProjectStructureMetadataExtractorFactory;
import org.jetbrains.kotlin.gradle.plugin.mpp.JarMppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.ProjectMppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifier;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifierKt;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.utils.LazyResolvedConfiguration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/IMppDependenciesProjectStructureMetadataExtractorFactory;", "currentBuild", "Lorg/jetbrains/kotlin/gradle/utils/CurrentBuildIdentifier;", "(Lorg/jetbrains/kotlin/gradle/utils/CurrentBuildIdentifier;)V", "create", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyProjectStructureMetadataExtractor;", "metadataArtifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedDependencyResult;", "diagnosticsCollector", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/PreparedKotlinToolingDiagnosticsCollector;", "resolvedMetadataConfiguration", "Lorg/jetbrains/kotlin/gradle/utils/LazyResolvedConfiguration;", "getProjectMppDependencyProjectStructureMetadataExtractorForCompositeProject", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ProjectMppDependencyProjectStructureMetadataExtractor;", "moduleId", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getProjectStructureMetadataFileForCurrentModuleId", "Ljava/io/File;", "isCompositeProjectContainsExtractedPsm", "", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nMppDependenciesProjectStructureMetadataExtractorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppDependenciesProjectStructureMetadataExtractorFactory.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n661#2,11:132\n766#2:143\n857#2,2:144\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 MppDependenciesProjectStructureMetadataExtractorFactory.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory\n*L\n93#1:132,11\n120#1:143\n120#1:144,2\n121#1:146\n121#1:147,3\n*E\n"})
public final class MppDependenciesProjectStructureMetadataExtractorFactory
implements IMppDependenciesProjectStructureMetadataExtractorFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CurrentBuildIdentifier currentBuild;

    private MppDependenciesProjectStructureMetadataExtractorFactory(CurrentBuildIdentifier currentBuild2) {
        this.currentBuild = currentBuild2;
    }

    @Override
    @Nullable
    public MppDependencyProjectStructureMetadataExtractor create(@NotNull ResolvedArtifactResult metadataArtifact, @NotNull ResolvedDependencyResult dependency, @NotNull PreparedKotlinToolingDiagnosticsCollector diagnosticsCollector, @Nullable LazyResolvedConfiguration resolvedMetadataConfiguration) {
        MppDependencyProjectStructureMetadataExtractor mppDependencyProjectStructureMetadataExtractor;
        Intrinsics.checkNotNullParameter((Object)metadataArtifact, (String)"metadataArtifact");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        ComponentIdentifier moduleId = metadataArtifact.getVariant().getOwner();
        if (moduleId instanceof ProjectComponentIdentifier) {
            ProjectMppDependencyProjectStructureMetadataExtractor projectMppDependencyProjectStructureMetadataExtractor;
            if (this.currentBuild.contains(moduleId)) {
                File file2 = this.getProjectStructureMetadataFileForCurrentModuleId(resolvedMetadataConfiguration, moduleId);
                if (file2 == null) {
                    throw new IllegalStateException(("Project structure metadata not found for project '" + ((ProjectComponentIdentifier)moduleId).getProjectPath() + '\'').toString());
                }
                File projectStructureMetadataFileForCurrentModuleId = file2;
                projectMppDependencyProjectStructureMetadataExtractor = new ProjectMppDependencyProjectStructureMetadataExtractor(((ProjectComponentIdentifier)moduleId).getProjectPath(), projectStructureMetadataFileForCurrentModuleId);
            } else if (this.isCompositeProjectContainsExtractedPsm(metadataArtifact)) {
                projectMppDependencyProjectStructureMetadataExtractor = this.getProjectMppDependencyProjectStructureMetadataExtractorForCompositeProject(resolvedMetadataConfiguration, moduleId);
            } else {
                diagnosticsCollector.report(KotlinToolingDiagnostics.ProjectIsolationIncompatibleWithIncludedBuildsWithOldKotlinVersion.INSTANCE.invoke(dependency.getRequested().toString(), GradleUtilsKt.getBuildTreePathCompat((ProjectComponentIdentifier)moduleId)), true, dependency.getRequested().toString());
                return null;
            }
            mppDependencyProjectStructureMetadataExtractor = projectMppDependencyProjectStructureMetadataExtractor;
        } else if (this.isCompositeProjectContainsExtractedPsm(metadataArtifact)) {
            Intrinsics.checkNotNullExpressionValue((Object)moduleId, (String)"moduleId");
            mppDependencyProjectStructureMetadataExtractor = this.getProjectMppDependencyProjectStructureMetadataExtractorForCompositeProject(resolvedMetadataConfiguration, moduleId);
        } else {
            File file3 = metadataArtifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"metadataArtifact.file");
            mppDependencyProjectStructureMetadataExtractor = new JarMppDependencyProjectStructureMetadataExtractor(file3);
        }
        return mppDependencyProjectStructureMetadataExtractor;
    }

    private final boolean isCompositeProjectContainsExtractedPsm(ResolvedArtifactResult metadataArtifact) {
        Object v1;
        block3: {
            Set set2 = metadataArtifact.getVariant().getAttributes().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"metadataArtifact.variant\u2026tes\n            .keySet()");
            Iterable $this$singleOrNull$iv = set2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Attribute attribute = (Attribute)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)attribute.getName(), (Object)Usage.USAGE_ATTRIBUTE.getName())) continue;
                if (found$iv) {
                    v1 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Attribute usageAttribute = v1;
        if (usageAttribute == null) {
            return false;
        }
        Object[] objectArray = new String[]{"kotlin-psm-metadata", "kotlin-local-metadata"};
        return CollectionsKt.listOf((Object[])objectArray).contains(String.valueOf(metadataArtifact.getVariant().getAttributes().getAttribute(usageAttribute)));
    }

    private final ProjectMppDependencyProjectStructureMetadataExtractor getProjectMppDependencyProjectStructureMetadataExtractorForCompositeProject(LazyResolvedConfiguration resolvedMetadataConfiguration, ComponentIdentifier moduleId) {
        File projectStructureMetadataFileForCurrentModuleId = this.getProjectStructureMetadataFileForCurrentModuleId(resolvedMetadataConfiguration, moduleId);
        return new ProjectMppDependencyProjectStructureMetadataExtractor(null, projectStructureMetadataFileForCurrentModuleId, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final File getProjectStructureMetadataFileForCurrentModuleId(LazyResolvedConfiguration resolvedMetadataConfiguration, ComponentIdentifier moduleId) {
        File file2;
        Set<ResolvedArtifactResult> set2;
        if (resolvedMetadataConfiguration != null && (set2 = resolvedMetadataConfiguration.getResolvedArtifacts()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = set2;
            boolean $i$f$filter22 = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId().getComponentIdentifier(), (Object)moduleId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolvedArtifactResult bl = (ResolvedArtifactResult)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getFile());
            }
            file2 = (File)CollectionsKt.singleOrNull((List)((List)destination$iv$iv2));
        } else {
            file2 = null;
        }
        return file2;
    }

    public /* synthetic */ MppDependenciesProjectStructureMetadataExtractorFactory(CurrentBuildIdentifier currentBuild2, DefaultConstructorMarker $constructor_marker) {
        this(currentBuild2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory$Companion;", "", "()V", "getOrCreate", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MppDependenciesProjectStructureMetadataExtractorFactory getOrCreate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new MppDependenciesProjectStructureMetadataExtractorFactory(CurrentBuildIdentifierKt.getCurrentBuild(project), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

