/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.nodejs;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.AbstractSetupTask;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.PlatformKt;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b'\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u00020\u00038UX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask;", "Lorg/jetbrains/kotlin/gradle/targets/js/AbstractSetupTask;", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsEnv;", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "()V", "artifactModule", "", "getArtifactModule", "()Ljava/lang/String;", "artifactName", "getArtifactName", "artifactPattern", "getArtifactPattern", "settings", "getSettings", "()Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "extract", "", "archive", "Ljava/io/File;", "fixBrokenSymlink", "name", "nodeBinDirPath", "Ljava/nio/file/Path;", "nodeDirProvider", "isWindows", "", "fixBrokenSymlinks", "destinationDir", "necessaryToFix", "Companion", "kotlin-gradle-plugin_common"})
public abstract class NodeJsSetupTask
extends AbstractSetupTask<NodeJsEnv, NodeJsRootExtension> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient NodeJsRootExtension settings;
    @NotNull
    public static final String NAME = "kotlinNodeJsSetup";

    public NodeJsSetupTask() {
        Project project = this.getProject().getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
        this.settings = NodeJsRootPlugin.Companion.getKotlinNodeJsExtension(project);
    }

    @Override
    @Internal
    @NotNull
    protected NodeJsRootExtension getSettings() {
        return this.settings;
    }

    @Override
    @Internal
    @NotNull
    protected String getArtifactPattern() {
        return "v[revision]/[artifact](-v[revision]-[classifier]).[ext]";
    }

    @Override
    @Internal
    @NotNull
    protected String getArtifactModule() {
        return "org.nodejs";
    }

    @Override
    @Internal
    @NotNull
    protected String getArtifactName() {
        return "node";
    }

    @Override
    public void extract(@NotNull File archive) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Ref.BooleanRef fixBrokenSymLinks = new Ref.BooleanRef();
        this.getFs$kotlin_gradle_plugin_common().copy(new Action(archive, this, fixBrokenSymLinks){
            final /* synthetic */ File $archive;
            final /* synthetic */ NodeJsSetupTask this$0;
            final /* synthetic */ Ref.BooleanRef $fixBrokenSymLinks;
            {
                this.$archive = $archive;
                this.this$0 = $receiver;
                this.$fixBrokenSymLinks = $fixBrokenSymLinks;
            }

            public final void execute(CopySpec it) {
                FileTree fileTree;
                Object[] objectArray = new Object[1];
                String string2 = this.$archive.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"archive.name");
                if (StringsKt.endsWith$default((String)string2, (String)"zip", (boolean)false, (int)2, null)) {
                    fileTree = this.this$0.getArchiveOperations$kotlin_gradle_plugin_common().zipTree((Object)this.$archive);
                } else {
                    this.$fixBrokenSymLinks.element = true;
                    fileTree = this.this$0.getArchiveOperations$kotlin_gradle_plugin_common().tarTree((Object)this.$archive);
                }
                objectArray[0] = fileTree;
                it.from(objectArray);
                it.into((Object)this.this$0.getDestination().getParentFile());
            }
        });
        this.fixBrokenSymlinks(this.getDestination(), ((NodeJsEnv)this.getEnv()).isWindows(), fixBrokenSymLinks.element);
        if (!((NodeJsEnv)this.getEnv()).isWindows()) {
            new File(((NodeJsEnv)this.getEnv()).getExecutable()).setExecutable(true);
        }
    }

    private final void fixBrokenSymlinks(File destinationDir, boolean isWindows, boolean necessaryToFix) {
        if (necessaryToFix) {
            Path nodeBinDir = PlatformKt.computeNodeBinDir(destinationDir, isWindows).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)nodeBinDir, (String)"nodeBinDir");
            this.fixBrokenSymlink("npm", nodeBinDir, destinationDir, isWindows);
            this.fixBrokenSymlink("npx", nodeBinDir, destinationDir, isWindows);
        }
    }

    private final void fixBrokenSymlink(String name2, Path nodeBinDirPath, File nodeDirProvider, boolean isWindows) {
        Path script = nodeBinDirPath.resolve(name2);
        String scriptFile = PlatformKt.computeNpmScriptFile(nodeDirProvider, name2, isWindows);
        if (Files.deleteIfExists(script)) {
            Files.createSymbolicLink(script, nodeBinDirPath.relativize(Paths.get(scriptFile, new String[0])), new FileAttribute[0]);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask$Companion;", "", "()V", "NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

