/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.io.Decompressor;

public final class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        return ZipUtil.addFileToZip(zos, file2, relativeName, writtenItemRelativePaths, fileFilter, file2.lastModified());
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, long timestamp) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        return ZipUtil.addFileToZip(zos, file2, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, timestamp, file2.isDirectory());
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor, boolean isDir) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        if (contentProcessor == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        return ZipUtil.addFileToZip(zos, file2, relativeName, writtenItemRelativePaths, fileFilter, contentProcessor, file2.lastModified(), isDir);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor, long timestamp, boolean bl) throws IOException {
        void isDir;
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (contentProcessor == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        if (isDir != false && !Strings.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtilRt.isFilePathAcceptable(file2, fileFilter) || writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file2 + " as " + relativeName);
        }
        long size = isDir != false ? 0L : file2.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(timestamp);
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (isDir == false) {
            try (InputStream is = contentProcessor.getContent(file2);){
                FileUtilRt.copy(is, zos);
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file2, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (jarOutputStream == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        if (file2.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file2, relativePath, fileFilter, writtenItemRelativePaths);
        }
        return ZipUtil.addFileToZip(jarOutputStream, file2, relativePath, writtenItemRelativePaths, fileFilter);
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir2, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (outputStream == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        if (dir2 == null) {
            ZipUtil.$$$reportNull$$$0(18);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(19);
        }
        if (jarFile != null && FileUtil.isAncestor(dir2.getPath(), jarFile.getPath(), false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir2, relativePath, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, true);
        }
        if ((children = dir2.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    @Deprecated
    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter2) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(20);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(21);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir.toPath(), filter2)).extract(outputDir.toPath());
    }

    public static void extract(@NotNull Path file2, @NotNull Path outputDir, @Nullable FilenameFilter filter2) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(22);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(23);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter2)).extract(outputDir);
    }

    public static void extract(@NotNull Path file2, @NotNull Path outputDir, @Nullable FilenameFilter filter2, boolean overwrite) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(24);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(25);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter2)).overwrite(overwrite).extract(outputDir);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter2, boolean overwrite) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(26);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(27);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir.toPath(), filter2)).overwrite(overwrite).extract(outputDir);
    }

    public static boolean isZipContainsFolder(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(28);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(29);
        }
        try (FileInputStream is = new FileInputStream(srcFile);
             ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));){
            os.putNextEntry(new ZipEntry(srcFile.getName()));
            FileUtilRt.copy(is, os);
            os.closeEntry();
        }
    }

    public static void compressFile(@NotNull Path srcFile, @NotNull Path zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(30);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(31);
        }
        try (ZipOutputStream os = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            os.putNextEntry(new ZipEntry(srcFile.getFileName().toString()));
            Files.copy(srcFile, os);
            os.closeEntry();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zos";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarOutputStream";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/ZipUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileToZip";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileOrDirRecursively";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirToZipRecursively";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "extract";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "compressFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(@NotNull File file2) throws IOException {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new FileInputStream(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/io/ZipUtil$FileContentProcessor$1", "getContent"));
            }
        };

        public InputStream getContent(@NotNull File var1) throws IOException;
    }

    private static final class FileFilterAdapter
    implements Predicate<String> {
        private final File myOutputDir;
        private final FilenameFilter myFilter;

        private static FileFilterAdapter wrap(@NotNull Path outputDir, @Nullable FilenameFilter filter2) {
            if (outputDir == null) {
                FileFilterAdapter.$$$reportNull$$$0(0);
            }
            return filter2 == null ? null : new FileFilterAdapter(outputDir, filter2);
        }

        private FileFilterAdapter(@NotNull Path outputDir, FilenameFilter filter2) {
            if (outputDir == null) {
                FileFilterAdapter.$$$reportNull$$$0(1);
            }
            this.myOutputDir = outputDir.toFile();
            this.myFilter = filter2;
        }

        @Override
        public boolean test(String entryName) {
            File outputFile2 = new File(this.myOutputDir, entryName);
            return this.myFilter.accept(outputFile2.getParentFile(), outputFile2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "outputDir";
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/ZipUtil$FileFilterAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

