/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectCoordinatesData;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectCoordinatesDataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.ModuleDependencyIdentifier;
import org.jetbrains.kotlin.gradle.plugin.mpp.internal.MetadataJsonSerialisationTool;
import org.jetbrains.kotlin.gradle.utils.LazyResolvedConfiguration;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0007J\f\u0010.\u001a\u00020/*\u000200H\u0002J\u0014\u0010.\u001a\u00020/*\u0002012\u0006\u00102\u001a\u00020\u001aH\u0002J\u0016\u00103\u001a\u0004\u0018\u00010/*\u0002012\u0006\u00102\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00188aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/GenerateProjectStructureMetadata;", "Lorg/gradle/api/DefaultTask;", "()V", "kmpIsolatedProjectsSupport", "", "kotlinProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "getKotlinProjectStructureMetadata$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "lazyKotlinProjectStructureMetadata", "Lkotlin/Lazy;", "getLazyKotlinProjectStructureMetadata$kotlin_gradle_plugin_common", "()Lkotlin/Lazy;", "setLazyKotlinProjectStructureMetadata$kotlin_gradle_plugin_common", "(Lkotlin/Lazy;)V", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "getProjectLayout$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/ProjectLayout;", "resultFile", "Ljava/io/File;", "getResultFile", "()Ljava/io/File;", "sourceSetDependencies", "Lorg/gradle/api/provider/MapProperty;", "", "Lorg/jetbrains/kotlin/gradle/utils/LazyResolvedConfiguration;", "getSourceSetDependencies$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/MapProperty;", "sourceSetDependenciesInputFiles", "", "Lorg/gradle/api/file/FileCollection;", "getSourceSetDependenciesInputFiles$kotlin_gradle_plugin_common", "()Ljava/util/List;", "sourceSetMetadataOutputsFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getSourceSetMetadataOutputsFile$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Provider;", "sourceSetOutputs", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/GenerateProjectStructureMetadata$SourceSetMetadataOutput;", "getSourceSetOutputs$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/ListProperty;", "generateMetadataXml", "", "moduleDependencyIdentifier", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "Lorg/gradle/api/artifacts/result/ResolvedDependencyResult;", "projectCoordinatesConfiguration", "tryReadFromKotlinProjectCoordinatesData", "SourceSetMetadataOutput", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nGenerateProjectStructureMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateProjectStructureMetadata.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/GenerateProjectStructureMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,140:1\n1549#2:141\n1620#2,3:142\n1238#2,4:148\n1179#2,2:152\n1253#2,4:154\n1#3:145\n453#4:146\n403#4:147\n*S KotlinDebug\n*F\n+ 1 GenerateProjectStructureMetadata.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/GenerateProjectStructureMetadata\n*L\n56#1:141\n56#1:142,3\n107#1:148,4\n126#1:152,2\n126#1:154,4\n107#1:146\n107#1:147\n*E\n"})
public abstract class GenerateProjectStructureMetadata
extends DefaultTask {
    public Lazy<KotlinProjectStructureMetadata> lazyKotlinProjectStructureMetadata;
    @NotNull
    private final Provider<RegularFile> sourceSetMetadataOutputsFile;
    private final boolean kmpIsolatedProjectsSupport;

    public GenerateProjectStructureMetadata() {
        Provider provider = this.getProject().getLayout().getBuildDirectory().file("internal/kmp/source-set-metadata-locations.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026mp/$SOURCE_SET_METADATA\")");
        this.sourceSetMetadataOutputsFile = provider;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.kmpIsolatedProjectsSupport = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getKotlinKmpProjectIsolationEnabled();
    }

    @Inject
    @NotNull
    public abstract ProjectLayout getProjectLayout$kotlin_gradle_plugin_common();

    @Internal
    @NotNull
    public final Lazy<KotlinProjectStructureMetadata> getLazyKotlinProjectStructureMetadata$kotlin_gradle_plugin_common() {
        Lazy<KotlinProjectStructureMetadata> lazy = this.lazyKotlinProjectStructureMetadata;
        if (lazy != null) {
            return lazy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lazyKotlinProjectStructureMetadata");
        return null;
    }

    public final void setLazyKotlinProjectStructureMetadata$kotlin_gradle_plugin_common(@NotNull Lazy<KotlinProjectStructureMetadata> lazy) {
        Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
        this.lazyKotlinProjectStructureMetadata = lazy;
    }

    @Nested
    @NotNull
    public final KotlinProjectStructureMetadata getKotlinProjectStructureMetadata$kotlin_gradle_plugin_common() {
        return (KotlinProjectStructureMetadata)this.getLazyKotlinProjectStructureMetadata$kotlin_gradle_plugin_common().getValue();
    }

    @Internal
    @NotNull
    public abstract MapProperty<String, LazyResolvedConfiguration> getSourceSetDependencies$kotlin_gradle_plugin_common();

    /*
     * WARNING - void declaration
     */
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final List<FileCollection> getSourceSetDependenciesInputFiles$kotlin_gradle_plugin_common() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((Map)this.getSourceSetDependencies$kotlin_gradle_plugin_common().get()).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LazyResolvedConfiguration lazyResolvedConfiguration = (LazyResolvedConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFiles());
        }
        return (List)destination$iv$iv;
    }

    @OutputFile
    @NotNull
    public final File getResultFile() {
        File file2 = ((RegularFile)this.getProjectLayout$kotlin_gradle_plugin_common().getBuildDirectory().file("kotlinProjectStructureMetadata/kotlin-project-structure-metadata.json").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"projectLayout.buildDirec\u2026E\"\n        ).get().asFile");
        return file2;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getSourceSetMetadataOutputsFile$kotlin_gradle_plugin_common() {
        return this.sourceSetMetadataOutputsFile;
    }

    @Nested
    @NotNull
    public abstract ListProperty<SourceSetMetadataOutput> getSourceSetOutputs$kotlin_gradle_plugin_common();

    private final ModuleDependencyIdentifier moduleDependencyIdentifier(ResolvedDependencyResult $this$moduleDependencyIdentifier, LazyResolvedConfiguration projectCoordinatesConfiguration2) {
        ModuleDependencyIdentifier moduleDependencyIdentifier;
        ComponentIdentifier componentIdentifier = $this$moduleDependencyIdentifier.getSelected().getId();
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            moduleDependencyIdentifier = this.tryReadFromKotlinProjectCoordinatesData($this$moduleDependencyIdentifier, projectCoordinatesConfiguration2);
            if (moduleDependencyIdentifier == null) {
                ResolvedComponentResult resolvedComponentResult = $this$moduleDependencyIdentifier.getSelected();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"selected");
                moduleDependencyIdentifier = this.moduleDependencyIdentifier(resolvedComponentResult);
            }
        } else if (componentIdentifier instanceof ModuleComponentIdentifier) {
            ResolvedComponentResult resolvedComponentResult = $this$moduleDependencyIdentifier.getSelected();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"selected");
            moduleDependencyIdentifier = this.moduleDependencyIdentifier(resolvedComponentResult);
        } else {
            throw new IllegalStateException(("Unknown ComponentIdentifier: " + $this$moduleDependencyIdentifier.getSelected()).toString());
        }
        return moduleDependencyIdentifier;
    }

    private final ModuleDependencyIdentifier tryReadFromKotlinProjectCoordinatesData(ResolvedDependencyResult $this$tryReadFromKotlinProjectCoordinatesData, LazyResolvedConfiguration projectCoordinatesConfiguration2) {
        ResolvedArtifactResult resolvedArtifactResult = (ResolvedArtifactResult)CollectionsKt.singleOrNull(projectCoordinatesConfiguration2.getArtifacts($this$tryReadFromKotlinProjectCoordinatesData));
        if (resolvedArtifactResult == null) {
            return null;
        }
        ResolvedArtifactResult projectCoordinatesFile = resolvedArtifactResult;
        File file2 = projectCoordinatesFile.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"projectCoordinatesFile.file");
        KotlinProjectCoordinatesData kotlinProjectCoordinatesData = KotlinProjectCoordinatesDataKt.parseKotlinProjectCoordinatesOrNull(file2);
        if (kotlinProjectCoordinatesData == null) {
            return null;
        }
        KotlinProjectCoordinatesData projectCoordinates = kotlinProjectCoordinatesData;
        return projectCoordinates.getModuleId();
    }

    private final ModuleDependencyIdentifier moduleDependencyIdentifier(ResolvedComponentResult $this$moduleDependencyIdentifier) {
        String string2;
        String string3;
        ModuleVersionIdentifier moduleVersionIdentifier = $this$moduleDependencyIdentifier.getModuleVersion();
        String string4 = moduleVersionIdentifier != null ? moduleVersionIdentifier.getGroup() : null;
        ModuleVersionIdentifier moduleVersionIdentifier2 = $this$moduleDependencyIdentifier.getModuleVersion();
        String string5 = string3 = moduleVersionIdentifier2 != null ? moduleVersionIdentifier2.getName() : null;
        if (string3 == null) {
            String string6;
            String string7 = string6 = "unspecified";
            String string8 = string4;
            boolean bl = false;
            this.getLogger().warn("[Kotlin] ComponentResult " + $this$moduleDependencyIdentifier + " has no name");
            string4 = string8;
            string2 = string6;
        } else {
            string2 = string3;
        }
        String string9 = string2;
        String string10 = string4;
        return new ModuleDependencyIdentifier(string10, string9);
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateMetadataXml() {
        void $this$associateTo$iv$iv;
        KotlinProjectStructureMetadata kotlinProjectStructureMetadata2;
        Map map2;
        Iterable $this$associateByTo$iv$iv$iv;
        this.getResultFile().getParentFile().mkdirs();
        if (this.kmpIsolatedProjectsSupport) {
            Map map3;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            KotlinProjectStructureMetadata kotlinProjectStructureMetadata3 = this.getKotlinProjectStructureMetadata$kotlin_gradle_plugin_common();
            Object object = this.getSourceSetDependencies$kotlin_gradle_plugin_common().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetDependencies.get()");
            Map map4 = (Map)object;
            Map map5 = null;
            Map map6 = null;
            Map map7 = null;
            KotlinProjectStructureMetadata kotlinProjectStructureMetadata4 = kotlinProjectStructureMetadata3;
            boolean $i$f$mapValues = false;
            void var4_8 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map3 = map2;
                boolean bl2 = false;
                LazyResolvedConfiguration resolvedConfiguration = (LazyResolvedConfiguration)entry3.getValue();
                Set directDependencies = resolvedConfiguration.getRoot().getDependencies();
                Set result2 = new LinkedHashSet();
                for (DependencyResult dependency : directDependencies) {
                    if (dependency.isConstraint() || !(dependency instanceof ResolvedDependencyResult)) continue;
                    ResolvedDependencyResult resolvedDependencyResult = (ResolvedDependencyResult)dependency;
                    Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"resolvedConfiguration");
                    result2.add(this.moduleDependencyIdentifier(resolvedDependencyResult, resolvedConfiguration));
                }
                Set set2 = result2;
                map3.put(k, set2);
            }
            map3 = destination$iv$iv;
            kotlinProjectStructureMetadata2 = KotlinProjectStructureMetadata.copy$default(kotlinProjectStructureMetadata4, map7, map6, map5, map3, null, null, false, null, null, 503, null);
        } else {
            kotlinProjectStructureMetadata2 = this.getKotlinProjectStructureMetadata$kotlin_gradle_plugin_common();
        }
        KotlinProjectStructureMetadata actualProjectStructureMetadata = kotlinProjectStructureMetadata2;
        String resultString = KotlinProjectStructureMetadataKt.toJson(actualProjectStructureMetadata);
        FilesKt.writeText$default((File)this.getResultFile(), (String)resultString, null, (int)2, null);
        Object object = this.getSourceSetOutputs$kotlin_gradle_plugin_common().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetOutputs.get()");
        Iterable $this$associate$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv$iv = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map2 = destination$iv$iv;
            SourceSetMetadataOutput it = (SourceSetMetadataOutput)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getSourceSetName(), (Object)it.getMetadataOutput().get());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map metadataOutputsBySourceSet = destination$iv$iv;
        String metadataOutputsJson = MetadataJsonSerialisationTool.INSTANCE.toJson$kotlin_gradle_plugin_common(metadataOutputsBySourceSet);
        File file2 = ((RegularFile)this.sourceSetMetadataOutputsFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"sourceSetMetadataOutputsFile.get().asFile");
        FilesKt.writeText$default((File)file2, (String)metadataOutputsJson, null, (int)2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/GenerateProjectStructureMetadata$SourceSetMetadataOutput;", "", "sourceSetName", "", "metadataOutput", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "(Ljava/lang/String;Lorg/gradle/api/provider/Provider;)V", "getMetadataOutput", "()Lorg/gradle/api/provider/Provider;", "getSourceSetName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    public static final class SourceSetMetadataOutput {
        @NotNull
        private final String sourceSetName;
        @NotNull
        private final Provider<File> metadataOutput;

        public SourceSetMetadataOutput(@NotNull String sourceSetName, @NotNull Provider<File> metadataOutput) {
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkNotNullParameter(metadataOutput, (String)"metadataOutput");
            this.sourceSetName = sourceSetName;
            this.metadataOutput = metadataOutput;
        }

        @Input
        @NotNull
        public final String getSourceSetName() {
            return this.sourceSetName;
        }

        @Input
        @Optional
        @NotNull
        public final Provider<File> getMetadataOutput() {
            return this.metadataOutput;
        }

        @NotNull
        public final String component1() {
            return this.sourceSetName;
        }

        @NotNull
        public final Provider<File> component2() {
            return this.metadataOutput;
        }

        @NotNull
        public final SourceSetMetadataOutput copy(@NotNull String sourceSetName, @NotNull Provider<File> metadataOutput) {
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkNotNullParameter(metadataOutput, (String)"metadataOutput");
            return new SourceSetMetadataOutput(sourceSetName, metadataOutput);
        }

        public static /* synthetic */ SourceSetMetadataOutput copy$default(SourceSetMetadataOutput sourceSetMetadataOutput, String string2, Provider provider, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = sourceSetMetadataOutput.sourceSetName;
            }
            if ((n & 2) != 0) {
                provider = sourceSetMetadataOutput.metadataOutput;
            }
            return sourceSetMetadataOutput.copy(string2, provider);
        }

        @NotNull
        public String toString() {
            return "SourceSetMetadataOutput(sourceSetName=" + this.sourceSetName + ", metadataOutput=" + this.metadataOutput + ')';
        }

        public int hashCode() {
            int result2 = this.sourceSetName.hashCode();
            result2 = result2 * 31 + this.metadataOutput.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceSetMetadataOutput)) {
                return false;
            }
            SourceSetMetadataOutput sourceSetMetadataOutput = (SourceSetMetadataOutput)other;
            if (!Intrinsics.areEqual((Object)this.sourceSetName, (Object)sourceSetMetadataOutput.sourceSetName)) {
                return false;
            }
            return Intrinsics.areEqual(this.metadataOutput, sourceSetMetadataOutput.metadataOutput);
        }
    }
}

