/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.statistics.MetricContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.plugins.ObservablePlugins;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aN\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u0018"}, d2={"addTaskMetrics", "", "project", "Lorg/gradle/api/Project;", "configurationTimeMetrics", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "collectAppliedPluginsStatistics", "collectGeneralConfigurationTimeMetrics", "gradle", "Lorg/gradle/api/invocation/Gradle;", "buildReportOutputs", "", "Lorg/jetbrains/kotlin/gradle/report/BuildReportType;", "useClasspathSnapshot", "", "pluginVersion", "", "isProjectIsolationEnabled", "isProjectIsolationRequested", "isConfigurationCacheRequested", "collectProjectConfigurationTimeMetrics", "reportLibrariesVersions", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nkotlinBuildStatisticsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinBuildStatisticsUtils.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatisticsUtilsKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n17#2,5:229\n22#2:236\n17#2,6:237\n1855#3,2:234\n1774#3,4:243\n766#3:247\n857#3,2:248\n1855#3,2:250\n*S KotlinDebug\n*F\n+ 1 kotlinBuildStatisticsUtils.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatisticsUtilsKt\n*L\n35#1:229,5\n35#1:236\n76#1:237,6\n38#1:234,2\n157#1:243,4\n185#1:247\n185#1:248,2\n185#1:250,2\n*E\n"})
public final class KotlinBuildStatisticsUtilsKt {
    @NotNull
    public static final MetricContainer collectGeneralConfigurationTimeMetrics(@NotNull Project project, @NotNull Gradle gradle, @NotNull List<? extends BuildReportType> buildReportOutputs, boolean useClasspathSnapshot, @NotNull String pluginVersion, boolean isProjectIsolationEnabled2, boolean isProjectIsolationRequested, boolean isConfigurationCacheRequested) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        Intrinsics.checkNotNullParameter(buildReportOutputs, (String)"buildReportOutputs");
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        MetricContainer configurationTimeMetrics = new MetricContainer();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        configurationTimeMetrics.put(StringMetrics.KOTLIN_COMPILER_VERSION, pluginVersion);
        configurationTimeMetrics.put(StringMetrics.USE_CLASSPATH_SNAPSHOT, String.valueOf(useClasspathSnapshot));
        Iterable $this$forEach$iv = buildReportOutputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildReportType it = (BuildReportType)element$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    configurationTimeMetrics.put(BooleanMetrics.BUILD_SCAN_BUILD_REPORT, true);
                    break;
                }
                case 2: {
                    configurationTimeMetrics.put(BooleanMetrics.FILE_BUILD_REPORT, true);
                    break;
                }
                case 3: {
                    configurationTimeMetrics.put(BooleanMetrics.HTTP_BUILD_REPORT, true);
                    break;
                }
                case 4: {
                    configurationTimeMetrics.put(BooleanMetrics.SINGLE_FILE_BUILD_REPORT, true);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    configurationTimeMetrics.put(BooleanMetrics.JSON_BUILD_REPORT, true);
                }
            }
        }
        String string2 = project.getRootDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.rootDir.absolutePath");
        configurationTimeMetrics.put(StringMetrics.PROJECT_PATH, string2);
        String string3 = gradle.getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"gradle.gradleVersion");
        configurationTimeMetrics.put(StringMetrics.GRADLE_VERSION, string3);
        if (!isProjectIsolationEnabled2) {
            gradle.getTaskGraph().whenReady(new Action(configurationTimeMetrics){
                final /* synthetic */ MetricContainer $configurationTimeMetrics;
                {
                    this.$configurationTimeMetrics = $configurationTimeMetrics;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void execute(TaskExecutionGraph taskExecutionGraph) {
                    void $this$mapTo$iv$iv;
                    List list = taskExecutionGraph.getAllTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"taskExecutionGraph.allTasks");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Task task2 = (Task)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    List executedTaskNames = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    this.$configurationTimeMetrics.put(BooleanMetrics.MAVEN_PUBLISH_EXECUTED, executedTaskNames.contains("install"));
                }
            });
        }
        configurationTimeMetrics.put(BooleanMetrics.GRADLE_CONFIGURATION_CACHE_ENABLED, isConfigurationCacheRequested);
        configurationTimeMetrics.put(BooleanMetrics.GRADLE_PROJECT_ISOLATION_ENABLED, isProjectIsolationRequested);
        long statisticOverhead2 = System.currentTimeMillis() - start$iv;
        configurationTimeMetrics.put(NumericalMetrics.STATISTICS_VISIT_ALL_PROJECTS_OVERHEAD, statisticOverhead2);
        return configurationTimeMetrics;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final MetricContainer collectProjectConfigurationTimeMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        configurationTimeMetrics = new MetricContainer();
        $i$f$measureTimeMillis = false;
        start$iv = System.currentTimeMillis();
        $i$a$-measureTimeMillis-KotlinBuildStatisticsUtilsKt$collectProjectConfigurationTimeMetrics$statisticOverhead$1 = false;
        KotlinBuildStatisticsUtilsKt.collectAppliedPluginsStatistics(project, configurationTimeMetrics);
        v0 = project.getConfigurations().getAsMap().values();
        Intrinsics.checkNotNullExpressionValue(v0, (String)"project.configurations.asMap.values");
        configurations = v0;
        for (Configuration configuration : configurations) {
            try {
                configurationName = configuration.getName();
                dependencies = configuration.getDependencies();
                var13_11 = configurationName;
                if (var13_11 == null) continue;
                tmp = -1;
                switch (var13_11.hashCode()) {
                    case -2074174337: {
                        if (var13_11.equals("compileOnly")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 950491699: {
                        if (var13_11.equals("compile")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1683336114: {
                        if (var13_11.equals("implementation")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 3284442: {
                        if (var13_11.equals("kapt")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case 1550962648: {
                        if (var13_11.equals("runtime")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 96794: {
                        if (var13_11.equals("api")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case 1325346147: {
                        if (var13_11.equals("KoverEngineConfig")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case 754694052: {
                        if (var13_11.equals("runtimeOnly")) {
                            tmp = 8;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 7: {
                        configurationTimeMetrics.put(BooleanMetrics.ENABLED_KOVER, true);
                        break;
                    }
                    case 4: {
                        configurationTimeMetrics.put(BooleanMetrics.ENABLED_KAPT, true);
                        for (Dependency dependency : dependencies) {
                            var16_14 = dependency.getGroup();
                            if (var16_14 == null) continue;
                            switch (var16_14.hashCode()) {
                                case -1070815569: {
                                    if (var16_14.equals("com.android.databinding")) break;
                                    ** break;
                                }
                                case -1209339086: {
                                    if (!var16_14.equals("org.jetbrains.kotlin.com.google.dagger")) ** break;
                                    configurationTimeMetrics.put(BooleanMetrics.ENABLED_DAGGER, true);
                                    ** break;
                                }
                            }
                            configurationTimeMetrics.put(BooleanMetrics.ENABLED_DATABINDING, true);
lbl84:
                            // 5 sources

                        }
                        break;
                    }
                    case 6: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_API_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies);
                        break;
                    }
                    case 3: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_IMPLEMENTATION_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies);
                        break;
                    }
                    case 2: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_COMPILE_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies);
                        break;
                    }
                    case 1: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_COMPILE_ONLY_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies);
                        break;
                    }
                    case 5: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_RUNTIME_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies);
                        break;
                    }
                    case 8: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_RUNTIME_ONLY_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies);
                    }
                }
            }
            catch (Throwable var11_9) {}
        }
        configurationTimeMetrics.put(NumericalMetrics.NUMBER_OF_SUBPROJECTS, 1L);
        v1 = project.getBuildscript().getSourceFile();
        if (v1 != null && (v1 = (var10_7 = v1.getName())) != null) {
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"name");
            v2 = StringsKt.endsWith$default((String)var10_7, (String)".kts", (boolean)false, (int)2, null);
        } else {
            v2 = false;
        }
        configurationTimeMetrics.put(BooleanMetrics.KOTLIN_KTS_USED, v2);
        KotlinBuildStatisticsUtilsKt.addTaskMetrics(project, configurationTimeMetrics);
        if (Intrinsics.areEqual((Object)project.getName(), (Object)"buildSrc")) {
            configurationTimeMetrics.put(NumericalMetrics.BUILD_SRC_COUNT, 1L);
            configurationTimeMetrics.put(BooleanMetrics.BUILD_SRC_EXISTS, true);
        }
        statisticOverhead = System.currentTimeMillis() - start$iv;
        configurationTimeMetrics.put(NumericalMetrics.STATISTICS_VISIT_ALL_PROJECTS_OVERHEAD, statisticOverhead);
        return configurationTimeMetrics;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addTaskMetrics(Project project, MetricContainer configurationTimeMetrics) {
        try {
            int n;
            void $this$count$iv;
            SortedSet sortedSet = project.getTasks().getNames();
            Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"project.tasks.names");
            List taskNames = CollectionsKt.toList((Iterable)sortedSet);
            configurationTimeMetrics.put(NumericalMetrics.GRADLE_NUMBER_OF_TASKS, taskNames.size());
            Iterable iterable = taskNames;
            NumericalMetrics numericalMetrics = NumericalMetrics.GRADLE_NUMBER_OF_UNCONFIGURED_TASKS;
            MetricContainer metricContainer = configurationTimeMetrics;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    boolean bl;
                    String name2 = (String)element$iv;
                    boolean bl2 = false;
                    try {
                        String string2 = project.getTasks().named(name2).getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.tasks.named(name).javaClass.name");
                        bl = StringsKt.contains$default((CharSequence)string2, (CharSequence)"TaskCreatingProvider", (boolean)false, (int)2, null);
                    }
                    catch (Exception _) {
                        bl = true;
                    }
                    if (!bl || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            metricContainer.put(numericalMetrics, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void collectAppliedPluginsStatistics(Project project, MetricContainer configurationTimeMetrics) {
        for (ObservablePlugins plugin2 : ObservablePlugins.values()) {
            if (!project.getPlugins().hasPlugin(plugin2.getTitle())) continue;
            configurationTimeMetrics.put(plugin2.getMetric(), true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void reportLibrariesVersions(MetricContainer configurationTimeMetrics, DependencySet dependencies2) {
        block29: {
            void $this$filterTo$iv$iv;
            DependencySet dependencySet = dependencies2;
            if (dependencySet == null) break block29;
            Iterable $this$filter$iv = (Iterable)dependencySet;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Dependency it = (Dependency)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof ProjectDependency))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                String string2;
                Dependency dependency = (Dependency)element$iv;
                boolean bl5 = false;
                String string3 = string2 = dependency.getGroup();
                if (string3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group");
                    bl4 = StringsKt.startsWith$default((String)string2, (String)"org.springframework", (boolean)false, (int)2, null);
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    String string4 = dependency.getVersion();
                    if (string4 == null) {
                        string4 = "0.0.0";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"dependency.version ?: \"0.0.0\"");
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_SPRING_VERSION, string4);
                    continue;
                }
                String string5 = string2 = dependency.getGroup();
                if (string5 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group");
                    bl3 = StringsKt.startsWith$default((String)string2, (String)"com.vaadin", (boolean)false, (int)2, null);
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    String string6 = dependency.getVersion();
                    if (string6 == null) {
                        string6 = "0.0.0";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"dependency.version ?: \"0.0.0\"");
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_VAADIN_VERSION, string6);
                    continue;
                }
                String string7 = string2 = dependency.getGroup();
                if (string7 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"group");
                    bl2 = StringsKt.startsWith$default((String)string2, (String)"org.jetbrains.kotlin.com.google.gwt", (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    String string8 = dependency.getVersion();
                    if (string8 == null) {
                        string8 = "0.0.0";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"dependency.version ?: \"0.0.0\"");
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_GWT_VERSION, string8);
                    continue;
                }
                String string9 = string2 = dependency.getGroup();
                if (string9 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"group");
                    bl = StringsKt.startsWith$default((String)string2, (String)"org.hibernate", (boolean)false, (int)2, null);
                } else {
                    bl = false;
                }
                if (bl) {
                    String string10 = dependency.getVersion();
                    if (string10 == null) {
                        string10 = "0.0.0";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"dependency.version ?: \"0.0.0\"");
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_HIBERNATE_VERSION, string10);
                    continue;
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlin")) {
                    String string11 = dependency.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"dependency.name");
                    if (StringsKt.startsWith$default((String)string11, (String)"kotlin-stdlib", (boolean)false, (int)2, null)) {
                        String string12 = dependency.getVersion();
                        if (string12 == null) {
                            string12 = "0.0.0";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"dependency.version ?: \"0.0.0\"");
                        configurationTimeMetrics.put(StringMetrics.KOTLIN_STDLIB_VERSION, string12);
                        continue;
                    }
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlinx") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"kotlinx-coroutines")) {
                    String string13 = dependency.getVersion();
                    if (string13 == null) {
                        string13 = "0.0.0";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"dependency.version ?: \"0.0.0\"");
                    configurationTimeMetrics.put(StringMetrics.KOTLIN_COROUTINES_VERSION, string13);
                    continue;
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlin") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"kotlin-reflect")) {
                    String string14 = dependency.getVersion();
                    if (string14 == null) {
                        string14 = "0.0.0";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"dependency.version ?: \"0.0.0\"");
                    configurationTimeMetrics.put(StringMetrics.KOTLIN_REFLECT_VERSION, string14);
                    continue;
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlinx")) {
                    String string15 = dependency.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"dependency.name");
                    if (StringsKt.startsWith$default((String)string15, (String)"kotlinx-serialization-runtime", (boolean)false, (int)2, null)) {
                        String string16 = dependency.getVersion();
                        if (string16 == null) {
                            string16 = "0.0.0";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"dependency.version ?: \"0.0.0\"");
                        configurationTimeMetrics.put(StringMetrics.KOTLIN_SERIALIZATION_VERSION, string16);
                        continue;
                    }
                }
                if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.android.tools.build")) continue;
                String string17 = dependency.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"dependency.name");
                if (!StringsKt.startsWith$default((String)string17, (String)"gradle", (boolean)false, (int)2, null)) continue;
                String string18 = dependency.getVersion();
                if (string18 == null) {
                    string18 = "0.0.0";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"dependency.version ?: \"0.0.0\"");
                configurationTimeMetrics.put(StringMetrics.ANDROID_GRADLE_PLUGIN_VERSION, string18);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildReportType.values().length];
            try {
                nArray[BuildReportType.BUILD_SCAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.HTTP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.SINGLE_FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.TRY_NEXT_CONSOLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.JSON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

