/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"availableMetrics", "", "", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "project", "Lorg/gradle/api/Project;", "validateFileName", "", "fileName", "propertyName", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nconfigureReporing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 configureReporing.kt\norg/jetbrains/kotlin/gradle/report/ConfigureReporingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,2:121\n1622#2:125\n1855#2,2:126\n1282#3,2:123\n11065#3:128\n11400#3,3:129\n*S KotlinDebug\n*F\n+ 1 configureReporing.kt\norg/jetbrains/kotlin/gradle/report/ConfigureReporingKt\n*L\n28#1:120\n28#1:121,2\n28#1:125\n73#1:126,2\n29#1:123,2\n22#1:128\n22#1:129,3\n*E\n"})
public final class ConfigureReporingKt {
    @NotNull
    private static final List<String> availableMetrics;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final ReportingSettings reportingSettings(@NotNull Project project) {
        File file2;
        File singleOutputFile;
        File file3;
        BuildScanSettings buildScanSettings;
        BuildScanSettings buildScanSettings2;
        HttpReportSettings httpReportSettings;
        HttpReportSettings httpReportSettings2;
        FileReportSettings fileReportSettings;
        FileReportSettings fileReportSettings2;
        BuildReportMode buildReportMode;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PropertiesProvider properties2 = PropertiesProvider.Companion.invoke(project);
        Boolean experimentalTryNextEnabled = (Boolean)properties2.getKotlinExperimentalTryNext().get();
        Iterable iterable = properties2.getBuildReportOutputs();
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BuildReportType buildReportType;
            void it;
            Collection collection;
            block20: {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                BuildReportType[] $this$firstOrNull$iv = BuildReportType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    BuildReportType element$iv;
                    BuildReportType brt = element$iv = $this$firstOrNull$iv[j];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)brt.name(), (Object)CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()))) continue;
                    buildReportType = element$iv;
                    break block20;
                }
                buildReportType = null;
            }
            if (buildReportType == null) {
                throw new IllegalStateException("Unknown output type: " + (String)it);
            }
            collection.add(buildReportType);
        }
        Collection collection = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)experimentalTryNextEnabled, (String)"experimentalTryNextEnabled");
        List buildReportOutputTypes = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)(experimentalTryNextEnabled != false ? CollectionsKt.listOf((Object)BuildReportType.TRY_NEXT_CONSOLE) : CollectionsKt.emptyList())));
        BuildReportMode buildReportMode2 = buildReportMode = buildReportOutputTypes.isEmpty() ? BuildReportMode.NONE : BuildReportMode.VERBOSE;
        if (buildReportOutputTypes.contains(BuildReportType.FILE)) {
            File file4;
            String string3 = properties2.getBuildReportFileOutputDir();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                ConfigureReporingKt.validateFileName(it, PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_FILE_DIR());
                file4 = new File(it);
            } else {
                File file5;
                if (ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project)) {
                    File file6 = project.getRootDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"project.rootDir");
                    file5 = FilesKt.resolve((File)file6, (String)"build");
                } else {
                    file5 = (File)project.getRootProject().getLayout().getBuildDirectory().getAsFile().get();
                }
                File file7 = file5;
                Intrinsics.checkNotNullExpressionValue((Object)file7, (String)"if (project.isProjectIso\u2026ry.asFile.get()\n        }");
                file4 = FilesKt.resolve((File)file7, (String)"reports/kotlin-build");
            }
            File buildReportDir = file4;
            boolean includeMetricsInReport = properties2.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
            fileReportSettings2 = new FileReportSettings(buildReportDir, null, includeMetricsInReport, 2, null);
        } else {
            fileReportSettings2 = fileReportSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.HTTP)) {
            String string4 = properties2.getBuildReportHttpUrl();
            if (string4 == null) {
                throw new IllegalStateException("Can't configure http report: '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_HTTP_URL() + "' property is mandatory");
            }
            String url = string4;
            String password = properties2.getBuildReportHttpPassword();
            String user = properties2.getBuildReportHttpUser();
            boolean includeGitBranchName = properties2.getBuildReportHttpIncludeGitBranchName();
            boolean useExecutor = properties2.getBuildReportHttpUseExecutor();
            httpReportSettings2 = new HttpReportSettings(url, password, user, properties2.getBuildReportHttpVerboseEnvironment(), includeGitBranchName, useExecutor);
        } else {
            httpReportSettings2 = httpReportSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.BUILD_SCAN)) {
            String[] stringArray;
            Set metrics;
            Object object = properties2.getBuildReportBuildScanMetrics();
            Set set2 = metrics = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : null;
            if (set2 != null) {
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string5 = ((Object)StringsKt.trim((CharSequence)it)).toString().toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                    if (availableMetrics.contains(string5)) continue;
                    throw new IllegalStateException("Unknown metric: '" + it + "', list of available metrics: " + availableMetrics);
                }
            }
            buildScanSettings2 = new BuildScanSettings(properties2.getBuildReportBuildScanCustomValuesLimit(), metrics);
        } else {
            buildScanSettings2 = buildScanSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.SINGLE_FILE)) {
            String string6 = properties2.getBuildReportSingleFile();
            if (string6 == null) throw new IllegalStateException("Can't configure single file report: '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_SINGLE_FILE() + "' property is mandatory");
            String it = string6;
            boolean bl = false;
            ConfigureReporingKt.validateFileName(it, PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_SINGLE_FILE());
            file3 = new File(it);
        } else {
            file3 = singleOutputFile = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.JSON)) {
            String string7 = properties2.getBuildReportJsonDir();
            if (string7 == null) throw new IllegalStateException("Can't configure json report: '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_JSON_DIR() + "' property is mandatory");
            String it = string7;
            boolean bl = false;
            ConfigureReporingKt.validateFileName(it, PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_BUILD_REPORT_JSON_DIR());
            file2 = new File(it);
        } else {
            file2 = null;
        }
        File jsonReportDir = file2;
        String string8 = properties2.getBuildReportLabel();
        boolean bl = properties2.getBuildReportIncludeCompilerArguments();
        return new ReportingSettings(buildReportOutputTypes, buildReportMode, string8, fileReportSettings, httpReportSettings, buildScanSettings, singleOutputFile, jsonReportDir, experimentalTryNextEnabled, bl);
    }

    private static final void validateFileName(String fileName, String propertyName) {
        if (StringsKt.isBlank((CharSequence)fileName)) {
            throw new IllegalStateException("The property '" + propertyName + "' must not be empty. Please provide a valid value.");
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        GradleBuildTime it;
        Collection collection;
        GradleBuildTime[] $this$mapTo$iv$iv;
        GradleBuildTime[] $this$map$iv = GradleBuildTime.values();
        boolean $i$f$map = false;
        GradleBuildTime[] gradleBuildTimeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (GradleBuildTime item$iv$iv : $this$mapTo$iv$iv) {
            void var8_8 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        $this$map$iv = GradleBuildPerformanceMetric.values();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n = $this$mapTo$iv$iv.length;
        for (int j = 0; j < n; ++j) {
            GradleBuildTime item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.name());
        }
        availableMetrics = CollectionsKt.plus((Collection)collection, (Iterable)((List)var3_3));
    }
}

