/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js;

import java.io.File;
import java.nio.file.Files;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0000\u001a\u0016\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\b\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"HTML", "", "JS", "JS_MAP", "META_JS", "MJS", "WASM", "writeWasmUnitTestRunner", "Ljava/io/File;", "workingDir", "compiledFile", "appendConfigsFromDir", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "confDir", "calculateDirHash", "Lorg/gradle/internal/hash/FileHasher;", "dir", "toHex", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/targets/js/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n603#2:85\n1313#2,2:86\n1313#2,2:90\n13316#3,2:88\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/targets/js/UtilsKt\n*L\n20#1:85\n21#1:86,2\n47#1:90,2\n32#1:88,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String JS = "js";
    @NotNull
    public static final String MJS = "mjs";
    @NotNull
    public static final String WASM = "wasm";
    @NotNull
    public static final String JS_MAP = "js.map";
    @NotNull
    public static final String META_JS = "meta.js";
    @NotNull
    public static final String HTML = "html";

    public static final void appendConfigsFromDir(@NotNull Appendable $this$appendConfigsFromDir, @NotNull File confDir) {
        Intrinsics.checkNotNullParameter((Object)$this$appendConfigsFromDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)confDir, (String)"confDir");
        Object[] objectArray = confDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] files2 = objectArray;
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])files2), (Function1)appendConfigsFromDir.1.INSTANCE), (Function1)appendConfigsFromDir.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            StringUtilsKt.appendLine($this$appendConfigsFromDir, "// " + it.getName());
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $this$appendConfigsFromDir.append(FilesKt.readText$default((File)it, null, (int)1, null));
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
        }
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        int n2 = 0;
        int n3 = $this$toHex.length * 2;
        char[] cArray = new char[n3];
        while (n2 < n3) {
            n = n2++;
            cArray[n] = 32;
        }
        char[] result2 = cArray;
        int i2 = 0;
        byte[] $this$forEach$iv = $this$toHex;
        boolean $i$f$forEach = false;
        int n4 = $this$forEach$iv.length;
        for (n = 0; n < n4; ++n) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            byte n5 = it;
            int n6 = i2;
            i2 = n6 + 1;
            result2[n6] = Character.forDigit(n5 >> 4 & 0xF, 16);
            n6 = i2;
            i2 = n6 + 1;
            result2[n6] = Character.forDigit(n5 & 0xF, 16);
        }
        return new String(result2);
    }

    @Nullable
    public static final String calculateDirHash(@NotNull FileHasher $this$calculateDirHash, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDirHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        if (!dir2.isDirectory()) {
            return null;
        }
        Hasher hasher = Hashing.defaultFunction().newHasher();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)dir2, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)file2, (File)dir2));
            if (!file2.isFile()) continue;
            if (!Files.isSymbolicLink(file2.toPath())) {
                hasher.putHash($this$calculateDirHash.hash(file2));
                continue;
            }
            File canonicalFile = file2.getCanonicalFile();
            hasher.putHash($this$calculateDirHash.hash(canonicalFile));
            Intrinsics.checkNotNullExpressionValue((Object)canonicalFile, (String)"canonicalFile");
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)canonicalFile, (File)dir2));
        }
        byte[] byArray = hasher.hash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hasher.hash().toByteArray()");
        return UtilsKt.toHex(byArray);
    }

    @NotNull
    public static final File writeWasmUnitTestRunner(@NotNull File workingDir2, @NotNull File compiledFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)compiledFile, (String)"compiledFile");
        File it = file2 = FilesKt.resolve((File)workingDir2, (String)"static");
        boolean bl = false;
        it.mkdirs();
        File file3 = file2;
        File testRunnerFile = FilesKt.resolve((File)file3, (String)"runUnitTests.mjs");
        FilesKt.writeText$default((File)testRunnerFile, (String)StringsKt.trimIndent((String)("\n        import { startUnitTests } from './" + FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)compiledFile, (File)file3)) + "';\n        startUnitTests();\n        ")), null, (int)2, null);
        return testRunnerFile;
    }
}

