/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0010"}, d2={"copyZipFilePartially", "", "sourceZipFile", "Ljava/io/File;", "destinationZipFile", "path", "", "ensureValidZipDirectoryPath", "isValidZipDirectoryPath", "", "requireValidZipDirectoryPath", "copyPartially", "Ljava/util/zip/ZipFile;", "listDescendants", "Lkotlin/sequences/Sequence;", "Ljava/util/zip/ZipEntry;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nzipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 zipUtils.kt\norg/jetbrains/kotlin/gradle/utils/ZipUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1#2:67\n1855#3,2:68\n*S KotlinDebug\n*F\n+ 1 zipUtils.kt\norg/jetbrains/kotlin/gradle/utils/ZipUtilsKt\n*L\n24#1:68,2\n*E\n"})
public final class ZipUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyZipFilePartially(@NotNull File sourceZipFile, @NotNull File destinationZipFile, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)sourceZipFile, (String)"sourceZipFile");
        Intrinsics.checkNotNullParameter((Object)destinationZipFile, (String)"destinationZipFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        Closeable closeable = new ZipFile(sourceZipFile);
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            ZipUtilsKt.copyPartially(zip, destinationZipFile, path);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyPartially(@NotNull ZipFile $this$copyPartially, @NotNull File destinationZipFile, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$copyPartially, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationZipFile, (String)"destinationZipFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        List entries2 = SequencesKt.toList(ZipUtilsKt.listDescendants($this$copyPartially, path));
        if (entries2.isEmpty()) {
            return;
        }
        Closeable closeable = new ZipOutputStream(new FileOutputStream(destinationZipFile));
        Throwable throwable = null;
        try {
            ZipOutputStream destinationZipOutputStream = (ZipOutputStream)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = entries2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileTime it;
                ZipEntry sourceEntry = (ZipEntry)element$iv;
                boolean bl2 = false;
                String string2 = sourceEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceEntry.name");
                ZipEntry destinationEntry = new ZipEntry(StringsKt.substringAfter$default((String)string2, (String)path, null, (int)2, null));
                Object object = sourceEntry.getLastAccessTime();
                FileTime fileTime = object;
                if (fileTime != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"lastAccessTime");
                    it = object;
                    boolean bl3 = false;
                    destinationEntry.setLastAccessTime(it);
                }
                object = sourceEntry.getLastModifiedTime();
                FileTime fileTime2 = object;
                if (fileTime2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"lastModifiedTime");
                    it = object;
                    boolean bl4 = false;
                    destinationEntry.setLastModifiedTime(it);
                }
                object = sourceEntry.getCreationTime();
                FileTime fileTime3 = object;
                if (fileTime3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime3, (String)"creationTime");
                    it = object;
                    boolean bl5 = false;
                    destinationEntry.setCreationTime(it);
                }
                destinationEntry.setComment(sourceEntry.getComment());
                destinationEntry.setExtra(sourceEntry.getExtra());
                destinationEntry.setCrc(sourceEntry.getCrc());
                destinationEntry.setSize(sourceEntry.getSize());
                destinationEntry.setMethod(sourceEntry.getMethod());
                destinationZipOutputStream.putNextEntry(destinationEntry);
                if (!sourceEntry.isDirectory()) {
                    object = $this$copyPartially.getInputStream(sourceEntry);
                    Throwable throwable2 = null;
                    try {
                        InputStream inputStream = (InputStream)object;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                        long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)destinationZipOutputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                }
                destinationZipOutputStream.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Sequence<ZipEntry> listDescendants(@NotNull ZipFile $this$listDescendants, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$listDescendants, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        Enumeration<? extends ZipEntry> enumeration = $this$listDescendants.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries()");
        return SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<ZipEntry, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZipEntry entry2) {
                boolean bl;
                if (!Intrinsics.areEqual((Object)entry2.getName(), (Object)this.$path)) {
                    String string2 = entry2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                    if (StringsKt.startsWith$default((String)string2, (String)this.$path, (boolean)false, (int)2, null)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    @NotNull
    public static final String ensureValidZipDirectoryPath(@NotNull String path) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (ZipUtilsKt.isValidZipDirectoryPath(path)) {
            return path;
        }
        String p0 = string2 = path + '/';
        boolean $i$f$ensureValidZipDirectoryPath$stub_for_inlining = false;
        boolean bl = false;
        ZipUtilsKt.requireValidZipDirectoryPath(p0);
        return string2;
    }

    private static final void requireValidZipDirectoryPath(String path) {
        if (!ZipUtilsKt.isValidZipDirectoryPath(path)) {
            boolean bl = false;
            String string2 = "Expected path to end with '/', found '" + path + '\'';
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private static final boolean isValidZipDirectoryPath(String path) {
        return ((CharSequence)path).length() == 0 || StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null);
    }
}

