/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil;

public final class SafeMath {
    private SafeMath() {
    }

    public static char safeIntToChar(int value2) {
        if (value2 < 0 || 65535 < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as char");
        }
        return (char)value2;
    }

    public static byte safeIntToByte(int value2) {
        if (value2 < -128 || 127 < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as byte (out of range)");
        }
        return (byte)value2;
    }

    public static short safeIntToShort(int value2) {
        if (value2 < Short.MIN_VALUE || Short.MAX_VALUE < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as short (out of range)");
        }
        return (short)value2;
    }

    public static char safeLongToChar(long value2) {
        if (value2 < 0L || 65535L < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as int (out of range)");
        }
        return (char)value2;
    }

    public static byte safeLongToByte(long value2) {
        if (value2 < -128L || 127L < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as int (out of range)");
        }
        return (byte)value2;
    }

    public static short safeLongToShort(long value2) {
        if (value2 < -32768L || 32767L < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as int (out of range)");
        }
        return (short)value2;
    }

    public static int safeLongToInt(long value2) {
        if (value2 < Integer.MIN_VALUE || Integer.MAX_VALUE < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as int (out of range)");
        }
        return (int)value2;
    }

    public static float safeDoubleToFloat(double value2) {
        if (Double.isNaN(value2)) {
            return Float.NaN;
        }
        if (Double.isInfinite(value2)) {
            return value2 < 0.0 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (value2 < -3.4028234663852886E38 || 3.4028234663852886E38 < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as float (out of range)");
        }
        float floatValue = (float)value2;
        if ((double)floatValue != value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as float (imprecise)");
        }
        return floatValue;
    }
}

