/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.jetbrains.kotlin.org.apache.commons.io.FileUtils;

public final class IOUtils {
    private static final int COPY_BUF_SIZE = 8024;
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];

    @Deprecated
    public static void closeQuietly(Closeable c) {
        org.jetbrains.kotlin.org.apache.commons.io.IOUtils.closeQuietly(c);
    }

    @Deprecated
    public static void copy(File sourceFile, OutputStream outputStream) throws IOException {
        FileUtils.copyFile(sourceFile, outputStream);
    }

    @Deprecated
    public static long copy(InputStream input, OutputStream output2) throws IOException {
        return org.jetbrains.kotlin.org.apache.commons.io.IOUtils.copy(input, output2);
    }

    @Deprecated
    public static long copy(InputStream input, OutputStream output2, int bufferSize) throws IOException {
        return org.jetbrains.kotlin.org.apache.commons.io.IOUtils.copy(input, output2, bufferSize);
    }

    @Deprecated
    public static long copyRange(InputStream input, long len, OutputStream output2) throws IOException {
        return org.jetbrains.kotlin.org.apache.commons.io.IOUtils.copyLarge(input, output2, 0L, len);
    }

    @Deprecated
    public static long copyRange(InputStream input, long length, OutputStream output2, int bufferSize) throws IOException {
        long count;
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be bigger than 0");
        }
        byte[] buffer = new byte[(int)Math.min((long)bufferSize, Math.max(0L, length))];
        int n = 0;
        for (count = 0L; count < length && -1 != (n = input.read(buffer, 0, (int)Math.min(length - count, (long)buffer.length))); count += (long)n) {
            if (output2 == null) continue;
            output2.write(buffer, 0, n);
        }
        return count;
    }

    @Deprecated
    public static int read(File file2, byte[] array2) throws IOException {
        try (InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
            int n = IOUtils.readFully(inputStream, array2, 0, array2.length);
            return n;
        }
    }

    public static int readFully(InputStream input, byte[] array2) throws IOException {
        return IOUtils.readFully(input, array2, 0, array2.length);
    }

    public static int readFully(InputStream input, byte[] array2, int offset, int length) throws IOException {
        if (length < 0 || offset < 0 || length + offset > array2.length || length + offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        return org.jetbrains.kotlin.org.apache.commons.io.IOUtils.read(input, array2, offset, length);
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int expectedLength = byteBuffer.remaining();
        int read = org.jetbrains.kotlin.org.apache.commons.io.IOUtils.read(channel, byteBuffer);
        if (read < expectedLength) {
            throw new EOFException();
        }
    }

    public static byte[] readRange(InputStream input, int length) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        org.jetbrains.kotlin.org.apache.commons.io.IOUtils.copyLarge(input, output2, 0L, (long)length);
        return output2.toByteArray();
    }

    public static byte[] readRange(ReadableByteChannel input, int length) throws IOException {
        int readNow;
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        ByteBuffer b = ByteBuffer.allocate(Math.min(length, 8024));
        for (int read = 0; read < length; read += readNow) {
            b.limit(Math.min(length - read, b.capacity()));
            readNow = input.read(b);
            if (readNow <= 0) break;
            output2.write(b.array(), 0, readNow);
            b.rewind();
        }
        return output2.toByteArray();
    }

    @Deprecated
    public static long skip(InputStream input, long numToSkip) throws IOException {
        return org.jetbrains.kotlin.org.apache.commons.io.IOUtils.skip(input, numToSkip);
    }

    @Deprecated
    public static byte[] toByteArray(InputStream input) throws IOException {
        return org.jetbrains.kotlin.org.apache.commons.io.IOUtils.toByteArray(input);
    }

    private IOUtils() {
    }
}

