/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.storage;

import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.UtilBundle;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class HeavyProcessLatch {
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final List<Operation> myHeavyProcesses = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);

    private HeavyProcessLatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(@NotNull Type type, @NotNull @Nls String displayName, @NotNull Runnable runnable) {
        if (type == null) {
            HeavyProcessLatch.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(2);
        }
        Op op = new Op(type, displayName);
        this.myHeavyProcesses.add(op);
        this.myEventDispatcher.getMulticaster().processStarted(op);
        try {
            runnable.run();
        }
        finally {
            this.myHeavyProcesses.remove(op);
            this.myEventDispatcher.getMulticaster().processFinished(op);
        }
    }

    public boolean isRunning() {
        return !this.myHeavyProcesses.isEmpty();
    }

    public boolean isRunning(@NotNull Type type) {
        if (type == null) {
            HeavyProcessLatch.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(this.myHeavyProcesses, op -> op.getType() == type);
    }

    public boolean isRunningAnythingBut(@NotNull Type type) {
        if (type == null) {
            HeavyProcessLatch.$$$reportNull$$$0(4);
        }
        return this.findRunningExcept(type) != null;
    }

    @TestOnly
    public Operation getAnyRunningOperation() {
        Iterator<Operation> iterator2 = this.myHeavyProcesses.iterator();
        return iterator2.hasNext() ? iterator2.next() : null;
    }

    @Nullable
    public Operation findRunningExcept(@NotNull Type type) {
        if (type == null) {
            HeavyProcessLatch.$$$reportNull$$$0(5);
        }
        for (Operation operation : this.myHeavyProcesses) {
            if (operation.getType() == type) continue;
            return operation;
        }
        return null;
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull HeavyProcessListener listener) {
        if (parentDisposable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            HeavyProcessLatch.$$$reportNull$$$0(7);
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/storage/HeavyProcessLatch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRunning";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRunningAnythingBut";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningExcept";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HeavyProcessListener
    extends EventListener {
        default public void processStarted(@NotNull Operation op) {
            if (op == null) {
                HeavyProcessListener.$$$reportNull$$$0(0);
            }
        }

        public void processFinished(@NotNull Operation var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "org/jetbrains/kotlin/com/intellij/util/io/storage/HeavyProcessLatch$HeavyProcessListener", "processStarted"));
        }
    }

    private static final class Op
    implements Operation {
        private final Type myType;
        @NotNull
        @Nls
        private final String myDisplayName;

        Op(@NotNull Type type, @NotNull @Nls String displayName) {
            if (type == null) {
                Op.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                Op.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.myDisplayName = displayName;
        }

        @Override
        @NotNull
        public Type getType() {
            Type type = this.myType;
            if (type == null) {
                Op.$$$reportNull$$$0(2);
            }
            return type;
        }

        @Override
        @Nls
        @NotNull
        public String getDisplayName() {
            String string2 = this.myDisplayName;
            if (string2 == null) {
                Op.$$$reportNull$$$0(3);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/storage/HeavyProcessLatch$Op";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/storage/HeavyProcessLatch$Op";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Type {
        Indexing("heavyProcess.type.indexing"),
        Syncing("heavyProcess.type.syncing"),
        Processing("heavyProcess.type.processing");

        private final String bundleKey;

        private Type(String bundleKey) {
            this.bundleKey = bundleKey;
        }

        @Nls
        public String toString() {
            return UtilBundle.message(this.bundleKey, new Object[0]);
        }
    }

    public static interface Operation {
        @NotNull
        public Type getType();

        @NotNull
        @Nls
        public String getDisplayName();
    }
}

