/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.HttpReportParameters;
import org.jetbrains.kotlin.build.report.statistics.StatTag;
import org.jetbrains.kotlin.buildtools.api.SourcesChanges;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.internal.report.BuildScanApi;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.StatisticsBuildFlowManager;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationCacheStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.gradle.report.BuildReportParameters;
import org.jetbrains.kotlin.gradle.report.BuildReportsService;
import org.jetbrains.kotlin.gradle.report.BuildScanExtensionHolder;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.DevelocityPluginBuildScanWrapper;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionInfo;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.TransformRecord;
import org.jetbrains.kotlin.gradle.report.UsesBuildMetricsService;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b\u0017J0\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\f2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016JR\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\f2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110&2\b\u0010'\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010(\u001a\u00020\u0014H\u0016J\u0012\u0010)\u001a\u00020\u00142\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020.H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService$Parameters;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildOperationRecords", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "buildReportService", "Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "failureMessages", "", "taskPathToMetricsReporter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "taskPathToTaskClass", "addBuildScanReport", "", "buildScan", "Lorg/jetbrains/kotlin/gradle/internal/report/BuildScanApi;", "addBuildScanReport$kotlin_gradle_plugin_common", "addTask", "taskPath", "taskClass", "Ljava/lang/Class;", "metricsReporter", "addTransformMetrics", "transformPath", "transformClass", "isKotlinTransform", "", "startTimeMs", "", "totalTimeMs", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "failureMessage", "close", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "updateBuildOperationRecord", "Lorg/jetbrains/kotlin/gradle/report/TaskRecord;", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMetricsService.kt\norg/jetbrains/kotlin/gradle/report/BuildMetricsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1#2:360\n1557#3:361\n1628#3,3:362\n1863#3,2:365\n*S KotlinDebug\n*F\n+ 1 BuildMetricsService.kt\norg/jetbrains/kotlin/gradle/report/BuildMetricsService\n*L\n135#1:361\n135#1:362,3\n324#1:365,2\n*E\n"})
public abstract class BuildMetricsService
implements BuildService<Parameters>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildReportsService buildReportService = new BuildReportsService();
    @NotNull
    private final ConcurrentLinkedQueue<BuildOperationRecord> buildOperationRecords = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<String> failureMessages = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentHashMap<String, BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>> taskPathToMetricsReporter = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> taskPathToTaskClass = new ConcurrentHashMap();
    @NotNull
    private static final Class<BuildMetricsService> serviceClass = BuildMetricsService.class;
    @NotNull
    private static final String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();
    private static final Logger log = Logging.getLogger(BuildMetricsService.class);

    public void addTask(@NotNull String taskPath, @NotNull Class<?> taskClass, @NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> metricsReporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter(taskClass, (String)"taskClass");
        Intrinsics.checkNotNullParameter(metricsReporter, (String)"metricsReporter");
        Object it = object = this.taskPathToMetricsReporter.put(taskPath, metricsReporter);
        boolean bl = false;
        if (it != null) {
            log.warn("Duplicate task path: " + taskPath);
        }
        object = this.taskPathToTaskClass.put(taskPath, taskClass.getName());
        it = (String)object;
        boolean bl2 = false;
        if (it != null) {
            log.warn("Duplicate task path: " + taskPath);
        }
    }

    public void addTransformMetrics(@NotNull String transformPath, @NotNull Class<?> transformClass, boolean isKotlinTransform, long startTimeMs, long totalTimeMs, @NotNull BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> buildMetrics, @Nullable String failureMessage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)transformPath, (String)"transformPath");
            Intrinsics.checkNotNullParameter(transformClass, (String)"transformClass");
            Intrinsics.checkNotNullParameter(buildMetrics, (String)"buildMetrics");
            String string2 = transformClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"transformClass.name");
            this.buildOperationRecords.add(new TransformRecord(transformPath, string2, isKotlinTransform, startTimeMs, totalTimeMs, buildMetrics));
            String string3 = failureMessage;
            if (string3 == null) break block0;
            String it = string3;
            boolean bl = false;
            this.failureMessages.add(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TaskRecord updateBuildOperationRecord(TaskFinishEvent event) {
        KotlinVersion kotlinVersion;
        SourcesChanges sourcesChanges;
        String string2;
        Object it;
        TaskOperationResult result2 = event.getResult();
        String taskPath = event.getDescriptor().getTaskPath();
        long totalTimeMs = result2.getEndTime() - result2.getStartTime();
        BuildMetrics buildMetrics = new BuildMetrics(null, null, null, null, 15, null);
        buildMetrics.getBuildTimes().addTimeMs((BuildTime)GradleBuildTime.GRADLE_TASK, totalTimeMs);
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter = this.taskPathToMetricsReporter.get(taskPath);
        if (buildMetricsReporter != null) {
            it = buildMetricsReporter;
            boolean bl = false;
            buildMetrics.addAll(it.getMetrics());
        }
        Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
        BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
        BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> buildMetrics2 = taskExecutionResult;
        if (buildMetrics2 != null && (buildMetrics2 = buildMetrics2.getBuildMetrics()) != null) {
            BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> it2 = it = buildMetrics2;
            boolean bl2 = false;
            buildMetrics.addAll(it2);
        }
        if ((string2 = this.taskPathToTaskClass.get(taskPath)) == null) {
            string2 = "unknown";
        }
        it = string2;
        long it2 = result2.getStartTime();
        boolean bl = result2 instanceof org.gradle.tooling.events.task.TaskExecutionResult;
        TaskSkippedResult taskSkippedResult = result2 instanceof TaskSkippedResult ? (TaskSkippedResult)result2 : null;
        String string3 = taskSkippedResult != null ? taskSkippedResult.getSkipMessage() : null;
        Object object = taskExecutionResult;
        if (object == null || (object = object.getIcLogLines()) == null) {
            object = CollectionsKt.emptyList();
        }
        BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> buildMetrics3 = object;
        Object object2 = taskExecutionResult;
        SourcesChanges sourcesChanges2 = sourcesChanges = object2 != null && (object2 = ((TaskExecutionResult)object2).getTaskInfo()) != null ? ((TaskExecutionInfo)object2).getChangedFiles() : null;
        Object object3 = taskExecutionResult;
        if (object3 == null || (object3 = ((TaskExecutionResult)object3).getTaskInfo()) == null || (object3 = ((TaskExecutionInfo)object3).getCompilerArguments()) == null) {
            object3 = new String[]{};
        }
        Object object4 = object3;
        Object object5 = taskExecutionResult;
        KotlinVersion kotlinVersion2 = kotlinVersion = object5 != null && (object5 = ((TaskExecutionResult)object5).getTaskInfo()) != null ? ((TaskExecutionInfo)object5).getKotlinLanguageVersion() : null;
        Object object6 = taskExecutionResult;
        if (object6 == null || (object6 = ((TaskExecutionResult)object6).getTaskInfo()) == null || (object6 = ((TaskExecutionInfo)object6).getTags()) == null) {
            object6 = SetsKt.emptySet();
        }
        Object object7 = object6;
        TaskRecord buildOperation = new TaskRecord(taskPath, (String)it, it2, totalTimeMs, (BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric>)buildMetrics, bl, string3, (List<String>)buildMetrics3, kotlinVersion, sourcesChanges, (String[])object4, (Set<? extends StatTag>)object7);
        this.buildOperationRecords.add(buildOperation);
        if (result2 instanceof TaskFailureResult) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = ((TaskFailureResult)result2).getFailures();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.failures");
            it = list;
            ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.failureMessages;
            boolean $i$f$map = false;
            void bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                object4 = (Failure)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it3.getMessage());
            }
            concurrentLinkedQueue.addAll((List)destination$iv$iv);
        }
        return buildOperation;
    }

    @Override
    public void close() {
        Collection collection = this.buildOperationRecords;
        List list = CollectionsKt.toList((Iterable)this.failureMessages);
        BuildServiceParameters buildServiceParameters = this.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"parameters");
        this.buildReportService.close(collection, list, BuildMetricsService.Companion.toBuildReportParameters((Parameters)buildServiceParameters));
    }

    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            TaskRecord buildOperation = this.updateBuildOperationRecord((TaskFinishEvent)event);
            BuildServiceParameters buildServiceParameters = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"parameters");
            BuildReportParameters buildParameters = BuildMetricsService.Companion.toBuildReportParameters((Parameters)buildServiceParameters);
            this.buildReportService.onFinish((TaskFinishEvent)event, buildOperation, buildParameters);
        }
    }

    public final void addBuildScanReport$kotlin_gradle_plugin_common(@Nullable BuildScanApi buildScan) {
        if (buildScan == null) {
            return;
        }
        this.buildReportService.initBuildScanTags$kotlin_gradle_plugin_common(buildScan, (String)((Parameters)this.getParameters()).getLabel().getOrNull());
        Collection collection = this.buildOperationRecords;
        BuildServiceParameters buildServiceParameters = this.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"parameters");
        this.buildReportService.addBuildScanReport$kotlin_gradle_plugin_common(collection, BuildMetricsService.Companion.toBuildReportParameters((Parameters)buildServiceParameters), buildScan);
        List list = (List)((Parameters)this.getParameters()).getBuildConfigurationTags().getOrNull();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StatTag it = (StatTag)element$iv;
                boolean bl = false;
                buildScan.tag(it.getReadableString());
            }
        }
        this.buildReportService.addCollectedTags$kotlin_gradle_plugin_common(buildScan);
        log.debug("Build metrics are stored into build scan for '" + this.buildReportService.getBuildUuid$kotlin_gradle_plugin_common() + "' build");
    }

    public static final /* synthetic */ TaskRecord access$updateBuildOperationRecord(BuildMetricsService $this, TaskFinishEvent event) {
        return $this.updateBuildOperationRecord(event);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J&\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u001a\u001a\u00020\fH\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "serviceClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "serviceName", "", "initBuildScanHolder", "Lorg/jetbrains/kotlin/gradle/internal/report/BuildScanApi;", "project", "Lorg/gradle/api/Project;", "buildMetricServiceProvider", "Lorg/gradle/api/provider/Provider;", "registerIfAbsent", "registerIfAbsentImpl", "setupTags", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "Lkotlin/collections/ArrayList;", "subscribeForTaskEvents", "", "subscribeForTaskEventsForBuildScan", "buildScanHolder", "toBuildReportParameters", "Lorg/jetbrains/kotlin/gradle/report/BuildReportParameters;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService$Parameters;", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nBuildMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMetricsService.kt\norg/jetbrains/kotlin/gradle/report/BuildMetricsService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1#2:360\n295#3,2:361\n*S KotlinDebug\n*F\n+ 1 BuildMetricsService.kt\norg/jetbrains/kotlin/gradle/report/BuildMetricsService$Companion\n*L\n313#1:361,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BuildReportParameters toBuildReportParameters(Parameters $this$toBuildReportParameters) {
            Object object = $this$toBuildReportParameters.getStartParameters().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"startParameters.get()");
            BuildStartParameters buildStartParameters = (BuildStartParameters)object;
            Object object2 = $this$toBuildReportParameters.getReportingSettings().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"reportingSettings.get()");
            ReportingSettings reportingSettings = (ReportingSettings)object2;
            HttpReportParameters httpReportParameters = (HttpReportParameters)$this$toBuildReportParameters.getHttpParameters().getOrNull();
            Object object3 = $this$toBuildReportParameters.getProjectDir().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"projectDir.asFile.get()");
            File file2 = (File)object3;
            String string2 = (String)$this$toBuildReportParameters.getLabel().getOrNull();
            Object object4 = $this$toBuildReportParameters.getProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"projectName.get()");
            String string3 = (String)object4;
            Object object5 = $this$toBuildReportParameters.getKotlinVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"kotlinVersion.get()");
            return new BuildReportParameters(buildStartParameters, reportingSettings, httpReportParameters, file2, string2, string3, (String)object5, new HashSet((Collection)$this$toBuildReportParameters.getBuildConfigurationTags().get()));
        }

        private final Provider<BuildMetricsService> registerIfAbsentImpl(Project project) {
            Provider provider;
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider2 = it.getService();
                Intrinsics.checkNotNull((Object)provider2, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.report.BuildMetricsService>");
                return provider2;
            }
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project);
            if (reportingSettings.getBuildReportOutputs().isEmpty()) {
                return null;
            }
            String kotlinVersion = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
            Provider it = provider = project.getGradle().getSharedServices().registerIfAbsent(serviceName, serviceClass, new Action(reportingSettings, project, kotlinVersion){
                final /* synthetic */ ReportingSettings $reportingSettings;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $kotlinVersion;
                {
                    this.$reportingSettings = $reportingSettings;
                    this.$project = $project;
                    this.$kotlinVersion = $kotlinVersion;
                }

                public final void execute(BuildServiceSpec<Parameters> it) {
                    Unit unit;
                    ((Parameters)it.getParameters()).getLabel().set((Object)this.$reportingSettings.getBuildReportLabel());
                    ((Parameters)it.getParameters()).getProjectName().set((Object)this.$project.getRootProject().getName());
                    ((Parameters)it.getParameters()).getKotlinVersion().set((Object)this.$kotlinVersion);
                    ((Parameters)it.getParameters()).getStartParameters().set((Object)BuildReportsService.Companion.getStartParameters(this.$project));
                    ((Parameters)it.getParameters()).getReportingSettings().set((Object)this.$reportingSettings);
                    HttpReportSettings httpReportSettings = this.$reportingSettings.getHttpReportSettings();
                    if (httpReportSettings != null) {
                        HttpReportSettings httpSettings = httpReportSettings;
                        boolean bl = false;
                        if (!httpSettings.getUseExecutorForHttpReport()) {
                            BuildMetricsService.access$getLog$cp().warn("`kotlin.internal.build.report.http.use.executor` property is for test purposes only");
                        }
                        ((Parameters)it.getParameters()).getHttpParameters().set((Object)new HttpReportParameters(httpSettings.getUrl(), httpSettings.getUser(), httpSettings.getPassword(), httpSettings.getUseExecutorForHttpReport()));
                        BuildMetricsService.access$getLog$cp().debug("Http report is enabled for " + httpSettings.getUrl());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        BuildMetricsService.access$getLog$cp().debug("Http report is disabled");
                    }
                    ((Parameters)it.getParameters()).getProjectDir().set((Object)this.$project.getLayout().getProjectDirectory());
                    ((Parameters)it.getParameters()).getBuildConfigurationTags().value((Iterable)org.jetbrains.kotlin.gradle.report.BuildMetricsService$Companion.access$setupTags(BuildMetricsService.Companion, this.$project));
                }
            });
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Companion.subscribeForTaskEvents(project, (Provider<BuildMetricsService>)it);
            return provider;
        }

        private final void subscribeForTaskEvents(Project project, Provider<BuildMetricsService> buildMetricServiceProvider) {
            boolean gradle80withBuildScanReport;
            BuildScanApi buildScanHolder = this.initBuildScanHolder(project, buildMetricServiceProvider);
            if (buildScanHolder != null) {
                this.subscribeForTaskEventsForBuildScan(project, buildMetricServiceProvider, buildScanHolder);
            }
            boolean bl = gradle80withBuildScanReport = Intrinsics.areEqual((Object)GradleVersion.current().getBaseVersion(), (Object)GradleVersion.version((String)"8.0")) && buildScanHolder != null;
            if (!gradle80withBuildScanReport) {
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(buildMetricServiceProvider);
            }
        }

        private final BuildScanApi initBuildScanHolder(Project project, Provider<BuildMetricsService> buildMetricServiceProvider) {
            Object object;
            block11: {
                Project rootProject;
                block10: {
                    Serializable serializable = (ReportingSettings)((Parameters)((BuildMetricsService)buildMetricServiceProvider.get()).getParameters()).getReportingSettings().getOrNull();
                    if (serializable == null || (serializable = serializable.getBuildScanReportSettings()) == null) {
                        return null;
                    }
                    rootProject = ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project) ? project : project.getRootProject();
                    object = rootProject.getExtensions().findByName("develocity");
                    if (object == null) break block10;
                    Object it = object;
                    boolean bl = false;
                    DevelocityPluginBuildScanWrapper develocityPluginBuildScanWrapper = DevelocityPluginBuildScanWrapper.Companion.invoke$kotlin_gradle_plugin_common(it);
                    object = develocityPluginBuildScanWrapper;
                    if (develocityPluginBuildScanWrapper != null) break block11;
                }
                Object object2 = rootProject.getExtensions().findByName("buildScan");
                if (object2 != null) {
                    Object it = object2;
                    boolean bl = false;
                    object = BuildScanExtensionHolder.Companion.invoke$kotlin_gradle_plugin_common(it);
                } else {
                    object = null;
                }
            }
            Object buildScan = object;
            if (buildScan == null && ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project)) {
                log.warn("Build report creation in the build scan format is not yet supported when the isolated projects feature is enabled. Follow https://youtrack.jetbrains.com/issue/KT-68847 for the updates. Build report for build scan won't be created.");
            } else if (buildScan == null) {
                log.debug("Build scan is not enabled. Build report for build scan won't be created.");
            } else {
                log.debug("Build report for build scan is configured.");
            }
            return (BuildScanApi)buildScan;
        }

        private final void subscribeForTaskEventsForBuildScan(Project project, Provider<BuildMetricsService> buildMetricServiceProvider, BuildScanApi buildScanHolder) {
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.0")) < 0) {
                buildScanHolder.buildFinished((Function0<Unit>)((Function0)new Function0<Unit>(buildMetricServiceProvider, buildScanHolder){
                    final /* synthetic */ Provider<BuildMetricsService> $buildMetricServiceProvider;
                    final /* synthetic */ BuildScanApi $buildScanHolder;
                    {
                        this.$buildMetricServiceProvider = $buildMetricServiceProvider;
                        this.$buildScanHolder = $buildScanHolder;
                        super(0);
                    }

                    public final void invoke() {
                        this.$buildMetricServiceProvider.map(new Transformer(this.$buildScanHolder){
                            final /* synthetic */ BuildScanApi $buildScanHolder;
                            {
                                this.$buildScanHolder = $buildScanHolder;
                            }

                            public final void transform(BuildMetricsService it) {
                                it.addBuildScanReport$kotlin_gradle_plugin_common(this.$buildScanHolder);
                            }
                        }).get();
                    }
                }));
            } else if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) < 0) {
                BuildMetricsService buildMetricService = (BuildMetricsService)buildMetricServiceProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)buildMetricService, (String)"buildMetricService");
                buildMetricService.buildReportService.initBuildScanTags$kotlin_gradle_plugin_common(buildScanHolder, (String)((Parameters)buildMetricService.getParameters()).getLabel().getOrNull());
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(project.provider(new Callable(buildMetricService, buildMetricServiceProvider, buildScanHolder){
                    final /* synthetic */ BuildMetricsService $buildMetricService;
                    final /* synthetic */ Provider<BuildMetricsService> $buildMetricServiceProvider;
                    final /* synthetic */ BuildScanApi $buildScanHolder;
                    {
                        this.$buildMetricService = $buildMetricService;
                        this.$buildMetricServiceProvider = $buildMetricServiceProvider;
                        this.$buildScanHolder = $buildScanHolder;
                    }

                    public final OperationCompletionListener call() {
                        return new OperationCompletionListener(this.$buildMetricService, this.$buildMetricServiceProvider, this.$buildScanHolder){
                            final /* synthetic */ BuildMetricsService $buildMetricService;
                            final /* synthetic */ Provider<BuildMetricsService> $buildMetricServiceProvider;
                            final /* synthetic */ BuildScanApi $buildScanHolder;
                            {
                                this.$buildMetricService = $buildMetricService;
                                this.$buildMetricServiceProvider = $buildMetricServiceProvider;
                                this.$buildScanHolder = $buildScanHolder;
                            }

                            public final void onFinish(FinishEvent event) {
                                if (event instanceof TaskFinishEvent) {
                                    BuildMetricsService buildMetricsService = this.$buildMetricService;
                                    Intrinsics.checkNotNullExpressionValue((Object)buildMetricsService, (String)"buildMetricService");
                                    TaskRecord buildOperation = BuildMetricsService.access$updateBuildOperationRecord(buildMetricsService, (TaskFinishEvent)event);
                                    BuildServiceParameters buildServiceParameters = this.$buildMetricService.getParameters();
                                    Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"buildMetricService.parameters");
                                    BuildReportParameters buildParameters = org.jetbrains.kotlin.gradle.report.BuildMetricsService$Companion.access$toBuildReportParameters(BuildMetricsService.Companion, (Parameters)buildServiceParameters);
                                    BuildReportsService buildReportService2 = (BuildReportsService)this.$buildMetricServiceProvider.map((Transformer)subscribeForTaskEventsForBuildScan.buildReportService.1.INSTANCE).get();
                                    buildReportService2.addBuildScanReport$kotlin_gradle_plugin_common((TaskFinishEvent)event, buildOperation, buildParameters, this.$buildScanHolder);
                                    buildReportService2.onFinish((TaskFinishEvent)event, buildOperation, buildParameters);
                                }
                            }
                        };
                    }
                }));
            } else {
                StatisticsBuildFlowManager.Companion.getInstance(project).subscribeForBuildScan(buildScanHolder);
            }
        }

        @Nullable
        public final Provider<BuildMetricsService> registerIfAbsent(@NotNull Project project) {
            Provider<BuildMetricsService> provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Provider<BuildMetricsService> provider2 = this.registerIfAbsentImpl(project);
            if (provider2 != null) {
                Provider<BuildMetricsService> provider3;
                Provider<BuildMetricsService> serviceProvider = provider3 = provider2;
                boolean bl = false;
                String string2 = UsesBuildMetricsService.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UsesBuildMetricsService::class.java.name");
                SingleActionPerProject.INSTANCE.run(project, string2, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Provider<BuildMetricsService> $serviceProvider;
                    {
                        this.$project = $project;
                        this.$serviceProvider = $serviceProvider;
                        super(0);
                    }

                    public final void invoke() {
                        TaskContainer taskContainer = this.$project.getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                        boolean $i$f$withType = false;
                        TaskCollection taskCollection = $this$withType$iv.withType(UsesBuildMetricsService.class);
                        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                        taskCollection.configureEach(new Action(this.$serviceProvider){
                            final /* synthetic */ Provider<BuildMetricsService> $serviceProvider;
                            {
                                this.$serviceProvider = $serviceProvider;
                            }

                            public final void execute(UsesBuildMetricsService task2) {
                                task2.getBuildMetricsService().value(this.$serviceProvider).disallowChanges();
                                task2.usesService(this.$serviceProvider);
                            }
                        });
                    }
                }));
                provider = provider3;
            } else {
                provider = null;
            }
            return provider;
        }

        private final ArrayList<StatTag> setupTags(Project project) {
            Object v1;
            ArrayList<StatTag> additionalTags;
            block4: {
                Gradle gradle = project.getGradle();
                additionalTags = new ArrayList<StatTag>();
                if (ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheEnabled(project)) {
                    additionalTags.add(StatTag.CONFIGURATION_CACHE);
                }
                if (gradle.getStartParameter().isBuildCacheEnabled()) {
                    additionalTags.add(StatTag.BUILD_CACHE);
                }
                String debugConfiguration = "-agentlib:";
                List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRuntimeMXBean().inputArguments");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!StringsKt.startsWith$default((String)it, (String)debugConfiguration, (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            if (v1 != null) {
                additionalTags.add(StatTag.GRADLE_DEBUG);
            }
            return additionalTags;
        }

        public static final /* synthetic */ ArrayList access$setupTags(Companion $this, Project project) {
            return $this.setupTags(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildConfigurationTags", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "getBuildConfigurationTags", "()Lorg/gradle/api/provider/ListProperty;", "httpParameters", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/build/report/statistics/HttpReportParameters;", "getHttpParameters", "()Lorg/gradle/api/provider/Property;", "kotlinVersion", "", "getKotlinVersion", "label", "getLabel", "projectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectName", "getProjectName", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "getReportingSettings", "startParameters", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "getStartParameters", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<BuildStartParameters> getStartParameters();

        @NotNull
        public Property<ReportingSettings> getReportingSettings();

        @NotNull
        public Property<HttpReportParameters> getHttpParameters();

        @NotNull
        public DirectoryProperty getProjectDir();

        @NotNull
        public Property<String> getLabel();

        @NotNull
        public Property<String> getProjectName();

        @NotNull
        public Property<String> getKotlinVersion();

        @NotNull
        public ListProperty<StatTag> getBuildConfigurationTags();
    }
}

