/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObject2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterators;

public class Object2ObjectArrayMap<K, V>
extends AbstractObject2ObjectMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Object[] key;
    private transient Object[] value;
    private int size;
    private transient Object2ObjectMap.FastEntrySet<K, V> entries;
    private transient ObjectSet<K> keys;
    private transient ObjectCollection<V> values;

    public Object2ObjectArrayMap(Object[] key, Object[] value2) {
        this.key = key;
        this.value = value2;
        this.size = key.length;
        if (key.length != value2.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value2.length + ")");
        }
    }

    public Object2ObjectArrayMap() {
        this.key = ObjectArrays.EMPTY_ARRAY;
        this.value = ObjectArrays.EMPTY_ARRAY;
    }

    public Object2ObjectArrayMap(int capacity) {
        this.key = new Object[capacity];
        this.value = new Object[capacity];
    }

    public Object2ObjectArrayMap(Object2ObjectMap<K, V> m) {
        this(m.size());
        int i2 = 0;
        for (Object2ObjectMap.Entry entry2 : m.object2ObjectEntrySet()) {
            this.key[i2] = entry2.getKey();
            this.value[i2] = entry2.getValue();
            ++i2;
        }
        this.size = i2;
    }

    public Object2ObjectArrayMap(Map<? extends K, ? extends V> m) {
        this(m.size());
        int i2 = 0;
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.key[i2] = e.getKey();
            this.value[i2] = e.getValue();
            ++i2;
        }
        this.size = i2;
    }

    public Object2ObjectArrayMap(Object[] key, Object[] value2, int size) {
        this.key = key;
        this.value = value2;
        this.size = size;
        if (key.length != value2.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value2.length + ")");
        }
        if (size > key.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the backing-arrays size (" + key.length + ")");
        }
    }

    public Object2ObjectMap.FastEntrySet<K, V> object2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        int i2 = this.size;
        while (i2-- != 0) {
            if (!Objects.equals(key[i2], k)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public V get(Object k) {
        Object[] key = this.key;
        int i2 = this.size;
        while (i2-- != 0) {
            if (!Objects.equals(key[i2], k)) continue;
            return (V)this.value[i2];
        }
        return (V)this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i2 = this.size;
        while (i2-- != 0) {
            this.key[i2] = null;
            this.value[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(Object v) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (!Objects.equals(this.value[i2], v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V put(K k, V v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            Object oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return (V)oldValue;
        }
        if (this.size == this.key.length) {
            Object[] newKey = new Object[this.size == 0 ? 2 : this.size * 2];
            Object[] newValue = new Object[this.size == 0 ? 2 : this.size * 2];
            int i2 = this.size;
            while (i2-- != 0) {
                newKey[i2] = this.key[i2];
                newValue[i2] = this.value[i2];
            }
            this.key = newKey;
            this.value = newValue;
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return (V)this.defRetValue;
    }

    @Override
    public V remove(Object k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return (V)this.defRetValue;
        }
        Object oldValue = this.value[oldPos];
        int tail = this.size - oldPos - 1;
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, tail);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, tail);
        --this.size;
        this.key[this.size] = null;
        this.value[this.size] = null;
        return (V)oldValue;
    }

    @Override
    public ObjectSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new ValuesCollection();
        }
        return this.values;
    }

    public Object2ObjectArrayMap<K, V> clone() {
        Object2ObjectArrayMap c;
        try {
            c = (Object2ObjectArrayMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (Object[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.entries = null;
        c.keys = null;
        c.values = null;
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int max = this.size;
        for (int i2 = 0; i2 < max; ++i2) {
            s.writeObject(this.key[i2]);
            s.writeObject(this.value[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.key = new Object[this.size];
        this.value = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.key[i2] = s.readObject();
            this.value[i2] = s.readObject();
        }
    }

    private final class EntrySet
    extends AbstractObjectSet<Object2ObjectMap.Entry<K, V>>
    implements Object2ObjectMap.FastEntrySet<K, V> {
        private EntrySet() {
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<K, V>> iterator() {
            return new ObjectIterator<Object2ObjectMap.Entry<K, V>>(){
                int curr = -1;
                int next = 0;

                @Override
                public boolean hasNext() {
                    return this.next < Object2ObjectArrayMap.this.size;
                }

                @Override
                public Object2ObjectMap.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.curr = this.next;
                    return new AbstractObject2ObjectMap.BasicEntry<Object, Object>(Object2ObjectArrayMap.this.key[this.curr], Object2ObjectArrayMap.this.value[this.next++]);
                }

                @Override
                public void remove() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    this.curr = -1;
                    int tail = Object2ObjectArrayMap.this.size-- - this.next--;
                    System.arraycopy(Object2ObjectArrayMap.this.key, this.next + 1, Object2ObjectArrayMap.this.key, this.next, tail);
                    System.arraycopy(Object2ObjectArrayMap.this.value, this.next + 1, Object2ObjectArrayMap.this.value, this.next, tail);
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).key[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).value[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                }

                @Override
                public void forEachRemaining(Consumer<? super Object2ObjectMap.Entry<K, V>> action2) {
                    int max = Object2ObjectArrayMap.this.size;
                    while (this.next < max) {
                        this.curr = this.next;
                        action2.accept(new AbstractObject2ObjectMap.BasicEntry<Object, Object>(Object2ObjectArrayMap.this.key[this.curr], Object2ObjectArrayMap.this.value[this.next++]));
                    }
                }
            };
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<K, V>> fastIterator() {
            return new ObjectIterator<Object2ObjectMap.Entry<K, V>>(){
                int next = 0;
                int curr = -1;
                final AbstractObject2ObjectMap.BasicEntry<K, V> entry = new AbstractObject2ObjectMap.BasicEntry();

                @Override
                public boolean hasNext() {
                    return this.next < Object2ObjectArrayMap.this.size;
                }

                @Override
                public Object2ObjectMap.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.curr = this.next;
                    this.entry.key = Object2ObjectArrayMap.this.key[this.curr];
                    this.entry.value = Object2ObjectArrayMap.this.value[this.next++];
                    return this.entry;
                }

                @Override
                public void remove() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    this.curr = -1;
                    int tail = Object2ObjectArrayMap.this.size-- - this.next--;
                    System.arraycopy(Object2ObjectArrayMap.this.key, this.next + 1, Object2ObjectArrayMap.this.key, this.next, tail);
                    System.arraycopy(Object2ObjectArrayMap.this.value, this.next + 1, Object2ObjectArrayMap.this.value, this.next, tail);
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).key[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).value[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                }

                @Override
                public void forEachRemaining(Consumer<? super Object2ObjectMap.Entry<K, V>> action2) {
                    int max = Object2ObjectArrayMap.this.size;
                    while (this.next < max) {
                        this.curr = this.next;
                        this.entry.key = Object2ObjectArrayMap.this.key[this.curr];
                        this.entry.value = Object2ObjectArrayMap.this.value[this.next++];
                        action2.accept(this.entry);
                    }
                }
            };
        }

        @Override
        public ObjectSpliterator<Object2ObjectMap.Entry<K, V>> spliterator() {
            return new EntrySetSpliterator(0, Object2ObjectArrayMap.this.size);
        }

        @Override
        public void forEach(Consumer<? super Object2ObjectMap.Entry<K, V>> action2) {
            int max = Object2ObjectArrayMap.this.size;
            for (int i2 = 0; i2 < max; ++i2) {
                action2.accept(new AbstractObject2ObjectMap.BasicEntry<Object, Object>(Object2ObjectArrayMap.this.key[i2], Object2ObjectArrayMap.this.value[i2]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Object2ObjectMap.Entry<K, V>> action2) {
            AbstractObject2ObjectMap.BasicEntry entry2 = new AbstractObject2ObjectMap.BasicEntry();
            int max = Object2ObjectArrayMap.this.size;
            for (int i2 = 0; i2 < max; ++i2) {
                entry2.key = Object2ObjectArrayMap.this.key[i2];
                entry2.value = Object2ObjectArrayMap.this.value[i2];
                action2.accept(entry2);
            }
        }

        @Override
        public int size() {
            return Object2ObjectArrayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            return Object2ObjectArrayMap.this.containsKey(k) && Objects.equals(Object2ObjectArrayMap.this.get(k), e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            int oldPos = Object2ObjectArrayMap.this.findKey(k);
            if (oldPos == -1 || !Objects.equals(v, Object2ObjectArrayMap.this.value[oldPos])) {
                return false;
            }
            int tail = Object2ObjectArrayMap.this.size - oldPos - 1;
            System.arraycopy(Object2ObjectArrayMap.this.key, oldPos + 1, Object2ObjectArrayMap.this.key, oldPos, tail);
            System.arraycopy(Object2ObjectArrayMap.this.value, oldPos + 1, Object2ObjectArrayMap.this.value, oldPos, tail);
            Object2ObjectArrayMap.this.size--;
            ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).key[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
            ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).value[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
            return true;
        }

        final class EntrySetSpliterator
        extends ObjectSpliterators.EarlyBindingSizeIndexBasedSpliterator<Object2ObjectMap.Entry<K, V>>
        implements ObjectSpliterator<Object2ObjectMap.Entry<K, V>> {
            EntrySetSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            public int characteristics() {
                return 16465;
            }

            @Override
            protected final Object2ObjectMap.Entry<K, V> get(int location) {
                return new AbstractObject2ObjectMap.BasicEntry<Object, Object>(Object2ObjectArrayMap.this.key[location], Object2ObjectArrayMap.this.value[location]);
            }

            protected final org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap$EntrySet.EntrySetSpliterator makeForSplit(int pos, int maxPos) {
                return new EntrySetSpliterator(pos, maxPos);
            }
        }
    }

    private final class KeySet
    extends AbstractObjectSet<K> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object k) {
            return Object2ObjectArrayMap.this.findKey(k) != -1;
        }

        @Override
        public boolean remove(Object k) {
            int oldPos = Object2ObjectArrayMap.this.findKey(k);
            if (oldPos == -1) {
                return false;
            }
            int tail = Object2ObjectArrayMap.this.size - oldPos - 1;
            System.arraycopy(Object2ObjectArrayMap.this.key, oldPos + 1, Object2ObjectArrayMap.this.key, oldPos, tail);
            System.arraycopy(Object2ObjectArrayMap.this.value, oldPos + 1, Object2ObjectArrayMap.this.value, oldPos, tail);
            Object2ObjectArrayMap.this.size--;
            ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).key[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
            ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).value[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
            return true;
        }

        @Override
        public ObjectIterator<K> iterator() {
            return new ObjectIterator<K>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < Object2ObjectArrayMap.this.size;
                }

                @Override
                public K next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return Object2ObjectArrayMap.this.key[this.pos++];
                }

                @Override
                public void remove() {
                    if (this.pos == 0) {
                        throw new IllegalStateException();
                    }
                    int tail = Object2ObjectArrayMap.this.size - this.pos;
                    System.arraycopy(Object2ObjectArrayMap.this.key, this.pos, Object2ObjectArrayMap.this.key, this.pos - 1, tail);
                    System.arraycopy(Object2ObjectArrayMap.this.value, this.pos, Object2ObjectArrayMap.this.value, this.pos - 1, tail);
                    Object2ObjectArrayMap.this.size--;
                    --this.pos;
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).key[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).value[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                }

                @Override
                public void forEachRemaining(Consumer<? super K> action2) {
                    int max = Object2ObjectArrayMap.this.size;
                    while (this.pos < max) {
                        action2.accept(Object2ObjectArrayMap.this.key[this.pos++]);
                    }
                }
            };
        }

        @Override
        public ObjectSpliterator<K> spliterator() {
            return new KeySetSpliterator(0, Object2ObjectArrayMap.this.size);
        }

        @Override
        public void forEach(Consumer<? super K> action2) {
            int max = Object2ObjectArrayMap.this.size;
            for (int i2 = 0; i2 < max; ++i2) {
                action2.accept(Object2ObjectArrayMap.this.key[i2]);
            }
        }

        @Override
        public int size() {
            return Object2ObjectArrayMap.this.size;
        }

        @Override
        public void clear() {
            Object2ObjectArrayMap.this.clear();
        }

        final class KeySetSpliterator
        extends ObjectSpliterators.EarlyBindingSizeIndexBasedSpliterator<K>
        implements ObjectSpliterator<K> {
            KeySetSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            public int characteristics() {
                return 16465;
            }

            @Override
            protected final K get(int location) {
                return Object2ObjectArrayMap.this.key[location];
            }

            protected final org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap$KeySet.KeySetSpliterator makeForSplit(int pos, int maxPos) {
                return new KeySetSpliterator(pos, maxPos);
            }

            @Override
            public void forEachRemaining(Consumer<? super K> action2) {
                int max = Object2ObjectArrayMap.this.size;
                while (this.pos < max) {
                    action2.accept(Object2ObjectArrayMap.this.key[this.pos++]);
                }
            }
        }
    }

    private final class ValuesCollection
    extends AbstractObjectCollection<V> {
        private ValuesCollection() {
        }

        @Override
        public boolean contains(Object v) {
            return Object2ObjectArrayMap.this.containsValue(v);
        }

        @Override
        public ObjectIterator<V> iterator() {
            return new ObjectIterator<V>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < Object2ObjectArrayMap.this.size;
                }

                @Override
                public V next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return Object2ObjectArrayMap.this.value[this.pos++];
                }

                @Override
                public void remove() {
                    if (this.pos == 0) {
                        throw new IllegalStateException();
                    }
                    int tail = Object2ObjectArrayMap.this.size - this.pos;
                    System.arraycopy(Object2ObjectArrayMap.this.key, this.pos, Object2ObjectArrayMap.this.key, this.pos - 1, tail);
                    System.arraycopy(Object2ObjectArrayMap.this.value, this.pos, Object2ObjectArrayMap.this.value, this.pos - 1, tail);
                    Object2ObjectArrayMap.this.size--;
                    --this.pos;
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).key[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                    ((Object2ObjectArrayMap)Object2ObjectArrayMap.this).value[((Object2ObjectArrayMap)Object2ObjectArrayMap.this).size] = null;
                }

                @Override
                public void forEachRemaining(Consumer<? super V> action2) {
                    int max = Object2ObjectArrayMap.this.size;
                    while (this.pos < max) {
                        action2.accept(Object2ObjectArrayMap.this.value[this.pos++]);
                    }
                }
            };
        }

        @Override
        public ObjectSpliterator<V> spliterator() {
            return new ValuesSpliterator(0, Object2ObjectArrayMap.this.size);
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            int max = Object2ObjectArrayMap.this.size;
            for (int i2 = 0; i2 < max; ++i2) {
                action2.accept(Object2ObjectArrayMap.this.value[i2]);
            }
        }

        @Override
        public int size() {
            return Object2ObjectArrayMap.this.size;
        }

        @Override
        public void clear() {
            Object2ObjectArrayMap.this.clear();
        }

        final class ValuesSpliterator
        extends ObjectSpliterators.EarlyBindingSizeIndexBasedSpliterator<V>
        implements ObjectSpliterator<V> {
            ValuesSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            public int characteristics() {
                return 16464;
            }

            @Override
            protected final V get(int location) {
                return Object2ObjectArrayMap.this.value[location];
            }

            protected final org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap$ValuesCollection.ValuesSpliterator makeForSplit(int pos, int maxPos) {
                return new ValuesSpliterator(pos, maxPos);
            }

            @Override
            public void forEachRemaining(Consumer<? super V> action2) {
                int max = Object2ObjectArrayMap.this.size;
                while (this.pos < max) {
                    action2.accept(Object2ObjectArrayMap.this.value[this.pos++]);
                }
            }
        }
    }
}

