/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.base.Function;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.AbstractIterator;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;
import org.jetbrains.kotlin.com.google.common.graph.ElementOrder;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.graph.EndpointPair;
import org.jetbrains.kotlin.com.google.common.graph.GraphConnections;
import org.jetbrains.kotlin.com.google.common.graph.Graphs;

@ElementTypesAreNonnullByDefault
final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    @CheckForNull
    private final List<NodeConnection<N>> orderedNodeConnections;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, Object> adjacentNodeValues, @CheckForNull List<NodeConnection<N>> orderedNodeConnections, int predecessorCount, int successorCount) {
        this.adjacentNodeValues = Preconditions.checkNotNull(adjacentNodeValues);
        this.orderedNodeConnections = orderedNodeConnections;
        this.predecessorCount = Graphs.checkNonNegative(predecessorCount);
        this.successorCount = Graphs.checkNonNegative(successorCount);
        Preconditions.checkState(predecessorCount <= adjacentNodeValues.size() && successorCount <= adjacentNodeValues.size());
    }

    static <N, V> DirectedGraphConnections<N, V> of(ElementOrder<N> incidentEdgeOrder) {
        ArrayList<NodeConnection<N>> orderedNodeConnections;
        int initialCapacity = 4;
        switch (incidentEdgeOrder.type()) {
            case UNORDERED: {
                orderedNodeConnections = null;
                break;
            }
            case STABLE: {
                orderedNodeConnections = new ArrayList<NodeConnection<N>>();
                break;
            }
            default: {
                throw new AssertionError((Object)incidentEdgeOrder.type());
            }
        }
        return new DirectedGraphConnections(new HashMap(initialCapacity, 1.0f), orderedNodeConnections, 0, 0);
    }

    static <N, V> DirectedGraphConnections<N, V> ofImmutable(N thisNode, Iterable<EndpointPair<N>> incidentEdges, Function<N, V> successorNodeToValueFn) {
        Preconditions.checkNotNull(thisNode);
        Preconditions.checkNotNull(successorNodeToValueFn);
        HashMap<N, Object> adjacentNodeValues = new HashMap<N, Object>();
        ImmutableList.Builder orderedNodeConnectionsBuilder = ImmutableList.builder();
        int predecessorCount = 0;
        int successorCount = 0;
        for (EndpointPair<N> incidentEdge : incidentEdges) {
            if (incidentEdge.nodeU().equals(thisNode) && incidentEdge.nodeV().equals(thisNode)) {
                adjacentNodeValues.put(thisNode, new PredAndSucc(successorNodeToValueFn.apply(thisNode)));
                orderedNodeConnectionsBuilder.add(new NodeConnection.Pred<N>(thisNode));
                orderedNodeConnectionsBuilder.add(new NodeConnection.Succ<N>(thisNode));
                ++predecessorCount;
                ++successorCount;
                continue;
            }
            if (incidentEdge.nodeV().equals(thisNode)) {
                N predecessor = incidentEdge.nodeU();
                Object existingValue = adjacentNodeValues.put(predecessor, PRED);
                if (existingValue != null) {
                    adjacentNodeValues.put(predecessor, new PredAndSucc(existingValue));
                }
                orderedNodeConnectionsBuilder.add(new NodeConnection.Pred<N>(predecessor));
                ++predecessorCount;
                continue;
            }
            Preconditions.checkArgument(incidentEdge.nodeU().equals(thisNode));
            N successor = incidentEdge.nodeV();
            V value2 = successorNodeToValueFn.apply(successor);
            V existingValue = adjacentNodeValues.put(successor, value2);
            if (existingValue != null) {
                Preconditions.checkArgument(existingValue == PRED);
                adjacentNodeValues.put(successor, new PredAndSucc(value2));
            }
            orderedNodeConnectionsBuilder.add(new NodeConnection.Succ<N>(successor));
            ++successorCount;
        }
        return new DirectedGraphConnections(adjacentNodeValues, orderedNodeConnectionsBuilder.build(), predecessorCount, successorCount);
    }

    @Override
    public Set<N> adjacentNodes() {
        if (this.orderedNodeConnections == null) {
            return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
        }
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                final Iterator nodeConnections = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                final HashSet seenNodes = new HashSet();
                return new AbstractIterator<N>(this){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (nodeConnections.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)nodeConnections.next();
                            boolean added = seenNodes.add(nodeConnection.node);
                            if (!added) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.adjacentNodeValues.size();
            }

            @Override
            public boolean contains(@CheckForNull Object obj2) {
                return DirectedGraphConnections.this.adjacentNodeValues.containsKey(obj2);
            }
        };
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                if (DirectedGraphConnections.this.orderedNodeConnections == null) {
                    final Iterator entries2 = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(this){

                        @Override
                        @CheckForNull
                        protected N computeNext() {
                            while (entries2.hasNext()) {
                                Map.Entry entry2 = (Map.Entry)entries2.next();
                                if (!DirectedGraphConnections.isPredecessor(entry2.getValue())) continue;
                                return entry2.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                final Iterator nodeConnections = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(this){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (nodeConnections.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)nodeConnections.next();
                            if (!(nodeConnection instanceof NodeConnection.Pred)) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.predecessorCount;
            }

            @Override
            public boolean contains(@CheckForNull Object obj2) {
                return DirectedGraphConnections.isPredecessor(DirectedGraphConnections.this.adjacentNodeValues.get(obj2));
            }
        };
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            @Override
            public UnmodifiableIterator<N> iterator() {
                if (DirectedGraphConnections.this.orderedNodeConnections == null) {
                    final Iterator entries2 = DirectedGraphConnections.this.adjacentNodeValues.entrySet().iterator();
                    return new AbstractIterator<N>(this){

                        @Override
                        @CheckForNull
                        protected N computeNext() {
                            while (entries2.hasNext()) {
                                Map.Entry entry2 = (Map.Entry)entries2.next();
                                if (!DirectedGraphConnections.isSuccessor(entry2.getValue())) continue;
                                return entry2.getKey();
                            }
                            return this.endOfData();
                        }
                    };
                }
                final Iterator nodeConnections = DirectedGraphConnections.this.orderedNodeConnections.iterator();
                return new AbstractIterator<N>(this){

                    @Override
                    @CheckForNull
                    protected N computeNext() {
                        while (nodeConnections.hasNext()) {
                            NodeConnection nodeConnection = (NodeConnection)nodeConnections.next();
                            if (!(nodeConnection instanceof NodeConnection.Succ)) continue;
                            return nodeConnection.node;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                return DirectedGraphConnections.this.successorCount;
            }

            @Override
            public boolean contains(@CheckForNull Object obj2) {
                return DirectedGraphConnections.isSuccessor(DirectedGraphConnections.this.adjacentNodeValues.get(obj2));
            }
        };
    }

    @Override
    public Iterator<EndpointPair<N>> incidentEdgeIterator(N thisNode) {
        Preconditions.checkNotNull(thisNode);
        final Iterator resultWithDoubleSelfLoop = this.orderedNodeConnections == null ? Iterators.concat(Iterators.transform(this.predecessors().iterator(), predecessor -> EndpointPair.ordered(predecessor, thisNode)), Iterators.transform(this.successors().iterator(), successor -> EndpointPair.ordered(thisNode, successor))) : Iterators.transform(this.orderedNodeConnections.iterator(), connection -> {
            if (connection instanceof NodeConnection.Succ) {
                return EndpointPair.ordered(thisNode, connection.node);
            }
            return EndpointPair.ordered(connection.node, thisNode);
        });
        final AtomicBoolean alreadySeenSelfLoop = new AtomicBoolean(false);
        return new AbstractIterator<EndpointPair<N>>(this){

            @Override
            @CheckForNull
            protected EndpointPair<N> computeNext() {
                while (resultWithDoubleSelfLoop.hasNext()) {
                    EndpointPair edge = (EndpointPair)resultWithDoubleSelfLoop.next();
                    if (edge.nodeU().equals(edge.nodeV())) {
                        if (alreadySeenSelfLoop.getAndSet(true)) continue;
                        return edge;
                    }
                    return edge;
                }
                return (EndpointPair)this.endOfData();
            }
        };
    }

    @Override
    @CheckForNull
    public V value(N node2) {
        Preconditions.checkNotNull(node2);
        Object value2 = this.adjacentNodeValues.get(node2);
        if (value2 == PRED) {
            return null;
        }
        if (value2 instanceof PredAndSucc) {
            return (V)((PredAndSucc)value2).successorValue;
        }
        return (V)value2;
    }

    @Override
    public void removePredecessor(N node2) {
        boolean removedPredecessor;
        Preconditions.checkNotNull(node2);
        Object previousValue = this.adjacentNodeValues.get(node2);
        if (previousValue == PRED) {
            this.adjacentNodeValues.remove(node2);
            removedPredecessor = true;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node2, ((PredAndSucc)previousValue).successorValue);
            removedPredecessor = true;
        } else {
            removedPredecessor = false;
        }
        if (removedPredecessor) {
            Graphs.checkNonNegative(--this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.remove(new NodeConnection.Pred<N>(node2));
            }
        }
    }

    @Override
    @CheckForNull
    public V removeSuccessor(Object node2) {
        Object removedValue;
        Preconditions.checkNotNull(node2);
        Object previousValue = this.adjacentNodeValues.get(node2);
        if (previousValue == null || previousValue == PRED) {
            removedValue = null;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node2, PRED);
            removedValue = ((PredAndSucc)previousValue).successorValue;
        } else {
            this.adjacentNodeValues.remove(node2);
            removedValue = previousValue;
        }
        if (removedValue != null) {
            Graphs.checkNonNegative(--this.successorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.remove(new NodeConnection.Succ<Object>(node2));
            }
        }
        return (V)(removedValue == null ? null : removedValue);
    }

    @Override
    public void addPredecessor(N node2, V unused2) {
        boolean addedPredecessor;
        Object previousValue = this.adjacentNodeValues.put(node2, PRED);
        if (previousValue == null) {
            addedPredecessor = true;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node2, previousValue);
            addedPredecessor = false;
        } else if (previousValue != PRED) {
            this.adjacentNodeValues.put(node2, new PredAndSucc(previousValue));
            addedPredecessor = true;
        } else {
            addedPredecessor = false;
        }
        if (addedPredecessor) {
            Graphs.checkPositive(++this.predecessorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Pred<N>(node2));
            }
        }
    }

    @Override
    @CheckForNull
    public V addSuccessor(N node2, V value2) {
        Object previousSuccessor;
        Object previousValue = this.adjacentNodeValues.put(node2, value2);
        if (previousValue == null) {
            previousSuccessor = null;
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node2, new PredAndSucc(value2));
            previousSuccessor = ((PredAndSucc)previousValue).successorValue;
        } else if (previousValue == PRED) {
            this.adjacentNodeValues.put(node2, new PredAndSucc(value2));
            previousSuccessor = null;
        } else {
            previousSuccessor = previousValue;
        }
        if (previousSuccessor == null) {
            Graphs.checkPositive(++this.successorCount);
            if (this.orderedNodeConnections != null) {
                this.orderedNodeConnections.add(new NodeConnection.Succ<N>(node2));
            }
        }
        return (V)(previousSuccessor == null ? null : previousSuccessor);
    }

    private static boolean isPredecessor(@CheckForNull Object value2) {
        return value2 == PRED || value2 instanceof PredAndSucc;
    }

    private static boolean isSuccessor(@CheckForNull Object value2) {
        return value2 != PRED && value2 != null;
    }

    private static abstract class NodeConnection<N> {
        final N node;

        NodeConnection(N node2) {
            this.node = Preconditions.checkNotNull(node2);
        }

        static final class Succ<N>
        extends NodeConnection<N> {
            Succ(N node2) {
                super(node2);
            }

            public boolean equals(@CheckForNull Object that) {
                if (that instanceof Succ) {
                    return this.node.equals(((Succ)that).node);
                }
                return false;
            }

            public int hashCode() {
                return Succ.class.hashCode() + this.node.hashCode();
            }
        }

        static final class Pred<N>
        extends NodeConnection<N> {
            Pred(N node2) {
                super(node2);
            }

            public boolean equals(@CheckForNull Object that) {
                if (that instanceof Pred) {
                    return this.node.equals(((Pred)that).node);
                }
                return false;
            }

            public int hashCode() {
                return Pred.class.hashCode() + this.node.hashCode();
            }
        }
    }

    private static final class PredAndSucc {
        private final Object successorValue;

        PredAndSucc(Object successorValue) {
            this.successorValue = successorValue;
        }
    }
}

