/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Converter;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.primitives.IntsMethodsForWeb;
import org.jetbrains.kotlin.com.google.common.primitives.Longs;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Ints
extends IntsMethodsForWeb {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static int hashCode(int value2) {
        return value2;
    }

    public static int checkedCast(long value2) {
        int result2 = (int)value2;
        Preconditions.checkArgument((long)result2 == value2, "Out of range: %s", value2);
        return result2;
    }

    public static int saturatedCast(long value2) {
        if (value2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value2;
    }

    public static int compare(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static boolean contains(int[] array2, int target2) {
        for (int value2 : array2) {
            if (value2 != target2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] array2, int target2) {
        return Ints.indexOf(array2, target2, 0, array2.length);
    }

    private static int indexOf(int[] array2, int target2, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(int[] array2, int[] target2) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target2, "target");
        if (target2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target2.length + 1; ++i2) {
            for (int j = 0; j < target2.length; ++j) {
                if (array2[i2 + j] != target2[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array2, int target2) {
        return Ints.lastIndexOf(array2, target2, 0, array2.length);
    }

    private static int lastIndexOf(int[] array2, int target2, int start2, int end) {
        for (int i2 = end - 1; i2 >= start2; --i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int min(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min) continue;
            min = array2[i2];
        }
        return min;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int max(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] <= max) continue;
            max = array2[i2];
        }
        return max;
    }

    public static int constrainToRange(int value2, int min, int max) {
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        return Math.min(Math.max(value2, min), max);
    }

    public static int[] concat(int[] ... arrays) {
        int length = 0;
        for (int[] array2 : arrays) {
            length += array2.length;
        }
        int[] result2 = new int[length];
        int pos = 0;
        for (int[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    public static byte[] toByteArray(int value2) {
        return new byte[]{(byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2};
    }

    public static int fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 4, "array too small: %s < %s", bytes.length, 4);
        return Ints.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static Converter<String, Integer> stringConverter() {
        return IntConverter.INSTANCE;
    }

    public static int[] ensureCapacity(int[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, int ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(array2[i2]);
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(int[] array2) {
        Preconditions.checkNotNull(array2);
        Ints.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Ints.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(int[] array2) {
        Preconditions.checkNotNull(array2);
        Ints.reverse(array2, 0, array2.length);
    }

    public static void reverse(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j = toIndex - 1; i2 < j; ++i2, --j) {
            int tmp = array2[i2];
            array2[i2] = array2[j];
            array2[j] = tmp;
        }
    }

    public static void rotate(int[] array2, int distance) {
        Ints.rotate(array2, distance, 0, array2.length);
    }

    public static void rotate(int[] array2, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m = -distance % length;
        m = m < 0 ? m + length : m;
        int newFirstIndex = m + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Ints.reverse(array2, fromIndex, newFirstIndex);
        Ints.reverse(array2, newFirstIndex, toIndex);
        Ints.reverse(array2, fromIndex, toIndex);
    }

    public static int[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof IntArrayAsList) {
            return ((IntArrayAsList)collection).toIntArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        int[] array2 = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = ((Number)Preconditions.checkNotNull(boxedArray[i2])).intValue();
        }
        return array2;
    }

    public static List<Integer> asList(int ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(backingArray);
    }

    @CheckForNull
    public static Integer tryParse(String string2) {
        return Ints.tryParse(string2, 10);
    }

    @CheckForNull
    public static Integer tryParse(String string2, int radix) {
        Long result2 = Longs.tryParse(string2, radix);
        if (result2 == null || result2 != (long)result2.intValue()) {
            return null;
        }
        return result2.intValue();
    }

    @GwtCompatible
    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements RandomAccess,
    Serializable {
        final int[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        IntArrayAsList(int[] array2) {
            this(array2, 0, array2.length);
        }

        IntArrayAsList(int[] array2, int start2, int end) {
            this.array = array2;
            this.start = start2;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Integer get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        public Spliterator.OfInt spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(@CheckForNull Object target2) {
            return target2 instanceof Integer && Ints.indexOf(this.array, (Integer)target2, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Integer && (i2 = Ints.indexOf(this.array, (Integer)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Integer && (i2 = Ints.lastIndexOf(this.array, (Integer)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Integer set(int index, Integer element) {
            Preconditions.checkElementIndex(index, this.size());
            int oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList that = (IntArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Ints.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        int[] toIntArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left, int[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Ints.compare(left[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Ints.lexicographicalComparator()";
        }
    }

    private static final class IntConverter
    extends Converter<String, Integer>
    implements Serializable {
        static final Converter<String, Integer> INSTANCE = new IntConverter();
        private static final long serialVersionUID = 1L;

        private IntConverter() {
        }

        @Override
        protected Integer doForward(String value2) {
            return Integer.decode(value2);
        }

        @Override
        protected String doBackward(Integer value2) {
            return value2.toString();
        }

        public String toString() {
            return "Ints.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

