/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.system;

import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.jna.JnaLoader;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;

public enum CpuArch {
    X86(32),
    X86_64(64),
    ARM32(32),
    ARM64(64),
    OTHER(0),
    UNKNOWN(0);

    public final int width;
    public static final CpuArch CURRENT;
    @Nullable
    private static Boolean ourEmulated;

    private CpuArch(int width) {
        if (width == 0) {
            try {
                width = Integer.parseInt(System.getProperty("sun.arch.data.model", "32"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.width = width;
    }

    @NotNull
    public static CpuArch fromString(@Nullable String arch) {
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            CpuArch cpuArch = X86_64;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(0);
            }
            return cpuArch;
        }
        if ("i386".equals(arch) || "x86".equals(arch)) {
            CpuArch cpuArch = X86;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(1);
            }
            return cpuArch;
        }
        if ("aarch64".equals(arch) || "arm64".equals(arch)) {
            CpuArch cpuArch = ARM64;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(2);
            }
            return cpuArch;
        }
        CpuArch cpuArch = arch == null || arch.trim().isEmpty() ? UNKNOWN : OTHER;
        if (cpuArch == null) {
            CpuArch.$$$reportNull$$$0(3);
        }
        return cpuArch;
    }

    public static boolean isIntel32() {
        return CURRENT == X86;
    }

    public static boolean isIntel64() {
        return CURRENT == X86_64;
    }

    public static boolean isArm32() {
        return CURRENT == ARM32;
    }

    public static boolean isArm64() {
        return CURRENT == ARM64;
    }

    public static boolean is32Bit() {
        return CpuArch.CURRENT.width == 32;
    }

    public static boolean isEmulated() {
        if (ourEmulated == null) {
            ourEmulated = CURRENT == X86_64 ? Boolean.valueOf(SystemInfoRt.isMac && CpuArch.isUnderRosetta() || SystemInfoRt.isWindows && !CpuArch.matchesWindowsNativeArch()) : (CURRENT == X86 ? Boolean.valueOf(SystemInfoRt.isWindows && !CpuArch.matchesWindowsNativeArch()) : Boolean.FALSE);
        }
        return ourEmulated == Boolean.TRUE;
    }

    private static boolean isUnderRosetta() {
        try {
            if (JnaLoader.isLoaded()) {
                IntByReference p = new IntByReference();
                LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference((long)SystemB.INT_SIZE);
                if (SystemB.INSTANCE.sysctlbyname("sysctl.proc_translated", p.getPointer(), size, null, LibCAPI.size_t.ZERO) != -1) {
                    return p.getValue() == 1;
                }
            }
        }
        catch (Throwable t) {
            Logger.getInstance(CpuArch.class).error(t);
        }
        return false;
    }

    private static boolean matchesWindowsNativeArch() {
        try {
            if (JnaLoader.isLoaded()) {
                WinBase.SYSTEM_INFO systemInfo = new WinBase.SYSTEM_INFO();
                Kernel32.INSTANCE.GetNativeSystemInfo(systemInfo);
                int arch = systemInfo.processorArchitecture.dwOemID.getLow().intValue();
                if (arch == 0) {
                    return CURRENT == X86;
                }
                if (arch == 9) {
                    return CURRENT == X86_64;
                }
                if (arch == 12) {
                    return CURRENT == ARM64;
                }
            }
        }
        catch (Throwable t) {
            Logger.getInstance(CpuArch.class).error(t);
        }
        return true;
    }

    static {
        CURRENT = CpuArch.fromString(System.getProperty("os.arch"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/system/CpuArch", "fromString"));
    }
}

