/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.internal.compilerRunner.native;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.buildtools.internal.ClassLoaderUtilsKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerArgumentsLogLevel;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;
import org.jetbrains.kotlin.gradle.internal.ParentClassLoaderProvider;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusService;
import org.jetbrains.kotlin.gradle.plugin.statistics.NativeArgumentMetrics;
import org.jetbrains.kotlin.internal.compilerRunner.native.KotlinNativeToolRunner;
import org.jetbrains.kotlin.konan.target.HostManager;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002+,BM\b\u0007\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020 H\u0002J0\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0#0\"*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0#0\"H\u0002J\f\u0010$\u001a\u00020%*\u00020%H\u0002J\f\u0010&\u001a\u00020'*\u00020\u001cH\u0002J\f\u0010(\u001a\u00020 *\u00020 H\u0002J\u0012\u0010(\u001a\u00020 *\b\u0012\u0004\u0012\u00020 0)H\u0002J\u0018\u0010(\u001a\u00020 *\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0*H\u0002R\u0014\u0010\u0010\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0016\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006 \u0015*\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner;", "", "metricsReporterProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "classLoadersCachingBuildServiceProvider", "Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "toolSpec", "Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolSpec;", "fusMetricsConsumer", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolSpec;Lorg/gradle/api/provider/Provider;Lorg/gradle/process/ExecOperations;)V", "classLoadersCachingBuildService", "getClassLoadersCachingBuildService", "()Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "metricsReporter", "getMetricsReporter", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "runInProcess", "", "args", "Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolArguments;", "runTool", "runViaExec", "escapeQuotes", "", "escapeQuotesForWindows", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "snapshot", "Ljava/util/Properties;", "toArgFile", "Ljava/nio/file/Path;", "toPrettyString", "", "", "ToolArguments", "ToolSpec", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinNativeToolRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNativeToolRunner.kt\norg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,257:1\n31#2,5:258\n31#2,3:263\n35#2:270\n31#2,3:271\n31#2,3:289\n35#2:296\n35#2:297\n1557#3:266\n1628#3,3:267\n1557#3:274\n1628#3,3:275\n1863#3,2:298\n1863#3,2:300\n1863#3,2:304\n3170#4,11:278\n37#5:292\n36#5,3:293\n1088#6,2:302\n*S KotlinDebug\n*F\n+ 1 KotlinNativeToolRunner.kt\norg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner\n*L\n47#1:258,5\n60#1:263,3\n60#1:270\n116#1:271,3\n150#1:289,3\n150#1:296\n116#1:297\n88#1:266\n88#1:267,3\n137#1:274\n137#1:275,3\n169#1:298,2\n178#1:300,2\n196#1:304,2\n147#1:278,11\n151#1:292\n151#1:293,3\n185#1:302,2\n*E\n"})
public abstract class KotlinNativeToolRunner {
    @NotNull
    private final Provider<BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>> metricsReporterProvider;
    @NotNull
    private final Provider<ClassLoadersCachingBuildService> classLoadersCachingBuildServiceProvider;
    @NotNull
    private final ToolSpec toolSpec;
    @NotNull
    private final Provider<BuildFusService> fusMetricsConsumer;
    @NotNull
    private final ExecOperations execOperations;
    private final Logger logger;

    @Inject
    public KotlinNativeToolRunner(@NotNull Provider<BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>> metricsReporterProvider, @NotNull Provider<ClassLoadersCachingBuildService> classLoadersCachingBuildServiceProvider, @NotNull ToolSpec toolSpec, @NotNull Provider<BuildFusService> fusMetricsConsumer, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter(metricsReporterProvider, (String)"metricsReporterProvider");
        Intrinsics.checkNotNullParameter(classLoadersCachingBuildServiceProvider, (String)"classLoadersCachingBuildServiceProvider");
        Intrinsics.checkNotNullParameter((Object)toolSpec, (String)"toolSpec");
        Intrinsics.checkNotNullParameter(fusMetricsConsumer, (String)"fusMetricsConsumer");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.metricsReporterProvider = metricsReporterProvider;
        this.classLoadersCachingBuildServiceProvider = classLoadersCachingBuildServiceProvider;
        this.toolSpec = toolSpec;
        this.fusMetricsConsumer = fusMetricsConsumer;
        this.execOperations = execOperations;
        this.logger = Logging.getLogger((String)((String)this.toolSpec.getDisplayName().get()));
    }

    private final ClassLoadersCachingBuildService getClassLoadersCachingBuildService() {
        Object object = this.classLoadersCachingBuildServiceProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classLoadersCachingBuildServiceProvider.get()");
        return (ClassLoadersCachingBuildService)object;
    }

    private final BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> getMetricsReporter() {
        return (BuildMetricsReporter)this.metricsReporterProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void runTool(@NotNull ToolArguments args2) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter = this.getMetricsReporter();
        Intrinsics.checkNotNullExpressionValue(buildMetricsReporter, (String)"metricsReporter");
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter2 = buildMetricsReporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.RUN_COMPILATION_IN_WORKER;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            BuildFusService buildFusService = (BuildFusService)this.fusMetricsConsumer.getOrNull();
            if (buildFusService != null) {
                BuildFusService metricsConsumer = buildFusService;
                boolean bl2 = false;
                NativeArgumentMetrics.INSTANCE.collectMetrics(args2.getArguments(), metricsConsumer.getFusMetricsConsumer$kotlin_gradle_plugin_common());
            }
            if (args2.getShouldRunInProcessMode()) {
                this.runInProcess(args2);
            } else {
                this.runViaExec(args2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void runViaExec(ToolArguments args2) {
        void $this$measure$iv;
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter = this.getMetricsReporter();
        Intrinsics.checkNotNullExpressionValue(buildMetricsReporter, (String)"metricsReporter");
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter2 = buildMetricsReporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.NATIVE_IN_EXECUTOR;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            ExecResult execResult;
            Pair pair;
            Iterable<Path> argFile;
            boolean bl = false;
            Properties properties2 = System.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"getProperties()");
            Map systemProperties2 = MapsKt.plus((Map)MapsKt.toMap(this.escapeQuotesForWindows((Sequence<Pair<String, String>>)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)this.snapshot(properties2)), (Function1)runViaExec.1.systemProperties.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(this){
                final /* synthetic */ KotlinNativeToolRunner this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(Pair<String, String> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    String k = (String)pair.component1();
                    return !KotlinNativeToolRunner.access$getToolSpec$p(this.this$0).getSystemPropertiesBlacklist().contains(k);
                }
            })))), this.toolSpec.getSystemProperties());
            Object object = this.toolSpec.getShouldPassArgumentsViaArgFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toolSpec.shouldPassArgumentsViaArgFile.get()");
            if (((Boolean)object).booleanValue()) {
                argFile = this.toArgFile(args2);
                Object[] objectArray = new String[]{this.toolSpec.getOptionalToolName().getOrNull(), '@' + argFile.toFile().getAbsolutePath()};
                pair = TuplesKt.to((Object)argFile, (Object)CollectionsKt.listOfNotNull((Object[])objectArray));
            } else {
                pair = TuplesKt.to(null, (Object)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.toolSpec.getOptionalToolName().getOrNull()), (Iterable)args2.getArguments()));
            }
            Pair toolArgsPair = pair;
            try {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LogLevel logLevel = GradleLoggingUtilsKt.getGradleLogLevel(args2.getCompilerArgumentsLogLevel());
                StringBuilder stringBuilder = new StringBuilder().append("\n                |Run \"").append((String)this.toolSpec.getDisplayName().get()).append("\" tool in a separate JVM process\n                |Main class = ").append((String)this.toolSpec.getMainClass().get()).append("\n                |Arguments = ").append(this.toPrettyString((Collection<String>)args2.getArguments())).append("\n                |Transformed arguments = ").append(this.toPrettyString((Collection)toolArgsPair.getSecond())).append("\n                |Classpath = ");
                Set set2 = this.toolSpec.getClasspath().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"toolSpec.classpath.files");
                argFile = set2;
                KotlinNativeToolRunner kotlinNativeToolRunner = this;
                StringBuilder stringBuilder2 = stringBuilder;
                LogLevel logLevel2 = logLevel;
                Logger logger = this.logger;
                boolean $i$f$map = false;
                void var14_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getAbsolutePath());
                }
                collection = (List)destination$iv$iv;
                StringBuilder stringBuilder3 = stringBuilder2.append(kotlinNativeToolRunner.toPrettyString(collection)).append("\n                |JVM options = ");
                Object object2 = this.toolSpec.getJvmArgs().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toolSpec.jvmArgs.get()");
                logger.log(logLevel2, StringsKt.trimMargin$default((String)stringBuilder3.append(this.toPrettyString((Collection)object2)).append("\n                |Java system properties = ").append(this.toPrettyString(systemProperties2)).append("\n                |Suppressed ENV variables = ").append(this.toPrettyString((Collection<String>)this.toolSpec.getEnvironmentBlacklist())).append("\n                |Custom ENV variables = ").append(this.toPrettyString(this.toolSpec.getEnvironment())).append("\n                ").toString(), null, (int)1, null));
                execResult = this.execOperations.javaexec(new Action(this, systemProperties2, (Pair<? extends Path, ? extends List<String>>)toolArgsPair){
                    final /* synthetic */ KotlinNativeToolRunner this$0;
                    final /* synthetic */ Map<String, String> $systemProperties;
                    final /* synthetic */ Pair<Path, List<String>> $toolArgsPair;
                    {
                        this.this$0 = $receiver;
                        this.$systemProperties = $systemProperties;
                        this.$toolArgsPair = $toolArgsPair;
                    }

                    public final void execute(JavaExecSpec spec) {
                        spec.getMainClass().set(KotlinNativeToolRunner.access$getToolSpec$p(this.this$0).getMainClass());
                        spec.setClasspath(KotlinNativeToolRunner.access$getToolSpec$p(this.this$0).getClasspath());
                        spec.jvmArgs((Iterable)KotlinNativeToolRunner.access$getToolSpec$p(this.this$0).getJvmArgs().get());
                        spec.systemProperties(this.$systemProperties);
                        spec.environment(KotlinNativeToolRunner.access$getToolSpec$p(this.this$0).getEnvironment());
                        Iterable $this$forEach$iv = KotlinNativeToolRunner.access$getToolSpec$p(this.this$0).getEnvironmentBlacklist();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            spec.getEnvironment().remove(it);
                        }
                        spec.args((Iterable)this.$toolArgsPair.getSecond());
                    }
                });
            }
            finally {
                Path path = (Path)toolArgsPair.getFirst();
                if (path != null) {
                    Object object3;
                    Path it = path;
                    boolean bl3 = false;
                    try {
                        object3 = Files.deleteIfExists(it);
                    }
                    catch (IOException _) {
                        object3 = Unit.INSTANCE;
                    }
                }
            }
            ExecResult execResult2 = execResult;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void runInProcess(ToolArguments args2) {
        void $this$measure$iv;
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter = this.getMetricsReporter();
        Intrinsics.checkNotNullExpressionValue(buildMetricsReporter, (String)"metricsReporter");
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter2 = buildMetricsReporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.NATIVE_IN_PROCESS;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            Object object;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            ClassLoadersCachingBuildService classLoadersCachingBuildService = this.getClassLoadersCachingBuildService();
            Set set2 = this.toolSpec.getClasspath().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"toolSpec.classpath.files");
            ClassLoader isolatedClassLoader2 = classLoadersCachingBuildService.getClassLoader(CollectionsKt.toList((Iterable)set2), new ParentClassLoaderProvider(){
                private final ClassLoader jdkClassesClassLoader;
                {
                    this.jdkClassesClassLoader = ClassLoaderUtilsKt.getJdkClassesClassLoader();
                }

                private static /* synthetic */ void getJdkClassesClassLoader$annotations() {
                }

                public ClassLoader getClassLoader() {
                    return this.jdkClassesClassLoader;
                }

                public int hashCode() {
                    ClassLoader classLoader = this.jdkClassesClassLoader;
                    return classLoader != null ? classLoader.hashCode() : 0;
                }

                public boolean equals(Object other) {
                    return other instanceof ParentClassLoaderProvider && Intrinsics.areEqual((Object)((ParentClassLoaderProvider)other).getClassLoader(), (Object)this.jdkClassesClassLoader);
                }
            });
            if (((List)this.toolSpec.getJvmArgs().get()).contains("-ea")) {
                isolatedClassLoader2.setDefaultAssertionStatus(true);
            }
            LogLevel logLevel = GradleLoggingUtilsKt.getGradleLogLevel(args2.getCompilerArgumentsLogLevel());
            StringBuilder stringBuilder = new StringBuilder().append("\n                |Run in-process tool \"").append((String)this.toolSpec.getDisplayName().get()).append("\"\n                |Entry point method = ").append((String)this.toolSpec.getMainClass().get()).append('.').append((String)this.toolSpec.getDaemonEntryPoint().get()).append("\n                |Classpath = ");
            Set set3 = this.toolSpec.getClasspath().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"toolSpec.classpath.files");
            Iterable iterable = set3;
            KotlinNativeToolRunner kotlinNativeToolRunner = this;
            StringBuilder stringBuilder2 = stringBuilder;
            LogLevel logLevel2 = logLevel;
            Logger logger = this.logger;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> destination$iv$iv = (BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                int n = 0;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            logger.log(logLevel2, StringsKt.trimMargin$default((String)stringBuilder2.append(kotlinNativeToolRunner.toPrettyString(collection)).append("\n                |Arguments = ").append(this.toPrettyString((Collection<String>)args2.getArguments())).append("\n                ").toString(), null, (int)1, null));
            List toolArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.toolSpec.getDisplayName().get()), (Iterable)args2.getArguments());
            try {
                Object object2;
                void $this$measure$iv2;
                Object v7;
                block13: {
                    void $this$singleOrNull$iv;
                    Class<?> mainClass = isolatedClassLoader2.loadClass((String)this.toolSpec.getMainClass().get());
                    Method[] methodArray = mainClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"mainClass\n                    .methods");
                    Object[] $i$f$mapTo2 = methodArray;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (void element$iv : $this$singleOrNull$iv) {
                        Method it = (Method)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.toolSpec.getDaemonEntryPoint().get())) continue;
                        if (found$iv) {
                            v7 = null;
                            break block13;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v7 = !found$iv ? null : single$iv;
                }
                Method method = v7;
                if (method == null) {
                    throw new IllegalStateException(("Couldn't find daemon entry point '" + (String)this.toolSpec.getDaemonEntryPoint().get() + '\'').toString());
                }
                Method entryPoint = method;
                BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter3 = this.getMetricsReporter();
                Intrinsics.checkNotNullExpressionValue(buildMetricsReporter3, (String)"metricsReporter");
                destination$iv$iv = buildMetricsReporter3;
                BuildTime time$iv2 = (BuildTime)GradleBuildTime.RUN_ENTRY_POINT;
                boolean $i$f$measure2 = false;
                $this$measure$iv2.startMeasure(time$iv2);
                try {
                    boolean bl3 = false;
                    Object[] objectArray = new Object[1];
                    Collection $this$toTypedArray$iv = toolArgs;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    objectArray[0] = thisCollection$iv.toArray(new String[0]);
                    object2 = entryPoint.invoke(null, objectArray);
                }
                finally {
                    $this$measure$iv2.endMeasure(time$iv2);
                }
                object = object2;
            }
            catch (InvocationTargetException t) {
                Throwable throwable = t.getTargetException();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"t.targetException");
                throw throwable;
            }
            Object object3 = object;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    private final Properties snapshot(Properties $this$snapshot) {
        Object object = $this$snapshot.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Properties");
        return (Properties)object;
    }

    private final Sequence<Pair<String, String>> escapeQuotesForWindows(Sequence<Pair<String, String>> $this$escapeQuotesForWindows) {
        return HostManager.Companion.getHostIsMingw() ? SequencesKt.map($this$escapeQuotesForWindows, (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Pair<? extends String, ? extends String>>(this){
            final /* synthetic */ KotlinNativeToolRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Pair<String, String> invoke(Pair<String, String> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                String key = (String)pair.component1();
                String value2 = (String)pair.component2();
                return TuplesKt.to((Object)KotlinNativeToolRunner.access$escapeQuotes(this.this$0, key), (Object)KotlinNativeToolRunner.access$escapeQuotes(this.this$0, value2));
            }
        })) : $this$escapeQuotesForWindows;
    }

    private final String escapeQuotes(String $this$escapeQuotes) {
        return StringsKt.replace$default((String)$this$escapeQuotes, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
    }

    private final String toPrettyString(Map<String, String> $this$toPrettyString) {
        StringBuilder stringBuilder;
        StringBuilder $this$toPrettyString_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toPrettyString_u24lambda_u2410.append('[');
        if (!$this$toPrettyString.isEmpty()) {
            $this$toPrettyString_u24lambda_u2410.append('\n');
        }
        Iterable $this$forEach$iv = $this$toPrettyString.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            String value2 = (String)entry2.getValue();
            $this$toPrettyString_u24lambda_u2410.append('\t').append(key).append(" = ").append(this.toPrettyString(value2)).append('\n');
        }
        $this$toPrettyString_u24lambda_u2410.append(']');
        return stringBuilder.toString();
    }

    private final String toPrettyString(Collection<String> $this$toPrettyString) {
        StringBuilder stringBuilder;
        StringBuilder $this$toPrettyString_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toPrettyString_u24lambda_u2412.append('[');
        if (!$this$toPrettyString.isEmpty()) {
            $this$toPrettyString_u24lambda_u2412.append('\n');
        }
        Iterable $this$forEach$iv = $this$toPrettyString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$toPrettyString_u24lambda_u2412.append('\t').append(this.toPrettyString(it)).append('\n');
        }
        $this$toPrettyString_u24lambda_u2412.append(']');
        return stringBuilder.toString();
    }

    private final String toPrettyString(String $this$toPrettyString) {
        String string2;
        if (((CharSequence)$this$toPrettyString).length() == 0) {
            string2 = "\"\"";
        } else {
            boolean bl;
            block5: {
                CharSequence $this$any$iv = $this$toPrettyString;
                boolean $i$f$any = false;
                for (int j = 0; j < $this$any$iv.length(); ++j) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(j);
                    boolean bl2 = false;
                    if (!(it == '\"' || CharsKt.isWhitespace((char)it))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                char c = '\"';
                String string3 = StringUtil.escapeStringCharacters($this$toPrettyString);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"escapeStringCharacters(this)");
                String string4 = string3;
                string2 = stringBuilder.append(c + string4).append('\"').toString();
            } else {
                string2 = $this$toPrettyString;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path toArgFile(ToolArguments $this$toArgFile) {
        Path argFile = Files.createTempFile("kotlinc-native-args", ".lst", new FileAttribute[0]);
        File file2 = argFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"argFile.toFile()");
        Object object = file2;
        Object object2 = Charsets.UTF_8;
        File file3 = object;
        int n = 8192;
        Object object3 = file3;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter w = (PrintWriter)object;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$toArgFile.getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String arg2 = (String)element$iv;
                boolean bl2 = false;
                String escapedArg = StringsKt.replace$default((String)StringsKt.replace$default((String)arg2, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
                w.println('\"' + escapedArg + '\"');
            }
            file3 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)argFile, (String)"argFile");
        return argFile;
    }

    public static final /* synthetic */ String access$escapeQuotes(KotlinNativeToolRunner $this, String $receiver) {
        return $this.escapeQuotes($receiver);
    }

    public static final /* synthetic */ ToolSpec access$getToolSpec$p(KotlinNativeToolRunner $this) {
        return $this.toolSpec;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolArguments;", "", "shouldRunInProcessMode", "", "compilerArgumentsLogLevel", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;", "arguments", "", "", "(ZLorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;Ljava/util/List;)V", "getArguments", "()Ljava/util/List;", "getCompilerArgumentsLogLevel", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;", "getShouldRunInProcessMode", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    public static final class ToolArguments {
        private final boolean shouldRunInProcessMode;
        @NotNull
        private final KotlinCompilerArgumentsLogLevel compilerArgumentsLogLevel;
        @NotNull
        private final List<String> arguments;

        public ToolArguments(boolean shouldRunInProcessMode, @NotNull KotlinCompilerArgumentsLogLevel compilerArgumentsLogLevel, @NotNull List<String> arguments) {
            Intrinsics.checkNotNullParameter((Object)((Object)compilerArgumentsLogLevel), (String)"compilerArgumentsLogLevel");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            this.shouldRunInProcessMode = shouldRunInProcessMode;
            this.compilerArgumentsLogLevel = compilerArgumentsLogLevel;
            this.arguments = arguments;
        }

        public final boolean getShouldRunInProcessMode() {
            return this.shouldRunInProcessMode;
        }

        @NotNull
        public final KotlinCompilerArgumentsLogLevel getCompilerArgumentsLogLevel() {
            return this.compilerArgumentsLogLevel;
        }

        @NotNull
        public final List<String> getArguments() {
            return this.arguments;
        }

        public final boolean component1() {
            return this.shouldRunInProcessMode;
        }

        @NotNull
        public final KotlinCompilerArgumentsLogLevel component2() {
            return this.compilerArgumentsLogLevel;
        }

        @NotNull
        public final List<String> component3() {
            return this.arguments;
        }

        @NotNull
        public final ToolArguments copy(boolean shouldRunInProcessMode, @NotNull KotlinCompilerArgumentsLogLevel compilerArgumentsLogLevel, @NotNull List<String> arguments) {
            Intrinsics.checkNotNullParameter((Object)((Object)compilerArgumentsLogLevel), (String)"compilerArgumentsLogLevel");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            return new ToolArguments(shouldRunInProcessMode, compilerArgumentsLogLevel, arguments);
        }

        public static /* synthetic */ ToolArguments copy$default(ToolArguments toolArguments, boolean bl, KotlinCompilerArgumentsLogLevel kotlinCompilerArgumentsLogLevel2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = toolArguments.shouldRunInProcessMode;
            }
            if ((n & 2) != 0) {
                kotlinCompilerArgumentsLogLevel2 = toolArguments.compilerArgumentsLogLevel;
            }
            if ((n & 4) != 0) {
                list = toolArguments.arguments;
            }
            return toolArguments.copy(bl, kotlinCompilerArgumentsLogLevel2, list);
        }

        @NotNull
        public String toString() {
            return "ToolArguments(shouldRunInProcessMode=" + this.shouldRunInProcessMode + ", compilerArgumentsLogLevel=" + (Object)((Object)this.compilerArgumentsLogLevel) + ", arguments=" + this.arguments + ')';
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.shouldRunInProcessMode);
            result2 = result2 * 31 + this.compilerArgumentsLogLevel.hashCode();
            result2 = result2 * 31 + ((Object)this.arguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolArguments)) {
                return false;
            }
            ToolArguments toolArguments = (ToolArguments)other;
            if (this.shouldRunInProcessMode != toolArguments.shouldRunInProcessMode) {
                return false;
            }
            if (this.compilerArgumentsLogLevel != toolArguments.compilerArgumentsLogLevel) {
                return false;
            }
            return Intrinsics.areEqual(this.arguments, toolArguments.arguments);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u009d\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u0012\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolSpec;", "", "displayName", "Lorg/gradle/api/provider/Provider;", "", "optionalToolName", "mainClass", "daemonEntryPoint", "classpath", "Lorg/gradle/api/file/FileCollection;", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "shouldPassArgumentsViaArgFile", "", "systemProperties", "", "environment", "environmentBlacklist", "", "(Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/ListProperty;Lorg/gradle/api/provider/Provider;Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;)V", "getClasspath", "()Lorg/gradle/api/file/FileCollection;", "getDaemonEntryPoint", "()Lorg/gradle/api/provider/Provider;", "getDisplayName", "getEnvironment", "()Ljava/util/Map;", "getEnvironmentBlacklist", "()Ljava/util/Set;", "getJvmArgs", "()Lorg/gradle/api/provider/ListProperty;", "getMainClass", "getOptionalToolName", "getShouldPassArgumentsViaArgFile", "getSystemProperties", "systemPropertiesBlacklist", "getSystemPropertiesBlacklist", "configureDefaultMaxHeapSize", "disableC2", "enableAssertions", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinNativeToolRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNativeToolRunner.kt\norg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n2632#2,3:258\n*S KotlinDebug\n*F\n+ 1 KotlinNativeToolRunner.kt\norg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner$ToolSpec\n*L\n243#1:258,3\n*E\n"})
    public static final class ToolSpec {
        @NotNull
        private final Provider<String> displayName;
        @NotNull
        private final Provider<String> optionalToolName;
        @NotNull
        private final Provider<String> mainClass;
        @NotNull
        private final Provider<String> daemonEntryPoint;
        @NotNull
        private final FileCollection classpath;
        @NotNull
        private final ListProperty<String> jvmArgs;
        @NotNull
        private final Provider<Boolean> shouldPassArgumentsViaArgFile;
        @NotNull
        private final Map<String, String> systemProperties;
        @NotNull
        private final Map<String, String> environment;
        @NotNull
        private final Set<String> environmentBlacklist;
        @NotNull
        private final Set<String> systemPropertiesBlacklist;

        public ToolSpec(@NotNull Provider<String> displayName, @NotNull Provider<String> optionalToolName, @NotNull Provider<String> mainClass, @NotNull Provider<String> daemonEntryPoint, @NotNull FileCollection classpath2, @NotNull ListProperty<String> jvmArgs2, @NotNull Provider<Boolean> shouldPassArgumentsViaArgFile, @NotNull Map<String, String> systemProperties2, @NotNull Map<String, String> environment2, @NotNull Set<String> environmentBlacklist2) {
            Intrinsics.checkNotNullParameter(displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter(optionalToolName, (String)"optionalToolName");
            Intrinsics.checkNotNullParameter(mainClass, (String)"mainClass");
            Intrinsics.checkNotNullParameter(daemonEntryPoint, (String)"daemonEntryPoint");
            Intrinsics.checkNotNullParameter((Object)classpath2, (String)"classpath");
            Intrinsics.checkNotNullParameter(jvmArgs2, (String)"jvmArgs");
            Intrinsics.checkNotNullParameter(shouldPassArgumentsViaArgFile, (String)"shouldPassArgumentsViaArgFile");
            Intrinsics.checkNotNullParameter(systemProperties2, (String)"systemProperties");
            Intrinsics.checkNotNullParameter(environment2, (String)"environment");
            Intrinsics.checkNotNullParameter(environmentBlacklist2, (String)"environmentBlacklist");
            this.displayName = displayName;
            this.optionalToolName = optionalToolName;
            this.mainClass = mainClass;
            this.daemonEntryPoint = daemonEntryPoint;
            this.classpath = classpath2;
            this.jvmArgs = jvmArgs2;
            this.shouldPassArgumentsViaArgFile = shouldPassArgumentsViaArgFile;
            this.systemProperties = systemProperties2;
            this.environment = environment2;
            this.environmentBlacklist = environmentBlacklist2;
            Object[] objectArray = new String[]{"java.endorsed.dirs", "user.dir", "java.system.class.loader"};
            this.systemPropertiesBlacklist = SetsKt.setOf((Object[])objectArray);
        }

        public /* synthetic */ ToolSpec(Provider provider, Provider provider2, Provider provider3, Provider provider4, FileCollection fileCollection, ListProperty listProperty, Provider provider5, Map map2, Map map3, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x80) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 0x100) != 0) {
                map3 = MapsKt.emptyMap();
            }
            if ((n & 0x200) != 0) {
                set2 = SetsKt.emptySet();
            }
            this((Provider<String>)provider, (Provider<String>)provider2, (Provider<String>)provider3, (Provider<String>)provider4, fileCollection, (ListProperty<String>)listProperty, (Provider<Boolean>)provider5, map2, map3, set2);
        }

        @NotNull
        public final Provider<String> getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Provider<String> getOptionalToolName() {
            return this.optionalToolName;
        }

        @NotNull
        public final Provider<String> getMainClass() {
            return this.mainClass;
        }

        @NotNull
        public final Provider<String> getDaemonEntryPoint() {
            return this.daemonEntryPoint;
        }

        @NotNull
        public final FileCollection getClasspath() {
            return this.classpath;
        }

        @NotNull
        public final ListProperty<String> getJvmArgs() {
            return this.jvmArgs;
        }

        @NotNull
        public final Provider<Boolean> getShouldPassArgumentsViaArgFile() {
            return this.shouldPassArgumentsViaArgFile;
        }

        @NotNull
        public final Map<String, String> getSystemProperties() {
            return this.systemProperties;
        }

        @NotNull
        public final Map<String, String> getEnvironment() {
            return this.environment;
        }

        @NotNull
        public final Set<String> getEnvironmentBlacklist() {
            return this.environmentBlacklist;
        }

        @NotNull
        public final Set<String> getSystemPropertiesBlacklist() {
            return this.systemPropertiesBlacklist;
        }

        @NotNull
        public final ToolSpec disableC2() {
            block1: {
                String string2 = System.getProperty("java.vm.name");
                if (string2 == null) break block1;
                String vmName = string2;
                boolean bl = false;
                if (StringsKt.contains((CharSequence)vmName, (CharSequence)"HotSpot", (boolean)true)) {
                    this.jvmArgs.add((Object)"-XX:TieredStopAtLevel=1");
                }
            }
            return this;
        }

        @NotNull
        public final ToolSpec enableAssertions() {
            this.jvmArgs.add((Object)"-ea");
            return this;
        }

        @NotNull
        public final ToolSpec configureDefaultMaxHeapSize() {
            boolean bl;
            block4: {
                Object object = this.jvmArgs.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jvmArgs.get()");
                Iterable $this$none$iv = (Iterable)object;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.startsWith$default((String)it, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.jvmArgs.add((Object)"-Xmx3g");
            }
            return this;
        }
    }
}

