/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.config;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.gradle.internal.config.AnalysisFlag;
import org.jetbrains.kotlin.gradle.internal.config.LanguageFeature;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersion;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettings;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettingsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBK\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\bH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "languageVersion", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "analysisFlags", "", "Lorg/jetbrains/kotlin/gradle/internal/config/AnalysisFlag;", "", "specificFeatures", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageFeature;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageFeature$State;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Map;Ljava/util/Map;)V", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "getFlag", "T", "flag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;)Ljava/lang/Object;", "getFeatureSupport", "feature", "toString", "", "isPreRelease", "", "Companion", "util"})
@SourceDebugExtension(value={"SMAP\nLanguageVersionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersionSettingsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,707:1\n1#2:708\n1053#3:709\n1863#3,2:710\n1053#3:712\n1863#3,2:713\n188#4,3:715\n*S KotlinDebug\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersionSettingsImpl\n*L\n673#1:709\n673#1:710,2\n681#1:712\n681#1:713,2\n687#1:715,3\n*E\n"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private final Map<AnalysisFlag<?>, ?> analysisFlags;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @JvmField
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, null, 12, null);

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion2, @NotNull ApiVersion apiVersion2, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags, @NotNull Map<LanguageFeature, ? extends LanguageFeature.State> specificFeatures) {
        Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion2, (String)"apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        Intrinsics.checkNotNullParameter(specificFeatures, (String)"specificFeatures");
        this.languageVersion = languageVersion2;
        this.apiVersion = apiVersion2;
        Map<AnalysisFlag<?>, ? extends Object> map2 = Collections.unmodifiableMap(analysisFlags);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.analysisFlags = map2;
        Map<LanguageFeature, ? extends LanguageFeature.State> map3 = Collections.unmodifiableMap(specificFeatures);
        Intrinsics.checkNotNullExpressionValue(map3, (String)"unmodifiableMap(...)");
        this.specificFeatures = map3;
    }

    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion2, ApiVersion apiVersion2, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        this(languageVersion2, apiVersion2, map2, map3);
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag2) {
        Intrinsics.checkNotNullParameter(flag2, (String)"flag");
        Object object = this.analysisFlags.get(flag2);
        if (object == null) {
            object = flag2.getDefaultValue();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        LanguageFeature.State state = this.specificFeatures.get((Object)feature);
        if (state != null) {
            LanguageFeature.State it = state;
            boolean bl = false;
            return it;
        }
        LanguageVersion since = feature.getSinceVersion();
        if (since != null && this.getLanguageVersion().compareTo((Enum)since) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0) {
            return feature.isEnabledWithWarning$util() ? LanguageFeature.State.ENABLED_WITH_WARNING : LanguageFeature.State.ENABLED;
        }
        return LanguageFeature.State.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Map.Entry entry2;
        void $this$forEach$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u245.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Iterable $this$sortedBy$iv = this.specificFeatures.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry2 = (Map.Entry)a;
                boolean bl = false;
                LanguageFeature feature = (LanguageFeature)((Object)entry2.getKey());
                entry2 = (Map.Entry)b;
                Comparable comparable = Integer.valueOf(feature.ordinal());
                bl = false;
                feature = (LanguageFeature)((Object)entry2.getKey());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(feature.ordinal()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            char c;
            entry2 = (Map.Entry)element$iv;
            boolean bl2 = false;
            LanguageFeature feature = (LanguageFeature)((Object)entry2.getKey());
            LanguageFeature.State state = (LanguageFeature.State)entry2.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    c = '+';
                    break;
                }
                case 2: {
                    c = '~';
                    break;
                }
                case 3: {
                    c = '-';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char c2 = c;
            $this$toString_u24lambda_u245.append("" + ' ' + c2 + (Object)((Object)feature));
        }
        $this$sortedBy$iv = this.analysisFlags.entrySet();
        $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry entry2 = (Map.Entry)a;
                boolean bl = false;
                AnalysisFlag flag2 = (AnalysisFlag)entry2.getKey();
                entry2 = (Map.Entry)b;
                Comparable comparable = (Comparable)((Object)flag2.toString());
                bl = false;
                flag2 = (AnalysisFlag)entry2.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)flag2.toString())));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry2 = (Map.Entry)element$iv;
            boolean bl3 = false;
            AnalysisFlag flag2 = (AnalysisFlag)entry2.getKey();
            Object value2 = entry2.getValue();
            $this$toString_u24lambda_u245.append("" + ' ' + flag2 + ':' + value2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPreRelease() {
        boolean bl;
        if (LanguageVersionSettingsKt.isPreRelease(this.getLanguageVersion())) return true;
        Map<LanguageFeature, LanguageFeature.State> $this$any$iv = this.specificFeatures;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry2 = element$iv = iterator2.next();
            boolean bl2 = false;
            LanguageFeature feature = entry2.getKey();
            LanguageFeature.State state = entry2.getValue();
            if (state == LanguageFeature.State.ENABLED && LanguageVersionSettingsKt.forcesPreReleaseBinariesIfEnabled(feature)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion2, @NotNull ApiVersion apiVersion2, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion2, (String)"apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        this(languageVersion2, apiVersion2, analysisFlags, null, 8, null);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion2, @NotNull ApiVersion apiVersion2) {
        Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
        Intrinsics.checkNotNullParameter((Object)apiVersion2, (String)"apiVersion");
        this(languageVersion2, apiVersion2, null, null, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettingsImpl$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettingsImpl;", "util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageFeature.State.values().length];
            try {
                nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.DISABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

