/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.name;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.name.Name;
import org.jetbrains.kotlin.gradle.internal.name.SpecialNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0012H\u0007J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0007J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/name/NameUtils;", "", "<init>", "()V", "SANITIZE_AS_JAVA_INVALID_CHARACTERS", "Lkotlin/text/Regex;", "CONTEXT_RECEIVER_PREFIX", "", "getCONTEXT_RECEIVER_PREFIX$annotations", "getCONTEXT_RECEIVER_PREFIX", "()Ljava/lang/String;", "sanitizeAsJavaIdentifier", "name", "getPackagePartClassNamePrefix", "shortFileName", "capitalizeAsJavaClassName", "str", "getScriptNameForFile", "Lorg/jetbrains/kotlin/gradle/internal/name/Name;", "filePath", "hasName", "", "delegateFieldName", "index", "", "propertyDelegateName", "propertyName", "contextReceiverName", "compiler.common"})
public final class NameUtils {
    @NotNull
    public static final NameUtils INSTANCE = new NameUtils();
    @NotNull
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex("[^\\p{L}\\p{Digit}]");
    @NotNull
    private static final String CONTEXT_RECEIVER_PREFIX = "$context_receiver";

    private NameUtils() {
    }

    @NotNull
    public static final String getCONTEXT_RECEIVER_PREFIX() {
        return CONTEXT_RECEIVER_PREFIX;
    }

    @JvmStatic
    public static /* synthetic */ void getCONTEXT_RECEIVER_PREFIX$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name, "_");
    }

    @JvmStatic
    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkNotNullParameter((Object)shortFileName, (String)"shortFileName");
        return ((CharSequence)shortFileName).length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(str.charAt(0));
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string4);
            String string5 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string2 = stringBuilder2.append(string5).toString();
        } else {
            string2 = '_' + str;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Name name = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)filePath, (char)'/', null, (int)2, null), (char)'.', null, (int)2, null)));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    @JvmStatic
    public static final boolean hasName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return !Intrinsics.areEqual((Object)name, (Object)SpecialNames.NO_NAME_PROVIDED) && !Intrinsics.areEqual((Object)name, (Object)SpecialNames.ANONYMOUS);
    }

    @JvmStatic
    @NotNull
    public static final Name delegateFieldName(int index) {
        Name name = Name.identifier("$$delegate_" + index);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    @JvmStatic
    @NotNull
    public static final Name propertyDelegateName(@NotNull Name propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Name name = Name.identifier(propertyName.asString() + "$delegate");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    @JvmStatic
    @NotNull
    public static final Name contextReceiverName(int index) {
        Name name = Name.identifier(CONTEXT_RECEIVER_PREFIX + '_' + index);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }
}

