/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.util.Collection;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptions;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a&\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\"\u0010\u0014\u001a\u00020\u0005*\u00060\u0015j\u0002`\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"DIAGNOSTIC_SEPARATOR", "", "DIAGNOSTIC_STACKTRACE_END_SEPARATOR", "DIAGNOSTIC_STACKTRACE_START", "renderReportedDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "logger", "Lorg/gradle/api/logging/Logger;", "renderingOptions", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticRenderingOptions;", "renderReportedDiagnostics", "diagnostics", "", "createAnExceptionForFatalDiagnostic", "Lorg/gradle/api/InvalidUserCodeException;", "render", "showStacktrace", "", "renderStacktrace", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "throwable", "", "useParsableFormatting", "kotlin-gradle-plugin_common"})
public final class RenderReportedDiagnosticsKt {
    @NotNull
    public static final String DIAGNOSTIC_SEPARATOR = "#diagnostic-end";
    @NotNull
    public static final String DIAGNOSTIC_STACKTRACE_START = "Stacktrace:";
    @NotNull
    public static final String DIAGNOSTIC_STACKTRACE_END_SEPARATOR = "#stacktrace-end";

    public static final void renderReportedDiagnostics(@NotNull Collection<ToolingDiagnostic> diagnostics, @NotNull Logger logger, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        for (ToolingDiagnostic diagnostic : diagnostics) {
            RenderReportedDiagnosticsKt.renderReportedDiagnostic(diagnostic, logger, renderingOptions);
        }
    }

    public static final void renderReportedDiagnostic(@NotNull ToolingDiagnostic diagnostic, @NotNull Logger logger, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        switch (WhenMappings.$EnumSwitchMapping$0[diagnostic.getSeverity().ordinal()]) {
            case 1: {
                logger.warn("w: " + RenderReportedDiagnosticsKt.render$default(diagnostic, renderingOptions, false, 2, null) + '\n');
                break;
            }
            case 2: {
                logger.error("e: " + RenderReportedDiagnosticsKt.render$default(diagnostic, renderingOptions, false, 2, null) + '\n');
                break;
            }
            case 3: {
                throw RenderReportedDiagnosticsKt.createAnExceptionForFatalDiagnostic(diagnostic, renderingOptions);
            }
        }
    }

    @NotNull
    public static final InvalidUserCodeException createAnExceptionForFatalDiagnostic(@NotNull ToolingDiagnostic $this$createAnExceptionForFatalDiagnostic, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$createAnExceptionForFatalDiagnostic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        String message2 = RenderReportedDiagnosticsKt.render($this$createAnExceptionForFatalDiagnostic, renderingOptions, false);
        if ($this$createAnExceptionForFatalDiagnostic.getThrowable() != null) {
            throw new InvalidUserCodeException(message2, $this$createAnExceptionForFatalDiagnostic.getThrowable());
        }
        throw new InvalidUserCodeException(message2);
    }

    private static final String render(ToolingDiagnostic $this$render, ToolingDiagnosticRenderingOptions renderingOptions, boolean showStacktrace) {
        StringBuilder stringBuilder;
        StringBuilder $this$render_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ToolingDiagnosticRenderingOptions $this$render_u24lambda_u241_u24lambda_u240 = renderingOptions;
        boolean bl2 = false;
        if (!$this$render_u24lambda_u241_u24lambda_u240.getUseParsableFormat() && $this$render_u24lambda_u241_u24lambda_u240.getShowSeverityEmoji()) {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$render.getSeverity().ordinal()]) {
                case 1: {
                    $this$render_u24lambda_u241.append("\u26a0\ufe0f ");
                    break;
                }
                case 2: 
                case 3: {
                    $this$render_u24lambda_u241.append("\u274c ");
                }
            }
        }
        if ($this$render_u24lambda_u241_u24lambda_u240.getUseParsableFormat()) {
            $this$render_u24lambda_u241.append($this$render).append('\n');
        } else {
            $this$render_u24lambda_u241.append($this$render.getMessage());
        }
        if (showStacktrace) {
            RenderReportedDiagnosticsKt.renderStacktrace($this$render_u24lambda_u241, $this$render.getThrowable(), $this$render_u24lambda_u241_u24lambda_u240.getUseParsableFormat());
        }
        if ($this$render_u24lambda_u241_u24lambda_u240.getUseParsableFormat()) {
            $this$render_u24lambda_u241.append(DIAGNOSTIC_SEPARATOR).append('\n');
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String render$default(ToolingDiagnostic toolingDiagnostic, ToolingDiagnosticRenderingOptions toolingDiagnosticRenderingOptions, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = toolingDiagnosticRenderingOptions.getShowStacktrace();
        }
        return RenderReportedDiagnosticsKt.render(toolingDiagnostic, toolingDiagnosticRenderingOptions, bl);
    }

    private static final void renderStacktrace(StringBuilder $this$renderStacktrace, Throwable throwable, boolean useParsableFormatting) {
        if (throwable == null) {
            return;
        }
        $this$renderStacktrace.append('\n');
        $this$renderStacktrace.append(DIAGNOSTIC_STACKTRACE_START).append('\n');
        $this$renderStacktrace.append(StringsKt.prependIndent((String)((Object)StringsKt.trim((CharSequence)ExceptionsKt.stackTraceToString((Throwable)throwable))).toString(), (String)"    ")).append('\n');
        if (useParsableFormatting) {
            $this$renderStacktrace.append(DIAGNOSTIC_STACKTRACE_END_SEPARATOR).append('\n');
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolingDiagnostic.Severity.values().length];
            try {
                nArray[ToolingDiagnostic.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.FATAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

