/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.ide;

import java.io.File;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.com.google.gson.JsonElement;
import org.jetbrains.kotlin.com.google.gson.JsonObject;
import org.jetbrains.kotlin.com.google.gson.JsonPrimitive;
import org.jetbrains.kotlin.com.google.gson.JsonSerializationContext;
import org.jetbrains.kotlin.com.google.gson.JsonSerializer;
import org.jetbrains.kotlin.com.google.gson.Strictness;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinDependencyCoordinates;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeDependencyResolver;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeMultiplatformImport;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeMultiplatformImportKt;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeMultiplatformImportStatistics;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeMultiplatformImportStatisticsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.tooling.core.Extras;

@DisableCachingByDefault(because="Used for debugging/diagnostic purpose.")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0011\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "resolveDependencies", "", "ExtrasAdapter", "FileAdapter", "IdeDependencyResolverAdapter", "IdeaKotlinDependencyCoordinatesAdapter", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nIdeResolveDependenciesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeResolveDependenciesTask.kt\norg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,117:1\n1863#2:118\n1872#2,3:119\n1864#2:122\n216#3,2:123\n*S KotlinDebug\n*F\n+ 1 IdeResolveDependenciesTask.kt\norg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask\n*L\n59#1:118\n65#1:119,3\n59#1:122\n75#1:123,2\n*E\n"})
public class IdeResolveDependenciesTask
extends DefaultTask {
    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void resolveDependencies() {
        StringBuilder stringBuilder;
        File outputDirectory2 = ((Directory)this.getProject().getLayout().getBuildDirectory().dir("ide/dependencies").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)outputDirectory2, (String)"outputDirectory");
        FilesKt.deleteRecursively((File)outputDirectory2);
        GsonBuilder gsonBuilder = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().registerTypeHierarchyAdapter(IdeDependencyResolver.class, IdeDependencyResolverAdapter.INSTANCE).registerTypeHierarchyAdapter(Extras.class, ExtrasAdapter.INSTANCE).registerTypeHierarchyAdapter(IdeaKotlinDependencyCoordinates.class, IdeaKotlinDependencyCoordinatesAdapter.INSTANCE);
        Type type = (Type)((Object)File.class);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Gson gson2 = gsonBuilder.registerTypeAdapter(type, new FileAdapter(project)).create();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        KotlinProjectExtension extension = KotlinProjectExtensionKt.getKotlinExtension(project2);
        Iterable $this$forEach$iv = (Iterable)extension.getSourceSets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinSourceSet sourceSet = (KotlinSourceSet)element$iv;
            boolean bl3 = false;
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            IdeMultiplatformImport ideMultiplatformImport = IdeMultiplatformImportKt.getKotlinIdeMultiplatformImport(project3);
            Intrinsics.checkNotNullExpressionValue((Object)sourceSet, (String)"sourceSet");
            Set<IdeaKotlinDependency> dependencies2 = ideMultiplatformImport.resolveDependencies(sourceSet);
            File jsonOutput = FilesKt.resolve((File)outputDirectory2, (String)("json/" + sourceSet.getName() + ".json"));
            jsonOutput.getParentFile().mkdirs();
            String string2 = gson2.toJson(dependencies2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(dependencies)");
            FilesKt.writeText$default((File)jsonOutput, (String)string2, null, (int)2, null);
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            Iterable $this$forEachIndexed$iv = IdeMultiplatformImportKt.getKotlinIdeMultiplatformImport(project4).serialize((Iterable<? extends IdeaKotlinDependency>)dependencies2);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void proto;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                byte[] byArray = (byte[])item$iv;
                int index = n;
                boolean bl2 = false;
                File protoOutput = FilesKt.resolve((File)outputDirectory2, (String)("proto/" + sourceSet.getName() + '/' + index + ".bin"));
                protoOutput.getParentFile().mkdirs();
                FilesKt.writeBytes((File)protoOutput, (byte[])proto);
            }
        }
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        IdeMultiplatformImportStatistics statistics = IdeMultiplatformImportStatisticsKt.getKotlinIdeMultiplatformImportStatistics(project5);
        boolean bl = false;
        File timeStatisticsFile = FilesKt.resolve((File)outputDirectory2, (String)"times.txt");
        StringBuilder bl3 = stringBuilder = new StringBuilder();
        File file2 = timeStatisticsFile;
        boolean bl4 = false;
        Map<Class<?>, Long> $this$forEach$iv2 = statistics.getExecutionTimes();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<Class<?>, Long>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$resolveDependencies_u24lambda_u244_u24lambda_u243;
            Map.Entry<Class<?>, Long> element$iv;
            Map.Entry<Class<?>, Long> entry2 = element$iv = iterator2.next();
            boolean bl5 = false;
            Class<?> clazz = entry2.getKey();
            long time = ((Number)entry2.getValue()).longValue();
            StringUtilsKt.appendLine((Appendable)$this$resolveDependencies_u24lambda_u244_u24lambda_u243, clazz.getName() + ' ' + time + ".ms");
        }
        FilesKt.writeText$default((File)file2, (String)stringBuilder.toString(), null, (int)2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask$ExtrasAdapter;", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializer;", "Lorg/jetbrains/kotlin/tooling/core/Extras;", "()V", "serialize", "Lorg/jetbrains/kotlin/com/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializationContext;", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nIdeResolveDependenciesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeResolveDependenciesTask.kt\norg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask$ExtrasAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1863#2:118\n1864#2:120\n1#3:119\n*S KotlinDebug\n*F\n+ 1 IdeResolveDependenciesTask.kt\norg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask$ExtrasAdapter\n*L\n97#1:118\n97#1:120\n*E\n"})
    private static final class ExtrasAdapter
    implements JsonSerializer<Extras> {
        @NotNull
        public static final ExtrasAdapter INSTANCE = new ExtrasAdapter();

        private ExtrasAdapter() {
        }

        @Override
        @NotNull
        public JsonElement serialize(@NotNull Extras src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            JsonObject jsonObject;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject $this$serialize_u24lambda_u243 = jsonObject = new JsonObject();
            boolean bl = false;
            Iterable $this$forEach$iv = src.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Object $this$serialize_u24lambda_u243_u24lambda_u242_u24lambda_u240;
                Extras.Entry entry2 = (Extras.Entry)element$iv;
                boolean bl2 = false;
                Object object2 = $this$serialize_u24lambda_u243;
                try {
                    $this$serialize_u24lambda_u243_u24lambda_u242_u24lambda_u240 = object2;
                    boolean bl3 = false;
                    $this$serialize_u24lambda_u243_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)context.serialize(entry2.getValue()));
                }
                catch (Throwable bl3) {
                    $this$serialize_u24lambda_u243_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                object2 = $this$serialize_u24lambda_u243_u24lambda_u242_u24lambda_u240;
                if (Result.exceptionOrNull-impl((Object)object2) == null) {
                    object = object2;
                } else {
                    boolean bl4 = false;
                    object = new JsonPrimitive(String.valueOf(entry2.getValue()));
                }
                JsonElement valueElement = (JsonElement)object;
                $this$serialize_u24lambda_u243.add(entry2.getKey().getStableString(), valueElement);
            }
            return jsonObject;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask$FileAdapter;", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializer;", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "serialize", "Lorg/jetbrains/kotlin/com/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializationContext;", "kotlin-gradle-plugin_common"})
    private static final class FileAdapter
    implements JsonSerializer<File> {
        @NotNull
        private final Project project;

        public FileAdapter(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        @NotNull
        public JsonElement serialize(@NotNull File src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonElement jsonElement;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            File file2 = this.project.getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.projectDir");
            if (FilesKt.startsWith((File)src, (File)file2)) {
                File file3 = this.project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.projectDir");
                jsonElement = new JsonPrimitive(FilesKt.relativeTo((File)src, (File)file3).getPath());
            } else {
                File file4 = this.project.getRootDir();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"project.rootDir");
                if (FilesKt.startsWith((File)src, (File)file4)) {
                    File file5 = this.project.getRootDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"project.rootDir");
                    jsonElement = new JsonPrimitive(FilesKt.relativeTo((File)src, (File)file5).getPath());
                } else {
                    jsonElement = new JsonPrimitive(src.getPath());
                }
            }
            return jsonElement;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask$IdeDependencyResolverAdapter;", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializer;", "Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeDependencyResolver;", "()V", "serialize", "Lorg/jetbrains/kotlin/com/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializationContext;", "kotlin-gradle-plugin_common"})
    private static final class IdeDependencyResolverAdapter
    implements JsonSerializer<IdeDependencyResolver> {
        @NotNull
        public static final IdeDependencyResolverAdapter INSTANCE = new IdeDependencyResolverAdapter();

        private IdeDependencyResolverAdapter() {
        }

        @Override
        @NotNull
        public JsonElement serialize(@NotNull IdeDependencyResolver src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new JsonPrimitive(src.getClass().getName());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeResolveDependenciesTask$IdeaKotlinDependencyCoordinatesAdapter;", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializer;", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinDependencyCoordinates;", "()V", "serialize", "Lorg/jetbrains/kotlin/com/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lorg/jetbrains/kotlin/com/google/gson/JsonSerializationContext;", "kotlin-gradle-plugin_common"})
    private static final class IdeaKotlinDependencyCoordinatesAdapter
    implements JsonSerializer<IdeaKotlinDependencyCoordinates> {
        @NotNull
        public static final IdeaKotlinDependencyCoordinatesAdapter INSTANCE = new IdeaKotlinDependencyCoordinatesAdapter();

        private IdeaKotlinDependencyCoordinatesAdapter() {
        }

        @Override
        @NotNull
        public JsonElement serialize(@NotNull IdeaKotlinDependencyCoordinates src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return new JsonPrimitive(src.toString());
        }
    }
}

