/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.fus.BuildUidService;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationCacheStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFinishMetrics;
import org.jetbrains.kotlin.gradle.plugin.statistics.CloseActionBuildFusService;
import org.jetbrains.kotlin.gradle.plugin.statistics.ConfigurationMetricParameterFlowActionBuildFusService;
import org.jetbrains.kotlin.gradle.plugin.statistics.ExecutedTaskMetrics;
import org.jetbrains.kotlin.gradle.plugin.statistics.FlowActionBuildFusService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatisticsUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsBeanService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsConfiguration;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsLoggerService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinTaskExecutionMetrics;
import org.jetbrains.kotlin.gradle.plugin.statistics.MetricContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.NonSynchronizedMetricsContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.SynchronizedMetricsContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.UsesBuildFusService;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifierKt;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 )*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0012\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J+\u0010 \u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0000\u00a2\u0006\u0002\b$J!\u0010%\u001a\u00020\u00192\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00190'H\u0000\u00a2\u0006\u0002\b(R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "T", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "Lorg/gradle/api/services/BuildService;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildFailed", "", "getBuildFailed", "()Z", "setBuildFailed", "(Z)V", "buildId", "", "kotlin.jvm.PlatformType", "getBuildId", "()Ljava/lang/String;", "fusMetricsConsumer", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/SynchronizedMetricsContainer;", "log", "Lorg/gradle/api/logging/Logger;", "projectEvaluatedTime", "", "close", "", "getFusMetricsConsumer", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "getFusMetricsConsumer$kotlin_gradle_plugin_common", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "recordBuildFinished", "configurationMetrics", "", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "recordBuildFinished$kotlin_gradle_plugin_common", "reportFusMetrics", "reportAction", "Lkotlin/Function1;", "reportFusMetrics$kotlin_gradle_plugin_common", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildFusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildFusService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1863#2,2:219\n*S KotlinDebug\n*F\n+ 1 BuildFusService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService\n*L\n188#1:219,2\n*E\n"})
public abstract class BuildFusService<T extends Parameters>
implements BuildService<T>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean buildFailed;
    private final Logger log = Logging.getLogger(this.getClass());
    private final String buildId = (String)((Parameters)this.getParameters()).getBuildId().get();
    @NotNull
    private final SynchronizedMetricsContainer fusMetricsConsumer;
    private final long projectEvaluatedTime;
    @NotNull
    private static final String serviceName = Reflection.getOrCreateKotlinClass(BuildFusService.class).getSimpleName() + '_' + BuildFusService.class.getClassLoader().hashCode();
    private static long buildStartTime = System.currentTimeMillis();

    public BuildFusService() {
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Initialize " + this.getClass().getSimpleName());
        String string2 = this.buildId;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildId");
        KotlinBuildStatsBeanService.Companion.recordBuildStart$kotlin_gradle_plugin_common(string2);
        this.fusMetricsConsumer = new SynchronizedMetricsContainer();
        this.projectEvaluatedTime = System.currentTimeMillis();
    }

    protected final boolean getBuildFailed() {
        return this.buildFailed;
    }

    protected final void setBuildFailed(boolean bl) {
        this.buildFailed = bl;
    }

    protected final String getBuildId() {
        return this.buildId;
    }

    @NotNull
    public final StatisticsValuesConsumer getFusMetricsConsumer$kotlin_gradle_plugin_common() {
        return this.fusMetricsConsumer;
    }

    public final void reportFusMetrics$kotlin_gradle_plugin_common(@NotNull Function1<? super StatisticsValuesConsumer, Unit> reportAction) {
        Intrinsics.checkNotNullParameter(reportAction, (String)"reportAction");
        NonSynchronizedMetricsContainer metricConsumer = new NonSynchronizedMetricsContainer();
        reportAction.invoke((Object)metricConsumer);
        this.fusMetricsConsumer.readFromMetricConsumer(metricConsumer);
    }

    public synchronized void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            TaskExecutionResult taskExecutionResult;
            if (((TaskFinishEvent)event).getResult() instanceof TaskFailureResult) {
                this.buildFailed = true;
            }
            String string2 = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.descriptor.taskPath");
            TaskExecutionResult taskExecutionResult2 = taskExecutionResult = TaskExecutionResults.INSTANCE.get(string2);
            if (taskExecutionResult2 != null) {
                TaskExecutionResult taskExecutionResult3;
                TaskExecutionResult executionResult = taskExecutionResult3 = taskExecutionResult2;
                boolean bl = false;
                this.reportFusMetrics$kotlin_gradle_plugin_common((Function1<StatisticsValuesConsumer, Unit>)((Function1)new Function1<StatisticsValuesConsumer, Unit>(executionResult, event){
                    final /* synthetic */ TaskExecutionResult $executionResult;
                    final /* synthetic */ FinishEvent $event;
                    {
                        this.$executionResult = $executionResult;
                        this.$event = $event;
                        super(1);
                    }

                    public final void invoke(StatisticsValuesConsumer it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        KotlinTaskExecutionMetrics.INSTANCE.collectMetrics(this.$executionResult, (TaskFinishEvent)this.$event, it);
                    }
                }));
            }
        }
        this.reportFusMetrics$kotlin_gradle_plugin_common((Function1<StatisticsValuesConsumer, Unit>)((Function1)new Function1<StatisticsValuesConsumer, Unit>(event){
            final /* synthetic */ FinishEvent $event;
            {
                this.$event = $event;
                super(1);
            }

            public final void invoke(StatisticsValuesConsumer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExecutedTaskMetrics.INSTANCE.collectMetrics$kotlin_gradle_plugin_common(this.$event, it);
            }
        }));
    }

    @Override
    public void close() {
        KotlinBuildStatsBeanService.Companion.closeServices();
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Close " + this.getClass().getSimpleName());
    }

    public final void recordBuildFinished$kotlin_gradle_plugin_common(boolean buildFailed, @NotNull String buildId, @NotNull List<MetricContainer> configurationMetrics) {
        block2: {
            KotlinBuildStatsConfiguration kotlinBuildStatsConfiguration;
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter(configurationMetrics, (String)"configurationMetrics");
            Logger logger = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
            BuildFinishMetrics.INSTANCE.collectMetrics(logger, buildFailed, buildStartTime, this.projectEvaluatedTime, this.fusMetricsConsumer);
            Iterable $this$forEach$iv = configurationMetrics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetricContainer it = (MetricContainer)element$iv;
                boolean bl = false;
                it.addToConsumer(this.fusMetricsConsumer);
            }
            MetricContainer metricContainer = (MetricContainer)((Parameters)this.getParameters()).getGeneralConfigurationMetrics().getOrNull();
            if (metricContainer != null) {
                metricContainer.addToConsumer(this.fusMetricsConsumer);
            }
            KotlinBuildStatsConfiguration kotlinBuildStatsConfiguration2 = (KotlinBuildStatsConfiguration)((Parameters)this.getParameters()).getBuildStatisticsConfiguration().getOrNull();
            if (kotlinBuildStatsConfiguration2 == null) break block2;
            KotlinBuildStatsConfiguration it = kotlinBuildStatsConfiguration = kotlinBuildStatsConfiguration2;
            boolean bl = false;
            KotlinBuildStatsLoggerService loggerService = new KotlinBuildStatsLoggerService(it);
            loggerService.initSessionLogger(buildId);
            loggerService.reportBuildFinished$kotlin_gradle_plugin_common(this.fusMetricsConsumer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\t\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nJ6\u0010\u0012\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Companion;", "", "()V", "buildStartTime", "", "serviceName", "", "getServiceName$kotlin_gradle_plugin_common", "()Ljava/lang/String;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "project", "Lorg/gradle/api/Project;", "pluginVersion", "buildUidService", "Lorg/jetbrains/kotlin/gradle/fus/BuildUidService;", "registerIfAbsentImpl", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getServiceName$kotlin_gradle_plugin_common() {
            return serviceName;
        }

        @NotNull
        public final Provider<? extends BuildFusService<? extends Parameters>> registerIfAbsent(@NotNull Project project, @NotNull String pluginVersion, @NotNull Provider<BuildUidService> buildUidService) {
            Provider<? extends BuildFusService<? extends Parameters>> provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
            Intrinsics.checkNotNullParameter(buildUidService, (String)"buildUidService");
            Provider<? extends BuildFusService<? extends Parameters>> serviceProvider = provider = this.registerIfAbsentImpl(project, pluginVersion, buildUidService);
            boolean bl = false;
            String string2 = UsesBuildFusService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UsesBuildFusService::class.java.name");
            SingleActionPerProject.INSTANCE.run(project, string2, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<? extends BuildFusService<? extends Parameters>> $serviceProvider;
                {
                    this.$project = $project;
                    this.$serviceProvider = $serviceProvider;
                    super(0);
                }

                public final void invoke() {
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                    TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                    boolean $i$f$withType = false;
                    TaskCollection taskCollection = $this$withType$iv.withType(UsesBuildFusService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                    taskCollection.configureEach(new Action(this.$serviceProvider){
                        final /* synthetic */ Provider<? extends BuildFusService<? extends Parameters>> $serviceProvider;
                        {
                            this.$serviceProvider = $serviceProvider;
                        }

                        public final void execute(UsesBuildFusService task2) {
                            task2.getBuildFusService().value(this.$serviceProvider).disallowChanges();
                            task2.usesService(this.$serviceProvider);
                        }
                    });
                }
            }));
            return provider;
        }

        private final Provider<? extends BuildFusService<? extends Parameters>> registerIfAbsentImpl(Project project, String pluginVersion, Provider<BuildUidService> buildUidService) {
            Provider<? extends BuildFusService<? extends Parameters>> fusService;
            Object object;
            boolean isProjectIsolationEnabled = ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project);
            boolean isConfigurationCacheRequested = ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheRequested(project);
            boolean isProjectIsolationRequested = ProjectIsolationStartParameterAccessorKt.isProjectIsolationRequested(project);
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(this.getServiceName$kotlin_gradle_plugin_common());
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider = it.getService();
                Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<out org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusService<out org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusService.Parameters>>");
                return provider;
            }
            KotlinBuildStatsBeanService.Companion.initStatsService$kotlin_gradle_plugin_common(project);
            List<BuildReportType> buildReportOutputs = ConfigureReporingKt.reportingSettings(project).getBuildReportOutputs();
            Boolean useClasspathSnapshot2 = (Boolean)PropertiesProvider.Companion.invoke(project).getUseClasspathSnapshot().get();
            Gradle gradle = project.getGradle();
            Provider generalConfigurationMetricsProvider2 = project.provider(new Callable(project, gradle, buildReportOutputs, useClasspathSnapshot2, pluginVersion, isProjectIsolationEnabled, isProjectIsolationRequested, isConfigurationCacheRequested){
                final /* synthetic */ Project $project;
                final /* synthetic */ Gradle $gradle;
                final /* synthetic */ List<BuildReportType> $buildReportOutputs;
                final /* synthetic */ Boolean $useClasspathSnapshot;
                final /* synthetic */ String $pluginVersion;
                final /* synthetic */ boolean $isProjectIsolationEnabled;
                final /* synthetic */ boolean $isProjectIsolationRequested;
                final /* synthetic */ boolean $isConfigurationCacheRequested;
                {
                    this.$project = $project;
                    this.$gradle = $gradle;
                    this.$buildReportOutputs = $buildReportOutputs;
                    this.$useClasspathSnapshot = $useClasspathSnapshot;
                    this.$pluginVersion = $pluginVersion;
                    this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                    this.$isProjectIsolationRequested = $isProjectIsolationRequested;
                    this.$isConfigurationCacheRequested = $isConfigurationCacheRequested;
                }

                public final MetricContainer call() {
                    Gradle gradle = this.$gradle;
                    Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
                    Boolean bl = this.$useClasspathSnapshot;
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"useClasspathSnapshot");
                    return KotlinBuildStatisticsUtilsKt.collectGeneralConfigurationTimeMetrics(this.$project, gradle, this.$buildReportOutputs, bl, this.$pluginVersion, this.$isProjectIsolationEnabled, this.$isProjectIsolationRequested, this.$isConfigurationCacheRequested);
                }
            });
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.9")) >= 0) {
                Intrinsics.checkNotNullExpressionValue((Object)generalConfigurationMetricsProvider2, (String)"generalConfigurationMetricsProvider");
                object = FlowActionBuildFusService.Companion.registerIfAbsentImpl$kotlin_gradle_plugin_common(project, buildUidService, (Provider<MetricContainer>)generalConfigurationMetricsProvider2);
            } else if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) >= 0) {
                Intrinsics.checkNotNullExpressionValue((Object)generalConfigurationMetricsProvider2, (String)"generalConfigurationMetricsProvider");
                object = ConfigurationMetricParameterFlowActionBuildFusService.Companion.registerIfAbsentImpl$kotlin_gradle_plugin_common(project, buildUidService, (Provider<MetricContainer>)generalConfigurationMetricsProvider2);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)generalConfigurationMetricsProvider2, (String)"generalConfigurationMetricsProvider");
                object = fusService = CloseActionBuildFusService.Companion.registerIfAbsentImpl$kotlin_gradle_plugin_common(project, buildUidService, (Provider<MetricContainer>)generalConfigurationMetricsProvider2);
            }
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"7.4")) >= 0 || !ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheEnabled(project) || !Intrinsics.areEqual((Object)CurrentBuildIdentifierKt.currentBuildId(project).getName(), (Object)"buildSrc")) {
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(fusService);
            }
            return fusService;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "buildStatisticsConfiguration", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsConfiguration;", "getBuildStatisticsConfiguration", "generalConfigurationMetrics", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "getGeneralConfigurationMetrics", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<MetricContainer> getGeneralConfigurationMetrics();

        @NotNull
        public Property<KotlinBuildStatsConfiguration> getBuildStatisticsConfiguration();

        @NotNull
        public Property<String> getBuildId();
    }
}

