/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.lang3;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.kotlin.org.apache.commons.lang3.ClassUtils;
import org.jetbrains.kotlin.org.apache.commons.lang3.StringUtils;

public class Validate {
    private static final String DEFAULT_NOT_NAN_EX_MESSAGE = "The validated value is not a number";
    private static final String DEFAULT_FINITE_EX_MESSAGE = "The value is invalid: %f";
    private static final String DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified exclusive range of %s to %s";
    private static final String DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified inclusive range of %s to %s";
    private static final String DEFAULT_MATCHES_PATTERN_EX = "The string %s does not match the pattern %s";
    private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
    private static final String DEFAULT_IS_TRUE_EX_MESSAGE = "The validated expression is false";
    private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
    private static final String DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE = "The validated collection contains null element at index: %d";
    private static final String DEFAULT_NOT_BLANK_EX_MESSAGE = "The validated character sequence is blank";
    private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";
    private static final String DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence is empty";
    private static final String DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE = "The validated collection is empty";
    private static final String DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE = "The validated map is empty";
    private static final String DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE = "The validated array index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE = "The validated collection index is invalid: %d";
    private static final String DEFAULT_VALID_STATE_EX_MESSAGE = "The validated state is false";
    private static final String DEFAULT_IS_ASSIGNABLE_EX_MESSAGE = "Cannot assign a %s to a %s";
    private static final String DEFAULT_IS_INSTANCE_OF_EX_MESSAGE = "Expected type: %s, actual: %s";

    public static void exclusiveBetween(double start2, double end, double value2) {
        if (value2 <= start2 || value2 >= end) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end));
        }
    }

    public static void exclusiveBetween(double start2, double end, double value2, String message2) {
        if (value2 <= start2 || value2 >= end) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void exclusiveBetween(long start2, long end, long value2) {
        if (value2 <= start2 || value2 >= end) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end));
        }
    }

    public static void exclusiveBetween(long start2, long end, long value2, String message2) {
        if (value2 <= start2 || value2 >= end) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static <T> void exclusiveBetween(T start2, T end, Comparable<T> value2) {
        if (value2.compareTo(start2) <= 0 || value2.compareTo(end) >= 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end));
        }
    }

    public static <T> void exclusiveBetween(T start2, T end, Comparable<T> value2, String message2, Object ... values) {
        if (value2.compareTo(start2) <= 0 || value2.compareTo(end) >= 0) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    public static void finite(double value2) {
        Validate.finite(value2, DEFAULT_FINITE_EX_MESSAGE, value2);
    }

    public static void finite(double value2, String message2, Object ... values) {
        if (Double.isNaN(value2) || Double.isInfinite(value2)) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    private static String getMessage(String message2, Object ... values) {
        return ArrayUtils.isEmpty(values) ? message2 : String.format(message2, values);
    }

    public static void inclusiveBetween(double start2, double end, double value2) {
        if (value2 < start2 || value2 > end) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end));
        }
    }

    public static void inclusiveBetween(double start2, double end, double value2, String message2) {
        if (value2 < start2 || value2 > end) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void inclusiveBetween(long start2, long end, long value2) {
        if (value2 < start2 || value2 > end) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end));
        }
    }

    public static void inclusiveBetween(long start2, long end, long value2, String message2) {
        if (value2 < start2 || value2 > end) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static <T> void inclusiveBetween(T start2, T end, Comparable<T> value2) {
        if (value2.compareTo(start2) < 0 || value2.compareTo(end) > 0) {
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value2, start2, end));
        }
    }

    public static <T> void inclusiveBetween(T start2, T end, Comparable<T> value2, String message2, Object ... values) {
        if (value2.compareTo(start2) < 0 || value2.compareTo(end) > 0) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    public static void isAssignableFrom(Class<?> superType, Class<?> type) {
        if (type == null || superType == null || !superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_ASSIGNABLE_EX_MESSAGE, ClassUtils.getName(type, "null type"), ClassUtils.getName(superType, "null type")));
        }
    }

    public static void isAssignableFrom(Class<?> superType, Class<?> type, String message2, Object ... values) {
        if (!superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj2) {
        if (!type.isInstance(obj2)) {
            throw new IllegalArgumentException(String.format(DEFAULT_IS_INSTANCE_OF_EX_MESSAGE, type.getName(), ClassUtils.getName(obj2, "null")));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj2, String message2, Object ... values) {
        if (!type.isInstance(obj2)) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(DEFAULT_IS_TRUE_EX_MESSAGE);
        }
    }

    public static void isTrue(boolean expression, String message2, double value2) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message2, value2));
        }
    }

    public static void isTrue(boolean expression, String message2, long value2) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message2, value2));
        }
    }

    public static void isTrue(boolean expression, String message2, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    public static void matchesPattern(CharSequence input, String pattern) {
        if (!Pattern.matches(pattern, input)) {
            throw new IllegalArgumentException(String.format(DEFAULT_MATCHES_PATTERN_EX, input, pattern));
        }
    }

    public static void matchesPattern(CharSequence input, String pattern, String message2, Object ... values) {
        if (!Pattern.matches(pattern, input)) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable) {
        return Validate.noNullElements(iterable, DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable, String message2, Object ... values) {
        Objects.requireNonNull(iterable, "iterable");
        int i2 = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                Object[] values2 = ArrayUtils.addAll(values, i2);
                throw new IllegalArgumentException(Validate.getMessage(message2, values2));
            }
            ++i2;
        }
        return iterable;
    }

    public static <T> T[] noNullElements(T[] array2) {
        return Validate.noNullElements(array2, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array2, String message2, Object ... values) {
        Objects.requireNonNull(array2, "array");
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (array2[i2] != null) continue;
            Object[] values2 = ArrayUtils.add(values, Integer.valueOf(i2));
            throw new IllegalArgumentException(Validate.getMessage(message2, values2));
        }
        return array2;
    }

    public static <T extends CharSequence> T notBlank(T chars) {
        return Validate.notBlank(chars, DEFAULT_NOT_BLANK_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> T notBlank(T chars, String message2, Object ... values) {
        Objects.requireNonNull(chars, Validate.toSupplier(message2, values));
        if (StringUtils.isBlank(chars)) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
        return chars;
    }

    public static <T extends Collection<?>> T notEmpty(T collection) {
        return Validate.notEmpty(collection, DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Map<?, ?>> T notEmpty(T map2) {
        return Validate.notEmpty(map2, DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE, new Object[0]);
    }

    public static <T extends CharSequence> T notEmpty(T chars) {
        return Validate.notEmpty(chars, DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message2, Object ... values) {
        Objects.requireNonNull(collection, Validate.toSupplier(message2, values));
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T notEmpty(T map2, String message2, Object ... values) {
        Objects.requireNonNull(map2, Validate.toSupplier(message2, values));
        if (map2.isEmpty()) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
        return map2;
    }

    public static <T extends CharSequence> T notEmpty(T chars, String message2, Object ... values) {
        Objects.requireNonNull(chars, Validate.toSupplier(message2, values));
        if (chars.length() == 0) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
        return chars;
    }

    public static <T> T[] notEmpty(T[] array2) {
        return Validate.notEmpty(array2, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] notEmpty(T[] array2, String message2, Object ... values) {
        Objects.requireNonNull(array2, Validate.toSupplier(message2, values));
        if (array2.length == 0) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
        return array2;
    }

    public static void notNaN(double value2) {
        Validate.notNaN(value2, DEFAULT_NOT_NAN_EX_MESSAGE, new Object[0]);
    }

    public static void notNaN(double value2, String message2, Object ... values) {
        if (Double.isNaN(value2)) {
            throw new IllegalArgumentException(Validate.getMessage(message2, values));
        }
    }

    @Deprecated
    public static <T> T notNull(T object) {
        return Validate.notNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
    }

    public static <T> T notNull(T object, String message2, Object ... values) {
        return Objects.requireNonNull(object, Validate.toSupplier(message2, values));
    }

    private static Supplier<String> toSupplier(String message2, Object ... values) {
        return () -> Validate.getMessage(message2, values);
    }

    public static <T extends Collection<?>> T validIndex(T collection, int index) {
        return Validate.validIndex(collection, index, DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE, new Object[]{index});
    }

    public static <T extends CharSequence> T validIndex(T chars, int index) {
        return Validate.validIndex(chars, index, DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE, index);
    }

    public static <T extends Collection<?>> T validIndex(T collection, int index, String message2, Object ... values) {
        Objects.requireNonNull(collection, "collection");
        if (index < 0 || index >= collection.size()) {
            throw new IndexOutOfBoundsException(Validate.getMessage(message2, values));
        }
        return collection;
    }

    public static <T extends CharSequence> T validIndex(T chars, int index, String message2, Object ... values) {
        Objects.requireNonNull(chars, "chars");
        if (index < 0 || index >= chars.length()) {
            throw new IndexOutOfBoundsException(Validate.getMessage(message2, values));
        }
        return chars;
    }

    public static <T> T[] validIndex(T[] array2, int index) {
        return Validate.validIndex(array2, index, DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE, index);
    }

    public static <T> T[] validIndex(T[] array2, int index, String message2, Object ... values) {
        Objects.requireNonNull(array2, "array");
        if (index < 0 || index >= array2.length) {
            throw new IndexOutOfBoundsException(Validate.getMessage(message2, values));
        }
        return array2;
    }

    public static void validState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException(DEFAULT_VALID_STATE_EX_MESSAGE);
        }
    }

    public static void validState(boolean expression, String message2, Object ... values) {
        if (!expression) {
            throw new IllegalStateException(Validate.getMessage(message2, values));
        }
    }
}

