/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.ThreadDumper;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SameThreadExecutorService;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;

public final class ConcurrencyUtil {
    public static final long DEFAULT_TIMEOUT_MS = 10L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            ConcurrencyUtil.$$$reportNull$$$0(0);
        }
        if (executorService == null) {
            for (Callable<T> task2 : tasks) {
                task2.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future2 = executorService.submit(callable);
                futures.add(future2);
            }
            for (Future future2 : futures) {
                ((Runnable)((Object)future2)).run();
            }
            for (Future future3 : futures) {
                try {
                    future3.get();
                }
                catch (CancellationException future2) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future4 : futures) {
                    future4.cancel(false);
                }
            }
        }
        return futures;
    }

    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map2, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(1);
        }
        if (key == null) {
            ConcurrencyUtil.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(3);
        }
        if ((v = map2.get(key)) != null) {
            Object v2 = v;
            if (v2 == null) {
                ConcurrencyUtil.$$$reportNull$$$0(4);
            }
            return v2;
        }
        V prev = map2.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(5);
        }
        return v3;
    }

    @NotNull
    public static <T> T cacheOrGet(@NotNull AtomicReference<T> ref, @NotNull T defaultValue) {
        T value2;
        if (ref == null) {
            ConcurrencyUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            ConcurrencyUtil.$$$reportNull$$$0(7);
        }
        if ((value2 = ref.get()) != null) {
            T t = value2;
            if (t == null) {
                ConcurrencyUtil.$$$reportNull$$$0(8);
            }
            return t;
        }
        T t = ref.updateAndGet(prev -> prev == null ? defaultValue : prev);
        if (t == null) {
            ConcurrencyUtil.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String name) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(10);
        }
        return ConcurrencyUtil.newSingleThreadExecutor(name, 5);
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String name, int priority) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(11);
        }
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NotNull @NonNls String name) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(12);
        }
        return ConcurrencyUtil.newSingleScheduledThreadExecutor(name, 5);
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String name, int priority) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(13);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(14);
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ExecutorService newSameThreadExecutorService() {
        return new SameThreadExecutorService();
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(@NonNls @NotNull String name, boolean isDaemon, int priority) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(15);
        }
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r, name);
            thread.setDaemon(isDaemon);
            thread.setPriority(priority);
            return thread;
        };
        if (threadFactory == null) {
            ConcurrencyUtil.$$$reportNull$$$0(16);
        }
        return threadFactory;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(@NonNls @NotNull String name) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(17);
        }
        ThreadFactory threadFactory = r -> new Thread(r, name);
        if (threadFactory == null) {
            ConcurrencyUtil.$$$reportNull$$$0(18);
        }
        return threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestOnly
    public static void awaitQuiescence(@NotNull ThreadPoolExecutor executor, long timeout, @NotNull TimeUnit timeUnit) {
        HashSet workers;
        if (executor == null) {
            ConcurrencyUtil.$$$reportNull$$$0(19);
        }
        if (timeUnit == null) {
            ConcurrencyUtil.$$$reportNull$$$0(20);
        }
        executor.setKeepAliveTime(1L, TimeUnit.NANOSECONDS);
        executor.setCorePoolSize(0);
        ReentrantLock mainLock = ReflectionUtil.getField(executor.getClass(), executor, ReentrantLock.class, "mainLock");
        mainLock.lock();
        try {
            Set workersField = ReflectionUtil.getField(executor.getClass(), executor, HashSet.class, "workers");
            workers = new HashSet(workersField);
        }
        finally {
            mainLock.unlock();
        }
        for (Object worker : workers) {
            void unit;
            Thread thread = ReflectionUtil.getField(worker.getClass(), worker, Thread.class, "thread");
            try {
                thread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                @NonNls String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                @NonNls String message2 = "Executor " + executor + " is still active after " + unit.toSeconds(timeout) + " seconds://///\nThread " + thread + " dump:\n" + trace + "all thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n/////";
                System.err.println(message2);
                break;
            }
        }
    }

    public static void joinAll(@NotNull Collection<? extends Thread> threads) throws RuntimeException {
        if (threads == null) {
            ConcurrencyUtil.$$$reportNull$$$0(21);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void joinAll(Thread ... threads) throws RuntimeException {
        if (threads == null) {
            ConcurrencyUtil.$$$reportNull$$$0(22);
        }
        ConcurrencyUtil.joinAll(Arrays.asList(threads));
    }

    public static void getAll(@NotNull Collection<? extends Future<?>> futures) throws ExecutionException, InterruptedException {
        if (futures == null) {
            ConcurrencyUtil.$$$reportNull$$$0(23);
        }
        for (Future<?> future2 : futures) {
            future2.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void getAll(long timeout, @NotNull TimeUnit timeUnit, @NotNull @NotNull Collection<? extends @NotNull Future<?>> collection) throws ExecutionException, InterruptedException, TimeoutException {
        void futures;
        if (timeUnit == null) {
            ConcurrencyUtil.$$$reportNull$$$0(24);
        }
        if (collection == null) {
            ConcurrencyUtil.$$$reportNull$$$0(25);
        }
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        for (Future future2 : futures) {
            long toWait = deadline - System.nanoTime();
            if (toWait < 0L) {
                throw new TimeoutException();
            }
            try {
                future2.get(toWait, TimeUnit.NANOSECONDS);
            }
            catch (CancellationException cancellationException) {}
        }
    }

    @Contract(pure=true)
    @NotNull
    public static Runnable underThreadNameRunnable(@NotNull String name, @NotNull Runnable runnable) {
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(26);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(27);
        }
        Runnable runnable2 = () -> ConcurrencyUtil.runUnderThreadName(name, runnable);
        if (runnable2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(28);
        }
        return runnable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderThreadName(@NotNull String name, @NotNull Runnable runnable) {
        Thread currentThread;
        String oldThreadName;
        if (name == null) {
            ConcurrencyUtil.$$$reportNull$$$0(29);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(30);
        }
        if (name.equals(oldThreadName = (currentThread = Thread.currentThread()).getName())) {
            runnable.run();
        } else {
            currentThread.setName(name);
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(oldThreadName);
            }
        }
    }

    @NotNull
    public static Runnable once(@NotNull Runnable delegate2) {
        if (delegate2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(31);
        }
        AtomicBoolean done = new AtomicBoolean(false);
        Runnable runnable = () -> {
            if (done.compareAndSet(false, true)) {
                delegate2.run();
            }
        };
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(32);
        }
        return runnable;
    }

    @ApiStatus.Obsolete
    public static <T, E extends Throwable> T withLock(@NotNull Lock lock2, @NotNull ThrowableComputable<T, E> runnable) throws E {
        if (lock2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(33);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(34);
        }
        lock2.lock();
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            lock2.unlock();
        }
    }

    @ApiStatus.Obsolete
    public static <E extends Throwable> void withLock(@NotNull Lock lock2, @NotNull ThrowableRunnable<E> runnable) throws E {
        if (lock2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(35);
        }
        if (runnable == null) {
            ConcurrencyUtil.$$$reportNull$$$0(36);
        }
        lock2.lock();
        try {
            runnable.run();
        }
        finally {
            lock2.unlock();
        }
    }

    public static void manifestExceptionsIn(@NotNull Future<?> task2) throws RuntimeException, Error {
        if (task2 == null) {
            ConcurrencyUtil.$$$reportNull$$$0(37);
        }
        try {
            task2.get();
        }
        catch (InterruptedException | CancellationException exception) {
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrow(e.getCause());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 27: 
            case 30: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ConcurrencyUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newNamedThreadFactory";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "underThreadNameRunnable";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "once";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 32: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newSingleThreadExecutor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newSingleScheduledThreadExecutor";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newNamedThreadFactory";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "awaitQuiescence";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "joinAll";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "underThreadNameRunnable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runUnderThreadName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "once";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "withLock";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "manifestExceptionsIn";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

