/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> keyToValues;
    private final Map<V, Set<K>> valueToKeys;

    public BidirectionalMultiMap() {
        this(new HashMap(), new HashMap());
    }

    public BidirectionalMultiMap(@NotNull Map<K, Set<V>> key2Values, @NotNull Map<V, Set<K>> value2Keys) {
        if (key2Values == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(0);
        }
        if (value2Keys == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(1);
        }
        this.keyToValues = key2Values;
        this.valueToKeys = value2Keys;
    }

    @NotNull
    public Set<V> getValues(K key) {
        Set<V> set2 = this.keyToValues.get(key);
        Set<Object> set3 = set2 == null ? Collections.emptySet() : set2;
        if (set3 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(2);
        }
        return set3;
    }

    @NotNull
    public Set<K> getKeys(V value2) {
        Set<K> set2 = this.valueToKeys.get(value2);
        Set<Object> set3 = set2 == null ? Collections.emptySet() : set2;
        if (set3 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(3);
        }
        return set3;
    }

    public boolean containsKey(K key) {
        return this.keyToValues.containsKey(key);
    }

    public boolean containsValue(V value2) {
        return this.valueToKeys.containsKey(value2);
    }

    public boolean put(K key, V value2) {
        Set<K> keys = this.valueToKeys.get(value2);
        if (keys == null) {
            keys = this.createKeysSet();
            this.valueToKeys.put((Set<K>)value2, (Set<V>)keys);
        }
        keys.add(key);
        Set<V> values = this.keyToValues.get(key);
        if (values == null) {
            values = this.createValuesSet();
            this.keyToValues.put(key, values);
        }
        return values.add(value2);
    }

    @NotNull
    private Set<V> createValuesSet() {
        return new HashSet();
    }

    @NotNull
    private Set<K> createKeysSet() {
        return new HashSet();
    }

    public boolean removeKey(K key) {
        Set<V> values = this.keyToValues.get(key);
        if (values == null) {
            return false;
        }
        for (V v : values) {
            Set<K> keys = this.valueToKeys.get(v);
            keys.remove(key);
            if (!keys.isEmpty()) continue;
            this.valueToKeys.remove(v);
        }
        this.keyToValues.remove(key);
        return true;
    }

    public void remove(K key, V value2) {
        Set<V> values = this.keyToValues.get(key);
        Set<K> keys = this.valueToKeys.get(value2);
        if (keys != null && values != null) {
            keys.remove(key);
            values.remove(value2);
            if (keys.isEmpty()) {
                this.valueToKeys.remove(value2);
            }
            if (values.isEmpty()) {
                this.keyToValues.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.keyToValues.isEmpty() && this.valueToKeys.isEmpty();
    }

    public boolean removeValue(V value2) {
        Set<K> keys = this.valueToKeys.get(value2);
        if (keys == null) {
            return false;
        }
        for (K k : keys) {
            Set<V> values = this.keyToValues.get(k);
            values.remove(value2);
            if (!values.isEmpty()) continue;
            this.keyToValues.remove(k);
        }
        this.valueToKeys.remove(value2);
        return true;
    }

    public void clear() {
        this.keyToValues.clear();
        this.valueToKeys.clear();
    }

    public Set<K> getKeys() {
        return this.keyToValues.keySet();
    }

    public Set<V> getValues() {
        return this.valueToKeys.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key2Values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2Keys";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMultiMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMultiMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

