/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Iterator;
import org.jetbrains.kotlin.com.intellij.util.containers.Convertor;

public final class ConvertingIterator<Domain, Range>
implements Iterator<Range> {
    private final Iterator<? extends Domain> myBaseIterator;
    private final Convertor<? super Domain, ? extends Range> myConvertor;

    public ConvertingIterator(Iterator<? extends Domain> baseIterator, Convertor<? super Domain, ? extends Range> convertor) {
        this.myBaseIterator = baseIterator;
        this.myConvertor = convertor;
    }

    @Override
    public boolean hasNext() {
        return this.myBaseIterator.hasNext();
    }

    @Override
    public Range next() {
        return this.myConvertor.convert(this.myBaseIterator.next());
    }

    @Override
    public void remove() {
        this.myBaseIterator.remove();
    }

    public static <Domain, Intermediate, Range> Convertor<Domain, Range> composition(Convertor<? super Domain, ? extends Intermediate> convertor1, Convertor<? super Intermediate, ? extends Range> convertor2) {
        return domain -> convertor2.convert((Object)convertor1.convert((Object)domain));
    }

    public static <Domain, Range> ConvertingIterator<Domain, Range> create(Iterator<? extends Domain> iterator2, Convertor<? super Domain, ? extends Range> convertor) {
        return new ConvertingIterator<Domain, Range>(iterator2, convertor);
    }

    public static final class IdConvertor<T>
    implements Convertor<T, T> {
        @Override
        public T convert(T object) {
            return object;
        }
    }
}

