/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl;

import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SequentialTaskExecutor;
import org.jetbrains.kotlin.com.intellij.util.indexing.StorageException;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexStorage;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.MapIndexStorageCache;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.UpdatableValueContainer;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueContainerExternalizer;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueContainerMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.MeasurableIndexStore;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMapValueStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapBase;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapBuilder;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapImpl;

public class MapIndexStorage<Key, Value>
implements IndexStorage<Key, Value>,
MeasurableIndexStore {
    private static final Logger LOG = Logger.getInstance(MapIndexStorage.class);
    private static final boolean ENABLE_WAL = SystemProperties.getBooleanProperty("idea.index.enable.wal", false);
    protected ValueContainerMap<Key, Value> myMap;
    private MapIndexStorageCache<Key, Value> myCache;
    protected final Path myBaseStorageFile;
    protected final KeyDescriptor<Key> myKeyDescriptor;
    private final int myCacheSize;
    private final DataExternalizer<Value> myDataExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;
    private final boolean myReadOnly;
    private final boolean myEnableWal;
    @NotNull
    private final ValueContainerInputRemapping myInputRemapping;

    public MapIndexStorage(Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile) throws IOException {
        if (keyDescriptor == null) {
            MapIndexStorage.$$$reportNull$$$0(0);
        }
        if (valueExternalizer == null) {
            MapIndexStorage.$$$reportNull$$$0(1);
        }
        this(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, true, false, false, null);
    }

    public MapIndexStorage(Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean initialize, boolean readOnly, boolean enableWal, @Nullable ValueContainerInputRemapping inputRemapping) throws IOException {
        if (keyDescriptor == null) {
            MapIndexStorage.$$$reportNull$$$0(2);
        }
        if (valueExternalizer == null) {
            MapIndexStorage.$$$reportNull$$$0(3);
        }
        this.myBaseStorageFile = storageFile;
        this.myKeyDescriptor = keyDescriptor;
        this.myCacheSize = cacheSize;
        this.myDataExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
        this.myReadOnly = readOnly;
        this.myEnableWal = enableWal;
        if (inputRemapping != null) {
            LOG.assertTrue(this.myReadOnly, "input remapping allowed only for read-only storage");
        } else {
            inputRemapping = ValueContainerInputRemapping.IDENTITY;
        }
        this.myInputRemapping = inputRemapping;
        if (initialize) {
            this.initMapAndCache();
        }
    }

    protected void initMapAndCache() throws IOException {
        ValueContainerMap map2 = this.createValueContainerMap();
        this.myCache = MapIndexStorageCacheProvider.Companion.getActualProvider().createCache(key -> map2.getModifiableValueContainer(key), (key, container) -> this.onDropFromCache((Key)key, (ChangeTrackingValueContainer<Value>)container), this.myKeyDescriptor, this.myCacheSize);
        this.myMap = map2;
    }

    private void onDropFromCache(Key key, @NotNull ChangeTrackingValueContainer<Value> valueContainer) {
        if (valueContainer == null) {
            MapIndexStorage.$$$reportNull$$$0(4);
        }
        try {
            if (!this.myReadOnly && valueContainer.isDirty()) {
                if (this.myKeyIsUniqueForIndexedFile) {
                    if (valueContainer.containsOnlyInvalidatedChange()) {
                        this.myMap.remove(key);
                        return;
                    }
                    if (valueContainer.containsCachedMergedData()) {
                        valueContainer.setNeedsCompacting(true);
                    }
                }
                this.myMap.merge(key, valueContainer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected PersistentMapBase<Key, UpdatableValueContainer<Value>> createPersistentMap(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<UpdatableValueContainer<Value>> valueContainerExternalizer, boolean isReadOnly, boolean compactOnClose, boolean keyIsUniqueForIndexedFile) throws IOException {
        if (keyDescriptor == null) {
            MapIndexStorage.$$$reportNull$$$0(5);
        }
        if (valueContainerExternalizer == null) {
            MapIndexStorage.$$$reportNull$$$0(6);
        }
        PersistentHashMapValueStorage.CreationTimeOptions creationOptions = PersistentHashMapValueStorage.CreationTimeOptions.threadLocalOptions().setCompactChunksWithValueDeserialization();
        if (keyIsUniqueForIndexedFile) {
            creationOptions = creationOptions.setHasNoChunks();
        }
        PersistentMapBase persistentMapBase = creationOptions.with(() -> new PersistentMapImpl(PersistentMapBuilder.newBuilder(this.getStorageFile(), keyDescriptor, valueContainerExternalizer).withWal(this.myEnableWal && ENABLE_WAL && !isReadOnly).withWalExecutor(SequentialTaskExecutor.createSequentialApplicationPoolExecutor("Index Wal Pool")).withReadonly(isReadOnly).withCompactOnClose(compactOnClose)));
        if (persistentMapBase == null) {
            MapIndexStorage.$$$reportNull$$$0(7);
        }
        return persistentMapBase;
    }

    @NotNull
    private ValueContainerMap<Key, Value> createValueContainerMap() throws IOException {
        ValueContainerExternalizer<Value> valueContainerExternalizer = new ValueContainerExternalizer<Value>(this.myDataExternalizer, this.myInputRemapping);
        PersistentMapBase<Key, UpdatableValueContainer<Value>> persistentMap = this.createPersistentMap(this.myKeyDescriptor, valueContainerExternalizer, this.myReadOnly, this.compactOnClose(), this.myKeyIsUniqueForIndexedFile);
        return new ValueContainerMap<Key, Value>(persistentMap, this.myKeyDescriptor, this.myDataExternalizer, this.myKeyIsUniqueForIndexedFile);
    }

    @Override
    public void updateValue(Key key, int inputId, Value newValue) throws StorageException {
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            this.myMap.markDirty();
            if (this.myKeyIsUniqueForIndexedFile) {
                MapIndexStorage.assertKeyInputIdConsistency(key, inputId);
                this.updateSingleValueDirectly(key, inputId, newValue);
            } else {
                IndexStorage.super.updateValue(key, inputId, newValue);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void addValue(Key key, int inputId, Value value2) throws StorageException {
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            this.myMap.markDirty();
            if (this.myKeyIsUniqueForIndexedFile) {
                MapIndexStorage.assertKeyInputIdConsistency(key, inputId);
                this.putSingleValueDirectly(key, inputId, value2);
            } else {
                ((ChangeTrackingValueContainer)this.read((Object)key)).addValue(inputId, value2);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            MapIndexStorage.$$$reportNull$$$0(8);
        }
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            this.myMap.markDirty();
            if (this.myKeyIsUniqueForIndexedFile) {
                MapIndexStorage.assertKeyInputIdConsistency(key, inputId);
                this.removeSingleValueDirectly(key, inputId);
            } else {
                ((ChangeTrackingValueContainer)this.read((Object)key)).removeAssociatedValue(inputId);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @NotNull
    private Path getStorageFile() {
        return MapIndexStorage.getIndexStorageFile(this.myBaseStorageFile);
    }

    @Override
    public void flush() throws IOException {
        if (!this.myMap.isClosed()) {
            this.clearCachedMappings();
            if (this.myMap.isDirty()) {
                this.myMap.force();
            }
        }
    }

    @Override
    public boolean isDirty() {
        if (this.myMap.isDirty()) {
            return true;
        }
        for (ChangeTrackingValueContainer<Value> container : this.myCache.getCachedValues()) {
            if (!container.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int keysCountApproximately() {
        return this.myMap.getStorageMap().keysCount();
    }

    protected boolean compactOnClose() {
        return false;
    }

    @Override
    public void close() throws StorageException {
        try {
            this.flush();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.myMap.closeAndDelete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.initMapAndCache();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) throws StorageException {
        ChangeTrackingValueContainer<Value> changeTrackingValueContainer;
        try {
            changeTrackingValueContainer = this.myCache.read(key);
        }
        catch (RuntimeException e) {
            ChangeTrackingValueContainer changeTrackingValueContainer2 = (ChangeTrackingValueContainer)MapIndexStorage.unwrapCauseAndRethrow(e);
            if (changeTrackingValueContainer2 == null) {
                MapIndexStorage.$$$reportNull$$$0(10);
            }
            return changeTrackingValueContainer2;
        }
        if (changeTrackingValueContainer == null) {
            MapIndexStorage.$$$reportNull$$$0(9);
        }
        return changeTrackingValueContainer;
    }

    private void removeSingleValueDirectly(Key key, int inputId) throws IOException {
        assert (this.myKeyIsUniqueForIndexedFile);
        ChangeTrackingValueContainer<Value> cached = this.readIfCached(key);
        if (cached != null) {
            cached.removeAssociatedValue(inputId);
            return;
        }
        this.myMap.remove(key);
    }

    private void updateSingleValueDirectly(Key key, int inputId, Value newValue) throws IOException {
        assert (this.myKeyIsUniqueForIndexedFile);
        ChangeTrackingValueContainer<Value> cached = this.readIfCached(key);
        if (cached != null) {
            cached.removeAssociatedValue(inputId);
            cached.addValue(inputId, newValue);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = new ChangeTrackingValueContainer<Value>(null);
        valueContainer.addValue(inputId, newValue);
        this.myMap.merge(key, valueContainer);
    }

    private void putSingleValueDirectly(Key key, int inputId, Value value2) throws IOException {
        assert (this.myKeyIsUniqueForIndexedFile);
        ChangeTrackingValueContainer<Value> cached = this.readIfCached(key);
        if (cached != null) {
            cached.addValue(inputId, value2);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = new ChangeTrackingValueContainer<Value>(null);
        valueContainer.addValue(inputId, value2);
        this.myMap.merge(key, valueContainer);
    }

    @Nullable
    private ChangeTrackingValueContainer<Value> readIfCached(Key key) {
        return this.myCache.readIfCached(key);
    }

    private static void assertKeyInputIdConsistency(@NotNull Object key, int inputId) {
        if (key == null) {
            MapIndexStorage.$$$reportNull$$$0(11);
        }
        assert ((Integer)key == inputId);
    }

    @Override
    public void clearCaches() {
        for (ChangeTrackingValueContainer<Value> container : this.myCache.getCachedValues()) {
            container.dropMergedData();
        }
    }

    @ApiStatus.Internal
    public final void clearCachedMappings() {
        this.myCache.invalidateAll();
    }

    protected static <T> T unwrapCauseAndRethrow(RuntimeException e) throws StorageException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw new StorageException(cause);
        }
        if (cause instanceof StorageException) {
            throw (StorageException)cause;
        }
        throw e;
    }

    @TestOnly
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws StorageException {
        if (processor == null) {
            MapIndexStorage.$$$reportNull$$$0(12);
        }
        try {
            this.clearCachedMappings();
            return this.doProcessKeys(processor);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
            return false;
        }
    }

    protected boolean doProcessKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            MapIndexStorage.$$$reportNull$$$0(13);
        }
        return this.myMap.processKeys(processor);
    }

    @TestOnly
    public PersistentMapBase<Key, UpdatableValueContainer<Value>> getIndexMap() {
        return this.myMap.getStorageMap();
    }

    @NotNull
    public static Path getIndexStorageFile(@NotNull Path baseFile) {
        if (baseFile == null) {
            MapIndexStorage.$$$reportNull$$$0(14);
        }
        Path path = baseFile.resolveSibling(baseFile.getFileName() + ".storage");
        if (path == null) {
            MapIndexStorage.$$$reportNull$$$0(15);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueContainer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueContainerExternalizer";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/MapIndexStorage";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/MapIndexStorage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPersistentMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexStorageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onDropFromCache";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPersistentMap";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertKeyInputIdConsistency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doProcessKeys";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndexStorageFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

