/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\b\t\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u001f\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001f\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001f\u0010\u001dR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001d\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/incremental/TrackedLookupMap;", "", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "lookupMap", "", "trackChanges", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/LookupMap;Z)V", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "key", "", "", "get", "(Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;)Ljava/util/Set;", "fileIds", "", "set", "(Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;Ljava/util/Set;)V", "append", "remove", "(Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;)V", "recordSet", "recordRemove", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "Z", "", "addedKeys", "Ljava/util/Set;", "getAddedKeys", "()Ljava/util/Set;", "removedKeys", "getRemovedKeys", "getKeys", "keys", "kotlin-build-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
final class TrackedLookupMap {
    @NotNull
    private final LookupMap lookupMap;
    private final boolean trackChanges;
    @Nullable
    private final Set<LookupSymbolKey> addedKeys;
    @Nullable
    private final Set<LookupSymbolKey> removedKeys;

    public TrackedLookupMap(@NotNull LookupMap lookupMap, boolean trackChanges) {
        Intrinsics.checkNotNullParameter((Object)lookupMap, (String)"lookupMap");
        this.lookupMap = lookupMap;
        this.trackChanges = trackChanges;
        this.addedKeys = this.trackChanges ? (Set)new LinkedHashSet() : null;
        this.removedKeys = this.trackChanges ? (Set)new LinkedHashSet() : null;
    }

    @Nullable
    public final Set<LookupSymbolKey> getAddedKeys() {
        return this.addedKeys;
    }

    @Nullable
    public final Set<LookupSymbolKey> getRemovedKeys() {
        return this.removedKeys;
    }

    @NotNull
    public final Set<LookupSymbolKey> getKeys() {
        return this.lookupMap.getKeys();
    }

    @Nullable
    public final Set<Integer> get(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.lookupMap.get(key);
    }

    public final void set(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.recordSet(key);
        this.lookupMap.set(key, fileIds);
    }

    public final void append(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.recordSet(key);
        this.lookupMap.append(key, fileIds);
    }

    public final void remove(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.recordRemove(key);
        this.lookupMap.remove(key);
    }

    private final void recordSet(LookupSymbolKey key) {
        if (!this.trackChanges) {
            return;
        }
        LookupSymbolKey lookupSymbolKey = key;
        if (!this.lookupMap.contains(lookupSymbolKey)) {
            Set<LookupSymbolKey> set2 = this.removedKeys;
            Intrinsics.checkNotNull(set2);
            if (set2.contains(lookupSymbolKey)) {
                this.removedKeys.remove(key);
            } else {
                Set<LookupSymbolKey> set3 = this.addedKeys;
                Intrinsics.checkNotNull(set3);
                set3.add(key);
            }
        }
    }

    private final void recordRemove(LookupSymbolKey key) {
        if (!this.trackChanges) {
            return;
        }
        LookupSymbolKey lookupSymbolKey = key;
        if (this.lookupMap.contains(lookupSymbolKey)) {
            Set<LookupSymbolKey> set2 = this.addedKeys;
            Intrinsics.checkNotNull(set2);
            if (set2.contains(lookupSymbolKey)) {
                this.addedKeys.remove(key);
            } else {
                Set<LookupSymbolKey> set3 = this.removedKeys;
                Intrinsics.checkNotNull(set3);
                set3.add(key);
            }
        }
    }
}

