/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanSpliterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObject2BooleanFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterators;

public abstract class AbstractObject2BooleanMap<K>
extends AbstractObject2BooleanFunction<K>
implements Object2BooleanMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2BooleanMap() {
    }

    @Override
    public boolean containsKey(Object k) {
        Iterator i2 = this.object2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Object2BooleanMap.Entry)i2.next()).getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(boolean v) {
        Iterator i2 = this.object2BooleanEntrySet().iterator();
        while (i2.hasNext()) {
            if (((Object2BooleanMap.Entry)i2.next()).getBooleanValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractObject2BooleanMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractObject2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2BooleanMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Object2BooleanMap.Entry<K>> i;
                    {
                        this.i = Object2BooleanMaps.fastIterator(AbstractObject2BooleanMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Object2BooleanMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super K> action2) {
                        this.i.forEachRemaining((? super E entry2) -> action2.accept((Object)entry2.getKey()));
                    }
                };
            }

            @Override
            public ObjectSpliterator<K> spliterator() {
                return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractObject2BooleanMap.this), 65);
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            @Override
            public boolean contains(boolean k) {
                return AbstractObject2BooleanMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractObject2BooleanMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2BooleanMap.this.clear();
            }

            @Override
            public BooleanIterator iterator() {
                return new BooleanIterator(){
                    private final ObjectIterator<Object2BooleanMap.Entry<K>> i;
                    {
                        this.i = Object2BooleanMaps.fastIterator(AbstractObject2BooleanMap.this);
                    }

                    @Override
                    public boolean nextBoolean() {
                        return ((Object2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(BooleanConsumer action2) {
                        this.i.forEachRemaining((? super E entry2) -> action2.accept(entry2.getBooleanValue()));
                    }
                };
            }

            @Override
            public BooleanSpliterator spliterator() {
                return BooleanSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractObject2BooleanMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Boolean> m) {
        if (m instanceof Object2BooleanMap) {
            ObjectIterator i2 = Object2BooleanMaps.fastIterator((Object2BooleanMap)m);
            while (i2.hasNext()) {
                Object2BooleanMap.Entry e = (Object2BooleanMap.Entry)i2.next();
                this.put(e.getKey(), e.getBooleanValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<K, Boolean>> i3 = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<K, Boolean> e = i3.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i2 = Object2BooleanMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Object2BooleanMap.Entry)i2.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.object2BooleanEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i2 = Object2BooleanMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Object2BooleanMap.Entry e = (Object2BooleanMap.Entry)i2.next();
            if (this == e.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(e.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(e.getBooleanValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Object2BooleanMap.Entry<K>> {
        protected final Object2BooleanMap<K> map;

        public BasicEntrySet(Object2BooleanMap<K> map2) {
            this.map = map2;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2BooleanMap.Entry) {
                Object2BooleanMap.Entry e = (Object2BooleanMap.Entry)o;
                Object k = e.getKey();
                return this.map.containsKey(k) && this.map.getBoolean(k) == e.getBooleanValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.getBoolean(k) == ((Boolean)value2).booleanValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2BooleanMap.Entry) {
                Object2BooleanMap.Entry e = (Object2BooleanMap.Entry)o;
                return this.map.remove(e.getKey(), e.getBooleanValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            boolean v = (Boolean)value2;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Object2BooleanMap.Entry<K>> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry<K>
    implements Object2BooleanMap.Entry<K> {
        protected K key;
        protected boolean value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Boolean value2) {
            this.key = key;
            this.value = value2;
        }

        public BasicEntry(K key, boolean value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public boolean getBooleanValue() {
            return this.value;
        }

        @Override
        public boolean setValue(boolean value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2BooleanMap.Entry) {
                Object2BooleanMap.Entry e = (Object2BooleanMap.Entry)o;
                return Objects.equals(this.key, e.getKey()) && this.value == e.getBooleanValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value2 = e.getValue();
            if (value2 == null || !(value2 instanceof Boolean)) {
                return false;
            }
            return Objects.equals(this.key, key) && this.value == (Boolean)value2;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

