/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.containers;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.ChangeBufferingList;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.IntIdsIterator;
import org.jetbrains.kotlin.com.intellij.util.indexing.containers.RandomAccessIntContainer;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueContainerImpl;

final class IdBitSet
implements Cloneable,
RandomAccessIntContainer {
    private static final int SHIFT = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int MASK = 63;
    private long[] myBitMask;
    private int myBitsSet;
    private int myLastUsedSlot;
    private int myBase = -1;

    IdBitSet(int capacity) {
        this.myBitMask = new long[(IdBitSet.calcCapacity(capacity) >> 6) + 1];
    }

    IdBitSet(int[] set, int count, int additional) {
        this(ChangeBufferingList.calcMinMax(set, count), additional);
        for (int i2 = 0; i2 < count; ++i2) {
            this.add(set[i2]);
        }
    }

    IdBitSet(RandomAccessIntContainer set, int additionalCount) {
        this(IdBitSet.calcMax(set), additionalCount);
        IntIdsIterator iterator2 = set.intIterator();
        while (iterator2.hasNext()) {
            this.add(iterator2.next());
        }
    }

    private static int[] calcMax(RandomAccessIntContainer set) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        IntIdsIterator iterator2 = set.intIterator();
        while (iterator2.hasNext()) {
            int next = iterator2.next();
            min = Math.min(min, next);
            max = Math.max(max, next);
        }
        return new int[]{min, max};
    }

    IdBitSet(int[] minMax, int additionalCount) {
        int base;
        int min = minMax[0];
        this.myBase = base = IdBitSet.roundToNearest(min);
        this.myBitMask = new long[(IdBitSet.calcCapacity(minMax[1] - base) + additionalCount >> 6) + 1];
    }

    static int roundToNearest(int min) {
        return min >> 6 << 6;
    }

    @Override
    public boolean add(int bitIndex) {
        boolean set = this.contains(bitIndex);
        if (!set) {
            if (this.myBase < 0) {
                this.myBase = IdBitSet.roundToNearest(bitIndex);
            } else if (bitIndex < this.myBase) {
                int newBase = IdBitSet.roundToNearest(bitIndex);
                int wordDiff = this.myBase - newBase >> 6;
                long[] n = new long[wordDiff + this.myBitMask.length];
                System.arraycopy(this.myBitMask, 0, n, wordDiff, this.myBitMask.length);
                this.myBitMask = n;
                this.myBase = newBase;
                this.myLastUsedSlot += wordDiff;
            }
            ++this.myBitsSet;
            int wordIndex = (bitIndex -= this.myBase) >> 6;
            if (wordIndex >= this.myBitMask.length) {
                this.myBitMask = ArrayUtil.realloc(this.myBitMask, Math.max(IdBitSet.calcCapacity(this.myBitMask.length), wordIndex + 1));
            }
            int n = wordIndex;
            this.myBitMask[n] = this.myBitMask[n] | 1L << (bitIndex & 0x3F);
            this.myLastUsedSlot = Math.max(this.myLastUsedSlot, wordIndex);
        }
        return !set;
    }

    private static int calcCapacity(int length) {
        return length + 3 * (length / 5);
    }

    @Override
    public int size() {
        return this.myBitsSet;
    }

    @Override
    public boolean remove(int bitIndex) {
        int wordIndex;
        if (bitIndex < this.myBase || this.myBase < 0) {
            return false;
        }
        if (!this.contains(bitIndex)) {
            return false;
        }
        --this.myBitsSet;
        int n = wordIndex = (bitIndex -= this.myBase) >> 6;
        this.myBitMask[n] = this.myBitMask[n] & (1L << (bitIndex & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        if (wordIndex == this.myLastUsedSlot) {
            while (this.myLastUsedSlot >= 0 && this.myBitMask[this.myLastUsedSlot] == 0L) {
                --this.myLastUsedSlot;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        return this.size() == 0 ? ValueContainerImpl.EMPTY_ITERATOR : new Iterator();
    }

    @Override
    public void compact() {
    }

    @Override
    public boolean contains(int bitIndex) {
        if (bitIndex < this.myBase || this.myBase < 0) {
            return false;
        }
        int wordIndex = (bitIndex -= this.myBase) >> 6;
        boolean result2 = false;
        if (wordIndex < this.myBitMask.length) {
            result2 = (this.myBitMask[wordIndex] & 1L << (bitIndex & 0x3F)) != 0L;
        }
        return result2;
    }

    @Override
    @NotNull
    public RandomAccessIntContainer ensureContainerCapacity(int diff) {
        IdBitSet idBitSet = this;
        if (idBitSet == null) {
            IdBitSet.$$$reportNull$$$0(0);
        }
        return idBitSet;
    }

    @Override
    public IdBitSet clone() {
        try {
            IdBitSet clone = (IdBitSet)super.clone();
            if (this.myBitMask.length != this.myLastUsedSlot + 1) {
                this.myBitMask = Arrays.copyOf(this.myBitMask, this.myLastUsedSlot + 1);
            }
            clone.myBitMask = (long[])this.myBitMask.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getInstance(this.getClass().getName()).error(ex);
            return null;
        }
    }

    private int nextSetBit(int bitIndex) {
        int wordIndex;
        if (this.myBase < 0) {
            throw new IllegalStateException();
        }
        if (bitIndex >= this.myBase) {
            bitIndex -= this.myBase;
        }
        if ((wordIndex = bitIndex >> 6) > this.myLastUsedSlot) {
            return -1;
        }
        long word = this.myBitMask[wordIndex] & -1L << bitIndex;
        while (word == 0L) {
            if (++wordIndex > this.myLastUsedSlot) {
                return -1;
            }
            word = this.myBitMask[wordIndex];
        }
        return wordIndex * 64 + Long.numberOfTrailingZeros(word) + this.myBase;
    }

    public static int sizeInBytes(int max, int min) {
        return IdBitSet.calcCapacity((IdBitSet.roundToNearest(max) - IdBitSet.roundToNearest(min) >> 6) + 1) * 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/indexing/containers/IdBitSet", "ensureContainerCapacity"));
    }

    private final class Iterator
    implements IntIdsIterator {
        private int nextSetBit;

        private Iterator() {
            this.nextSetBit = IdBitSet.this.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextSetBit != -1;
        }

        @Override
        public int next() {
            int setBit = this.nextSetBit;
            this.nextSetBit = IdBitSet.this.nextSetBit(setBit + 1);
            return setBit;
        }

        @Override
        public int size() {
            return IdBitSet.this.size();
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new Iterator();
        }
    }
}

