/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils.processes;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.processes.ExecAsyncHandle;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\f\u0010\u001a\u001a\u00060\u000ej\u0002`\u000fH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/processes/ExecAsyncHandleImpl;", "Lorg/jetbrains/kotlin/gradle/utils/processes/ExecAsyncHandle;", "displayName", "", "abortTimeout", "Ljava/time/Duration;", "run", "Lkotlin/Function0;", "Lorg/gradle/process/ExecResult;", "(Ljava/lang/String;Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)V", "getDisplayName", "()Ljava/lang/String;", "failure", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logTag", "result", "thread", "Ljava/lang/Thread;", "abort", "", "isAlive", "", "start", "waitForCompletion", "waitForFailure", "waitForResult", "Companion", "kotlin-gradle-plugin_common"})
final class ExecAsyncHandleImpl
implements ExecAsyncHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String displayName;
    @NotNull
    private final Duration abortTimeout;
    @NotNull
    private final Function0<ExecResult> run;
    @NotNull
    private final String logTag;
    @NotNull
    private final AtomicReference<ExecResult> result;
    @NotNull
    private final AtomicReference<Exception> failure;
    @NotNull
    private final Thread thread;
    @NotNull
    private static final Logger logger;

    public ExecAsyncHandleImpl(@NotNull String displayName, @NotNull Duration abortTimeout, @NotNull Function0<? extends ExecResult> run2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)abortTimeout, (String)"abortTimeout");
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        this.displayName = displayName;
        this.abortTimeout = abortTimeout;
        this.run = run2;
        this.logTag = "[ExecAsyncHandle " + this.getDisplayName() + ']';
        this.result = new AtomicReference<Object>(null);
        this.failure = new AtomicReference<Object>(null);
        String string2 = this.getDisplayName();
        this.thread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)string2, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ExecAsyncHandleImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExecAsyncHandleImpl.access$getLogger$cp().info(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0) + " started");
                try {
                    ExecAsyncHandleImpl.access$getResult$p(this.this$0).set(ExecAsyncHandleImpl.access$getRun$p(this.this$0).invoke());
                    ExecAsyncHandleImpl.access$getLogger$cp().info(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0) + " finished " + ExecAsyncHandleImpl.access$getResult$p(this.this$0).get());
                }
                catch (Exception e) {
                    ExecAsyncHandleImpl.access$getFailure$p(this.this$0).set(e);
                    ExecAsyncHandleImpl.access$getLogger$cp().info(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0) + " failed " + e);
                }
            }
        }), (int)20, null);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public ExecAsyncHandle start() {
        this.thread.start();
        return this;
    }

    @Override
    @Nullable
    public ExecResult waitForResult() {
        this.waitForCompletion();
        if (this.failure.get() != null) {
            return null;
        }
        ExecResult execResult = this.result.get();
        if (execResult == null) {
            boolean bl = false;
            String string2 = this.logTag + " result is null";
            throw new IllegalArgumentException(string2.toString());
        }
        return execResult;
    }

    @Override
    @NotNull
    public Exception waitForFailure() {
        this.waitForCompletion();
        Exception exception = this.failure.get();
        if (exception == null) {
            boolean bl = false;
            String string2 = this.logTag + " failure is null";
            throw new IllegalArgumentException(string2.toString());
        }
        return exception;
    }

    @Override
    public void abort() {
        this.thread.interrupt();
        logger.info(this.logTag + " aborted");
    }

    private final void waitForCompletion() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            logger.info(this.logTag + " interrupted " + ex);
            this.thread.interrupt();
            this.thread.join(this.abortTimeout.toMillis());
        }
    }

    @Override
    public boolean isAlive() {
        return !this.thread.isAlive();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getLogTag$p(ExecAsyncHandleImpl $this) {
        return $this.logTag;
    }

    public static final /* synthetic */ AtomicReference access$getResult$p(ExecAsyncHandleImpl $this) {
        return $this.result;
    }

    public static final /* synthetic */ Function0 access$getRun$p(ExecAsyncHandleImpl $this) {
        return $this.run;
    }

    public static final /* synthetic */ AtomicReference access$getFailure$p(ExecAsyncHandleImpl $this) {
        return $this.failure;
    }

    static {
        Logger logger = Logging.getLogger(ExecAsyncHandle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ExecAsyncHandle::class.java)");
        ExecAsyncHandleImpl.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/processes/ExecAsyncHandleImpl$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

