/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.name;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Name
implements Comparable<Name> {
    @NotNull
    private final String name;
    private final boolean special;

    private Name(@NotNull String name, boolean special) {
        if (name == null) {
            Name.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.special = special;
    }

    @NotNull
    public String asString() {
        String string2 = this.name;
        if (string2 == null) {
            Name.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String getIdentifier() {
        if (this.special) {
            throw new IllegalStateException("not identifier: " + this);
        }
        String string2 = this.asString();
        if (string2 == null) {
            Name.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean isSpecial() {
        return this.special;
    }

    @NotNull
    public String asStringStripSpecialMarkers() {
        if (this.isSpecial()) {
            String string2 = this.asString().substring(1, this.asString().length() - 1);
            if (string2 == null) {
                Name.$$$reportNull$$$0(3);
            }
            return string2;
        }
        String string3 = this.asString();
        if (string3 == null) {
            Name.$$$reportNull$$$0(4);
        }
        return string3;
    }

    @Override
    public int compareTo(Name that) {
        return this.name.compareTo(that.name);
    }

    @NotNull
    public static Name identifier(@NotNull String name) {
        if (name == null) {
            Name.$$$reportNull$$$0(5);
        }
        return new Name(name, false);
    }

    public static boolean isValidIdentifier(@NotNull String name) {
        if (name == null) {
            Name.$$$reportNull$$$0(6);
        }
        if (name.isEmpty() || name.startsWith("<")) {
            return false;
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (ch != '.' && ch != '/' && ch != '\\') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Name identifierIfValid(@NotNull String name) {
        if (name == null) {
            Name.$$$reportNull$$$0(7);
        }
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    @NotNull
    public static Name special(@NotNull String name) {
        if (name == null) {
            Name.$$$reportNull$$$0(8);
        }
        if (!name.startsWith("<")) {
            throw new IllegalArgumentException("special name must start with '<': " + name);
        }
        return new Name(name, true);
    }

    @NotNull
    public static Name guessByFirstCharacter(@NotNull String name) {
        if (name == null) {
            Name.$$$reportNull$$$0(9);
        }
        if (name.startsWith("<")) {
            return Name.special(name);
        }
        return Name.identifier(name);
    }

    @Nullable
    public String getIdentifierOrNullIfSpecial() {
        if (this.special) {
            return null;
        }
        return this.asString();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name name1 = (Name)o;
        if (this.special != name1.special) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + (this.special ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/gradle/internal/name/Name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/gradle/internal/name/Name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asStringStripSpecialMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "identifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidIdentifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "identifierIfValid";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "special";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessByFirstCharacter";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

