/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.CDATA;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.ImmutableCDATA;
import org.jetbrains.kotlin.org.jdom.ImmutableElement;
import org.jetbrains.kotlin.org.jdom.ImmutableSameTypeAttributeList;
import org.jetbrains.kotlin.org.jdom.ImmutableText;
import org.jetbrains.kotlin.org.jdom.Text;

public final class JDOMInterner {
    @ApiStatus.Internal
    public static final JDOMInterner INSTANCE = new JDOMInterner();
    private final Interner<String> myStrings = Interner.createStringInterner();
    private final ObjectOpenCustomHashSet<Element> myElements = new ObjectOpenCustomHashSet<Element>(new Hash.Strategy<Element>(){

        @Override
        public int hashCode(Element e) {
            return JDOMInterner.hashCode(e);
        }

        @Override
        public boolean equals(Element o1, Element o2) {
            return JDOMInterner.equals(o1, o2);
        }
    });
    private final ObjectOpenCustomHashSet<Text> myTexts = new ObjectOpenCustomHashSet<Text>(new Hash.Strategy<Text>(){

        @Override
        public int hashCode(Text object) {
            return JDOMInterner.computeTextHashCode(object);
        }

        @Override
        public boolean equals(Text o1, Text o2) {
            return o1 == o2 || o1 != null && o2 != null && Comparing.strEqual(o1.getValue(), o2.getValue());
        }
    });

    private static int computeAttributesHashCode(Element e) {
        List<Attribute> attributes2 = JDOMUtil.getAttributes(e);
        if (attributes2 instanceof ImmutableSameTypeAttributeList) {
            return attributes2.hashCode();
        }
        int result2 = 1;
        for (Attribute attribute : attributes2) {
            result2 = result2 * 31 + JDOMInterner.computeAttributeHashCode(attribute.getName(), attribute.getValue());
        }
        return result2;
    }

    private static boolean attributesEqual(Element o1, Element o2) {
        if (o1 instanceof ImmutableElement) {
            return ((ImmutableElement)o1).attributesEqual(o2);
        }
        if (o2 instanceof ImmutableElement) {
            return ((ImmutableElement)o2).attributesEqual(o1);
        }
        List<Attribute> a1 = JDOMUtil.getAttributes(o1);
        List<Attribute> a2 = JDOMUtil.getAttributes(o2);
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a1.size(); ++i2) {
            Attribute attr2;
            Attribute attr1 = a1.get(i2);
            if (ImmutableElement.attributesEqual(attr1, attr2 = a2.get(i2))) continue;
            return false;
        }
        return true;
    }

    static int computeAttributeHashCode(String name, String value2) {
        return name.hashCode() * 31 + (value2 == null ? 0 : value2.hashCode());
    }

    private static int computeTextHashCode(Text object) {
        return object.getValue().hashCode();
    }

    @NotNull
    public synchronized Element internElement(@NotNull Element element) {
        if (element == null) {
            JDOMInterner.$$$reportNull$$$0(0);
        }
        if (element instanceof ImmutableElement) {
            Element element2 = element;
            if (element2 == null) {
                JDOMInterner.$$$reportNull$$$0(1);
            }
            return element2;
        }
        for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            return new ImmutableElement(element, this);
        }
        Element interned = this.myElements.get(element);
        if (interned == null) {
            interned = new ImmutableElement(element, this);
            this.myElements.add(interned);
        }
        Element element3 = interned;
        if (element3 == null) {
            JDOMInterner.$$$reportNull$$$0(2);
        }
        return element3;
    }

    public static boolean isInterned(@NotNull Element element) {
        if (element == null) {
            JDOMInterner.$$$reportNull$$$0(3);
        }
        return element instanceof ImmutableElement;
    }

    @NotNull
    synchronized Text internText(@NotNull Text text) {
        if (text == null) {
            JDOMInterner.$$$reportNull$$$0(4);
        }
        if (text instanceof ImmutableText || text instanceof ImmutableCDATA) {
            Text text2 = text;
            if (text2 == null) {
                JDOMInterner.$$$reportNull$$$0(5);
            }
            return text2;
        }
        Object interned = this.myTexts.get(text);
        if (interned == null) {
            interned = text instanceof CDATA ? new ImmutableCDATA(text.getText()) : new ImmutableText(this.myStrings.intern(text.getText()));
            this.myTexts.add((Text)interned);
        }
        Text text3 = interned;
        if (text3 == null) {
            JDOMInterner.$$$reportNull$$$0(6);
        }
        return text3;
    }

    synchronized String internString(String s) {
        return this.myStrings.intern(s);
    }

    public static int hashCode(@Nullable Element e) {
        if (e == null) {
            return 0;
        }
        int result2 = e.getName().hashCode() * 31;
        result2 += JDOMInterner.computeAttributesHashCode(e);
        List content = e.getContent();
        result2 = result2 * 31 + content.size();
        for (Content child : content) {
            if (child instanceof Text) {
                result2 = result2 * 31 + JDOMInterner.computeTextHashCode((Text)child);
                continue;
            }
            if (!(child instanceof Element)) continue;
            result2 = result2 * 31 + JDOMInterner.hashCode((Element)child);
            break;
        }
        return result2;
    }

    public static boolean equals(@Nullable Element o1, @Nullable Element o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null || !Comparing.strEqual(o1.getName(), o2.getName()) || !JDOMInterner.attributesEqual(o1, o2)) {
            return false;
        }
        List content1 = o1.getContent();
        List content2 = o2.getContent();
        if (content1.size() != content2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < content1.size(); ++i2) {
            Content c1 = (Content)content1.get(i2);
            Content c2 = (Content)content2.get(i2);
            if (c1 instanceof Text) {
                if (c2 instanceof Text && Comparing.strEqual(c1.getValue(), c2.getValue())) continue;
                return false;
            }
            if (c1 instanceof Element) {
                if (c2 instanceof Element && JDOMInterner.equals((Element)c1, (Element)c2)) continue;
                return false;
            }
            throw new RuntimeException(c1.toString());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/org/jdom/JDOMInterner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/org/jdom/JDOMInterner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "internText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInterned";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "internText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

