/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.abi;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiToolsInterface;
import org.jetbrains.kotlin.gradle.tasks.abi.AbiToolsTask;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiCheckTask;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiUpdateTask;

@DisableCachingByDefault(because="No output")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0016\u0010\u0010\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiCheckTaskImpl;", "Lorg/jetbrains/kotlin/gradle/tasks/abi/AbiToolsTask;", "Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiCheckTask;", "()V", "actualDir", "Lorg/gradle/api/file/DirectoryProperty;", "getActualDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectName", "", "getProjectName", "()Ljava/lang/String;", "projectPath", "kotlin.jvm.PlatformType", "referenceDir", "getReferenceDir", "rootDir", "Ljava/io/File;", "variantName", "Lorg/gradle/api/provider/Property;", "getVariantName", "()Lorg/gradle/api/provider/Property;", "runTools", "", "tools", "Lorg/jetbrains/kotlin/abi/tools/api/AbiToolsInterface;", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinLegacyAbiCheckTaskImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLegacyAbiCheckTaskImpl.kt\norg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiCheckTaskImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1863#2,2:92\n*S KotlinDebug\n*F\n+ 1 KotlinLegacyAbiCheckTaskImpl.kt\norg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiCheckTaskImpl\n*L\n55#1:92,2\n*E\n"})
public abstract class KotlinLegacyAbiCheckTaskImpl
extends AbiToolsTask
implements KotlinLegacyAbiCheckTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectName;
    private final String projectPath;
    private final File rootDir;

    public KotlinLegacyAbiCheckTaskImpl() {
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.projectName = string;
        this.projectPath = this.getProject().getPath();
        this.rootDir = this.getProject().getRootDir();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getReferenceDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getActualDir();

    @Input
    @NotNull
    public abstract Property<String> getVariantName();

    @Input
    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @Override
    protected void runTools(@NotNull AbiToolsInterface tools) {
        Intrinsics.checkNotNullParameter((Object)tools, (String)"tools");
        File referenceDir = ((Directory)this.getReferenceDir().get()).getAsFile();
        File actualDir = ((Directory)this.getActualDir().get()).getAsFile();
        String pathPrefix = Intrinsics.areEqual((Object)this.projectPath, (Object)":") ? ":" : this.projectPath + ':';
        String jvmDumpName = this.projectName + ".api";
        String klibDumpName = this.projectName + ".klib.api";
        StringBuilder errorBuilder = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)actualDir, (String)"actualDir");
        List actualDumps2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)actualDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(jvmDumpName, klibDumpName){
            final /* synthetic */ String $jvmDumpName;
            final /* synthetic */ String $klibDumpName;
            {
                this.$jvmDumpName = $jvmDumpName;
                this.$klibDumpName = $klibDumpName;
                super(1);
            }

            public final Boolean invoke(File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return file.isFile() && Intrinsics.areEqual((Object)file.getName(), (Object)this.$jvmDumpName) || Intrinsics.areEqual((Object)file.getName(), (Object)this.$klibDumpName);
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)referenceDir, (String)"referenceDir");
        Set referenceDumps2 = SequencesKt.toMutableSet((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)referenceDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(jvmDumpName, klibDumpName){
            final /* synthetic */ String $jvmDumpName;
            final /* synthetic */ String $klibDumpName;
            {
                this.$jvmDumpName = $jvmDumpName;
                this.$klibDumpName = $klibDumpName;
                super(1);
            }

            public final Boolean invoke(File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return file.isFile() && Intrinsics.areEqual((Object)file.getName(), (Object)this.$jvmDumpName) || Intrinsics.areEqual((Object)file.getName(), (Object)this.$klibDumpName);
            }
        })));
        Iterable $this$forEach$iv = actualDumps2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File actualDump = (File)element$iv;
            boolean bl = false;
            String relative = FilesKt.toRelativeString((File)actualDump, (File)actualDir);
            File referenceDump = FilesKt.resolve((File)referenceDir, (String)relative);
            if (referenceDumps2.remove(referenceDump)) {
                Set diffSet = new LinkedHashSet();
                String diff = tools.filesDiff(referenceDump, actualDump);
                if (diff != null) {
                    diffSet.add(diff);
                }
                if (!(!((Collection)diffSet).isEmpty())) continue;
                String diffText = CollectionsKt.joinToString$default((Iterable)diffSet, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
                errorBuilder.append("\n<<<ABI has changed>>>\n" + diffText + "\n\n");
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Expected file with ABI declarations '");
            File file = this.rootDir;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
            errorBuilder.append(stringBuilder.append(FilesKt.relativeTo((File)referenceDump, (File)file)).append("' does not exist.\n\n").toString());
        }
        if (((CharSequence)errorBuilder).length() > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("You can run '").append(pathPrefix);
            Object object = this.getVariantName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variantName.get()");
            errorBuilder.append(stringBuilder.append(KotlinLegacyAbiUpdateTask.Companion.nameForVariant((String)object)).append("' task to create or overwrite reference ABI declarations").toString());
            throw new IllegalStateException(("ABI check failed for project " + this.projectName + "\n\n" + errorBuilder).toString());
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiCheckTaskImpl$Companion;", "", "()V", "nameForVariant", "", "variantName", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String nameForVariant(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return AbiToolsTask.Companion.composeTaskName$kotlin_gradle_plugin_common("checkLegacyAbi", variantName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

